/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.intcaches;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LinkedCustomIntObjectHashMap<V> {
    private static final float LOAD_FACTOR = 0.6f;
    private Entry<V>[] entries;
    private Entry<V> top;
    private Entry<V> back;
    private transient int tableSizeMask;
    private transient int tableSize;
    private int actualEntriesCount;
    private transient int rehashAfterEntriesCount;
    @NotNull
    private final RemovalPolicy<? super V> eldestEntryRemovalPolicy;

    LinkedCustomIntObjectHashMap(@NotNull RemovalPolicy<? super V> eldestEntryRemovalPolicy) {
        if (eldestEntryRemovalPolicy == null) {
            LinkedCustomIntObjectHashMap.$$$reportNull$$$0(0);
        }
        this.eldestEntryRemovalPolicy = eldestEntryRemovalPolicy;
        this.init();
    }

    private void init() {
        this.tableSize = HashCommon.arraySize((int)16, (float)0.6f);
        this.tableSizeMask = this.tableSize - 1;
        this.rehashAfterEntriesCount = HashCommon.maxFill((int)this.tableSize, (float)0.6f);
        this.entries = new Entry[this.tableSize];
        this.actualEntriesCount = 0;
    }

    public int size() {
        return this.actualEntriesCount;
    }

    public boolean isEmpty() {
        return this.actualEntriesCount == 0;
    }

    public void clear() {
        if (this.actualEntriesCount == 0) {
            return;
        }
        this.back = null;
        this.top = null;
        this.init();
    }

    public V get(int key) {
        Entry<V>[] entries = this.entries;
        int hash = LinkedCustomIntObjectHashMap.hashKey(key);
        int index = hash & this.tableSizeMask;
        Entry e = entries[index];
        while (e != null) {
            if (e.key == key) {
                this.moveToTop(e);
                return (V)e.value;
            }
            e = e.hashNext;
        }
        return null;
    }

    private static int hashKey(int key) {
        return HashCommon.mix((int)key);
    }

    public V put(int key, @NotNull V value) {
        if (value == null) {
            LinkedCustomIntObjectHashMap.$$$reportNull$$$0(1);
        }
        Entry<V>[] table = this.entries;
        int hash = LinkedCustomIntObjectHashMap.hashKey(key);
        int index = hash & this.tableSizeMask;
        Entry e = table[index];
        while (e != null) {
            if (e.key == key) {
                this.moveToTop(e);
                return e.setValue(value);
            }
            e = e.hashNext;
        }
        e = new Entry<V>(key, value);
        e.hashNext = (Entry)table[index];
        table[index] = e;
        Entry<V> top = this.top;
        e.next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = e;
        } else {
            this.back = e;
        }
        this.top = e;
        ++this.actualEntriesCount;
        if (this.eldestEntryRemovalPolicy.shouldRemoveEldest(this.actualEntriesCount, ((Entry)this.back).key, ((Entry)this.back).value)) {
            V removedValue = this.remove(((Entry)this.back).key);
            if (removedValue == null) {
                throw new ConcurrentModificationException("LinkedIntHashMap.Entry was not removed. Likely concurrent modification? " + ((Entry)this.back).key);
            }
        } else if (this.actualEntriesCount >= this.rehashAfterEntriesCount) {
            this.rehash(HashCommon.arraySize((int)(this.actualEntriesCount + 1), (float)0.6f));
        }
        return null;
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public V remove(int key) {
        Entry<V>[] entries = this.entries;
        int hash = LinkedCustomIntObjectHashMap.hashKey(key);
        int index = hash & this.tableSizeMask;
        Entry e = entries[index];
        if (e == null) {
            return null;
        }
        if (e.key == key) {
            entries[index] = e.hashNext;
        } else {
            Entry last2;
            do {
                last2 = e;
                if ((e = e.hashNext) != null) continue;
                return null;
            } while (e.key != key);
            last2.hashNext = e.hashNext;
        }
        this.unlink(e);
        --this.actualEntriesCount;
        return (V)e.value;
    }

    @NotNull
    public Set<Integer> keySet() {
        return new KeySet();
    }

    @NotNull
    public Collection<V> values() {
        return new Values();
    }

    @NotNull
    public Set<Entry<V>> entrySet() {
        return new EntrySet();
    }

    private void moveToTop(Entry<V> e) {
        Entry<V> top = this.top;
        if (top == e) {
            return;
        }
        Entry prev = ((Entry)e).previous;
        Entry next = ((Entry)e).next;
        prev.next = next;
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)top).previous = (Entry)e;
        ((Entry)e).next = (Entry)top;
        ((Entry)e).previous = null;
        this.top = e;
    }

    private void unlink(Entry<V> e) {
        Entry prev = ((Entry)e).previous;
        Entry next = ((Entry)e).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)e).previous = null;
        ((Entry)e).next = null;
    }

    private void rehash(int newTableSize) {
        this.tableSizeMask = newTableSize - 1;
        this.tableSize = newTableSize;
        this.rehashAfterEntriesCount = HashCommon.maxFill((int)this.tableSize, (float)0.6f);
        Entry[] entries = new Entry[newTableSize];
        Entry e = this.back;
        while (e != null) {
            int index = LinkedCustomIntObjectHashMap.hashKey(e.key) & this.tableSizeMask;
            e.hashNext = entries[index];
            entries[index] = e;
            e = e.previous;
        }
        this.entries = entries;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eldestEntryRemovalPolicy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/intcaches/LinkedCustomIntObjectHashMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Entry<V>
    implements Map.Entry<Integer, V> {
        private final int key;
        private V value;
        private Entry<V> hashNext;
        private Entry<V> next;
        private Entry<V> previous;

        Entry(int key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Integer getKey() {
            return this.key();
        }

        public int key() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface RemovalPolicy<V> {
        public boolean shouldRemoveEldest(int var1, int var2, V var3);
    }

    private final class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            return new LinkedHashIterator<Integer>(){

                @Override
                public Integer next() {
                    return this.nextEntry().key;
                }
            };
        }

        @Override
        public int size() {
            return LinkedCustomIntObjectHashMap.this.actualEntriesCount;
        }

        @Override
        public boolean contains(Object o) {
            return LinkedCustomIntObjectHashMap.this.containsKey((Integer)o);
        }

        @Override
        public boolean remove(Object o) {
            return LinkedCustomIntObjectHashMap.this.remove((Integer)o) != null;
        }

        @Override
        public void clear() {
            LinkedCustomIntObjectHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return new LinkedHashIterator<V>(){

                @Override
                public V next() {
                    return this.nextEntry().value;
                }
            };
        }

        @Override
        public int size() {
            return LinkedCustomIntObjectHashMap.this.actualEntriesCount;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            for (Entry entry : LinkedCustomIntObjectHashMap.this.entries) {
                if (entry == null || !entry.value.equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            LinkedCustomIntObjectHashMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Entry<V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Entry<V>> iterator() {
            return new LinkedHashIterator<Entry<V>>(){

                @Override
                public Entry<V> next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = LinkedCustomIntObjectHashMap.this.get((Integer)e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return LinkedCustomIntObjectHashMap.this.remove((Integer)e.getKey()) != null;
        }

        @Override
        public int size() {
            return LinkedCustomIntObjectHashMap.this.actualEntriesCount;
        }

        @Override
        public void clear() {
            LinkedCustomIntObjectHashMap.this.clear();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        private Entry<V> e;
        private Entry<V> last;

        private LinkedHashIterator() {
            this.e = LinkedCustomIntObjectHashMap.this.back;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedCustomIntObjectHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<V> nextEntry() {
            this.last = this.e;
            Entry result = this.last;
            this.e = result.previous;
            return result;
        }
    }
}

