/*
 *  Phusion Passenger - https://www.phusionpassenger.com/
 *  Copyright (c) 2010-2025 Asynchronous B.V.
 *
 *  "Passenger", "Phusion Passenger" and "Union Station" are registered
 *  trademarks of Asynchronous B.V.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
#ifndef _PASSENGER_APACHE2_MODULE_CONFIG_H_
#define _PASSENGER_APACHE2_MODULE_CONFIG_H_

#include <LoggingKit/LoggingKit.h>
#include <Constants.h>
#include <Utils.h>

#include <set>
#include <string>

// The APR headers must come after the Passenger headers.
// See Hooks.cpp to learn why.
#include <httpd.h>
#include <http_config.h>
#include <apr_pools.h>
#include <apr_strings.h>

#include "ConfigGeneral/Common.h"
#include "DirConfig/AutoGeneratedStruct.h"
#include "ServerConfig/AutoGeneratedStruct.h"

namespace Passenger {
namespace Apache2Module {

using namespace std;


/**
 * Per-directory configuration information (manually-written part).
 *
 * Use the getter methods to query information, because those will return
 * the default value if the value is not specified.
 */
struct DirConfig: public AutoGeneratedDirConfig {

	/*************************************/
	/*************************************/

	/*************************************/
};


/**
 * Server-wide (global, not per-virtual host) configuration information
 * (manually written part).
 *
 * Use the getter methods to query information, because those will return
 * the default value if the value is not specified.
 */
struct ServerConfig: public AutoGeneratedServerConfig {
	Json::Value manifest;

	Json::Value ctl;

	StaticString ctlSourceFile;
	unsigned int ctlSourceLine;
	bool ctlExplicitlySet: 1;

	ServerConfig() {
		ctlSourceLine = 0;
		ctlExplicitlySet = false;
	}
};

extern ServerConfig serverConfig;

void *createDirConfig(apr_pool_t *p, char *dirspec);
void *mergeDirConfig(apr_pool_t *p, void *basev, void *addv);
void postprocessConfig(server_rec *s, apr_pool_t *pool, apr_pool_t *temp_pool);



} // namespace Apache2Module
} // namespace Passenger

#endif /* _PASSENGER_APACHE2_MODULE_CONFIG_H_ */
