/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpRequestLogger;
import com.azure.core.http.policy.HttpResponseLogger;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class HttpLogOptions {
    private static final HttpHeaderName X_MS_RETURN_CLIENT_REQUEST_ID = HttpHeaderName.fromString("x-ms-return-client-request-id");
    private static final HttpHeaderName MS_CV = HttpHeaderName.fromString("MS-CV");
    private static final HttpHeaderName REQUEST_ID = HttpHeaderName.fromString("Request-Id");
    private String applicationId = null;
    private HttpLogDetailLevel logLevel = HttpLogDetailLevel.ENVIRONMENT_HTTP_LOG_DETAIL_LEVEL;
    private Set<HttpHeaderName> allowedHeaderNames = new HashSet<HttpHeaderName>(DEFAULT_HEADERS_ALLOWLIST);
    private Set<String> allowedQueryParamNames = new HashSet<String>(DEFAULT_QUERY_PARAMS_ALLOWLIST);
    private boolean prettyPrintBody;
    private boolean disableRedactedHeaderLogging;
    private HttpRequestLogger requestLogger;
    private HttpResponseLogger responseLogger;
    private static final ClientLogger LOGGER = new ClientLogger(HttpLogOptions.class);
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final String INVALID_APPLICATION_ID_LENGTH = "'applicationId' length cannot be greater than 24";
    private static final String INVALID_APPLICATION_ID_SPACE = "'applicationId' cannot contain spaces.";
    static final Set<HttpHeaderName> DEFAULT_HEADERS_ALLOWLIST = Collections.unmodifiableSet(new HashSet<HttpHeaderName>(Arrays.asList(HttpHeaderName.X_MS_REQUEST_ID, HttpHeaderName.X_MS_CLIENT_REQUEST_ID, X_MS_RETURN_CLIENT_REQUEST_ID, HttpHeaderName.TRACEPARENT, MS_CV, HttpHeaderName.ACCEPT, HttpHeaderName.CACHE_CONTROL, HttpHeaderName.CONNECTION, HttpHeaderName.CONTENT_LENGTH, HttpHeaderName.DATE, HttpHeaderName.ETAG, HttpHeaderName.EXPIRES, HttpHeaderName.IF_MATCH, HttpHeaderName.IF_MODIFIED_SINCE, HttpHeaderName.IF_NONE_MATCH, HttpHeaderName.IF_UNMODIFIED_SINCE, HttpHeaderName.LAST_MODIFIED, HttpHeaderName.PRAGMA, REQUEST_ID, HttpHeaderName.RETRY_AFTER, HttpHeaderName.RETRY_AFTER_MS, HttpHeaderName.SERVER, HttpHeaderName.TRANSFER_ENCODING, HttpHeaderName.USER_AGENT, HttpHeaderName.WWW_AUTHENTICATE)));
    static final List<String> DEFAULT_QUERY_PARAMS_ALLOWLIST = Collections.singletonList("api-version");

    public HttpLogDetailLevel getLogLevel() {
        return this.logLevel;
    }

    public HttpLogOptions setLogLevel(HttpLogDetailLevel logLevel) {
        this.logLevel = logLevel == null ? HttpLogDetailLevel.NONE : logLevel;
        return this;
    }

    @Deprecated
    public Set<String> getAllowedHeaderNames() {
        return this.allowedHeaderNames.stream().map(HttpHeaderName::getCaseSensitiveName).collect(Collectors.toSet());
    }

    public Set<HttpHeaderName> getAllowedHttpHeaderNames() {
        return this.allowedHeaderNames;
    }

    @Deprecated
    public HttpLogOptions setAllowedHeaderNames(Set<String> allowedHeaderNames) {
        this.allowedHeaderNames = allowedHeaderNames == null ? new HashSet<HttpHeaderName>() : allowedHeaderNames.stream().map(HttpHeaderName::fromString).collect(Collectors.toSet());
        return this;
    }

    public HttpLogOptions setAllowedHttpHeaderNames(Set<HttpHeaderName> allowedHttpHeaderNames) {
        this.allowedHeaderNames = allowedHttpHeaderNames == null ? new HashSet() : allowedHttpHeaderNames;
        return this;
    }

    @Deprecated
    public HttpLogOptions addAllowedHeaderName(String allowedHeaderName) {
        Objects.requireNonNull(allowedHeaderName);
        this.allowedHeaderNames.add(HttpHeaderName.fromString(allowedHeaderName));
        return this;
    }

    public HttpLogOptions addAllowedHttpHeaderName(HttpHeaderName allowedHeaderName) {
        Objects.requireNonNull(allowedHeaderName);
        this.allowedHeaderNames.add(allowedHeaderName);
        return this;
    }

    public Set<String> getAllowedQueryParamNames() {
        return this.allowedQueryParamNames;
    }

    public HttpLogOptions setAllowedQueryParamNames(Set<String> allowedQueryParamNames) {
        this.allowedQueryParamNames = allowedQueryParamNames == null ? new HashSet() : allowedQueryParamNames;
        return this;
    }

    public HttpLogOptions addAllowedQueryParamName(String allowedQueryParamName) {
        this.allowedQueryParamNames.add(allowedQueryParamName);
        return this;
    }

    @Deprecated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Deprecated
    public HttpLogOptions setApplicationId(String applicationId) {
        if (!CoreUtils.isNullOrEmpty(applicationId)) {
            if (applicationId.length() > 24) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_LENGTH));
            }
            if (applicationId.contains(" ")) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_SPACE));
            }
        }
        this.applicationId = applicationId;
        return this;
    }

    @Deprecated
    public boolean isPrettyPrintBody() {
        return this.prettyPrintBody;
    }

    @Deprecated
    public HttpLogOptions setPrettyPrintBody(boolean prettyPrintBody) {
        this.prettyPrintBody = prettyPrintBody;
        return this;
    }

    public HttpRequestLogger getRequestLogger() {
        return this.requestLogger;
    }

    public HttpLogOptions setRequestLogger(HttpRequestLogger requestLogger) {
        this.requestLogger = requestLogger;
        return this;
    }

    public HttpResponseLogger getResponseLogger() {
        return this.responseLogger;
    }

    public HttpLogOptions setResponseLogger(HttpResponseLogger responseLogger) {
        this.responseLogger = responseLogger;
        return this;
    }

    public HttpLogOptions disableRedactedHeaderLogging(boolean disableRedactedHeaderLogging) {
        this.disableRedactedHeaderLogging = disableRedactedHeaderLogging;
        return this;
    }

    public boolean isRedactedHeaderLoggingDisabled() {
        return this.disableRedactedHeaderLogging;
    }
}

