/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.netty.Metrics;
import reactor.netty.internal.util.MapUtils;
import reactor.netty.transport.ByteBufAllocatorMeters;

final class ByteBufAllocatorMetrics {
    static final ByteBufAllocatorMetrics INSTANCE = new ByteBufAllocatorMetrics();
    final ConcurrentMap<String, ByteBufAllocatorMetric> cache = new ConcurrentHashMap<String, ByteBufAllocatorMetric>();

    private ByteBufAllocatorMetrics() {
    }

    void registerMetrics(String allocType, ByteBufAllocatorMetric metrics, ByteBufAllocator alloc) {
        MapUtils.computeIfAbsent(this.cache, metrics.hashCode() + "", key -> {
            Tags tags = Tags.of((String[])new String[]{ByteBufAllocatorMeters.ByteBufAllocatorMetersTags.ID.asString(), key, ByteBufAllocatorMeters.ByteBufAllocatorMetersTags.TYPE.asString(), allocType});
            Gauge.builder((String)ByteBufAllocatorMeters.USED_HEAP_MEMORY.getName(), (Object)metrics, ByteBufAllocatorMetric::usedHeapMemory).tags((Iterable)tags).register(Metrics.REGISTRY);
            Gauge.builder((String)ByteBufAllocatorMeters.USED_DIRECT_MEMORY.getName(), (Object)metrics, ByteBufAllocatorMetric::usedDirectMemory).tags((Iterable)tags).register(Metrics.REGISTRY);
            if (metrics instanceof PooledByteBufAllocatorMetric) {
                PooledByteBufAllocatorMetric pooledMetrics = (PooledByteBufAllocatorMetric)metrics;
                PooledByteBufAllocator pooledAlloc = (PooledByteBufAllocator)alloc;
                Gauge.builder((String)ByteBufAllocatorMeters.HEAP_ARENAS.getName(), (Object)pooledMetrics, PooledByteBufAllocatorMetric::numHeapArenas).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)ByteBufAllocatorMeters.DIRECT_ARENAS.getName(), (Object)pooledMetrics, PooledByteBufAllocatorMetric::numDirectArenas).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)ByteBufAllocatorMeters.THREAD_LOCAL_CACHES.getName(), (Object)pooledMetrics, PooledByteBufAllocatorMetric::numThreadLocalCaches).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)ByteBufAllocatorMeters.SMALL_CACHE_SIZE.getName(), (Object)pooledMetrics, PooledByteBufAllocatorMetric::smallCacheSize).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)ByteBufAllocatorMeters.NORMAL_CACHE_SIZE.getName(), (Object)pooledMetrics, PooledByteBufAllocatorMetric::normalCacheSize).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)ByteBufAllocatorMeters.CHUNK_SIZE.getName(), (Object)pooledMetrics, PooledByteBufAllocatorMetric::chunkSize).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)ByteBufAllocatorMeters.ACTIVE_HEAP_MEMORY.getName(), (Object)pooledAlloc, PooledByteBufAllocator::pinnedHeapMemory).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)ByteBufAllocatorMeters.ACTIVE_DIRECT_MEMORY.getName(), (Object)pooledAlloc, PooledByteBufAllocator::pinnedDirectMemory).tags((Iterable)tags).register(Metrics.REGISTRY);
            }
            return metrics;
        });
    }
}

