/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import jakarta.json.JsonException;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.io.IOException;
import org.opensearch.client.json.jackson.JacksonJsonpLocation;

class JacksonUtils {
    JacksonUtils() {
    }

    public static JsonException convertException(IOException ioe) {
        if (ioe instanceof JsonGenerationException) {
            return new jakarta.json.stream.JsonGenerationException(ioe.getMessage(), (Throwable)ioe);
        }
        if (ioe instanceof JsonParseException) {
            JsonParseException jpe = (JsonParseException)ioe;
            return new JsonParsingException(ioe.getMessage(), (Throwable)jpe, (JsonLocation)new JacksonJsonpLocation(jpe.getLocation()));
        }
        return new JsonException("Jackson exception", (Throwable)ioe);
    }
}

