/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.normalization;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.neuralsearch.processor.dto.TechniqueCompatibilityCheckDTO;
import org.opensearch.neuralsearch.processor.normalization.L2ScoreNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.MinMaxScoreNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.RRFNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationUtil;
import org.opensearch.neuralsearch.processor.normalization.ZScoreNormalizationTechnique;

public class ScoreNormalizationFactory {
    private static final ScoreNormalizationUtil scoreNormalizationUtil = new ScoreNormalizationUtil();
    public static final ScoreNormalizationTechnique DEFAULT_METHOD = new MinMaxScoreNormalizationTechnique();
    private static final Map<String, Function<Map<String, Object>, ScoreNormalizationTechnique>> SCORE_NORMALIZATION_METHODS = Map.of("min_max", params -> new MinMaxScoreNormalizationTechnique((Map<String, Object>)params, scoreNormalizationUtil), "l2", params -> new L2ScoreNormalizationTechnique((Map<String, Object>)params, scoreNormalizationUtil), "rrf", params -> new RRFNormalizationTechnique((Map<String, Object>)params, scoreNormalizationUtil), "z_score", params -> new ZScoreNormalizationTechnique());
    private static final Map<String, Set<String>> COMBINATION_TECHNIQUE_FOR_NORMALIZATION_METHODS = Map.of("min_max", Set.of("arithmetic_mean", "geometric_mean", "harmonic_mean"), "l2", Set.of("arithmetic_mean", "geometric_mean", "harmonic_mean"), "rrf", Set.of("arithmetic_mean", "geometric_mean", "harmonic_mean"), "z_score", Set.of("arithmetic_mean"));

    public ScoreNormalizationTechnique createNormalization(String technique) {
        return this.createNormalization(technique, Map.of());
    }

    public ScoreNormalizationTechnique createNormalization(String technique, Map<String, Object> params) {
        return Optional.ofNullable(SCORE_NORMALIZATION_METHODS.get(technique)).orElseThrow(() -> new IllegalArgumentException("provided normalization technique is not supported")).apply(params);
    }

    public void isTechniquesCompatible(TechniqueCompatibilityCheckDTO techniqueCompatibilityCheckDTO) {
        ScoreNormalizationTechnique normalizationTechnique = techniqueCompatibilityCheckDTO.getScoreNormalizationTechnique();
        Set<String> supportedTechniques = COMBINATION_TECHNIQUE_FOR_NORMALIZATION_METHODS.get(normalizationTechnique.techniqueName());
        if (!supportedTechniques.contains(techniqueCompatibilityCheckDTO.getScoreCombinationTechnique().techniqueName())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "provided combination technique %s is not supported for normalization technique %s. Supported techniques are: %s", techniqueCompatibilityCheckDTO.getScoreCombinationTechnique().techniqueName(), normalizationTechnique.techniqueName(), String.join((CharSequence)", ", supportedTechniques)));
        }
    }
}

