/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.contextmanagement;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;

public class MLUpdateContextManagementTemplateRequest
extends ActionRequest {
    private final String templateName;
    private final ContextManagementTemplate template;

    public MLUpdateContextManagementTemplateRequest(String templateName, ContextManagementTemplate template) {
        this.templateName = templateName;
        this.template = template;
    }

    public MLUpdateContextManagementTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.templateName = in.readString();
        this.template = new ContextManagementTemplate(in);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.templateName == null || this.templateName.trim().isEmpty()) {
            exception = ValidateActions.addValidationError((String)"Template name cannot be null or empty", exception);
        }
        if (this.template == null) {
            exception = ValidateActions.addValidationError((String)"Context management template cannot be null", (ActionRequestValidationException)exception);
        }
        return exception;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.templateName);
        this.template.writeTo(out);
    }

    @Generated
    public static MLUpdateContextManagementTemplateRequestBuilder builder() {
        return new MLUpdateContextManagementTemplateRequestBuilder();
    }

    @Generated
    public String getTemplateName() {
        return this.templateName;
    }

    @Generated
    public ContextManagementTemplate getTemplate() {
        return this.template;
    }

    @Generated
    public String toString() {
        return "MLUpdateContextManagementTemplateRequest(templateName=" + this.getTemplateName() + ", template=" + String.valueOf(this.getTemplate()) + ")";
    }

    @Generated
    public static class MLUpdateContextManagementTemplateRequestBuilder {
        @Generated
        private String templateName;
        @Generated
        private ContextManagementTemplate template;

        @Generated
        MLUpdateContextManagementTemplateRequestBuilder() {
        }

        @Generated
        public MLUpdateContextManagementTemplateRequestBuilder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Generated
        public MLUpdateContextManagementTemplateRequestBuilder template(ContextManagementTemplate template) {
            this.template = template;
            return this;
        }

        @Generated
        public MLUpdateContextManagementTemplateRequest build() {
            return new MLUpdateContextManagementTemplateRequest(this.templateName, this.template);
        }

        @Generated
        public String toString() {
            return "MLUpdateContextManagementTemplateRequest.MLUpdateContextManagementTemplateRequestBuilder(templateName=" + this.templateName + ", template=" + String.valueOf(this.template) + ")";
        }
    }
}

