/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchResponseSections;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.neuralsearch.query.ext.AgentStepsSearchExtBuilder;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchResponseProcessor;

public class AgenticContextResponseProcessor
implements SearchResponseProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(AgenticContextResponseProcessor.class);
    public static final String TYPE = "agentic_context";
    private final String tag;
    private final String description;
    private final boolean ignoreFailure;
    private final boolean includeAgentSteps;
    private final boolean includeDslQuery;

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) {
        return response;
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response, PipelineProcessingContext requestContext) {
        String dslQueryStr;
        EventStatsManager.increment(EventStatName.AGENTIC_CONTEXT_PROCESSOR_EXECUTIONS);
        if (requestContext == null) {
            return response;
        }
        String agentStepsStr = this.includeAgentSteps ? (String)requestContext.getAttribute("agent_steps_summary") : null;
        String memoryIdStr = (String)requestContext.getAttribute("memory_id");
        String string = dslQueryStr = this.includeDslQuery ? (String)requestContext.getAttribute("dsl_query") : null;
        if (agentStepsStr == null && memoryIdStr == null && dslQueryStr == null) {
            return response;
        }
        ArrayList<AgentStepsSearchExtBuilder> newExtensions = new ArrayList<AgentStepsSearchExtBuilder>();
        List existingExtensions = response.getInternalResponse().getSearchExtBuilders();
        if (existingExtensions != null) {
            newExtensions.addAll(existingExtensions);
        }
        newExtensions.add(new AgentStepsSearchExtBuilder(agentStepsStr, memoryIdStr, dslQueryStr));
        SearchResponseSections newInternalResponse = new SearchResponseSections(response.getHits(), response.getAggregations(), response.getSuggest(), response.isTimedOut(), response.isTerminatedEarly(), null, response.getNumReducePhases(), newExtensions);
        return new SearchResponse(newInternalResponse, response.getScrollId(), response.getTotalShards(), response.getSuccessfulShards(), response.getSkippedShards(), response.getTook().millis(), response.getPhaseTook(), response.getShardFailures(), response.getClusters(), response.pointInTimeId());
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public AgenticContextResponseProcessor(String tag, String description, boolean ignoreFailure, boolean includeAgentSteps, boolean includeDslQuery) {
        this.tag = tag;
        this.description = description;
        this.ignoreFailure = ignoreFailure;
        this.includeAgentSteps = includeAgentSteps;
        this.includeDslQuery = includeDslQuery;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    @Generated
    public boolean isIncludeAgentSteps() {
        return this.includeAgentSteps;
    }

    @Generated
    public boolean isIncludeDslQuery() {
        return this.includeDslQuery;
    }

    public static class Factory
    implements Processor.Factory<SearchResponseProcessor> {
        public AgenticContextResponseProcessor create(Map<String, Processor.Factory<SearchResponseProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) {
            boolean includeAgentSteps = ConfigurationUtils.readBooleanProperty((String)AgenticContextResponseProcessor.TYPE, (String)tag, config, (String)"agent_steps_summary", (boolean)false);
            boolean includeDslQuery = ConfigurationUtils.readBooleanProperty((String)AgenticContextResponseProcessor.TYPE, (String)tag, config, (String)"dsl_query", (boolean)false);
            return new AgenticContextResponseProcessor(tag, description, ignoreFailure, includeAgentSteps, includeDslQuery);
        }
    }
}

