"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToolTip = exports.POSITIONS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../common");
var _portal = require("../portal");
var _tool_tip_popover = require("./tool_tip_popover");
var _services = require("../../services");
var _react2 = require("../../services/react");
var _resize_observer = require("../observer/resize_observer");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var positionsToClassNameMap = {
  top: 'euiToolTip--top',
  right: 'euiToolTip--right',
  bottom: 'euiToolTip--bottom',
  left: 'euiToolTip--left'
};
var POSITIONS = (0, _common.keysOf)(positionsToClassNameMap);
exports.POSITIONS = POSITIONS;
var delayToMsMap = {
  regular: 250,
  long: 250 * 5
};
var displayToClassNameMap = {
  inlineBlock: undefined,
  block: 'euiToolTipAnchor--displayBlock'
};
var DEFAULT_TOOLTIP_STYLES = {
  // position the tooltip content near the top-left
  // corner of the window so it can't create scrollbars
  // 50,50 because who knows what negative margins, padding, etc
  top: 50,
  left: 50,
  // just in case, avoid any potential flicker by hiding
  // the tooltip before it is positioned
  opacity: 0,
  // prevent accidental mouse interaction while positioning
  visibility: 'hidden'
};
var EuiToolTip = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiToolTip, _Component);
  var _super = _createSuper(EuiToolTip);
  function EuiToolTip() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiToolTip);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_isMounted", false);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "anchor", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "popover", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "timeoutId", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      visible: false,
      calculatedPosition: _this.props.position,
      toolTipStyles: DEFAULT_TOOLTIP_STYLES,
      arrowStyles: undefined,
      id: _this.props.id || (0, _services.htmlIdGenerator)()()
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "clearAnimationTimeout", function () {
      if (_this.timeoutId) {
        _this.timeoutId = clearTimeout(_this.timeoutId);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "testAnchor", function () {
      // when the tooltip is visible, this checks if the anchor is still part of document
      // this fixes when the react root is removed from the dom without unmounting
      // https://github.com/elastic/oui/issues/1105
      if (document.body.contains(_this.anchor) === false) {
        // the anchor is no longer part of `document`
        _this.hideToolTip();
      } else {
        if (_this.state.visible) {
          // if still visible, keep checking
          requestAnimationFrame(_this.testAnchor);
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setPopoverRef", function (ref) {
      _this.popover = ref;

      // if the popover has been unmounted, clear
      // any previous knowledge about its size
      if (ref == null) {
        _this.setState({
          toolTipStyles: DEFAULT_TOOLTIP_STYLES,
          arrowStyles: undefined
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showToolTip", function () {
      if (!_this.timeoutId) {
        _this.timeoutId = setTimeout(function () {
          (0, _react2.enqueueStateChange)(function () {
            return _this.setState({
              visible: true
            });
          });
        }, delayToMsMap[_this.props.delay]);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "positionToolTip", function () {
      var requestedPosition = _this.props.position;
      if (!_this.anchor || !_this.popover) {
        return;
      }
      var _findPopoverPosition = (0, _services.findPopoverPosition)({
          anchor: _this.anchor,
          popover: _this.popover,
          position: requestedPosition,
          offset: 16,
          // offset popover 16px from the anchor
          arrowConfig: {
            arrowWidth: 12,
            arrowBuffer: 4
          }
        }),
        position = _findPopoverPosition.position,
        left = _findPopoverPosition.left,
        top = _findPopoverPosition.top,
        arrow = _findPopoverPosition.arrow; // If encroaching the right edge of the window:
      // When `props.content` changes and is longer than `prevProps.content`, the tooltip width remains and
      // the resizeObserver callback will fire twice (once for vertical resize caused by text line wrapping,
      // once for a subsequent position correction) and cause a flash rerender and reposition.
      // To prevent this, we can orient from the right so that text line wrapping does not occur, negating
      // the second resizeObserver callback call.
      var windowWidth = document.documentElement.clientWidth || window.innerWidth;
      var useRightValue = windowWidth / 2 < left;
      var toolTipStyles = {
        top: top,
        left: useRightValue ? 'auto' : left,
        right: useRightValue ? windowWidth - left - _this.popover.offsetWidth : 'auto'
      };
      _this.setState({
        visible: true,
        calculatedPosition: position,
        toolTipStyles: toolTipStyles,
        arrowStyles: arrow
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "hideToolTip", function () {
      _this.clearAnimationTimeout();
      (0, _react2.enqueueStateChange)(function () {
        if (_this._isMounted) {
          _this.setState({
            visible: false
          });
        }
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "hasFocusMouseMoveListener", function () {
      _this.hideToolTip();
      window.removeEventListener('mousemove', _this.hasFocusMouseMoveListener);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onKeyUp", function (event) {
      if (event.key === _services.keys.TAB) {
        window.addEventListener('mousemove', _this.hasFocusMouseMoveListener);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMouseOut", function (event) {
      // Prevent mousing over children from hiding the tooltip by testing for whether the mouse has
      // left the anchor for a non-child.
      if (_this.anchor === event.relatedTarget || _this.anchor != null && !_this.anchor.contains(event.relatedTarget)) {
        _this.hideToolTip();
      }
      if (_this.props.onMouseOut) {
        _this.props.onMouseOut(event);
      }
    });
    return _this;
  }
  (0, _createClass2.default)(EuiToolTip, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearAnimationTimeout();
      this._isMounted = false;
      window.removeEventListener('mousemove', this.hasFocusMouseMoveListener);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevState.visible === false && this.state.visible === true) {
        requestAnimationFrame(this.testAnchor);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        anchorClassName = _this$props.anchorClassName,
        content = _this$props.content,
        title = _this$props.title,
        delay = _this$props.delay,
        _this$props$display = _this$props.display,
        display = _this$props$display === void 0 ? 'inlineBlock' : _this$props$display,
        rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "className", "anchorClassName", "content", "title", "delay", "display"]);
      var _this$state = this.state,
        arrowStyles = _this$state.arrowStyles,
        id = _this$state.id,
        toolTipStyles = _this$state.toolTipStyles,
        visible = _this$state.visible;
      var classes = (0, _classnames.default)('euiToolTip', positionsToClassNameMap[this.state.calculatedPosition], className);
      var anchorClasses = (0, _classnames.default)('euiToolTipAnchor', display ? displayToClassNameMap[display] : null, anchorClassName);
      var tooltip;
      if (visible && (content || title)) {
        tooltip = /*#__PURE__*/_react.default.createElement(_portal.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_tool_tip_popover.EuiToolTipPopover, (0, _extends2.default)({
          className: classes,
          style: toolTipStyles,
          positionToolTip: this.positionToolTip,
          popoverRef: this.setPopoverRef,
          title: title,
          id: id,
          role: "tooltip"
        }, rest), /*#__PURE__*/_react.default.createElement("div", {
          style: arrowStyles,
          className: "euiToolTip__arrow"
        }), /*#__PURE__*/_react.default.createElement(_resize_observer.EuiResizeObserver, {
          onResize: this.positionToolTip
        }, function (resizeRef) {
          return /*#__PURE__*/_react.default.createElement("div", {
            ref: resizeRef
          }, content);
        })));
      }

      /* eslint-disable jsx-a11y/mouse-events-have-key-events */
      var anchor = /*#__PURE__*/_react.default.createElement("span", {
        ref: function ref(anchor) {
          return _this2.anchor = anchor;
        },
        className: anchorClasses,
        onMouseOver: this.showToolTip,
        onMouseOut: this.onMouseOut,
        onKeyUp: function onKeyUp(event) {
          _this2.onKeyUp(event);
        }
      }, /*#__PURE__*/(0, _react.cloneElement)(children, _objectSpread({
        onFocus: this.showToolTip,
        onBlur: this.hideToolTip
      }, visible && {
        'aria-describedby': this.state.id
      })));
      /* eslint-enable jsx-a11y/mouse-events-have-key-events */

      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, anchor, tooltip);
    }
  }]);
  return EuiToolTip;
}(_react.Component);
exports.EuiToolTip = EuiToolTip;
(0, _defineProperty2.default)(EuiToolTip, "defaultProps", {
  position: 'top',
  delay: 'regular'
});
EuiToolTip.propTypes = {
  /**
     * Passes onto the the trigger.
     */
  anchorClassName: _propTypes.default.string,
  /**
     * The in-view trigger for your tooltip.
     */
  children: _propTypes.default.element.isRequired,
  /**
     * Passes onto the tooltip itself, not the trigger.
     */
  className: _propTypes.default.string,
  /**
     * The main content of your tooltip.
     */
  content: _propTypes.default.node,
  /**
     * Common display alternatives for the anchor wrapper
     */
  display: _propTypes.default.oneOf(["inlineBlock", "block"]),
  /**
     * Delay before showing tooltip. Good for repeatable items.
     */
  delay: _propTypes.default.oneOf(["regular", "long"]).isRequired,
  /**
     * An optional title for your tooltip.
     */
  title: _propTypes.default.node,
  /**
     * Unless you provide one, this will be randomly generated.
     */
  id: _propTypes.default.string,
  /**
     * Suggested position. If there is not enough room for it this will be changed.
     */
  position: _propTypes.default.oneOf(["top", "right", "bottom", "left"]).isRequired,
  /**
     * If supplied, called when mouse movement causes the tool tip to be
     * hidden.
     */
  onMouseOut: _propTypes.default.func
};