/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.breaker;

import org.opensearch.ad.settings.ADNumericSetting;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.timeseries.breaker.ThresholdCircuitBreaker;

public class MemoryCircuitBreaker
extends ThresholdCircuitBreaker<Integer> {
    private final JvmService jvmService;

    public MemoryCircuitBreaker(JvmService jvmService) {
        super(ADNumericSetting.getJVMHeapUsageThreshold());
        this.jvmService = jvmService;
    }

    public MemoryCircuitBreaker(int threshold, JvmService jvmService) {
        super(threshold);
        this.jvmService = jvmService;
    }

    @Override
    public boolean isOpen() {
        return this.jvmService.stats().getMem().getHeapUsedPercent() > (Integer)this.getThreshold();
    }
}

