/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.ko.KoreanAnalyzer;
import org.apache.lucene.analysis.ko.KoreanPartOfSpeechStopFilter;
import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.UserDictionary;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.opensearch.index.analysis.Analysis;
import org.opensearch.index.analysis.NoriPartOfSpeechStopFilterFactory;
import org.opensearch.index.analysis.NoriTokenizerFactory;

public class NoriAnalyzerProvider
extends AbstractIndexAnalyzerProvider<KoreanAnalyzer> {
    private final KoreanAnalyzer analyzer;

    public NoriAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        KoreanTokenizer.DecompoundMode mode = NoriTokenizerFactory.getMode(settings);
        UserDictionary userDictionary = NoriTokenizerFactory.getUserDictionary(env, settings);
        List tagList = Analysis.parseWordList((Environment)env, (Settings)settings, (String)"stoptags", s -> s);
        Set<POS.Tag> stopTags = tagList != null ? NoriPartOfSpeechStopFilterFactory.resolvePOSList(tagList) : KoreanPartOfSpeechStopFilter.DEFAULT_STOP_TAGS;
        this.analyzer = new KoreanAnalyzer(userDictionary, mode, stopTags, false);
    }

    public KoreanAnalyzer get() {
        return this.analyzer;
    }
}

