/*

    This file was generated with gl3w_gen.cmake, part of glXXw
    (hosted at https://github.com/paroj/glXXw-cmake)

    This is free and unencumbered software released into the public domain.

    Anyone is free to copy, modify, publish, use, compile, sell, or
    distribute this software, either in source code form or as a compiled
    binary, for any purpose, commercial or non-commercial, and by any
    means.

    In jurisdictions that recognize copyright laws, the author or authors
    of this software dedicate any and all copyright interest in the
    software to the public domain. We make this dedication for the benefit
    of the public at large and to the detriment of our heirs and
    successors. We intend this dedication to be an overt act of
    relinquishment in perpetuity of all present and future rights to this
    software under copyright law.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __gl3w_h_
#define __gl3w_h_

#include <GL/glcorearb.h>

#ifndef __gl_h_
#define __gl_h_
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*GL3WglProc)(void);
typedef GL3WglProc (*GL3WGetProcAddressProc)(const char *proc);

/* gl3w api */
int gl3wInit(void);
int gl3wInit2(GL3WGetProcAddressProc proc);
int gl3wIsSupported(int major, int minor);
GL3WglProc gl3wGetProcAddress(const char *proc);

/* OpenGL functions */
extern PFNGLACTIVEPROGRAMEXTPROC                               gl3wActiveProgramEXT;
extern PFNGLACTIVESHADERPROGRAMPROC                            gl3wActiveShaderProgram;
extern PFNGLACTIVETEXTUREPROC                                  gl3wActiveTexture;
extern PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC            gl3wApplyFramebufferAttachmentCMAAINTEL;
extern PFNGLATTACHSHADERPROC                                   gl3wAttachShader;
extern PFNGLBEGINCONDITIONALRENDERPROC                         gl3wBeginConditionalRender;
extern PFNGLBEGINCONDITIONALRENDERNVPROC                       gl3wBeginConditionalRenderNV;
extern PFNGLBEGINPERFMONITORAMDPROC                            gl3wBeginPerfMonitorAMD;
extern PFNGLBEGINPERFQUERYINTELPROC                            gl3wBeginPerfQueryINTEL;
extern PFNGLBEGINQUERYPROC                                     gl3wBeginQuery;
extern PFNGLBEGINQUERYINDEXEDPROC                              gl3wBeginQueryIndexed;
extern PFNGLBEGINTRANSFORMFEEDBACKPROC                         gl3wBeginTransformFeedback;
extern PFNGLBINDATTRIBLOCATIONPROC                             gl3wBindAttribLocation;
extern PFNGLBINDBUFFERPROC                                     gl3wBindBuffer;
extern PFNGLBINDBUFFERBASEPROC                                 gl3wBindBufferBase;
extern PFNGLBINDBUFFERRANGEPROC                                gl3wBindBufferRange;
extern PFNGLBINDBUFFERSBASEPROC                                gl3wBindBuffersBase;
extern PFNGLBINDBUFFERSRANGEPROC                               gl3wBindBuffersRange;
extern PFNGLBINDFRAGDATALOCATIONPROC                           gl3wBindFragDataLocation;
extern PFNGLBINDFRAGDATALOCATIONINDEXEDPROC                    gl3wBindFragDataLocationIndexed;
extern PFNGLBINDFRAMEBUFFERPROC                                gl3wBindFramebuffer;
extern PFNGLBINDIMAGETEXTUREPROC                               gl3wBindImageTexture;
extern PFNGLBINDIMAGETEXTURESPROC                              gl3wBindImageTextures;
extern PFNGLBINDMULTITEXTUREEXTPROC                            gl3wBindMultiTextureEXT;
extern PFNGLBINDPROGRAMPIPELINEPROC                            gl3wBindProgramPipeline;
extern PFNGLBINDRENDERBUFFERPROC                               gl3wBindRenderbuffer;
extern PFNGLBINDSAMPLERPROC                                    gl3wBindSampler;
extern PFNGLBINDSAMPLERSPROC                                   gl3wBindSamplers;
extern PFNGLBINDTEXTUREPROC                                    gl3wBindTexture;
extern PFNGLBINDTEXTUREUNITPROC                                gl3wBindTextureUnit;
extern PFNGLBINDTEXTURESPROC                                   gl3wBindTextures;
extern PFNGLBINDTRANSFORMFEEDBACKPROC                          gl3wBindTransformFeedback;
extern PFNGLBINDVERTEXARRAYPROC                                gl3wBindVertexArray;
extern PFNGLBINDVERTEXBUFFERPROC                               gl3wBindVertexBuffer;
extern PFNGLBINDVERTEXBUFFERSPROC                              gl3wBindVertexBuffers;
extern PFNGLBLENDBARRIERKHRPROC                                gl3wBlendBarrierKHR;
extern PFNGLBLENDBARRIERNVPROC                                 gl3wBlendBarrierNV;
extern PFNGLBLENDCOLORPROC                                     gl3wBlendColor;
extern PFNGLBLENDEQUATIONPROC                                  gl3wBlendEquation;
extern PFNGLBLENDEQUATIONSEPARATEPROC                          gl3wBlendEquationSeparate;
extern PFNGLBLENDEQUATIONSEPARATEIPROC                         gl3wBlendEquationSeparatei;
extern PFNGLBLENDEQUATIONSEPARATEIARBPROC                      gl3wBlendEquationSeparateiARB;
extern PFNGLBLENDEQUATIONIPROC                                 gl3wBlendEquationi;
extern PFNGLBLENDEQUATIONIARBPROC                              gl3wBlendEquationiARB;
extern PFNGLBLENDFUNCPROC                                      gl3wBlendFunc;
extern PFNGLBLENDFUNCSEPARATEPROC                              gl3wBlendFuncSeparate;
extern PFNGLBLENDFUNCSEPARATEIPROC                             gl3wBlendFuncSeparatei;
extern PFNGLBLENDFUNCSEPARATEIARBPROC                          gl3wBlendFuncSeparateiARB;
extern PFNGLBLENDFUNCIPROC                                     gl3wBlendFunci;
extern PFNGLBLENDFUNCIARBPROC                                  gl3wBlendFunciARB;
extern PFNGLBLENDPARAMETERINVPROC                              gl3wBlendParameteriNV;
extern PFNGLBLITFRAMEBUFFERPROC                                gl3wBlitFramebuffer;
extern PFNGLBLITNAMEDFRAMEBUFFERPROC                           gl3wBlitNamedFramebuffer;
extern PFNGLBUFFERADDRESSRANGENVPROC                           gl3wBufferAddressRangeNV;
extern PFNGLBUFFERDATAPROC                                     gl3wBufferData;
extern PFNGLBUFFERPAGECOMMITMENTARBPROC                        gl3wBufferPageCommitmentARB;
extern PFNGLBUFFERSTORAGEPROC                                  gl3wBufferStorage;
extern PFNGLBUFFERSUBDATAPROC                                  gl3wBufferSubData;
extern PFNGLCALLCOMMANDLISTNVPROC                              gl3wCallCommandListNV;
extern PFNGLCHECKFRAMEBUFFERSTATUSPROC                         gl3wCheckFramebufferStatus;
extern PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC                    gl3wCheckNamedFramebufferStatus;
extern PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC                 gl3wCheckNamedFramebufferStatusEXT;
extern PFNGLCLAMPCOLORPROC                                     gl3wClampColor;
extern PFNGLCLEARPROC                                          gl3wClear;
extern PFNGLCLEARBUFFERDATAPROC                                gl3wClearBufferData;
extern PFNGLCLEARBUFFERSUBDATAPROC                             gl3wClearBufferSubData;
extern PFNGLCLEARBUFFERFIPROC                                  gl3wClearBufferfi;
extern PFNGLCLEARBUFFERFVPROC                                  gl3wClearBufferfv;
extern PFNGLCLEARBUFFERIVPROC                                  gl3wClearBufferiv;
extern PFNGLCLEARBUFFERUIVPROC                                 gl3wClearBufferuiv;
extern PFNGLCLEARCOLORPROC                                     gl3wClearColor;
extern PFNGLCLEARDEPTHPROC                                     gl3wClearDepth;
extern PFNGLCLEARDEPTHFPROC                                    gl3wClearDepthf;
extern PFNGLCLEARNAMEDBUFFERDATAPROC                           gl3wClearNamedBufferData;
extern PFNGLCLEARNAMEDBUFFERDATAEXTPROC                        gl3wClearNamedBufferDataEXT;
extern PFNGLCLEARNAMEDBUFFERSUBDATAPROC                        gl3wClearNamedBufferSubData;
extern PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC                     gl3wClearNamedBufferSubDataEXT;
extern PFNGLCLEARNAMEDFRAMEBUFFERFIPROC                        gl3wClearNamedFramebufferfi;
extern PFNGLCLEARNAMEDFRAMEBUFFERFVPROC                        gl3wClearNamedFramebufferfv;
extern PFNGLCLEARNAMEDFRAMEBUFFERIVPROC                        gl3wClearNamedFramebufferiv;
extern PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC                       gl3wClearNamedFramebufferuiv;
extern PFNGLCLEARSTENCILPROC                                   gl3wClearStencil;
extern PFNGLCLEARTEXIMAGEPROC                                  gl3wClearTexImage;
extern PFNGLCLEARTEXSUBIMAGEPROC                               gl3wClearTexSubImage;
extern PFNGLCLIENTATTRIBDEFAULTEXTPROC                         gl3wClientAttribDefaultEXT;
extern PFNGLCLIENTWAITSYNCPROC                                 gl3wClientWaitSync;
extern PFNGLCLIPCONTROLPROC                                    gl3wClipControl;
extern PFNGLCOLORFORMATNVPROC                                  gl3wColorFormatNV;
extern PFNGLCOLORMASKPROC                                      gl3wColorMask;
extern PFNGLCOLORMASKIPROC                                     gl3wColorMaski;
extern PFNGLCOMMANDLISTSEGMENTSNVPROC                          gl3wCommandListSegmentsNV;
extern PFNGLCOMPILECOMMANDLISTNVPROC                           gl3wCompileCommandListNV;
extern PFNGLCOMPILESHADERPROC                                  gl3wCompileShader;
extern PFNGLCOMPILESHADERINCLUDEARBPROC                        gl3wCompileShaderIncludeARB;
extern PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC                   gl3wCompressedMultiTexImage1DEXT;
extern PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC                   gl3wCompressedMultiTexImage2DEXT;
extern PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC                   gl3wCompressedMultiTexImage3DEXT;
extern PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC                gl3wCompressedMultiTexSubImage1DEXT;
extern PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC                gl3wCompressedMultiTexSubImage2DEXT;
extern PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC                gl3wCompressedMultiTexSubImage3DEXT;
extern PFNGLCOMPRESSEDTEXIMAGE1DPROC                           gl3wCompressedTexImage1D;
extern PFNGLCOMPRESSEDTEXIMAGE2DPROC                           gl3wCompressedTexImage2D;
extern PFNGLCOMPRESSEDTEXIMAGE3DPROC                           gl3wCompressedTexImage3D;
extern PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC                        gl3wCompressedTexSubImage1D;
extern PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC                        gl3wCompressedTexSubImage2D;
extern PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC                        gl3wCompressedTexSubImage3D;
extern PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC                    gl3wCompressedTextureImage1DEXT;
extern PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC                    gl3wCompressedTextureImage2DEXT;
extern PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC                    gl3wCompressedTextureImage3DEXT;
extern PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC                    gl3wCompressedTextureSubImage1D;
extern PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC                 gl3wCompressedTextureSubImage1DEXT;
extern PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC                    gl3wCompressedTextureSubImage2D;
extern PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC                 gl3wCompressedTextureSubImage2DEXT;
extern PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC                    gl3wCompressedTextureSubImage3D;
extern PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC                 gl3wCompressedTextureSubImage3DEXT;
extern PFNGLCONSERVATIVERASTERPARAMETERFNVPROC                 gl3wConservativeRasterParameterfNV;
extern PFNGLCONSERVATIVERASTERPARAMETERINVPROC                 gl3wConservativeRasterParameteriNV;
extern PFNGLCOPYBUFFERSUBDATAPROC                              gl3wCopyBufferSubData;
extern PFNGLCOPYIMAGESUBDATAPROC                               gl3wCopyImageSubData;
extern PFNGLCOPYMULTITEXIMAGE1DEXTPROC                         gl3wCopyMultiTexImage1DEXT;
extern PFNGLCOPYMULTITEXIMAGE2DEXTPROC                         gl3wCopyMultiTexImage2DEXT;
extern PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC                      gl3wCopyMultiTexSubImage1DEXT;
extern PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC                      gl3wCopyMultiTexSubImage2DEXT;
extern PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC                      gl3wCopyMultiTexSubImage3DEXT;
extern PFNGLCOPYNAMEDBUFFERSUBDATAPROC                         gl3wCopyNamedBufferSubData;
extern PFNGLCOPYPATHNVPROC                                     gl3wCopyPathNV;
extern PFNGLCOPYTEXIMAGE1DPROC                                 gl3wCopyTexImage1D;
extern PFNGLCOPYTEXIMAGE2DPROC                                 gl3wCopyTexImage2D;
extern PFNGLCOPYTEXSUBIMAGE1DPROC                              gl3wCopyTexSubImage1D;
extern PFNGLCOPYTEXSUBIMAGE2DPROC                              gl3wCopyTexSubImage2D;
extern PFNGLCOPYTEXSUBIMAGE3DPROC                              gl3wCopyTexSubImage3D;
extern PFNGLCOPYTEXTUREIMAGE1DEXTPROC                          gl3wCopyTextureImage1DEXT;
extern PFNGLCOPYTEXTUREIMAGE2DEXTPROC                          gl3wCopyTextureImage2DEXT;
extern PFNGLCOPYTEXTURESUBIMAGE1DPROC                          gl3wCopyTextureSubImage1D;
extern PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC                       gl3wCopyTextureSubImage1DEXT;
extern PFNGLCOPYTEXTURESUBIMAGE2DPROC                          gl3wCopyTextureSubImage2D;
extern PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC                       gl3wCopyTextureSubImage2DEXT;
extern PFNGLCOPYTEXTURESUBIMAGE3DPROC                          gl3wCopyTextureSubImage3D;
extern PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC                       gl3wCopyTextureSubImage3DEXT;
extern PFNGLCOVERFILLPATHINSTANCEDNVPROC                       gl3wCoverFillPathInstancedNV;
extern PFNGLCOVERFILLPATHNVPROC                                gl3wCoverFillPathNV;
extern PFNGLCOVERSTROKEPATHINSTANCEDNVPROC                     gl3wCoverStrokePathInstancedNV;
extern PFNGLCOVERSTROKEPATHNVPROC                              gl3wCoverStrokePathNV;
extern PFNGLCOVERAGEMODULATIONNVPROC                           gl3wCoverageModulationNV;
extern PFNGLCOVERAGEMODULATIONTABLENVPROC                      gl3wCoverageModulationTableNV;
extern PFNGLCREATEBUFFERSPROC                                  gl3wCreateBuffers;
extern PFNGLCREATECOMMANDLISTSNVPROC                           gl3wCreateCommandListsNV;
extern PFNGLCREATEFRAMEBUFFERSPROC                             gl3wCreateFramebuffers;
extern PFNGLCREATEPERFQUERYINTELPROC                           gl3wCreatePerfQueryINTEL;
extern PFNGLCREATEPROGRAMPROC                                  gl3wCreateProgram;
extern PFNGLCREATEPROGRAMPIPELINESPROC                         gl3wCreateProgramPipelines;
extern PFNGLCREATEQUERIESPROC                                  gl3wCreateQueries;
extern PFNGLCREATERENDERBUFFERSPROC                            gl3wCreateRenderbuffers;
extern PFNGLCREATESAMPLERSPROC                                 gl3wCreateSamplers;
extern PFNGLCREATESHADERPROC                                   gl3wCreateShader;
extern PFNGLCREATESHADERPROGRAMEXTPROC                         gl3wCreateShaderProgramEXT;
extern PFNGLCREATESHADERPROGRAMVPROC                           gl3wCreateShaderProgramv;
extern PFNGLCREATESTATESNVPROC                                 gl3wCreateStatesNV;
extern PFNGLCREATESYNCFROMCLEVENTARBPROC                       gl3wCreateSyncFromCLeventARB;
extern PFNGLCREATETEXTURESPROC                                 gl3wCreateTextures;
extern PFNGLCREATETRANSFORMFEEDBACKSPROC                       gl3wCreateTransformFeedbacks;
extern PFNGLCREATEVERTEXARRAYSPROC                             gl3wCreateVertexArrays;
extern PFNGLCULLFACEPROC                                       gl3wCullFace;
extern PFNGLDEBUGMESSAGECALLBACKPROC                           gl3wDebugMessageCallback;
extern PFNGLDEBUGMESSAGECALLBACKARBPROC                        gl3wDebugMessageCallbackARB;
extern PFNGLDEBUGMESSAGECONTROLPROC                            gl3wDebugMessageControl;
extern PFNGLDEBUGMESSAGECONTROLARBPROC                         gl3wDebugMessageControlARB;
extern PFNGLDEBUGMESSAGEINSERTPROC                             gl3wDebugMessageInsert;
extern PFNGLDEBUGMESSAGEINSERTARBPROC                          gl3wDebugMessageInsertARB;
extern PFNGLDELETEBUFFERSPROC                                  gl3wDeleteBuffers;
extern PFNGLDELETECOMMANDLISTSNVPROC                           gl3wDeleteCommandListsNV;
extern PFNGLDELETEFRAMEBUFFERSPROC                             gl3wDeleteFramebuffers;
extern PFNGLDELETENAMEDSTRINGARBPROC                           gl3wDeleteNamedStringARB;
extern PFNGLDELETEPATHSNVPROC                                  gl3wDeletePathsNV;
extern PFNGLDELETEPERFMONITORSAMDPROC                          gl3wDeletePerfMonitorsAMD;
extern PFNGLDELETEPERFQUERYINTELPROC                           gl3wDeletePerfQueryINTEL;
extern PFNGLDELETEPROGRAMPROC                                  gl3wDeleteProgram;
extern PFNGLDELETEPROGRAMPIPELINESPROC                         gl3wDeleteProgramPipelines;
extern PFNGLDELETEQUERIESPROC                                  gl3wDeleteQueries;
extern PFNGLDELETERENDERBUFFERSPROC                            gl3wDeleteRenderbuffers;
extern PFNGLDELETESAMPLERSPROC                                 gl3wDeleteSamplers;
extern PFNGLDELETESHADERPROC                                   gl3wDeleteShader;
extern PFNGLDELETESTATESNVPROC                                 gl3wDeleteStatesNV;
extern PFNGLDELETESYNCPROC                                     gl3wDeleteSync;
extern PFNGLDELETETEXTURESPROC                                 gl3wDeleteTextures;
extern PFNGLDELETETRANSFORMFEEDBACKSPROC                       gl3wDeleteTransformFeedbacks;
extern PFNGLDELETEVERTEXARRAYSPROC                             gl3wDeleteVertexArrays;
extern PFNGLDEPTHFUNCPROC                                      gl3wDepthFunc;
extern PFNGLDEPTHMASKPROC                                      gl3wDepthMask;
extern PFNGLDEPTHRANGEPROC                                     gl3wDepthRange;
extern PFNGLDEPTHRANGEARRAYVPROC                               gl3wDepthRangeArrayv;
extern PFNGLDEPTHRANGEINDEXEDPROC                              gl3wDepthRangeIndexed;
extern PFNGLDEPTHRANGEFPROC                                    gl3wDepthRangef;
extern PFNGLDETACHSHADERPROC                                   gl3wDetachShader;
extern PFNGLDISABLEPROC                                        gl3wDisable;
extern PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC                   gl3wDisableClientStateIndexedEXT;
extern PFNGLDISABLECLIENTSTATEIEXTPROC                         gl3wDisableClientStateiEXT;
extern PFNGLDISABLEINDEXEDEXTPROC                              gl3wDisableIndexedEXT;
extern PFNGLDISABLEVERTEXARRAYATTRIBPROC                       gl3wDisableVertexArrayAttrib;
extern PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC                    gl3wDisableVertexArrayAttribEXT;
extern PFNGLDISABLEVERTEXARRAYEXTPROC                          gl3wDisableVertexArrayEXT;
extern PFNGLDISABLEVERTEXATTRIBARRAYPROC                       gl3wDisableVertexAttribArray;
extern PFNGLDISABLEIPROC                                       gl3wDisablei;
extern PFNGLDISPATCHCOMPUTEPROC                                gl3wDispatchCompute;
extern PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC                    gl3wDispatchComputeGroupSizeARB;
extern PFNGLDISPATCHCOMPUTEINDIRECTPROC                        gl3wDispatchComputeIndirect;
extern PFNGLDRAWARRAYSPROC                                     gl3wDrawArrays;
extern PFNGLDRAWARRAYSINDIRECTPROC                             gl3wDrawArraysIndirect;
extern PFNGLDRAWARRAYSINSTANCEDPROC                            gl3wDrawArraysInstanced;
extern PFNGLDRAWARRAYSINSTANCEDARBPROC                         gl3wDrawArraysInstancedARB;
extern PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC                gl3wDrawArraysInstancedBaseInstance;
extern PFNGLDRAWARRAYSINSTANCEDEXTPROC                         gl3wDrawArraysInstancedEXT;
extern PFNGLDRAWBUFFERPROC                                     gl3wDrawBuffer;
extern PFNGLDRAWBUFFERSPROC                                    gl3wDrawBuffers;
extern PFNGLDRAWCOMMANDSADDRESSNVPROC                          gl3wDrawCommandsAddressNV;
extern PFNGLDRAWCOMMANDSNVPROC                                 gl3wDrawCommandsNV;
extern PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC                    gl3wDrawCommandsStatesAddressNV;
extern PFNGLDRAWCOMMANDSSTATESNVPROC                           gl3wDrawCommandsStatesNV;
extern PFNGLDRAWELEMENTSPROC                                   gl3wDrawElements;
extern PFNGLDRAWELEMENTSBASEVERTEXPROC                         gl3wDrawElementsBaseVertex;
extern PFNGLDRAWELEMENTSINDIRECTPROC                           gl3wDrawElementsIndirect;
extern PFNGLDRAWELEMENTSINSTANCEDPROC                          gl3wDrawElementsInstanced;
extern PFNGLDRAWELEMENTSINSTANCEDARBPROC                       gl3wDrawElementsInstancedARB;
extern PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC              gl3wDrawElementsInstancedBaseInstance;
extern PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC                gl3wDrawElementsInstancedBaseVertex;
extern PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC    gl3wDrawElementsInstancedBaseVertexBaseInstance;
extern PFNGLDRAWELEMENTSINSTANCEDEXTPROC                       gl3wDrawElementsInstancedEXT;
extern PFNGLDRAWRANGEELEMENTSPROC                              gl3wDrawRangeElements;
extern PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC                    gl3wDrawRangeElementsBaseVertex;
extern PFNGLDRAWTRANSFORMFEEDBACKPROC                          gl3wDrawTransformFeedback;
extern PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC                 gl3wDrawTransformFeedbackInstanced;
extern PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC                    gl3wDrawTransformFeedbackStream;
extern PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC           gl3wDrawTransformFeedbackStreamInstanced;
extern PFNGLDRAWVKIMAGENVPROC                                  gl3wDrawVkImageNV;
extern PFNGLEDGEFLAGFORMATNVPROC                               gl3wEdgeFlagFormatNV;
extern PFNGLENABLEPROC                                         gl3wEnable;
extern PFNGLENABLECLIENTSTATEINDEXEDEXTPROC                    gl3wEnableClientStateIndexedEXT;
extern PFNGLENABLECLIENTSTATEIEXTPROC                          gl3wEnableClientStateiEXT;
extern PFNGLENABLEINDEXEDEXTPROC                               gl3wEnableIndexedEXT;
extern PFNGLENABLEVERTEXARRAYATTRIBPROC                        gl3wEnableVertexArrayAttrib;
extern PFNGLENABLEVERTEXARRAYATTRIBEXTPROC                     gl3wEnableVertexArrayAttribEXT;
extern PFNGLENABLEVERTEXARRAYEXTPROC                           gl3wEnableVertexArrayEXT;
extern PFNGLENABLEVERTEXATTRIBARRAYPROC                        gl3wEnableVertexAttribArray;
extern PFNGLENABLEIPROC                                        gl3wEnablei;
extern PFNGLENDCONDITIONALRENDERPROC                           gl3wEndConditionalRender;
extern PFNGLENDCONDITIONALRENDERNVPROC                         gl3wEndConditionalRenderNV;
extern PFNGLENDPERFMONITORAMDPROC                              gl3wEndPerfMonitorAMD;
extern PFNGLENDPERFQUERYINTELPROC                              gl3wEndPerfQueryINTEL;
extern PFNGLENDQUERYPROC                                       gl3wEndQuery;
extern PFNGLENDQUERYINDEXEDPROC                                gl3wEndQueryIndexed;
extern PFNGLENDTRANSFORMFEEDBACKPROC                           gl3wEndTransformFeedback;
extern PFNGLEVALUATEDEPTHVALUESARBPROC                         gl3wEvaluateDepthValuesARB;
extern PFNGLFENCESYNCPROC                                      gl3wFenceSync;
extern PFNGLFINISHPROC                                         gl3wFinish;
extern PFNGLFLUSHPROC                                          gl3wFlush;
extern PFNGLFLUSHMAPPEDBUFFERRANGEPROC                         gl3wFlushMappedBufferRange;
extern PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC                    gl3wFlushMappedNamedBufferRange;
extern PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC                 gl3wFlushMappedNamedBufferRangeEXT;
extern PFNGLFOGCOORDFORMATNVPROC                               gl3wFogCoordFormatNV;
extern PFNGLFRAGMENTCOVERAGECOLORNVPROC                        gl3wFragmentCoverageColorNV;
extern PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC                       gl3wFramebufferDrawBufferEXT;
extern PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC                      gl3wFramebufferDrawBuffersEXT;
extern PFNGLFRAMEBUFFERPARAMETERIPROC                          gl3wFramebufferParameteri;
extern PFNGLFRAMEBUFFERREADBUFFEREXTPROC                       gl3wFramebufferReadBufferEXT;
extern PFNGLFRAMEBUFFERRENDERBUFFERPROC                        gl3wFramebufferRenderbuffer;
extern PFNGLFRAMEBUFFERSAMPLELOCATIONSFVARBPROC                gl3wFramebufferSampleLocationsfvARB;
extern PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC                 gl3wFramebufferSampleLocationsfvNV;
extern PFNGLFRAMEBUFFERTEXTUREPROC                             gl3wFramebufferTexture;
extern PFNGLFRAMEBUFFERTEXTURE1DPROC                           gl3wFramebufferTexture1D;
extern PFNGLFRAMEBUFFERTEXTURE2DPROC                           gl3wFramebufferTexture2D;
extern PFNGLFRAMEBUFFERTEXTURE3DPROC                           gl3wFramebufferTexture3D;
extern PFNGLFRAMEBUFFERTEXTUREARBPROC                          gl3wFramebufferTextureARB;
extern PFNGLFRAMEBUFFERTEXTUREFACEARBPROC                      gl3wFramebufferTextureFaceARB;
extern PFNGLFRAMEBUFFERTEXTURELAYERPROC                        gl3wFramebufferTextureLayer;
extern PFNGLFRAMEBUFFERTEXTURELAYERARBPROC                     gl3wFramebufferTextureLayerARB;
extern PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC                 gl3wFramebufferTextureMultiviewOVR;
extern PFNGLFRONTFACEPROC                                      gl3wFrontFace;
extern PFNGLGENBUFFERSPROC                                     gl3wGenBuffers;
extern PFNGLGENFRAMEBUFFERSPROC                                gl3wGenFramebuffers;
extern PFNGLGENPATHSNVPROC                                     gl3wGenPathsNV;
extern PFNGLGENPERFMONITORSAMDPROC                             gl3wGenPerfMonitorsAMD;
extern PFNGLGENPROGRAMPIPELINESPROC                            gl3wGenProgramPipelines;
extern PFNGLGENQUERIESPROC                                     gl3wGenQueries;
extern PFNGLGENRENDERBUFFERSPROC                               gl3wGenRenderbuffers;
extern PFNGLGENSAMPLERSPROC                                    gl3wGenSamplers;
extern PFNGLGENTEXTURESPROC                                    gl3wGenTextures;
extern PFNGLGENTRANSFORMFEEDBACKSPROC                          gl3wGenTransformFeedbacks;
extern PFNGLGENVERTEXARRAYSPROC                                gl3wGenVertexArrays;
extern PFNGLGENERATEMIPMAPPROC                                 gl3wGenerateMipmap;
extern PFNGLGENERATEMULTITEXMIPMAPEXTPROC                      gl3wGenerateMultiTexMipmapEXT;
extern PFNGLGENERATETEXTUREMIPMAPPROC                          gl3wGenerateTextureMipmap;
extern PFNGLGENERATETEXTUREMIPMAPEXTPROC                       gl3wGenerateTextureMipmapEXT;
extern PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC                 gl3wGetActiveAtomicCounterBufferiv;
extern PFNGLGETACTIVEATTRIBPROC                                gl3wGetActiveAttrib;
extern PFNGLGETACTIVESUBROUTINENAMEPROC                        gl3wGetActiveSubroutineName;
extern PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC                 gl3wGetActiveSubroutineUniformName;
extern PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC                   gl3wGetActiveSubroutineUniformiv;
extern PFNGLGETACTIVEUNIFORMPROC                               gl3wGetActiveUniform;
extern PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC                      gl3wGetActiveUniformBlockName;
extern PFNGLGETACTIVEUNIFORMBLOCKIVPROC                        gl3wGetActiveUniformBlockiv;
extern PFNGLGETACTIVEUNIFORMNAMEPROC                           gl3wGetActiveUniformName;
extern PFNGLGETACTIVEUNIFORMSIVPROC                            gl3wGetActiveUniformsiv;
extern PFNGLGETATTACHEDSHADERSPROC                             gl3wGetAttachedShaders;
extern PFNGLGETATTRIBLOCATIONPROC                              gl3wGetAttribLocation;
extern PFNGLGETBOOLEANINDEXEDVEXTPROC                          gl3wGetBooleanIndexedvEXT;
extern PFNGLGETBOOLEANI_VPROC                                  gl3wGetBooleani_v;
extern PFNGLGETBOOLEANVPROC                                    gl3wGetBooleanv;
extern PFNGLGETBUFFERPARAMETERI64VPROC                         gl3wGetBufferParameteri64v;
extern PFNGLGETBUFFERPARAMETERIVPROC                           gl3wGetBufferParameteriv;
extern PFNGLGETBUFFERPARAMETERUI64VNVPROC                      gl3wGetBufferParameterui64vNV;
extern PFNGLGETBUFFERPOINTERVPROC                              gl3wGetBufferPointerv;
extern PFNGLGETBUFFERSUBDATAPROC                               gl3wGetBufferSubData;
extern PFNGLGETCOMMANDHEADERNVPROC                             gl3wGetCommandHeaderNV;
extern PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC                  gl3wGetCompressedMultiTexImageEXT;
extern PFNGLGETCOMPRESSEDTEXIMAGEPROC                          gl3wGetCompressedTexImage;
extern PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC                      gl3wGetCompressedTextureImage;
extern PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC                   gl3wGetCompressedTextureImageEXT;
extern PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC                   gl3wGetCompressedTextureSubImage;
extern PFNGLGETCOVERAGEMODULATIONTABLENVPROC                   gl3wGetCoverageModulationTableNV;
extern PFNGLGETDEBUGMESSAGELOGPROC                             gl3wGetDebugMessageLog;
extern PFNGLGETDEBUGMESSAGELOGARBPROC                          gl3wGetDebugMessageLogARB;
extern PFNGLGETDOUBLEINDEXEDVEXTPROC                           gl3wGetDoubleIndexedvEXT;
extern PFNGLGETDOUBLEI_VPROC                                   gl3wGetDoublei_v;
extern PFNGLGETDOUBLEI_VEXTPROC                                gl3wGetDoublei_vEXT;
extern PFNGLGETDOUBLEVPROC                                     gl3wGetDoublev;
extern PFNGLGETERRORPROC                                       gl3wGetError;
extern PFNGLGETFIRSTPERFQUERYIDINTELPROC                       gl3wGetFirstPerfQueryIdINTEL;
extern PFNGLGETFLOATINDEXEDVEXTPROC                            gl3wGetFloatIndexedvEXT;
extern PFNGLGETFLOATI_VPROC                                    gl3wGetFloati_v;
extern PFNGLGETFLOATI_VEXTPROC                                 gl3wGetFloati_vEXT;
extern PFNGLGETFLOATVPROC                                      gl3wGetFloatv;
extern PFNGLGETFRAGDATAINDEXPROC                               gl3wGetFragDataIndex;
extern PFNGLGETFRAGDATALOCATIONPROC                            gl3wGetFragDataLocation;
extern PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC            gl3wGetFramebufferAttachmentParameteriv;
extern PFNGLGETFRAMEBUFFERPARAMETERIVPROC                      gl3wGetFramebufferParameteriv;
extern PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC                   gl3wGetFramebufferParameterivEXT;
extern PFNGLGETGRAPHICSRESETSTATUSPROC                         gl3wGetGraphicsResetStatus;
extern PFNGLGETGRAPHICSRESETSTATUSARBPROC                      gl3wGetGraphicsResetStatusARB;
extern PFNGLGETIMAGEHANDLEARBPROC                              gl3wGetImageHandleARB;
extern PFNGLGETIMAGEHANDLENVPROC                               gl3wGetImageHandleNV;
extern PFNGLGETINTEGER64I_VPROC                                gl3wGetInteger64i_v;
extern PFNGLGETINTEGER64VPROC                                  gl3wGetInteger64v;
extern PFNGLGETINTEGERINDEXEDVEXTPROC                          gl3wGetIntegerIndexedvEXT;
extern PFNGLGETINTEGERI_VPROC                                  gl3wGetIntegeri_v;
extern PFNGLGETINTEGERUI64I_VNVPROC                            gl3wGetIntegerui64i_vNV;
extern PFNGLGETINTEGERUI64VNVPROC                              gl3wGetIntegerui64vNV;
extern PFNGLGETINTEGERVPROC                                    gl3wGetIntegerv;
extern PFNGLGETINTERNALFORMATSAMPLEIVNVPROC                    gl3wGetInternalformatSampleivNV;
extern PFNGLGETINTERNALFORMATI64VPROC                          gl3wGetInternalformati64v;
extern PFNGLGETINTERNALFORMATIVPROC                            gl3wGetInternalformativ;
extern PFNGLGETMULTITEXENVFVEXTPROC                            gl3wGetMultiTexEnvfvEXT;
extern PFNGLGETMULTITEXENVIVEXTPROC                            gl3wGetMultiTexEnvivEXT;
extern PFNGLGETMULTITEXGENDVEXTPROC                            gl3wGetMultiTexGendvEXT;
extern PFNGLGETMULTITEXGENFVEXTPROC                            gl3wGetMultiTexGenfvEXT;
extern PFNGLGETMULTITEXGENIVEXTPROC                            gl3wGetMultiTexGenivEXT;
extern PFNGLGETMULTITEXIMAGEEXTPROC                            gl3wGetMultiTexImageEXT;
extern PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC                 gl3wGetMultiTexLevelParameterfvEXT;
extern PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC                 gl3wGetMultiTexLevelParameterivEXT;
extern PFNGLGETMULTITEXPARAMETERIIVEXTPROC                     gl3wGetMultiTexParameterIivEXT;
extern PFNGLGETMULTITEXPARAMETERIUIVEXTPROC                    gl3wGetMultiTexParameterIuivEXT;
extern PFNGLGETMULTITEXPARAMETERFVEXTPROC                      gl3wGetMultiTexParameterfvEXT;
extern PFNGLGETMULTITEXPARAMETERIVEXTPROC                      gl3wGetMultiTexParameterivEXT;
extern PFNGLGETMULTISAMPLEFVPROC                               gl3wGetMultisamplefv;
extern PFNGLGETNAMEDBUFFERPARAMETERI64VPROC                    gl3wGetNamedBufferParameteri64v;
extern PFNGLGETNAMEDBUFFERPARAMETERIVPROC                      gl3wGetNamedBufferParameteriv;
extern PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC                   gl3wGetNamedBufferParameterivEXT;
extern PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC                 gl3wGetNamedBufferParameterui64vNV;
extern PFNGLGETNAMEDBUFFERPOINTERVPROC                         gl3wGetNamedBufferPointerv;
extern PFNGLGETNAMEDBUFFERPOINTERVEXTPROC                      gl3wGetNamedBufferPointervEXT;
extern PFNGLGETNAMEDBUFFERSUBDATAPROC                          gl3wGetNamedBufferSubData;
extern PFNGLGETNAMEDBUFFERSUBDATAEXTPROC                       gl3wGetNamedBufferSubDataEXT;
extern PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC       gl3wGetNamedFramebufferAttachmentParameteriv;
extern PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC    gl3wGetNamedFramebufferAttachmentParameterivEXT;
extern PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC                 gl3wGetNamedFramebufferParameteriv;
extern PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC              gl3wGetNamedFramebufferParameterivEXT;
extern PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC            gl3wGetNamedProgramLocalParameterIivEXT;
extern PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC           gl3wGetNamedProgramLocalParameterIuivEXT;
extern PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC             gl3wGetNamedProgramLocalParameterdvEXT;
extern PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC             gl3wGetNamedProgramLocalParameterfvEXT;
extern PFNGLGETNAMEDPROGRAMSTRINGEXTPROC                       gl3wGetNamedProgramStringEXT;
extern PFNGLGETNAMEDPROGRAMIVEXTPROC                           gl3wGetNamedProgramivEXT;
extern PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC                gl3wGetNamedRenderbufferParameteriv;
extern PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC             gl3wGetNamedRenderbufferParameterivEXT;
extern PFNGLGETNAMEDSTRINGARBPROC                              gl3wGetNamedStringARB;
extern PFNGLGETNAMEDSTRINGIVARBPROC                            gl3wGetNamedStringivARB;
extern PFNGLGETNEXTPERFQUERYIDINTELPROC                        gl3wGetNextPerfQueryIdINTEL;
extern PFNGLGETOBJECTLABELPROC                                 gl3wGetObjectLabel;
extern PFNGLGETOBJECTLABELEXTPROC                              gl3wGetObjectLabelEXT;
extern PFNGLGETOBJECTPTRLABELPROC                              gl3wGetObjectPtrLabel;
extern PFNGLGETPATHCOMMANDSNVPROC                              gl3wGetPathCommandsNV;
extern PFNGLGETPATHCOORDSNVPROC                                gl3wGetPathCoordsNV;
extern PFNGLGETPATHDASHARRAYNVPROC                             gl3wGetPathDashArrayNV;
extern PFNGLGETPATHLENGTHNVPROC                                gl3wGetPathLengthNV;
extern PFNGLGETPATHMETRICRANGENVPROC                           gl3wGetPathMetricRangeNV;
extern PFNGLGETPATHMETRICSNVPROC                               gl3wGetPathMetricsNV;
extern PFNGLGETPATHPARAMETERFVNVPROC                           gl3wGetPathParameterfvNV;
extern PFNGLGETPATHPARAMETERIVNVPROC                           gl3wGetPathParameterivNV;
extern PFNGLGETPATHSPACINGNVPROC                               gl3wGetPathSpacingNV;
extern PFNGLGETPERFCOUNTERINFOINTELPROC                        gl3wGetPerfCounterInfoINTEL;
extern PFNGLGETPERFMONITORCOUNTERDATAAMDPROC                   gl3wGetPerfMonitorCounterDataAMD;
extern PFNGLGETPERFMONITORCOUNTERINFOAMDPROC                   gl3wGetPerfMonitorCounterInfoAMD;
extern PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC                 gl3wGetPerfMonitorCounterStringAMD;
extern PFNGLGETPERFMONITORCOUNTERSAMDPROC                      gl3wGetPerfMonitorCountersAMD;
extern PFNGLGETPERFMONITORGROUPSTRINGAMDPROC                   gl3wGetPerfMonitorGroupStringAMD;
extern PFNGLGETPERFMONITORGROUPSAMDPROC                        gl3wGetPerfMonitorGroupsAMD;
extern PFNGLGETPERFQUERYDATAINTELPROC                          gl3wGetPerfQueryDataINTEL;
extern PFNGLGETPERFQUERYIDBYNAMEINTELPROC                      gl3wGetPerfQueryIdByNameINTEL;
extern PFNGLGETPERFQUERYINFOINTELPROC                          gl3wGetPerfQueryInfoINTEL;
extern PFNGLGETPOINTERINDEXEDVEXTPROC                          gl3wGetPointerIndexedvEXT;
extern PFNGLGETPOINTERI_VEXTPROC                               gl3wGetPointeri_vEXT;
extern PFNGLGETPOINTERVPROC                                    gl3wGetPointerv;
extern PFNGLGETPROGRAMBINARYPROC                               gl3wGetProgramBinary;
extern PFNGLGETPROGRAMINFOLOGPROC                              gl3wGetProgramInfoLog;
extern PFNGLGETPROGRAMINTERFACEIVPROC                          gl3wGetProgramInterfaceiv;
extern PFNGLGETPROGRAMPIPELINEINFOLOGPROC                      gl3wGetProgramPipelineInfoLog;
extern PFNGLGETPROGRAMPIPELINEIVPROC                           gl3wGetProgramPipelineiv;
extern PFNGLGETPROGRAMRESOURCEINDEXPROC                        gl3wGetProgramResourceIndex;
extern PFNGLGETPROGRAMRESOURCELOCATIONPROC                     gl3wGetProgramResourceLocation;
extern PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC                gl3wGetProgramResourceLocationIndex;
extern PFNGLGETPROGRAMRESOURCENAMEPROC                         gl3wGetProgramResourceName;
extern PFNGLGETPROGRAMRESOURCEFVNVPROC                         gl3wGetProgramResourcefvNV;
extern PFNGLGETPROGRAMRESOURCEIVPROC                           gl3wGetProgramResourceiv;
extern PFNGLGETPROGRAMSTAGEIVPROC                              gl3wGetProgramStageiv;
extern PFNGLGETPROGRAMIVPROC                                   gl3wGetProgramiv;
extern PFNGLGETQUERYBUFFEROBJECTI64VPROC                       gl3wGetQueryBufferObjecti64v;
extern PFNGLGETQUERYBUFFEROBJECTIVPROC                         gl3wGetQueryBufferObjectiv;
extern PFNGLGETQUERYBUFFEROBJECTUI64VPROC                      gl3wGetQueryBufferObjectui64v;
extern PFNGLGETQUERYBUFFEROBJECTUIVPROC                        gl3wGetQueryBufferObjectuiv;
extern PFNGLGETQUERYINDEXEDIVPROC                              gl3wGetQueryIndexediv;
extern PFNGLGETQUERYOBJECTI64VPROC                             gl3wGetQueryObjecti64v;
extern PFNGLGETQUERYOBJECTIVPROC                               gl3wGetQueryObjectiv;
extern PFNGLGETQUERYOBJECTUI64VPROC                            gl3wGetQueryObjectui64v;
extern PFNGLGETQUERYOBJECTUIVPROC                              gl3wGetQueryObjectuiv;
extern PFNGLGETQUERYIVPROC                                     gl3wGetQueryiv;
extern PFNGLGETRENDERBUFFERPARAMETERIVPROC                     gl3wGetRenderbufferParameteriv;
extern PFNGLGETSAMPLERPARAMETERIIVPROC                         gl3wGetSamplerParameterIiv;
extern PFNGLGETSAMPLERPARAMETERIUIVPROC                        gl3wGetSamplerParameterIuiv;
extern PFNGLGETSAMPLERPARAMETERFVPROC                          gl3wGetSamplerParameterfv;
extern PFNGLGETSAMPLERPARAMETERIVPROC                          gl3wGetSamplerParameteriv;
extern PFNGLGETSHADERINFOLOGPROC                               gl3wGetShaderInfoLog;
extern PFNGLGETSHADERPRECISIONFORMATPROC                       gl3wGetShaderPrecisionFormat;
extern PFNGLGETSHADERSOURCEPROC                                gl3wGetShaderSource;
extern PFNGLGETSHADERIVPROC                                    gl3wGetShaderiv;
extern PFNGLGETSTAGEINDEXNVPROC                                gl3wGetStageIndexNV;
extern PFNGLGETSTRINGPROC                                      gl3wGetString;
extern PFNGLGETSTRINGIPROC                                     gl3wGetStringi;
extern PFNGLGETSUBROUTINEINDEXPROC                             gl3wGetSubroutineIndex;
extern PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC                   gl3wGetSubroutineUniformLocation;
extern PFNGLGETSYNCIVPROC                                      gl3wGetSynciv;
extern PFNGLGETTEXIMAGEPROC                                    gl3wGetTexImage;
extern PFNGLGETTEXLEVELPARAMETERFVPROC                         gl3wGetTexLevelParameterfv;
extern PFNGLGETTEXLEVELPARAMETERIVPROC                         gl3wGetTexLevelParameteriv;
extern PFNGLGETTEXPARAMETERIIVPROC                             gl3wGetTexParameterIiv;
extern PFNGLGETTEXPARAMETERIUIVPROC                            gl3wGetTexParameterIuiv;
extern PFNGLGETTEXPARAMETERFVPROC                              gl3wGetTexParameterfv;
extern PFNGLGETTEXPARAMETERIVPROC                              gl3wGetTexParameteriv;
extern PFNGLGETTEXTUREHANDLEARBPROC                            gl3wGetTextureHandleARB;
extern PFNGLGETTEXTUREHANDLENVPROC                             gl3wGetTextureHandleNV;
extern PFNGLGETTEXTUREIMAGEPROC                                gl3wGetTextureImage;
extern PFNGLGETTEXTUREIMAGEEXTPROC                             gl3wGetTextureImageEXT;
extern PFNGLGETTEXTURELEVELPARAMETERFVPROC                     gl3wGetTextureLevelParameterfv;
extern PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC                  gl3wGetTextureLevelParameterfvEXT;
extern PFNGLGETTEXTURELEVELPARAMETERIVPROC                     gl3wGetTextureLevelParameteriv;
extern PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC                  gl3wGetTextureLevelParameterivEXT;
extern PFNGLGETTEXTUREPARAMETERIIVPROC                         gl3wGetTextureParameterIiv;
extern PFNGLGETTEXTUREPARAMETERIIVEXTPROC                      gl3wGetTextureParameterIivEXT;
extern PFNGLGETTEXTUREPARAMETERIUIVPROC                        gl3wGetTextureParameterIuiv;
extern PFNGLGETTEXTUREPARAMETERIUIVEXTPROC                     gl3wGetTextureParameterIuivEXT;
extern PFNGLGETTEXTUREPARAMETERFVPROC                          gl3wGetTextureParameterfv;
extern PFNGLGETTEXTUREPARAMETERFVEXTPROC                       gl3wGetTextureParameterfvEXT;
extern PFNGLGETTEXTUREPARAMETERIVPROC                          gl3wGetTextureParameteriv;
extern PFNGLGETTEXTUREPARAMETERIVEXTPROC                       gl3wGetTextureParameterivEXT;
extern PFNGLGETTEXTURESAMPLERHANDLEARBPROC                     gl3wGetTextureSamplerHandleARB;
extern PFNGLGETTEXTURESAMPLERHANDLENVPROC                      gl3wGetTextureSamplerHandleNV;
extern PFNGLGETTEXTURESUBIMAGEPROC                             gl3wGetTextureSubImage;
extern PFNGLGETTRANSFORMFEEDBACKVARYINGPROC                    gl3wGetTransformFeedbackVarying;
extern PFNGLGETTRANSFORMFEEDBACKI64_VPROC                      gl3wGetTransformFeedbacki64_v;
extern PFNGLGETTRANSFORMFEEDBACKI_VPROC                        gl3wGetTransformFeedbacki_v;
extern PFNGLGETTRANSFORMFEEDBACKIVPROC                         gl3wGetTransformFeedbackiv;
extern PFNGLGETUNIFORMBLOCKINDEXPROC                           gl3wGetUniformBlockIndex;
extern PFNGLGETUNIFORMINDICESPROC                              gl3wGetUniformIndices;
extern PFNGLGETUNIFORMLOCATIONPROC                             gl3wGetUniformLocation;
extern PFNGLGETUNIFORMSUBROUTINEUIVPROC                        gl3wGetUniformSubroutineuiv;
extern PFNGLGETUNIFORMDVPROC                                   gl3wGetUniformdv;
extern PFNGLGETUNIFORMFVPROC                                   gl3wGetUniformfv;
extern PFNGLGETUNIFORMI64VARBPROC                              gl3wGetUniformi64vARB;
extern PFNGLGETUNIFORMI64VNVPROC                               gl3wGetUniformi64vNV;
extern PFNGLGETUNIFORMIVPROC                                   gl3wGetUniformiv;
extern PFNGLGETUNIFORMUI64VARBPROC                             gl3wGetUniformui64vARB;
extern PFNGLGETUNIFORMUI64VNVPROC                              gl3wGetUniformui64vNV;
extern PFNGLGETUNIFORMUIVPROC                                  gl3wGetUniformuiv;
extern PFNGLGETVERTEXARRAYINDEXED64IVPROC                      gl3wGetVertexArrayIndexed64iv;
extern PFNGLGETVERTEXARRAYINDEXEDIVPROC                        gl3wGetVertexArrayIndexediv;
extern PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC                    gl3wGetVertexArrayIntegeri_vEXT;
extern PFNGLGETVERTEXARRAYINTEGERVEXTPROC                      gl3wGetVertexArrayIntegervEXT;
extern PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC                    gl3wGetVertexArrayPointeri_vEXT;
extern PFNGLGETVERTEXARRAYPOINTERVEXTPROC                      gl3wGetVertexArrayPointervEXT;
extern PFNGLGETVERTEXARRAYIVPROC                               gl3wGetVertexArrayiv;
extern PFNGLGETVERTEXATTRIBIIVPROC                             gl3wGetVertexAttribIiv;
extern PFNGLGETVERTEXATTRIBIUIVPROC                            gl3wGetVertexAttribIuiv;
extern PFNGLGETVERTEXATTRIBLDVPROC                             gl3wGetVertexAttribLdv;
extern PFNGLGETVERTEXATTRIBLI64VNVPROC                         gl3wGetVertexAttribLi64vNV;
extern PFNGLGETVERTEXATTRIBLUI64VARBPROC                       gl3wGetVertexAttribLui64vARB;
extern PFNGLGETVERTEXATTRIBLUI64VNVPROC                        gl3wGetVertexAttribLui64vNV;
extern PFNGLGETVERTEXATTRIBPOINTERVPROC                        gl3wGetVertexAttribPointerv;
extern PFNGLGETVERTEXATTRIBDVPROC                              gl3wGetVertexAttribdv;
extern PFNGLGETVERTEXATTRIBFVPROC                              gl3wGetVertexAttribfv;
extern PFNGLGETVERTEXATTRIBIVPROC                              gl3wGetVertexAttribiv;
extern PFNGLGETVKPROCADDRNVPROC                                gl3wGetVkProcAddrNV;
extern PFNGLGETNCOMPRESSEDTEXIMAGEPROC                         gl3wGetnCompressedTexImage;
extern PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC                      gl3wGetnCompressedTexImageARB;
extern PFNGLGETNTEXIMAGEPROC                                   gl3wGetnTexImage;
extern PFNGLGETNTEXIMAGEARBPROC                                gl3wGetnTexImageARB;
extern PFNGLGETNUNIFORMDVPROC                                  gl3wGetnUniformdv;
extern PFNGLGETNUNIFORMDVARBPROC                               gl3wGetnUniformdvARB;
extern PFNGLGETNUNIFORMFVPROC                                  gl3wGetnUniformfv;
extern PFNGLGETNUNIFORMFVARBPROC                               gl3wGetnUniformfvARB;
extern PFNGLGETNUNIFORMI64VARBPROC                             gl3wGetnUniformi64vARB;
extern PFNGLGETNUNIFORMIVPROC                                  gl3wGetnUniformiv;
extern PFNGLGETNUNIFORMIVARBPROC                               gl3wGetnUniformivARB;
extern PFNGLGETNUNIFORMUI64VARBPROC                            gl3wGetnUniformui64vARB;
extern PFNGLGETNUNIFORMUIVPROC                                 gl3wGetnUniformuiv;
extern PFNGLGETNUNIFORMUIVARBPROC                              gl3wGetnUniformuivARB;
extern PFNGLHINTPROC                                           gl3wHint;
extern PFNGLINDEXFORMATNVPROC                                  gl3wIndexFormatNV;
extern PFNGLINSERTEVENTMARKEREXTPROC                           gl3wInsertEventMarkerEXT;
extern PFNGLINTERPOLATEPATHSNVPROC                             gl3wInterpolatePathsNV;
extern PFNGLINVALIDATEBUFFERDATAPROC                           gl3wInvalidateBufferData;
extern PFNGLINVALIDATEBUFFERSUBDATAPROC                        gl3wInvalidateBufferSubData;
extern PFNGLINVALIDATEFRAMEBUFFERPROC                          gl3wInvalidateFramebuffer;
extern PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC                 gl3wInvalidateNamedFramebufferData;
extern PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC              gl3wInvalidateNamedFramebufferSubData;
extern PFNGLINVALIDATESUBFRAMEBUFFERPROC                       gl3wInvalidateSubFramebuffer;
extern PFNGLINVALIDATETEXIMAGEPROC                             gl3wInvalidateTexImage;
extern PFNGLINVALIDATETEXSUBIMAGEPROC                          gl3wInvalidateTexSubImage;
extern PFNGLISBUFFERPROC                                       gl3wIsBuffer;
extern PFNGLISBUFFERRESIDENTNVPROC                             gl3wIsBufferResidentNV;
extern PFNGLISCOMMANDLISTNVPROC                                gl3wIsCommandListNV;
extern PFNGLISENABLEDPROC                                      gl3wIsEnabled;
extern PFNGLISENABLEDINDEXEDEXTPROC                            gl3wIsEnabledIndexedEXT;
extern PFNGLISENABLEDIPROC                                     gl3wIsEnabledi;
extern PFNGLISFRAMEBUFFERPROC                                  gl3wIsFramebuffer;
extern PFNGLISIMAGEHANDLERESIDENTARBPROC                       gl3wIsImageHandleResidentARB;
extern PFNGLISIMAGEHANDLERESIDENTNVPROC                        gl3wIsImageHandleResidentNV;
extern PFNGLISNAMEDBUFFERRESIDENTNVPROC                        gl3wIsNamedBufferResidentNV;
extern PFNGLISNAMEDSTRINGARBPROC                               gl3wIsNamedStringARB;
extern PFNGLISPATHNVPROC                                       gl3wIsPathNV;
extern PFNGLISPOINTINFILLPATHNVPROC                            gl3wIsPointInFillPathNV;
extern PFNGLISPOINTINSTROKEPATHNVPROC                          gl3wIsPointInStrokePathNV;
extern PFNGLISPROGRAMPROC                                      gl3wIsProgram;
extern PFNGLISPROGRAMPIPELINEPROC                              gl3wIsProgramPipeline;
extern PFNGLISQUERYPROC                                        gl3wIsQuery;
extern PFNGLISRENDERBUFFERPROC                                 gl3wIsRenderbuffer;
extern PFNGLISSAMPLERPROC                                      gl3wIsSampler;
extern PFNGLISSHADERPROC                                       gl3wIsShader;
extern PFNGLISSTATENVPROC                                      gl3wIsStateNV;
extern PFNGLISSYNCPROC                                         gl3wIsSync;
extern PFNGLISTEXTUREPROC                                      gl3wIsTexture;
extern PFNGLISTEXTUREHANDLERESIDENTARBPROC                     gl3wIsTextureHandleResidentARB;
extern PFNGLISTEXTUREHANDLERESIDENTNVPROC                      gl3wIsTextureHandleResidentNV;
extern PFNGLISTRANSFORMFEEDBACKPROC                            gl3wIsTransformFeedback;
extern PFNGLISVERTEXARRAYPROC                                  gl3wIsVertexArray;
extern PFNGLLABELOBJECTEXTPROC                                 gl3wLabelObjectEXT;
extern PFNGLLINEWIDTHPROC                                      gl3wLineWidth;
extern PFNGLLINKPROGRAMPROC                                    gl3wLinkProgram;
extern PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC                 gl3wListDrawCommandsStatesClientNV;
extern PFNGLLOGICOPPROC                                        gl3wLogicOp;
extern PFNGLMAKEBUFFERNONRESIDENTNVPROC                        gl3wMakeBufferNonResidentNV;
extern PFNGLMAKEBUFFERRESIDENTNVPROC                           gl3wMakeBufferResidentNV;
extern PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC                  gl3wMakeImageHandleNonResidentARB;
extern PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC                   gl3wMakeImageHandleNonResidentNV;
extern PFNGLMAKEIMAGEHANDLERESIDENTARBPROC                     gl3wMakeImageHandleResidentARB;
extern PFNGLMAKEIMAGEHANDLERESIDENTNVPROC                      gl3wMakeImageHandleResidentNV;
extern PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC                   gl3wMakeNamedBufferNonResidentNV;
extern PFNGLMAKENAMEDBUFFERRESIDENTNVPROC                      gl3wMakeNamedBufferResidentNV;
extern PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC                gl3wMakeTextureHandleNonResidentARB;
extern PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC                 gl3wMakeTextureHandleNonResidentNV;
extern PFNGLMAKETEXTUREHANDLERESIDENTARBPROC                   gl3wMakeTextureHandleResidentARB;
extern PFNGLMAKETEXTUREHANDLERESIDENTNVPROC                    gl3wMakeTextureHandleResidentNV;
extern PFNGLMAPBUFFERPROC                                      gl3wMapBuffer;
extern PFNGLMAPBUFFERRANGEPROC                                 gl3wMapBufferRange;
extern PFNGLMAPNAMEDBUFFERPROC                                 gl3wMapNamedBuffer;
extern PFNGLMAPNAMEDBUFFEREXTPROC                              gl3wMapNamedBufferEXT;
extern PFNGLMAPNAMEDBUFFERRANGEPROC                            gl3wMapNamedBufferRange;
extern PFNGLMAPNAMEDBUFFERRANGEEXTPROC                         gl3wMapNamedBufferRangeEXT;
extern PFNGLMATRIXFRUSTUMEXTPROC                               gl3wMatrixFrustumEXT;
extern PFNGLMATRIXLOAD3X2FNVPROC                               gl3wMatrixLoad3x2fNV;
extern PFNGLMATRIXLOAD3X3FNVPROC                               gl3wMatrixLoad3x3fNV;
extern PFNGLMATRIXLOADIDENTITYEXTPROC                          gl3wMatrixLoadIdentityEXT;
extern PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC                      gl3wMatrixLoadTranspose3x3fNV;
extern PFNGLMATRIXLOADTRANSPOSEDEXTPROC                        gl3wMatrixLoadTransposedEXT;
extern PFNGLMATRIXLOADTRANSPOSEFEXTPROC                        gl3wMatrixLoadTransposefEXT;
extern PFNGLMATRIXLOADDEXTPROC                                 gl3wMatrixLoaddEXT;
extern PFNGLMATRIXLOADFEXTPROC                                 gl3wMatrixLoadfEXT;
extern PFNGLMATRIXMULT3X2FNVPROC                               gl3wMatrixMult3x2fNV;
extern PFNGLMATRIXMULT3X3FNVPROC                               gl3wMatrixMult3x3fNV;
extern PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC                      gl3wMatrixMultTranspose3x3fNV;
extern PFNGLMATRIXMULTTRANSPOSEDEXTPROC                        gl3wMatrixMultTransposedEXT;
extern PFNGLMATRIXMULTTRANSPOSEFEXTPROC                        gl3wMatrixMultTransposefEXT;
extern PFNGLMATRIXMULTDEXTPROC                                 gl3wMatrixMultdEXT;
extern PFNGLMATRIXMULTFEXTPROC                                 gl3wMatrixMultfEXT;
extern PFNGLMATRIXORTHOEXTPROC                                 gl3wMatrixOrthoEXT;
extern PFNGLMATRIXPOPEXTPROC                                   gl3wMatrixPopEXT;
extern PFNGLMATRIXPUSHEXTPROC                                  gl3wMatrixPushEXT;
extern PFNGLMATRIXROTATEDEXTPROC                               gl3wMatrixRotatedEXT;
extern PFNGLMATRIXROTATEFEXTPROC                               gl3wMatrixRotatefEXT;
extern PFNGLMATRIXSCALEDEXTPROC                                gl3wMatrixScaledEXT;
extern PFNGLMATRIXSCALEFEXTPROC                                gl3wMatrixScalefEXT;
extern PFNGLMATRIXTRANSLATEDEXTPROC                            gl3wMatrixTranslatedEXT;
extern PFNGLMATRIXTRANSLATEFEXTPROC                            gl3wMatrixTranslatefEXT;
extern PFNGLMAXSHADERCOMPILERTHREADSARBPROC                    gl3wMaxShaderCompilerThreadsARB;
extern PFNGLMEMORYBARRIERPROC                                  gl3wMemoryBarrier;
extern PFNGLMEMORYBARRIERBYREGIONPROC                          gl3wMemoryBarrierByRegion;
extern PFNGLMINSAMPLESHADINGPROC                               gl3wMinSampleShading;
extern PFNGLMINSAMPLESHADINGARBPROC                            gl3wMinSampleShadingARB;
extern PFNGLMULTIDRAWARRAYSPROC                                gl3wMultiDrawArrays;
extern PFNGLMULTIDRAWARRAYSINDIRECTPROC                        gl3wMultiDrawArraysIndirect;
extern PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC         gl3wMultiDrawArraysIndirectBindlessCountNV;
extern PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC              gl3wMultiDrawArraysIndirectBindlessNV;
extern PFNGLMULTIDRAWARRAYSINDIRECTCOUNTPROC                   gl3wMultiDrawArraysIndirectCount;
extern PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC                gl3wMultiDrawArraysIndirectCountARB;
extern PFNGLMULTIDRAWELEMENTSPROC                              gl3wMultiDrawElements;
extern PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC                    gl3wMultiDrawElementsBaseVertex;
extern PFNGLMULTIDRAWELEMENTSINDIRECTPROC                      gl3wMultiDrawElementsIndirect;
extern PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC       gl3wMultiDrawElementsIndirectBindlessCountNV;
extern PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC            gl3wMultiDrawElementsIndirectBindlessNV;
extern PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTPROC                 gl3wMultiDrawElementsIndirectCount;
extern PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC              gl3wMultiDrawElementsIndirectCountARB;
extern PFNGLMULTITEXBUFFEREXTPROC                              gl3wMultiTexBufferEXT;
extern PFNGLMULTITEXCOORDPOINTEREXTPROC                        gl3wMultiTexCoordPointerEXT;
extern PFNGLMULTITEXENVFEXTPROC                                gl3wMultiTexEnvfEXT;
extern PFNGLMULTITEXENVFVEXTPROC                               gl3wMultiTexEnvfvEXT;
extern PFNGLMULTITEXENVIEXTPROC                                gl3wMultiTexEnviEXT;
extern PFNGLMULTITEXENVIVEXTPROC                               gl3wMultiTexEnvivEXT;
extern PFNGLMULTITEXGENDEXTPROC                                gl3wMultiTexGendEXT;
extern PFNGLMULTITEXGENDVEXTPROC                               gl3wMultiTexGendvEXT;
extern PFNGLMULTITEXGENFEXTPROC                                gl3wMultiTexGenfEXT;
extern PFNGLMULTITEXGENFVEXTPROC                               gl3wMultiTexGenfvEXT;
extern PFNGLMULTITEXGENIEXTPROC                                gl3wMultiTexGeniEXT;
extern PFNGLMULTITEXGENIVEXTPROC                               gl3wMultiTexGenivEXT;
extern PFNGLMULTITEXIMAGE1DEXTPROC                             gl3wMultiTexImage1DEXT;
extern PFNGLMULTITEXIMAGE2DEXTPROC                             gl3wMultiTexImage2DEXT;
extern PFNGLMULTITEXIMAGE3DEXTPROC                             gl3wMultiTexImage3DEXT;
extern PFNGLMULTITEXPARAMETERIIVEXTPROC                        gl3wMultiTexParameterIivEXT;
extern PFNGLMULTITEXPARAMETERIUIVEXTPROC                       gl3wMultiTexParameterIuivEXT;
extern PFNGLMULTITEXPARAMETERFEXTPROC                          gl3wMultiTexParameterfEXT;
extern PFNGLMULTITEXPARAMETERFVEXTPROC                         gl3wMultiTexParameterfvEXT;
extern PFNGLMULTITEXPARAMETERIEXTPROC                          gl3wMultiTexParameteriEXT;
extern PFNGLMULTITEXPARAMETERIVEXTPROC                         gl3wMultiTexParameterivEXT;
extern PFNGLMULTITEXRENDERBUFFEREXTPROC                        gl3wMultiTexRenderbufferEXT;
extern PFNGLMULTITEXSUBIMAGE1DEXTPROC                          gl3wMultiTexSubImage1DEXT;
extern PFNGLMULTITEXSUBIMAGE2DEXTPROC                          gl3wMultiTexSubImage2DEXT;
extern PFNGLMULTITEXSUBIMAGE3DEXTPROC                          gl3wMultiTexSubImage3DEXT;
extern PFNGLNAMEDBUFFERDATAPROC                                gl3wNamedBufferData;
extern PFNGLNAMEDBUFFERDATAEXTPROC                             gl3wNamedBufferDataEXT;
extern PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC                   gl3wNamedBufferPageCommitmentARB;
extern PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC                   gl3wNamedBufferPageCommitmentEXT;
extern PFNGLNAMEDBUFFERSTORAGEPROC                             gl3wNamedBufferStorage;
extern PFNGLNAMEDBUFFERSTORAGEEXTPROC                          gl3wNamedBufferStorageEXT;
extern PFNGLNAMEDBUFFERSUBDATAPROC                             gl3wNamedBufferSubData;
extern PFNGLNAMEDBUFFERSUBDATAEXTPROC                          gl3wNamedBufferSubDataEXT;
extern PFNGLNAMEDCOPYBUFFERSUBDATAEXTPROC                      gl3wNamedCopyBufferSubDataEXT;
extern PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC                     gl3wNamedFramebufferDrawBuffer;
extern PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC                    gl3wNamedFramebufferDrawBuffers;
extern PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC                     gl3wNamedFramebufferParameteri;
extern PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC                  gl3wNamedFramebufferParameteriEXT;
extern PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC                     gl3wNamedFramebufferReadBuffer;
extern PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC                   gl3wNamedFramebufferRenderbuffer;
extern PFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC                gl3wNamedFramebufferRenderbufferEXT;
extern PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVARBPROC           gl3wNamedFramebufferSampleLocationsfvARB;
extern PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC            gl3wNamedFramebufferSampleLocationsfvNV;
extern PFNGLNAMEDFRAMEBUFFERTEXTUREPROC                        gl3wNamedFramebufferTexture;
extern PFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC                   gl3wNamedFramebufferTexture1DEXT;
extern PFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC                   gl3wNamedFramebufferTexture2DEXT;
extern PFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC                   gl3wNamedFramebufferTexture3DEXT;
extern PFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC                     gl3wNamedFramebufferTextureEXT;
extern PFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC                 gl3wNamedFramebufferTextureFaceEXT;
extern PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC                   gl3wNamedFramebufferTextureLayer;
extern PFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC                gl3wNamedFramebufferTextureLayerEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC                gl3wNamedProgramLocalParameter4dEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC               gl3wNamedProgramLocalParameter4dvEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC                gl3wNamedProgramLocalParameter4fEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC               gl3wNamedProgramLocalParameter4fvEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC               gl3wNamedProgramLocalParameterI4iEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC              gl3wNamedProgramLocalParameterI4ivEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC              gl3wNamedProgramLocalParameterI4uiEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC             gl3wNamedProgramLocalParameterI4uivEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC              gl3wNamedProgramLocalParameters4fvEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC             gl3wNamedProgramLocalParametersI4ivEXT;
extern PFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC            gl3wNamedProgramLocalParametersI4uivEXT;
extern PFNGLNAMEDPROGRAMSTRINGEXTPROC                          gl3wNamedProgramStringEXT;
extern PFNGLNAMEDRENDERBUFFERSTORAGEPROC                       gl3wNamedRenderbufferStorage;
extern PFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC                    gl3wNamedRenderbufferStorageEXT;
extern PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC            gl3wNamedRenderbufferStorageMultisample;
extern PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC gl3wNamedRenderbufferStorageMultisampleCoverageEXT;
extern PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC         gl3wNamedRenderbufferStorageMultisampleEXT;
extern PFNGLNAMEDSTRINGARBPROC                                 gl3wNamedStringARB;
extern PFNGLNORMALFORMATNVPROC                                 gl3wNormalFormatNV;
extern PFNGLOBJECTLABELPROC                                    gl3wObjectLabel;
extern PFNGLOBJECTPTRLABELPROC                                 gl3wObjectPtrLabel;
extern PFNGLPATCHPARAMETERFVPROC                               gl3wPatchParameterfv;
extern PFNGLPATCHPARAMETERIPROC                                gl3wPatchParameteri;
extern PFNGLPATHCOMMANDSNVPROC                                 gl3wPathCommandsNV;
extern PFNGLPATHCOORDSNVPROC                                   gl3wPathCoordsNV;
extern PFNGLPATHCOVERDEPTHFUNCNVPROC                           gl3wPathCoverDepthFuncNV;
extern PFNGLPATHDASHARRAYNVPROC                                gl3wPathDashArrayNV;
extern PFNGLPATHGLYPHINDEXARRAYNVPROC                          gl3wPathGlyphIndexArrayNV;
extern PFNGLPATHGLYPHINDEXRANGENVPROC                          gl3wPathGlyphIndexRangeNV;
extern PFNGLPATHGLYPHRANGENVPROC                               gl3wPathGlyphRangeNV;
extern PFNGLPATHGLYPHSNVPROC                                   gl3wPathGlyphsNV;
extern PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC                    gl3wPathMemoryGlyphIndexArrayNV;
extern PFNGLPATHPARAMETERFNVPROC                               gl3wPathParameterfNV;
extern PFNGLPATHPARAMETERFVNVPROC                              gl3wPathParameterfvNV;
extern PFNGLPATHPARAMETERINVPROC                               gl3wPathParameteriNV;
extern PFNGLPATHPARAMETERIVNVPROC                              gl3wPathParameterivNV;
extern PFNGLPATHSTENCILDEPTHOFFSETNVPROC                       gl3wPathStencilDepthOffsetNV;
extern PFNGLPATHSTENCILFUNCNVPROC                              gl3wPathStencilFuncNV;
extern PFNGLPATHSTRINGNVPROC                                   gl3wPathStringNV;
extern PFNGLPATHSUBCOMMANDSNVPROC                              gl3wPathSubCommandsNV;
extern PFNGLPATHSUBCOORDSNVPROC                                gl3wPathSubCoordsNV;
extern PFNGLPAUSETRANSFORMFEEDBACKPROC                         gl3wPauseTransformFeedback;
extern PFNGLPIXELSTOREFPROC                                    gl3wPixelStoref;
extern PFNGLPIXELSTOREIPROC                                    gl3wPixelStorei;
extern PFNGLPOINTALONGPATHNVPROC                               gl3wPointAlongPathNV;
extern PFNGLPOINTPARAMETERFPROC                                gl3wPointParameterf;
extern PFNGLPOINTPARAMETERFVPROC                               gl3wPointParameterfv;
extern PFNGLPOINTPARAMETERIPROC                                gl3wPointParameteri;
extern PFNGLPOINTPARAMETERIVPROC                               gl3wPointParameteriv;
extern PFNGLPOINTSIZEPROC                                      gl3wPointSize;
extern PFNGLPOLYGONMODEPROC                                    gl3wPolygonMode;
extern PFNGLPOLYGONOFFSETPROC                                  gl3wPolygonOffset;
extern PFNGLPOLYGONOFFSETCLAMPPROC                             gl3wPolygonOffsetClamp;
extern PFNGLPOLYGONOFFSETCLAMPEXTPROC                          gl3wPolygonOffsetClampEXT;
extern PFNGLPOPDEBUGGROUPPROC                                  gl3wPopDebugGroup;
extern PFNGLPOPGROUPMARKEREXTPROC                              gl3wPopGroupMarkerEXT;
extern PFNGLPRIMITIVEBOUNDINGBOXARBPROC                        gl3wPrimitiveBoundingBoxARB;
extern PFNGLPRIMITIVERESTARTINDEXPROC                          gl3wPrimitiveRestartIndex;
extern PFNGLPROGRAMBINARYPROC                                  gl3wProgramBinary;
extern PFNGLPROGRAMPARAMETERIPROC                              gl3wProgramParameteri;
extern PFNGLPROGRAMPARAMETERIARBPROC                           gl3wProgramParameteriARB;
extern PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC                  gl3wProgramPathFragmentInputGenNV;
extern PFNGLPROGRAMUNIFORM1DPROC                               gl3wProgramUniform1d;
extern PFNGLPROGRAMUNIFORM1DEXTPROC                            gl3wProgramUniform1dEXT;
extern PFNGLPROGRAMUNIFORM1DVPROC                              gl3wProgramUniform1dv;
extern PFNGLPROGRAMUNIFORM1DVEXTPROC                           gl3wProgramUniform1dvEXT;
extern PFNGLPROGRAMUNIFORM1FPROC                               gl3wProgramUniform1f;
extern PFNGLPROGRAMUNIFORM1FEXTPROC                            gl3wProgramUniform1fEXT;
extern PFNGLPROGRAMUNIFORM1FVPROC                              gl3wProgramUniform1fv;
extern PFNGLPROGRAMUNIFORM1FVEXTPROC                           gl3wProgramUniform1fvEXT;
extern PFNGLPROGRAMUNIFORM1IPROC                               gl3wProgramUniform1i;
extern PFNGLPROGRAMUNIFORM1I64ARBPROC                          gl3wProgramUniform1i64ARB;
extern PFNGLPROGRAMUNIFORM1I64NVPROC                           gl3wProgramUniform1i64NV;
extern PFNGLPROGRAMUNIFORM1I64VARBPROC                         gl3wProgramUniform1i64vARB;
extern PFNGLPROGRAMUNIFORM1I64VNVPROC                          gl3wProgramUniform1i64vNV;
extern PFNGLPROGRAMUNIFORM1IEXTPROC                            gl3wProgramUniform1iEXT;
extern PFNGLPROGRAMUNIFORM1IVPROC                              gl3wProgramUniform1iv;
extern PFNGLPROGRAMUNIFORM1IVEXTPROC                           gl3wProgramUniform1ivEXT;
extern PFNGLPROGRAMUNIFORM1UIPROC                              gl3wProgramUniform1ui;
extern PFNGLPROGRAMUNIFORM1UI64ARBPROC                         gl3wProgramUniform1ui64ARB;
extern PFNGLPROGRAMUNIFORM1UI64NVPROC                          gl3wProgramUniform1ui64NV;
extern PFNGLPROGRAMUNIFORM1UI64VARBPROC                        gl3wProgramUniform1ui64vARB;
extern PFNGLPROGRAMUNIFORM1UI64VNVPROC                         gl3wProgramUniform1ui64vNV;
extern PFNGLPROGRAMUNIFORM1UIEXTPROC                           gl3wProgramUniform1uiEXT;
extern PFNGLPROGRAMUNIFORM1UIVPROC                             gl3wProgramUniform1uiv;
extern PFNGLPROGRAMUNIFORM1UIVEXTPROC                          gl3wProgramUniform1uivEXT;
extern PFNGLPROGRAMUNIFORM2DPROC                               gl3wProgramUniform2d;
extern PFNGLPROGRAMUNIFORM2DEXTPROC                            gl3wProgramUniform2dEXT;
extern PFNGLPROGRAMUNIFORM2DVPROC                              gl3wProgramUniform2dv;
extern PFNGLPROGRAMUNIFORM2DVEXTPROC                           gl3wProgramUniform2dvEXT;
extern PFNGLPROGRAMUNIFORM2FPROC                               gl3wProgramUniform2f;
extern PFNGLPROGRAMUNIFORM2FEXTPROC                            gl3wProgramUniform2fEXT;
extern PFNGLPROGRAMUNIFORM2FVPROC                              gl3wProgramUniform2fv;
extern PFNGLPROGRAMUNIFORM2FVEXTPROC                           gl3wProgramUniform2fvEXT;
extern PFNGLPROGRAMUNIFORM2IPROC                               gl3wProgramUniform2i;
extern PFNGLPROGRAMUNIFORM2I64ARBPROC                          gl3wProgramUniform2i64ARB;
extern PFNGLPROGRAMUNIFORM2I64NVPROC                           gl3wProgramUniform2i64NV;
extern PFNGLPROGRAMUNIFORM2I64VARBPROC                         gl3wProgramUniform2i64vARB;
extern PFNGLPROGRAMUNIFORM2I64VNVPROC                          gl3wProgramUniform2i64vNV;
extern PFNGLPROGRAMUNIFORM2IEXTPROC                            gl3wProgramUniform2iEXT;
extern PFNGLPROGRAMUNIFORM2IVPROC                              gl3wProgramUniform2iv;
extern PFNGLPROGRAMUNIFORM2IVEXTPROC                           gl3wProgramUniform2ivEXT;
extern PFNGLPROGRAMUNIFORM2UIPROC                              gl3wProgramUniform2ui;
extern PFNGLPROGRAMUNIFORM2UI64ARBPROC                         gl3wProgramUniform2ui64ARB;
extern PFNGLPROGRAMUNIFORM2UI64NVPROC                          gl3wProgramUniform2ui64NV;
extern PFNGLPROGRAMUNIFORM2UI64VARBPROC                        gl3wProgramUniform2ui64vARB;
extern PFNGLPROGRAMUNIFORM2UI64VNVPROC                         gl3wProgramUniform2ui64vNV;
extern PFNGLPROGRAMUNIFORM2UIEXTPROC                           gl3wProgramUniform2uiEXT;
extern PFNGLPROGRAMUNIFORM2UIVPROC                             gl3wProgramUniform2uiv;
extern PFNGLPROGRAMUNIFORM2UIVEXTPROC                          gl3wProgramUniform2uivEXT;
extern PFNGLPROGRAMUNIFORM3DPROC                               gl3wProgramUniform3d;
extern PFNGLPROGRAMUNIFORM3DEXTPROC                            gl3wProgramUniform3dEXT;
extern PFNGLPROGRAMUNIFORM3DVPROC                              gl3wProgramUniform3dv;
extern PFNGLPROGRAMUNIFORM3DVEXTPROC                           gl3wProgramUniform3dvEXT;
extern PFNGLPROGRAMUNIFORM3FPROC                               gl3wProgramUniform3f;
extern PFNGLPROGRAMUNIFORM3FEXTPROC                            gl3wProgramUniform3fEXT;
extern PFNGLPROGRAMUNIFORM3FVPROC                              gl3wProgramUniform3fv;
extern PFNGLPROGRAMUNIFORM3FVEXTPROC                           gl3wProgramUniform3fvEXT;
extern PFNGLPROGRAMUNIFORM3IPROC                               gl3wProgramUniform3i;
extern PFNGLPROGRAMUNIFORM3I64ARBPROC                          gl3wProgramUniform3i64ARB;
extern PFNGLPROGRAMUNIFORM3I64NVPROC                           gl3wProgramUniform3i64NV;
extern PFNGLPROGRAMUNIFORM3I64VARBPROC                         gl3wProgramUniform3i64vARB;
extern PFNGLPROGRAMUNIFORM3I64VNVPROC                          gl3wProgramUniform3i64vNV;
extern PFNGLPROGRAMUNIFORM3IEXTPROC                            gl3wProgramUniform3iEXT;
extern PFNGLPROGRAMUNIFORM3IVPROC                              gl3wProgramUniform3iv;
extern PFNGLPROGRAMUNIFORM3IVEXTPROC                           gl3wProgramUniform3ivEXT;
extern PFNGLPROGRAMUNIFORM3UIPROC                              gl3wProgramUniform3ui;
extern PFNGLPROGRAMUNIFORM3UI64ARBPROC                         gl3wProgramUniform3ui64ARB;
extern PFNGLPROGRAMUNIFORM3UI64NVPROC                          gl3wProgramUniform3ui64NV;
extern PFNGLPROGRAMUNIFORM3UI64VARBPROC                        gl3wProgramUniform3ui64vARB;
extern PFNGLPROGRAMUNIFORM3UI64VNVPROC                         gl3wProgramUniform3ui64vNV;
extern PFNGLPROGRAMUNIFORM3UIEXTPROC                           gl3wProgramUniform3uiEXT;
extern PFNGLPROGRAMUNIFORM3UIVPROC                             gl3wProgramUniform3uiv;
extern PFNGLPROGRAMUNIFORM3UIVEXTPROC                          gl3wProgramUniform3uivEXT;
extern PFNGLPROGRAMUNIFORM4DPROC                               gl3wProgramUniform4d;
extern PFNGLPROGRAMUNIFORM4DEXTPROC                            gl3wProgramUniform4dEXT;
extern PFNGLPROGRAMUNIFORM4DVPROC                              gl3wProgramUniform4dv;
extern PFNGLPROGRAMUNIFORM4DVEXTPROC                           gl3wProgramUniform4dvEXT;
extern PFNGLPROGRAMUNIFORM4FPROC                               gl3wProgramUniform4f;
extern PFNGLPROGRAMUNIFORM4FEXTPROC                            gl3wProgramUniform4fEXT;
extern PFNGLPROGRAMUNIFORM4FVPROC                              gl3wProgramUniform4fv;
extern PFNGLPROGRAMUNIFORM4FVEXTPROC                           gl3wProgramUniform4fvEXT;
extern PFNGLPROGRAMUNIFORM4IPROC                               gl3wProgramUniform4i;
extern PFNGLPROGRAMUNIFORM4I64ARBPROC                          gl3wProgramUniform4i64ARB;
extern PFNGLPROGRAMUNIFORM4I64NVPROC                           gl3wProgramUniform4i64NV;
extern PFNGLPROGRAMUNIFORM4I64VARBPROC                         gl3wProgramUniform4i64vARB;
extern PFNGLPROGRAMUNIFORM4I64VNVPROC                          gl3wProgramUniform4i64vNV;
extern PFNGLPROGRAMUNIFORM4IEXTPROC                            gl3wProgramUniform4iEXT;
extern PFNGLPROGRAMUNIFORM4IVPROC                              gl3wProgramUniform4iv;
extern PFNGLPROGRAMUNIFORM4IVEXTPROC                           gl3wProgramUniform4ivEXT;
extern PFNGLPROGRAMUNIFORM4UIPROC                              gl3wProgramUniform4ui;
extern PFNGLPROGRAMUNIFORM4UI64ARBPROC                         gl3wProgramUniform4ui64ARB;
extern PFNGLPROGRAMUNIFORM4UI64NVPROC                          gl3wProgramUniform4ui64NV;
extern PFNGLPROGRAMUNIFORM4UI64VARBPROC                        gl3wProgramUniform4ui64vARB;
extern PFNGLPROGRAMUNIFORM4UI64VNVPROC                         gl3wProgramUniform4ui64vNV;
extern PFNGLPROGRAMUNIFORM4UIEXTPROC                           gl3wProgramUniform4uiEXT;
extern PFNGLPROGRAMUNIFORM4UIVPROC                             gl3wProgramUniform4uiv;
extern PFNGLPROGRAMUNIFORM4UIVEXTPROC                          gl3wProgramUniform4uivEXT;
extern PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC                    gl3wProgramUniformHandleui64ARB;
extern PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC                     gl3wProgramUniformHandleui64NV;
extern PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC                   gl3wProgramUniformHandleui64vARB;
extern PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC                    gl3wProgramUniformHandleui64vNV;
extern PFNGLPROGRAMUNIFORMMATRIX2DVPROC                        gl3wProgramUniformMatrix2dv;
extern PFNGLPROGRAMUNIFORMMATRIX2DVEXTPROC                     gl3wProgramUniformMatrix2dvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX2FVPROC                        gl3wProgramUniformMatrix2fv;
extern PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC                     gl3wProgramUniformMatrix2fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC                      gl3wProgramUniformMatrix2x3dv;
extern PFNGLPROGRAMUNIFORMMATRIX2X3DVEXTPROC                   gl3wProgramUniformMatrix2x3dvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC                      gl3wProgramUniformMatrix2x3fv;
extern PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC                   gl3wProgramUniformMatrix2x3fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC                      gl3wProgramUniformMatrix2x4dv;
extern PFNGLPROGRAMUNIFORMMATRIX2X4DVEXTPROC                   gl3wProgramUniformMatrix2x4dvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC                      gl3wProgramUniformMatrix2x4fv;
extern PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC                   gl3wProgramUniformMatrix2x4fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX3DVPROC                        gl3wProgramUniformMatrix3dv;
extern PFNGLPROGRAMUNIFORMMATRIX3DVEXTPROC                     gl3wProgramUniformMatrix3dvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX3FVPROC                        gl3wProgramUniformMatrix3fv;
extern PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC                     gl3wProgramUniformMatrix3fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC                      gl3wProgramUniformMatrix3x2dv;
extern PFNGLPROGRAMUNIFORMMATRIX3X2DVEXTPROC                   gl3wProgramUniformMatrix3x2dvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC                      gl3wProgramUniformMatrix3x2fv;
extern PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC                   gl3wProgramUniformMatrix3x2fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC                      gl3wProgramUniformMatrix3x4dv;
extern PFNGLPROGRAMUNIFORMMATRIX3X4DVEXTPROC                   gl3wProgramUniformMatrix3x4dvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC                      gl3wProgramUniformMatrix3x4fv;
extern PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC                   gl3wProgramUniformMatrix3x4fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX4DVPROC                        gl3wProgramUniformMatrix4dv;
extern PFNGLPROGRAMUNIFORMMATRIX4DVEXTPROC                     gl3wProgramUniformMatrix4dvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX4FVPROC                        gl3wProgramUniformMatrix4fv;
extern PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC                     gl3wProgramUniformMatrix4fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC                      gl3wProgramUniformMatrix4x2dv;
extern PFNGLPROGRAMUNIFORMMATRIX4X2DVEXTPROC                   gl3wProgramUniformMatrix4x2dvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC                      gl3wProgramUniformMatrix4x2fv;
extern PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC                   gl3wProgramUniformMatrix4x2fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC                      gl3wProgramUniformMatrix4x3dv;
extern PFNGLPROGRAMUNIFORMMATRIX4X3DVEXTPROC                   gl3wProgramUniformMatrix4x3dvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC                      gl3wProgramUniformMatrix4x3fv;
extern PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC                   gl3wProgramUniformMatrix4x3fvEXT;
extern PFNGLPROGRAMUNIFORMUI64NVPROC                           gl3wProgramUniformui64NV;
extern PFNGLPROGRAMUNIFORMUI64VNVPROC                          gl3wProgramUniformui64vNV;
extern PFNGLPROVOKINGVERTEXPROC                                gl3wProvokingVertex;
extern PFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC                     gl3wPushClientAttribDefaultEXT;
extern PFNGLPUSHDEBUGGROUPPROC                                 gl3wPushDebugGroup;
extern PFNGLPUSHGROUPMARKEREXTPROC                             gl3wPushGroupMarkerEXT;
extern PFNGLQUERYCOUNTERPROC                                   gl3wQueryCounter;
extern PFNGLRASTERSAMPLESEXTPROC                               gl3wRasterSamplesEXT;
extern PFNGLREADBUFFERPROC                                     gl3wReadBuffer;
extern PFNGLREADPIXELSPROC                                     gl3wReadPixels;
extern PFNGLREADNPIXELSPROC                                    gl3wReadnPixels;
extern PFNGLREADNPIXELSARBPROC                                 gl3wReadnPixelsARB;
extern PFNGLRELEASESHADERCOMPILERPROC                          gl3wReleaseShaderCompiler;
extern PFNGLRENDERBUFFERSTORAGEPROC                            gl3wRenderbufferStorage;
extern PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC                 gl3wRenderbufferStorageMultisample;
extern PFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC       gl3wRenderbufferStorageMultisampleCoverageNV;
extern PFNGLRESOLVEDEPTHVALUESNVPROC                           gl3wResolveDepthValuesNV;
extern PFNGLRESUMETRANSFORMFEEDBACKPROC                        gl3wResumeTransformFeedback;
extern PFNGLSAMPLECOVERAGEPROC                                 gl3wSampleCoverage;
extern PFNGLSAMPLEMASKIPROC                                    gl3wSampleMaski;
extern PFNGLSAMPLERPARAMETERIIVPROC                            gl3wSamplerParameterIiv;
extern PFNGLSAMPLERPARAMETERIUIVPROC                           gl3wSamplerParameterIuiv;
extern PFNGLSAMPLERPARAMETERFPROC                              gl3wSamplerParameterf;
extern PFNGLSAMPLERPARAMETERFVPROC                             gl3wSamplerParameterfv;
extern PFNGLSAMPLERPARAMETERIPROC                              gl3wSamplerParameteri;
extern PFNGLSAMPLERPARAMETERIVPROC                             gl3wSamplerParameteriv;
extern PFNGLSCISSORPROC                                        gl3wScissor;
extern PFNGLSCISSORARRAYVPROC                                  gl3wScissorArrayv;
extern PFNGLSCISSORINDEXEDPROC                                 gl3wScissorIndexed;
extern PFNGLSCISSORINDEXEDVPROC                                gl3wScissorIndexedv;
extern PFNGLSECONDARYCOLORFORMATNVPROC                         gl3wSecondaryColorFormatNV;
extern PFNGLSELECTPERFMONITORCOUNTERSAMDPROC                   gl3wSelectPerfMonitorCountersAMD;
extern PFNGLSHADERBINARYPROC                                   gl3wShaderBinary;
extern PFNGLSHADERSOURCEPROC                                   gl3wShaderSource;
extern PFNGLSHADERSTORAGEBLOCKBINDINGPROC                      gl3wShaderStorageBlockBinding;
extern PFNGLSIGNALVKFENCENVPROC                                gl3wSignalVkFenceNV;
extern PFNGLSIGNALVKSEMAPHORENVPROC                            gl3wSignalVkSemaphoreNV;
extern PFNGLSPECIALIZESHADERPROC                               gl3wSpecializeShader;
extern PFNGLSPECIALIZESHADERARBPROC                            gl3wSpecializeShaderARB;
extern PFNGLSTATECAPTURENVPROC                                 gl3wStateCaptureNV;
extern PFNGLSTENCILFILLPATHINSTANCEDNVPROC                     gl3wStencilFillPathInstancedNV;
extern PFNGLSTENCILFILLPATHNVPROC                              gl3wStencilFillPathNV;
extern PFNGLSTENCILFUNCPROC                                    gl3wStencilFunc;
extern PFNGLSTENCILFUNCSEPARATEPROC                            gl3wStencilFuncSeparate;
extern PFNGLSTENCILMASKPROC                                    gl3wStencilMask;
extern PFNGLSTENCILMASKSEPARATEPROC                            gl3wStencilMaskSeparate;
extern PFNGLSTENCILOPPROC                                      gl3wStencilOp;
extern PFNGLSTENCILOPSEPARATEPROC                              gl3wStencilOpSeparate;
extern PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC                   gl3wStencilStrokePathInstancedNV;
extern PFNGLSTENCILSTROKEPATHNVPROC                            gl3wStencilStrokePathNV;
extern PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC            gl3wStencilThenCoverFillPathInstancedNV;
extern PFNGLSTENCILTHENCOVERFILLPATHNVPROC                     gl3wStencilThenCoverFillPathNV;
extern PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC          gl3wStencilThenCoverStrokePathInstancedNV;
extern PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC                   gl3wStencilThenCoverStrokePathNV;
extern PFNGLSUBPIXELPRECISIONBIASNVPROC                        gl3wSubpixelPrecisionBiasNV;
extern PFNGLTEXBUFFERPROC                                      gl3wTexBuffer;
extern PFNGLTEXBUFFERARBPROC                                   gl3wTexBufferARB;
extern PFNGLTEXBUFFERRANGEPROC                                 gl3wTexBufferRange;
extern PFNGLTEXCOORDFORMATNVPROC                               gl3wTexCoordFormatNV;
extern PFNGLTEXIMAGE1DPROC                                     gl3wTexImage1D;
extern PFNGLTEXIMAGE2DPROC                                     gl3wTexImage2D;
extern PFNGLTEXIMAGE2DMULTISAMPLEPROC                          gl3wTexImage2DMultisample;
extern PFNGLTEXIMAGE3DPROC                                     gl3wTexImage3D;
extern PFNGLTEXIMAGE3DMULTISAMPLEPROC                          gl3wTexImage3DMultisample;
extern PFNGLTEXPAGECOMMITMENTARBPROC                           gl3wTexPageCommitmentARB;
extern PFNGLTEXPARAMETERIIVPROC                                gl3wTexParameterIiv;
extern PFNGLTEXPARAMETERIUIVPROC                               gl3wTexParameterIuiv;
extern PFNGLTEXPARAMETERFPROC                                  gl3wTexParameterf;
extern PFNGLTEXPARAMETERFVPROC                                 gl3wTexParameterfv;
extern PFNGLTEXPARAMETERIPROC                                  gl3wTexParameteri;
extern PFNGLTEXPARAMETERIVPROC                                 gl3wTexParameteriv;
extern PFNGLTEXSTORAGE1DPROC                                   gl3wTexStorage1D;
extern PFNGLTEXSTORAGE2DPROC                                   gl3wTexStorage2D;
extern PFNGLTEXSTORAGE2DMULTISAMPLEPROC                        gl3wTexStorage2DMultisample;
extern PFNGLTEXSTORAGE3DPROC                                   gl3wTexStorage3D;
extern PFNGLTEXSTORAGE3DMULTISAMPLEPROC                        gl3wTexStorage3DMultisample;
extern PFNGLTEXSUBIMAGE1DPROC                                  gl3wTexSubImage1D;
extern PFNGLTEXSUBIMAGE2DPROC                                  gl3wTexSubImage2D;
extern PFNGLTEXSUBIMAGE3DPROC                                  gl3wTexSubImage3D;
extern PFNGLTEXTUREBARRIERPROC                                 gl3wTextureBarrier;
extern PFNGLTEXTUREBARRIERNVPROC                               gl3wTextureBarrierNV;
extern PFNGLTEXTUREBUFFERPROC                                  gl3wTextureBuffer;
extern PFNGLTEXTUREBUFFEREXTPROC                               gl3wTextureBufferEXT;
extern PFNGLTEXTUREBUFFERRANGEPROC                             gl3wTextureBufferRange;
extern PFNGLTEXTUREBUFFERRANGEEXTPROC                          gl3wTextureBufferRangeEXT;
extern PFNGLTEXTUREIMAGE1DEXTPROC                              gl3wTextureImage1DEXT;
extern PFNGLTEXTUREIMAGE2DEXTPROC                              gl3wTextureImage2DEXT;
extern PFNGLTEXTUREIMAGE3DEXTPROC                              gl3wTextureImage3DEXT;
extern PFNGLTEXTUREPAGECOMMITMENTEXTPROC                       gl3wTexturePageCommitmentEXT;
extern PFNGLTEXTUREPARAMETERIIVPROC                            gl3wTextureParameterIiv;
extern PFNGLTEXTUREPARAMETERIIVEXTPROC                         gl3wTextureParameterIivEXT;
extern PFNGLTEXTUREPARAMETERIUIVPROC                           gl3wTextureParameterIuiv;
extern PFNGLTEXTUREPARAMETERIUIVEXTPROC                        gl3wTextureParameterIuivEXT;
extern PFNGLTEXTUREPARAMETERFPROC                              gl3wTextureParameterf;
extern PFNGLTEXTUREPARAMETERFEXTPROC                           gl3wTextureParameterfEXT;
extern PFNGLTEXTUREPARAMETERFVPROC                             gl3wTextureParameterfv;
extern PFNGLTEXTUREPARAMETERFVEXTPROC                          gl3wTextureParameterfvEXT;
extern PFNGLTEXTUREPARAMETERIPROC                              gl3wTextureParameteri;
extern PFNGLTEXTUREPARAMETERIEXTPROC                           gl3wTextureParameteriEXT;
extern PFNGLTEXTUREPARAMETERIVPROC                             gl3wTextureParameteriv;
extern PFNGLTEXTUREPARAMETERIVEXTPROC                          gl3wTextureParameterivEXT;
extern PFNGLTEXTURERENDERBUFFEREXTPROC                         gl3wTextureRenderbufferEXT;
extern PFNGLTEXTURESTORAGE1DPROC                               gl3wTextureStorage1D;
extern PFNGLTEXTURESTORAGE1DEXTPROC                            gl3wTextureStorage1DEXT;
extern PFNGLTEXTURESTORAGE2DPROC                               gl3wTextureStorage2D;
extern PFNGLTEXTURESTORAGE2DEXTPROC                            gl3wTextureStorage2DEXT;
extern PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC                    gl3wTextureStorage2DMultisample;
extern PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC                 gl3wTextureStorage2DMultisampleEXT;
extern PFNGLTEXTURESTORAGE3DPROC                               gl3wTextureStorage3D;
extern PFNGLTEXTURESTORAGE3DEXTPROC                            gl3wTextureStorage3DEXT;
extern PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC                    gl3wTextureStorage3DMultisample;
extern PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC                 gl3wTextureStorage3DMultisampleEXT;
extern PFNGLTEXTURESUBIMAGE1DPROC                              gl3wTextureSubImage1D;
extern PFNGLTEXTURESUBIMAGE1DEXTPROC                           gl3wTextureSubImage1DEXT;
extern PFNGLTEXTURESUBIMAGE2DPROC                              gl3wTextureSubImage2D;
extern PFNGLTEXTURESUBIMAGE2DEXTPROC                           gl3wTextureSubImage2DEXT;
extern PFNGLTEXTURESUBIMAGE3DPROC                              gl3wTextureSubImage3D;
extern PFNGLTEXTURESUBIMAGE3DEXTPROC                           gl3wTextureSubImage3DEXT;
extern PFNGLTEXTUREVIEWPROC                                    gl3wTextureView;
extern PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC                    gl3wTransformFeedbackBufferBase;
extern PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC                   gl3wTransformFeedbackBufferRange;
extern PFNGLTRANSFORMFEEDBACKVARYINGSPROC                      gl3wTransformFeedbackVaryings;
extern PFNGLTRANSFORMPATHNVPROC                                gl3wTransformPathNV;
extern PFNGLUNIFORM1DPROC                                      gl3wUniform1d;
extern PFNGLUNIFORM1DVPROC                                     gl3wUniform1dv;
extern PFNGLUNIFORM1FPROC                                      gl3wUniform1f;
extern PFNGLUNIFORM1FVPROC                                     gl3wUniform1fv;
extern PFNGLUNIFORM1IPROC                                      gl3wUniform1i;
extern PFNGLUNIFORM1I64ARBPROC                                 gl3wUniform1i64ARB;
extern PFNGLUNIFORM1I64NVPROC                                  gl3wUniform1i64NV;
extern PFNGLUNIFORM1I64VARBPROC                                gl3wUniform1i64vARB;
extern PFNGLUNIFORM1I64VNVPROC                                 gl3wUniform1i64vNV;
extern PFNGLUNIFORM1IVPROC                                     gl3wUniform1iv;
extern PFNGLUNIFORM1UIPROC                                     gl3wUniform1ui;
extern PFNGLUNIFORM1UI64ARBPROC                                gl3wUniform1ui64ARB;
extern PFNGLUNIFORM1UI64NVPROC                                 gl3wUniform1ui64NV;
extern PFNGLUNIFORM1UI64VARBPROC                               gl3wUniform1ui64vARB;
extern PFNGLUNIFORM1UI64VNVPROC                                gl3wUniform1ui64vNV;
extern PFNGLUNIFORM1UIVPROC                                    gl3wUniform1uiv;
extern PFNGLUNIFORM2DPROC                                      gl3wUniform2d;
extern PFNGLUNIFORM2DVPROC                                     gl3wUniform2dv;
extern PFNGLUNIFORM2FPROC                                      gl3wUniform2f;
extern PFNGLUNIFORM2FVPROC                                     gl3wUniform2fv;
extern PFNGLUNIFORM2IPROC                                      gl3wUniform2i;
extern PFNGLUNIFORM2I64ARBPROC                                 gl3wUniform2i64ARB;
extern PFNGLUNIFORM2I64NVPROC                                  gl3wUniform2i64NV;
extern PFNGLUNIFORM2I64VARBPROC                                gl3wUniform2i64vARB;
extern PFNGLUNIFORM2I64VNVPROC                                 gl3wUniform2i64vNV;
extern PFNGLUNIFORM2IVPROC                                     gl3wUniform2iv;
extern PFNGLUNIFORM2UIPROC                                     gl3wUniform2ui;
extern PFNGLUNIFORM2UI64ARBPROC                                gl3wUniform2ui64ARB;
extern PFNGLUNIFORM2UI64NVPROC                                 gl3wUniform2ui64NV;
extern PFNGLUNIFORM2UI64VARBPROC                               gl3wUniform2ui64vARB;
extern PFNGLUNIFORM2UI64VNVPROC                                gl3wUniform2ui64vNV;
extern PFNGLUNIFORM2UIVPROC                                    gl3wUniform2uiv;
extern PFNGLUNIFORM3DPROC                                      gl3wUniform3d;
extern PFNGLUNIFORM3DVPROC                                     gl3wUniform3dv;
extern PFNGLUNIFORM3FPROC                                      gl3wUniform3f;
extern PFNGLUNIFORM3FVPROC                                     gl3wUniform3fv;
extern PFNGLUNIFORM3IPROC                                      gl3wUniform3i;
extern PFNGLUNIFORM3I64ARBPROC                                 gl3wUniform3i64ARB;
extern PFNGLUNIFORM3I64NVPROC                                  gl3wUniform3i64NV;
extern PFNGLUNIFORM3I64VARBPROC                                gl3wUniform3i64vARB;
extern PFNGLUNIFORM3I64VNVPROC                                 gl3wUniform3i64vNV;
extern PFNGLUNIFORM3IVPROC                                     gl3wUniform3iv;
extern PFNGLUNIFORM3UIPROC                                     gl3wUniform3ui;
extern PFNGLUNIFORM3UI64ARBPROC                                gl3wUniform3ui64ARB;
extern PFNGLUNIFORM3UI64NVPROC                                 gl3wUniform3ui64NV;
extern PFNGLUNIFORM3UI64VARBPROC                               gl3wUniform3ui64vARB;
extern PFNGLUNIFORM3UI64VNVPROC                                gl3wUniform3ui64vNV;
extern PFNGLUNIFORM3UIVPROC                                    gl3wUniform3uiv;
extern PFNGLUNIFORM4DPROC                                      gl3wUniform4d;
extern PFNGLUNIFORM4DVPROC                                     gl3wUniform4dv;
extern PFNGLUNIFORM4FPROC                                      gl3wUniform4f;
extern PFNGLUNIFORM4FVPROC                                     gl3wUniform4fv;
extern PFNGLUNIFORM4IPROC                                      gl3wUniform4i;
extern PFNGLUNIFORM4I64ARBPROC                                 gl3wUniform4i64ARB;
extern PFNGLUNIFORM4I64NVPROC                                  gl3wUniform4i64NV;
extern PFNGLUNIFORM4I64VARBPROC                                gl3wUniform4i64vARB;
extern PFNGLUNIFORM4I64VNVPROC                                 gl3wUniform4i64vNV;
extern PFNGLUNIFORM4IVPROC                                     gl3wUniform4iv;
extern PFNGLUNIFORM4UIPROC                                     gl3wUniform4ui;
extern PFNGLUNIFORM4UI64ARBPROC                                gl3wUniform4ui64ARB;
extern PFNGLUNIFORM4UI64NVPROC                                 gl3wUniform4ui64NV;
extern PFNGLUNIFORM4UI64VARBPROC                               gl3wUniform4ui64vARB;
extern PFNGLUNIFORM4UI64VNVPROC                                gl3wUniform4ui64vNV;
extern PFNGLUNIFORM4UIVPROC                                    gl3wUniform4uiv;
extern PFNGLUNIFORMBLOCKBINDINGPROC                            gl3wUniformBlockBinding;
extern PFNGLUNIFORMHANDLEUI64ARBPROC                           gl3wUniformHandleui64ARB;
extern PFNGLUNIFORMHANDLEUI64NVPROC                            gl3wUniformHandleui64NV;
extern PFNGLUNIFORMHANDLEUI64VARBPROC                          gl3wUniformHandleui64vARB;
extern PFNGLUNIFORMHANDLEUI64VNVPROC                           gl3wUniformHandleui64vNV;
extern PFNGLUNIFORMMATRIX2DVPROC                               gl3wUniformMatrix2dv;
extern PFNGLUNIFORMMATRIX2FVPROC                               gl3wUniformMatrix2fv;
extern PFNGLUNIFORMMATRIX2X3DVPROC                             gl3wUniformMatrix2x3dv;
extern PFNGLUNIFORMMATRIX2X3FVPROC                             gl3wUniformMatrix2x3fv;
extern PFNGLUNIFORMMATRIX2X4DVPROC                             gl3wUniformMatrix2x4dv;
extern PFNGLUNIFORMMATRIX2X4FVPROC                             gl3wUniformMatrix2x4fv;
extern PFNGLUNIFORMMATRIX3DVPROC                               gl3wUniformMatrix3dv;
extern PFNGLUNIFORMMATRIX3FVPROC                               gl3wUniformMatrix3fv;
extern PFNGLUNIFORMMATRIX3X2DVPROC                             gl3wUniformMatrix3x2dv;
extern PFNGLUNIFORMMATRIX3X2FVPROC                             gl3wUniformMatrix3x2fv;
extern PFNGLUNIFORMMATRIX3X4DVPROC                             gl3wUniformMatrix3x4dv;
extern PFNGLUNIFORMMATRIX3X4FVPROC                             gl3wUniformMatrix3x4fv;
extern PFNGLUNIFORMMATRIX4DVPROC                               gl3wUniformMatrix4dv;
extern PFNGLUNIFORMMATRIX4FVPROC                               gl3wUniformMatrix4fv;
extern PFNGLUNIFORMMATRIX4X2DVPROC                             gl3wUniformMatrix4x2dv;
extern PFNGLUNIFORMMATRIX4X2FVPROC                             gl3wUniformMatrix4x2fv;
extern PFNGLUNIFORMMATRIX4X3DVPROC                             gl3wUniformMatrix4x3dv;
extern PFNGLUNIFORMMATRIX4X3FVPROC                             gl3wUniformMatrix4x3fv;
extern PFNGLUNIFORMSUBROUTINESUIVPROC                          gl3wUniformSubroutinesuiv;
extern PFNGLUNIFORMUI64NVPROC                                  gl3wUniformui64NV;
extern PFNGLUNIFORMUI64VNVPROC                                 gl3wUniformui64vNV;
extern PFNGLUNMAPBUFFERPROC                                    gl3wUnmapBuffer;
extern PFNGLUNMAPNAMEDBUFFERPROC                               gl3wUnmapNamedBuffer;
extern PFNGLUNMAPNAMEDBUFFEREXTPROC                            gl3wUnmapNamedBufferEXT;
extern PFNGLUSEPROGRAMPROC                                     gl3wUseProgram;
extern PFNGLUSEPROGRAMSTAGESPROC                               gl3wUseProgramStages;
extern PFNGLUSESHADERPROGRAMEXTPROC                            gl3wUseShaderProgramEXT;
extern PFNGLVALIDATEPROGRAMPROC                                gl3wValidateProgram;
extern PFNGLVALIDATEPROGRAMPIPELINEPROC                        gl3wValidateProgramPipeline;
extern PFNGLVERTEXARRAYATTRIBBINDINGPROC                       gl3wVertexArrayAttribBinding;
extern PFNGLVERTEXARRAYATTRIBFORMATPROC                        gl3wVertexArrayAttribFormat;
extern PFNGLVERTEXARRAYATTRIBIFORMATPROC                       gl3wVertexArrayAttribIFormat;
extern PFNGLVERTEXARRAYATTRIBLFORMATPROC                       gl3wVertexArrayAttribLFormat;
extern PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC                 gl3wVertexArrayBindVertexBufferEXT;
extern PFNGLVERTEXARRAYBINDINGDIVISORPROC                      gl3wVertexArrayBindingDivisor;
extern PFNGLVERTEXARRAYCOLOROFFSETEXTPROC                      gl3wVertexArrayColorOffsetEXT;
extern PFNGLVERTEXARRAYEDGEFLAGOFFSETEXTPROC                   gl3wVertexArrayEdgeFlagOffsetEXT;
extern PFNGLVERTEXARRAYELEMENTBUFFERPROC                       gl3wVertexArrayElementBuffer;
extern PFNGLVERTEXARRAYFOGCOORDOFFSETEXTPROC                   gl3wVertexArrayFogCoordOffsetEXT;
extern PFNGLVERTEXARRAYINDEXOFFSETEXTPROC                      gl3wVertexArrayIndexOffsetEXT;
extern PFNGLVERTEXARRAYMULTITEXCOORDOFFSETEXTPROC              gl3wVertexArrayMultiTexCoordOffsetEXT;
extern PFNGLVERTEXARRAYNORMALOFFSETEXTPROC                     gl3wVertexArrayNormalOffsetEXT;
extern PFNGLVERTEXARRAYSECONDARYCOLOROFFSETEXTPROC             gl3wVertexArraySecondaryColorOffsetEXT;
extern PFNGLVERTEXARRAYTEXCOORDOFFSETEXTPROC                   gl3wVertexArrayTexCoordOffsetEXT;
extern PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC              gl3wVertexArrayVertexAttribBindingEXT;
extern PFNGLVERTEXARRAYVERTEXATTRIBDIVISOREXTPROC              gl3wVertexArrayVertexAttribDivisorEXT;
extern PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC               gl3wVertexArrayVertexAttribFormatEXT;
extern PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC              gl3wVertexArrayVertexAttribIFormatEXT;
extern PFNGLVERTEXARRAYVERTEXATTRIBIOFFSETEXTPROC              gl3wVertexArrayVertexAttribIOffsetEXT;
extern PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC              gl3wVertexArrayVertexAttribLFormatEXT;
extern PFNGLVERTEXARRAYVERTEXATTRIBLOFFSETEXTPROC              gl3wVertexArrayVertexAttribLOffsetEXT;
extern PFNGLVERTEXARRAYVERTEXATTRIBOFFSETEXTPROC               gl3wVertexArrayVertexAttribOffsetEXT;
extern PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC             gl3wVertexArrayVertexBindingDivisorEXT;
extern PFNGLVERTEXARRAYVERTEXBUFFERPROC                        gl3wVertexArrayVertexBuffer;
extern PFNGLVERTEXARRAYVERTEXBUFFERSPROC                       gl3wVertexArrayVertexBuffers;
extern PFNGLVERTEXARRAYVERTEXOFFSETEXTPROC                     gl3wVertexArrayVertexOffsetEXT;
extern PFNGLVERTEXATTRIB1DPROC                                 gl3wVertexAttrib1d;
extern PFNGLVERTEXATTRIB1DVPROC                                gl3wVertexAttrib1dv;
extern PFNGLVERTEXATTRIB1FPROC                                 gl3wVertexAttrib1f;
extern PFNGLVERTEXATTRIB1FVPROC                                gl3wVertexAttrib1fv;
extern PFNGLVERTEXATTRIB1SPROC                                 gl3wVertexAttrib1s;
extern PFNGLVERTEXATTRIB1SVPROC                                gl3wVertexAttrib1sv;
extern PFNGLVERTEXATTRIB2DPROC                                 gl3wVertexAttrib2d;
extern PFNGLVERTEXATTRIB2DVPROC                                gl3wVertexAttrib2dv;
extern PFNGLVERTEXATTRIB2FPROC                                 gl3wVertexAttrib2f;
extern PFNGLVERTEXATTRIB2FVPROC                                gl3wVertexAttrib2fv;
extern PFNGLVERTEXATTRIB2SPROC                                 gl3wVertexAttrib2s;
extern PFNGLVERTEXATTRIB2SVPROC                                gl3wVertexAttrib2sv;
extern PFNGLVERTEXATTRIB3DPROC                                 gl3wVertexAttrib3d;
extern PFNGLVERTEXATTRIB3DVPROC                                gl3wVertexAttrib3dv;
extern PFNGLVERTEXATTRIB3FPROC                                 gl3wVertexAttrib3f;
extern PFNGLVERTEXATTRIB3FVPROC                                gl3wVertexAttrib3fv;
extern PFNGLVERTEXATTRIB3SPROC                                 gl3wVertexAttrib3s;
extern PFNGLVERTEXATTRIB3SVPROC                                gl3wVertexAttrib3sv;
extern PFNGLVERTEXATTRIB4NBVPROC                               gl3wVertexAttrib4Nbv;
extern PFNGLVERTEXATTRIB4NIVPROC                               gl3wVertexAttrib4Niv;
extern PFNGLVERTEXATTRIB4NSVPROC                               gl3wVertexAttrib4Nsv;
extern PFNGLVERTEXATTRIB4NUBPROC                               gl3wVertexAttrib4Nub;
extern PFNGLVERTEXATTRIB4NUBVPROC                              gl3wVertexAttrib4Nubv;
extern PFNGLVERTEXATTRIB4NUIVPROC                              gl3wVertexAttrib4Nuiv;
extern PFNGLVERTEXATTRIB4NUSVPROC                              gl3wVertexAttrib4Nusv;
extern PFNGLVERTEXATTRIB4BVPROC                                gl3wVertexAttrib4bv;
extern PFNGLVERTEXATTRIB4DPROC                                 gl3wVertexAttrib4d;
extern PFNGLVERTEXATTRIB4DVPROC                                gl3wVertexAttrib4dv;
extern PFNGLVERTEXATTRIB4FPROC                                 gl3wVertexAttrib4f;
extern PFNGLVERTEXATTRIB4FVPROC                                gl3wVertexAttrib4fv;
extern PFNGLVERTEXATTRIB4IVPROC                                gl3wVertexAttrib4iv;
extern PFNGLVERTEXATTRIB4SPROC                                 gl3wVertexAttrib4s;
extern PFNGLVERTEXATTRIB4SVPROC                                gl3wVertexAttrib4sv;
extern PFNGLVERTEXATTRIB4UBVPROC                               gl3wVertexAttrib4ubv;
extern PFNGLVERTEXATTRIB4UIVPROC                               gl3wVertexAttrib4uiv;
extern PFNGLVERTEXATTRIB4USVPROC                               gl3wVertexAttrib4usv;
extern PFNGLVERTEXATTRIBBINDINGPROC                            gl3wVertexAttribBinding;
extern PFNGLVERTEXATTRIBDIVISORPROC                            gl3wVertexAttribDivisor;
extern PFNGLVERTEXATTRIBDIVISORARBPROC                         gl3wVertexAttribDivisorARB;
extern PFNGLVERTEXATTRIBFORMATPROC                             gl3wVertexAttribFormat;
extern PFNGLVERTEXATTRIBFORMATNVPROC                           gl3wVertexAttribFormatNV;
extern PFNGLVERTEXATTRIBI1IPROC                                gl3wVertexAttribI1i;
extern PFNGLVERTEXATTRIBI1IVPROC                               gl3wVertexAttribI1iv;
extern PFNGLVERTEXATTRIBI1UIPROC                               gl3wVertexAttribI1ui;
extern PFNGLVERTEXATTRIBI1UIVPROC                              gl3wVertexAttribI1uiv;
extern PFNGLVERTEXATTRIBI2IPROC                                gl3wVertexAttribI2i;
extern PFNGLVERTEXATTRIBI2IVPROC                               gl3wVertexAttribI2iv;
extern PFNGLVERTEXATTRIBI2UIPROC                               gl3wVertexAttribI2ui;
extern PFNGLVERTEXATTRIBI2UIVPROC                              gl3wVertexAttribI2uiv;
extern PFNGLVERTEXATTRIBI3IPROC                                gl3wVertexAttribI3i;
extern PFNGLVERTEXATTRIBI3IVPROC                               gl3wVertexAttribI3iv;
extern PFNGLVERTEXATTRIBI3UIPROC                               gl3wVertexAttribI3ui;
extern PFNGLVERTEXATTRIBI3UIVPROC                              gl3wVertexAttribI3uiv;
extern PFNGLVERTEXATTRIBI4BVPROC                               gl3wVertexAttribI4bv;
extern PFNGLVERTEXATTRIBI4IPROC                                gl3wVertexAttribI4i;
extern PFNGLVERTEXATTRIBI4IVPROC                               gl3wVertexAttribI4iv;
extern PFNGLVERTEXATTRIBI4SVPROC                               gl3wVertexAttribI4sv;
extern PFNGLVERTEXATTRIBI4UBVPROC                              gl3wVertexAttribI4ubv;
extern PFNGLVERTEXATTRIBI4UIPROC                               gl3wVertexAttribI4ui;
extern PFNGLVERTEXATTRIBI4UIVPROC                              gl3wVertexAttribI4uiv;
extern PFNGLVERTEXATTRIBI4USVPROC                              gl3wVertexAttribI4usv;
extern PFNGLVERTEXATTRIBIFORMATPROC                            gl3wVertexAttribIFormat;
extern PFNGLVERTEXATTRIBIFORMATNVPROC                          gl3wVertexAttribIFormatNV;
extern PFNGLVERTEXATTRIBIPOINTERPROC                           gl3wVertexAttribIPointer;
extern PFNGLVERTEXATTRIBL1DPROC                                gl3wVertexAttribL1d;
extern PFNGLVERTEXATTRIBL1DVPROC                               gl3wVertexAttribL1dv;
extern PFNGLVERTEXATTRIBL1I64NVPROC                            gl3wVertexAttribL1i64NV;
extern PFNGLVERTEXATTRIBL1I64VNVPROC                           gl3wVertexAttribL1i64vNV;
extern PFNGLVERTEXATTRIBL1UI64ARBPROC                          gl3wVertexAttribL1ui64ARB;
extern PFNGLVERTEXATTRIBL1UI64NVPROC                           gl3wVertexAttribL1ui64NV;
extern PFNGLVERTEXATTRIBL1UI64VARBPROC                         gl3wVertexAttribL1ui64vARB;
extern PFNGLVERTEXATTRIBL1UI64VNVPROC                          gl3wVertexAttribL1ui64vNV;
extern PFNGLVERTEXATTRIBL2DPROC                                gl3wVertexAttribL2d;
extern PFNGLVERTEXATTRIBL2DVPROC                               gl3wVertexAttribL2dv;
extern PFNGLVERTEXATTRIBL2I64NVPROC                            gl3wVertexAttribL2i64NV;
extern PFNGLVERTEXATTRIBL2I64VNVPROC                           gl3wVertexAttribL2i64vNV;
extern PFNGLVERTEXATTRIBL2UI64NVPROC                           gl3wVertexAttribL2ui64NV;
extern PFNGLVERTEXATTRIBL2UI64VNVPROC                          gl3wVertexAttribL2ui64vNV;
extern PFNGLVERTEXATTRIBL3DPROC                                gl3wVertexAttribL3d;
extern PFNGLVERTEXATTRIBL3DVPROC                               gl3wVertexAttribL3dv;
extern PFNGLVERTEXATTRIBL3I64NVPROC                            gl3wVertexAttribL3i64NV;
extern PFNGLVERTEXATTRIBL3I64VNVPROC                           gl3wVertexAttribL3i64vNV;
extern PFNGLVERTEXATTRIBL3UI64NVPROC                           gl3wVertexAttribL3ui64NV;
extern PFNGLVERTEXATTRIBL3UI64VNVPROC                          gl3wVertexAttribL3ui64vNV;
extern PFNGLVERTEXATTRIBL4DPROC                                gl3wVertexAttribL4d;
extern PFNGLVERTEXATTRIBL4DVPROC                               gl3wVertexAttribL4dv;
extern PFNGLVERTEXATTRIBL4I64NVPROC                            gl3wVertexAttribL4i64NV;
extern PFNGLVERTEXATTRIBL4I64VNVPROC                           gl3wVertexAttribL4i64vNV;
extern PFNGLVERTEXATTRIBL4UI64NVPROC                           gl3wVertexAttribL4ui64NV;
extern PFNGLVERTEXATTRIBL4UI64VNVPROC                          gl3wVertexAttribL4ui64vNV;
extern PFNGLVERTEXATTRIBLFORMATPROC                            gl3wVertexAttribLFormat;
extern PFNGLVERTEXATTRIBLFORMATNVPROC                          gl3wVertexAttribLFormatNV;
extern PFNGLVERTEXATTRIBLPOINTERPROC                           gl3wVertexAttribLPointer;
extern PFNGLVERTEXATTRIBP1UIPROC                               gl3wVertexAttribP1ui;
extern PFNGLVERTEXATTRIBP1UIVPROC                              gl3wVertexAttribP1uiv;
extern PFNGLVERTEXATTRIBP2UIPROC                               gl3wVertexAttribP2ui;
extern PFNGLVERTEXATTRIBP2UIVPROC                              gl3wVertexAttribP2uiv;
extern PFNGLVERTEXATTRIBP3UIPROC                               gl3wVertexAttribP3ui;
extern PFNGLVERTEXATTRIBP3UIVPROC                              gl3wVertexAttribP3uiv;
extern PFNGLVERTEXATTRIBP4UIPROC                               gl3wVertexAttribP4ui;
extern PFNGLVERTEXATTRIBP4UIVPROC                              gl3wVertexAttribP4uiv;
extern PFNGLVERTEXATTRIBPOINTERPROC                            gl3wVertexAttribPointer;
extern PFNGLVERTEXBINDINGDIVISORPROC                           gl3wVertexBindingDivisor;
extern PFNGLVERTEXFORMATNVPROC                                 gl3wVertexFormatNV;
extern PFNGLVIEWPORTPROC                                       gl3wViewport;
extern PFNGLVIEWPORTARRAYVPROC                                 gl3wViewportArrayv;
extern PFNGLVIEWPORTINDEXEDFPROC                               gl3wViewportIndexedf;
extern PFNGLVIEWPORTINDEXEDFVPROC                              gl3wViewportIndexedfv;
extern PFNGLVIEWPORTPOSITIONWSCALENVPROC                       gl3wViewportPositionWScaleNV;
extern PFNGLVIEWPORTSWIZZLENVPROC                              gl3wViewportSwizzleNV;
extern PFNGLWAITSYNCPROC                                       gl3wWaitSync;
extern PFNGLWAITVKSEMAPHORENVPROC                              gl3wWaitVkSemaphoreNV;
extern PFNGLWEIGHTPATHSNVPROC                                  gl3wWeightPathsNV;
extern PFNGLWINDOWRECTANGLESEXTPROC                            gl3wWindowRectanglesEXT;
#define glActiveProgramEXT                               gl3wActiveProgramEXT
#define glActiveShaderProgram                            gl3wActiveShaderProgram
#define glActiveTexture                                  gl3wActiveTexture
#define glApplyFramebufferAttachmentCMAAINTEL            gl3wApplyFramebufferAttachmentCMAAINTEL
#define glAttachShader                                   gl3wAttachShader
#define glBeginConditionalRender                         gl3wBeginConditionalRender
#define glBeginConditionalRenderNV                       gl3wBeginConditionalRenderNV
#define glBeginPerfMonitorAMD                            gl3wBeginPerfMonitorAMD
#define glBeginPerfQueryINTEL                            gl3wBeginPerfQueryINTEL
#define glBeginQuery                                     gl3wBeginQuery
#define glBeginQueryIndexed                              gl3wBeginQueryIndexed
#define glBeginTransformFeedback                         gl3wBeginTransformFeedback
#define glBindAttribLocation                             gl3wBindAttribLocation
#define glBindBuffer                                     gl3wBindBuffer
#define glBindBufferBase                                 gl3wBindBufferBase
#define glBindBufferRange                                gl3wBindBufferRange
#define glBindBuffersBase                                gl3wBindBuffersBase
#define glBindBuffersRange                               gl3wBindBuffersRange
#define glBindFragDataLocation                           gl3wBindFragDataLocation
#define glBindFragDataLocationIndexed                    gl3wBindFragDataLocationIndexed
#define glBindFramebuffer                                gl3wBindFramebuffer
#define glBindImageTexture                               gl3wBindImageTexture
#define glBindImageTextures                              gl3wBindImageTextures
#define glBindMultiTextureEXT                            gl3wBindMultiTextureEXT
#define glBindProgramPipeline                            gl3wBindProgramPipeline
#define glBindRenderbuffer                               gl3wBindRenderbuffer
#define glBindSampler                                    gl3wBindSampler
#define glBindSamplers                                   gl3wBindSamplers
#define glBindTexture                                    gl3wBindTexture
#define glBindTextureUnit                                gl3wBindTextureUnit
#define glBindTextures                                   gl3wBindTextures
#define glBindTransformFeedback                          gl3wBindTransformFeedback
#define glBindVertexArray                                gl3wBindVertexArray
#define glBindVertexBuffer                               gl3wBindVertexBuffer
#define glBindVertexBuffers                              gl3wBindVertexBuffers
#define glBlendBarrierKHR                                gl3wBlendBarrierKHR
#define glBlendBarrierNV                                 gl3wBlendBarrierNV
#define glBlendColor                                     gl3wBlendColor
#define glBlendEquation                                  gl3wBlendEquation
#define glBlendEquationSeparate                          gl3wBlendEquationSeparate
#define glBlendEquationSeparatei                         gl3wBlendEquationSeparatei
#define glBlendEquationSeparateiARB                      gl3wBlendEquationSeparateiARB
#define glBlendEquationi                                 gl3wBlendEquationi
#define glBlendEquationiARB                              gl3wBlendEquationiARB
#define glBlendFunc                                      gl3wBlendFunc
#define glBlendFuncSeparate                              gl3wBlendFuncSeparate
#define glBlendFuncSeparatei                             gl3wBlendFuncSeparatei
#define glBlendFuncSeparateiARB                          gl3wBlendFuncSeparateiARB
#define glBlendFunci                                     gl3wBlendFunci
#define glBlendFunciARB                                  gl3wBlendFunciARB
#define glBlendParameteriNV                              gl3wBlendParameteriNV
#define glBlitFramebuffer                                gl3wBlitFramebuffer
#define glBlitNamedFramebuffer                           gl3wBlitNamedFramebuffer
#define glBufferAddressRangeNV                           gl3wBufferAddressRangeNV
#define glBufferData                                     gl3wBufferData
#define glBufferPageCommitmentARB                        gl3wBufferPageCommitmentARB
#define glBufferStorage                                  gl3wBufferStorage
#define glBufferSubData                                  gl3wBufferSubData
#define glCallCommandListNV                              gl3wCallCommandListNV
#define glCheckFramebufferStatus                         gl3wCheckFramebufferStatus
#define glCheckNamedFramebufferStatus                    gl3wCheckNamedFramebufferStatus
#define glCheckNamedFramebufferStatusEXT                 gl3wCheckNamedFramebufferStatusEXT
#define glClampColor                                     gl3wClampColor
#define glClear                                          gl3wClear
#define glClearBufferData                                gl3wClearBufferData
#define glClearBufferSubData                             gl3wClearBufferSubData
#define glClearBufferfi                                  gl3wClearBufferfi
#define glClearBufferfv                                  gl3wClearBufferfv
#define glClearBufferiv                                  gl3wClearBufferiv
#define glClearBufferuiv                                 gl3wClearBufferuiv
#define glClearColor                                     gl3wClearColor
#define glClearDepth                                     gl3wClearDepth
#define glClearDepthf                                    gl3wClearDepthf
#define glClearNamedBufferData                           gl3wClearNamedBufferData
#define glClearNamedBufferDataEXT                        gl3wClearNamedBufferDataEXT
#define glClearNamedBufferSubData                        gl3wClearNamedBufferSubData
#define glClearNamedBufferSubDataEXT                     gl3wClearNamedBufferSubDataEXT
#define glClearNamedFramebufferfi                        gl3wClearNamedFramebufferfi
#define glClearNamedFramebufferfv                        gl3wClearNamedFramebufferfv
#define glClearNamedFramebufferiv                        gl3wClearNamedFramebufferiv
#define glClearNamedFramebufferuiv                       gl3wClearNamedFramebufferuiv
#define glClearStencil                                   gl3wClearStencil
#define glClearTexImage                                  gl3wClearTexImage
#define glClearTexSubImage                               gl3wClearTexSubImage
#define glClientAttribDefaultEXT                         gl3wClientAttribDefaultEXT
#define glClientWaitSync                                 gl3wClientWaitSync
#define glClipControl                                    gl3wClipControl
#define glColorFormatNV                                  gl3wColorFormatNV
#define glColorMask                                      gl3wColorMask
#define glColorMaski                                     gl3wColorMaski
#define glCommandListSegmentsNV                          gl3wCommandListSegmentsNV
#define glCompileCommandListNV                           gl3wCompileCommandListNV
#define glCompileShader                                  gl3wCompileShader
#define glCompileShaderIncludeARB                        gl3wCompileShaderIncludeARB
#define glCompressedMultiTexImage1DEXT                   gl3wCompressedMultiTexImage1DEXT
#define glCompressedMultiTexImage2DEXT                   gl3wCompressedMultiTexImage2DEXT
#define glCompressedMultiTexImage3DEXT                   gl3wCompressedMultiTexImage3DEXT
#define glCompressedMultiTexSubImage1DEXT                gl3wCompressedMultiTexSubImage1DEXT
#define glCompressedMultiTexSubImage2DEXT                gl3wCompressedMultiTexSubImage2DEXT
#define glCompressedMultiTexSubImage3DEXT                gl3wCompressedMultiTexSubImage3DEXT
#define glCompressedTexImage1D                           gl3wCompressedTexImage1D
#define glCompressedTexImage2D                           gl3wCompressedTexImage2D
#define glCompressedTexImage3D                           gl3wCompressedTexImage3D
#define glCompressedTexSubImage1D                        gl3wCompressedTexSubImage1D
#define glCompressedTexSubImage2D                        gl3wCompressedTexSubImage2D
#define glCompressedTexSubImage3D                        gl3wCompressedTexSubImage3D
#define glCompressedTextureImage1DEXT                    gl3wCompressedTextureImage1DEXT
#define glCompressedTextureImage2DEXT                    gl3wCompressedTextureImage2DEXT
#define glCompressedTextureImage3DEXT                    gl3wCompressedTextureImage3DEXT
#define glCompressedTextureSubImage1D                    gl3wCompressedTextureSubImage1D
#define glCompressedTextureSubImage1DEXT                 gl3wCompressedTextureSubImage1DEXT
#define glCompressedTextureSubImage2D                    gl3wCompressedTextureSubImage2D
#define glCompressedTextureSubImage2DEXT                 gl3wCompressedTextureSubImage2DEXT
#define glCompressedTextureSubImage3D                    gl3wCompressedTextureSubImage3D
#define glCompressedTextureSubImage3DEXT                 gl3wCompressedTextureSubImage3DEXT
#define glConservativeRasterParameterfNV                 gl3wConservativeRasterParameterfNV
#define glConservativeRasterParameteriNV                 gl3wConservativeRasterParameteriNV
#define glCopyBufferSubData                              gl3wCopyBufferSubData
#define glCopyImageSubData                               gl3wCopyImageSubData
#define glCopyMultiTexImage1DEXT                         gl3wCopyMultiTexImage1DEXT
#define glCopyMultiTexImage2DEXT                         gl3wCopyMultiTexImage2DEXT
#define glCopyMultiTexSubImage1DEXT                      gl3wCopyMultiTexSubImage1DEXT
#define glCopyMultiTexSubImage2DEXT                      gl3wCopyMultiTexSubImage2DEXT
#define glCopyMultiTexSubImage3DEXT                      gl3wCopyMultiTexSubImage3DEXT
#define glCopyNamedBufferSubData                         gl3wCopyNamedBufferSubData
#define glCopyPathNV                                     gl3wCopyPathNV
#define glCopyTexImage1D                                 gl3wCopyTexImage1D
#define glCopyTexImage2D                                 gl3wCopyTexImage2D
#define glCopyTexSubImage1D                              gl3wCopyTexSubImage1D
#define glCopyTexSubImage2D                              gl3wCopyTexSubImage2D
#define glCopyTexSubImage3D                              gl3wCopyTexSubImage3D
#define glCopyTextureImage1DEXT                          gl3wCopyTextureImage1DEXT
#define glCopyTextureImage2DEXT                          gl3wCopyTextureImage2DEXT
#define glCopyTextureSubImage1D                          gl3wCopyTextureSubImage1D
#define glCopyTextureSubImage1DEXT                       gl3wCopyTextureSubImage1DEXT
#define glCopyTextureSubImage2D                          gl3wCopyTextureSubImage2D
#define glCopyTextureSubImage2DEXT                       gl3wCopyTextureSubImage2DEXT
#define glCopyTextureSubImage3D                          gl3wCopyTextureSubImage3D
#define glCopyTextureSubImage3DEXT                       gl3wCopyTextureSubImage3DEXT
#define glCoverFillPathInstancedNV                       gl3wCoverFillPathInstancedNV
#define glCoverFillPathNV                                gl3wCoverFillPathNV
#define glCoverStrokePathInstancedNV                     gl3wCoverStrokePathInstancedNV
#define glCoverStrokePathNV                              gl3wCoverStrokePathNV
#define glCoverageModulationNV                           gl3wCoverageModulationNV
#define glCoverageModulationTableNV                      gl3wCoverageModulationTableNV
#define glCreateBuffers                                  gl3wCreateBuffers
#define glCreateCommandListsNV                           gl3wCreateCommandListsNV
#define glCreateFramebuffers                             gl3wCreateFramebuffers
#define glCreatePerfQueryINTEL                           gl3wCreatePerfQueryINTEL
#define glCreateProgram                                  gl3wCreateProgram
#define glCreateProgramPipelines                         gl3wCreateProgramPipelines
#define glCreateQueries                                  gl3wCreateQueries
#define glCreateRenderbuffers                            gl3wCreateRenderbuffers
#define glCreateSamplers                                 gl3wCreateSamplers
#define glCreateShader                                   gl3wCreateShader
#define glCreateShaderProgramEXT                         gl3wCreateShaderProgramEXT
#define glCreateShaderProgramv                           gl3wCreateShaderProgramv
#define glCreateStatesNV                                 gl3wCreateStatesNV
#define glCreateSyncFromCLeventARB                       gl3wCreateSyncFromCLeventARB
#define glCreateTextures                                 gl3wCreateTextures
#define glCreateTransformFeedbacks                       gl3wCreateTransformFeedbacks
#define glCreateVertexArrays                             gl3wCreateVertexArrays
#define glCullFace                                       gl3wCullFace
#define glDebugMessageCallback                           gl3wDebugMessageCallback
#define glDebugMessageCallbackARB                        gl3wDebugMessageCallbackARB
#define glDebugMessageControl                            gl3wDebugMessageControl
#define glDebugMessageControlARB                         gl3wDebugMessageControlARB
#define glDebugMessageInsert                             gl3wDebugMessageInsert
#define glDebugMessageInsertARB                          gl3wDebugMessageInsertARB
#define glDeleteBuffers                                  gl3wDeleteBuffers
#define glDeleteCommandListsNV                           gl3wDeleteCommandListsNV
#define glDeleteFramebuffers                             gl3wDeleteFramebuffers
#define glDeleteNamedStringARB                           gl3wDeleteNamedStringARB
#define glDeletePathsNV                                  gl3wDeletePathsNV
#define glDeletePerfMonitorsAMD                          gl3wDeletePerfMonitorsAMD
#define glDeletePerfQueryINTEL                           gl3wDeletePerfQueryINTEL
#define glDeleteProgram                                  gl3wDeleteProgram
#define glDeleteProgramPipelines                         gl3wDeleteProgramPipelines
#define glDeleteQueries                                  gl3wDeleteQueries
#define glDeleteRenderbuffers                            gl3wDeleteRenderbuffers
#define glDeleteSamplers                                 gl3wDeleteSamplers
#define glDeleteShader                                   gl3wDeleteShader
#define glDeleteStatesNV                                 gl3wDeleteStatesNV
#define glDeleteSync                                     gl3wDeleteSync
#define glDeleteTextures                                 gl3wDeleteTextures
#define glDeleteTransformFeedbacks                       gl3wDeleteTransformFeedbacks
#define glDeleteVertexArrays                             gl3wDeleteVertexArrays
#define glDepthFunc                                      gl3wDepthFunc
#define glDepthMask                                      gl3wDepthMask
#define glDepthRange                                     gl3wDepthRange
#define glDepthRangeArrayv                               gl3wDepthRangeArrayv
#define glDepthRangeIndexed                              gl3wDepthRangeIndexed
#define glDepthRangef                                    gl3wDepthRangef
#define glDetachShader                                   gl3wDetachShader
#define glDisable                                        gl3wDisable
#define glDisableClientStateIndexedEXT                   gl3wDisableClientStateIndexedEXT
#define glDisableClientStateiEXT                         gl3wDisableClientStateiEXT
#define glDisableIndexedEXT                              gl3wDisableIndexedEXT
#define glDisableVertexArrayAttrib                       gl3wDisableVertexArrayAttrib
#define glDisableVertexArrayAttribEXT                    gl3wDisableVertexArrayAttribEXT
#define glDisableVertexArrayEXT                          gl3wDisableVertexArrayEXT
#define glDisableVertexAttribArray                       gl3wDisableVertexAttribArray
#define glDisablei                                       gl3wDisablei
#define glDispatchCompute                                gl3wDispatchCompute
#define glDispatchComputeGroupSizeARB                    gl3wDispatchComputeGroupSizeARB
#define glDispatchComputeIndirect                        gl3wDispatchComputeIndirect
#define glDrawArrays                                     gl3wDrawArrays
#define glDrawArraysIndirect                             gl3wDrawArraysIndirect
#define glDrawArraysInstanced                            gl3wDrawArraysInstanced
#define glDrawArraysInstancedARB                         gl3wDrawArraysInstancedARB
#define glDrawArraysInstancedBaseInstance                gl3wDrawArraysInstancedBaseInstance
#define glDrawArraysInstancedEXT                         gl3wDrawArraysInstancedEXT
#define glDrawBuffer                                     gl3wDrawBuffer
#define glDrawBuffers                                    gl3wDrawBuffers
#define glDrawCommandsAddressNV                          gl3wDrawCommandsAddressNV
#define glDrawCommandsNV                                 gl3wDrawCommandsNV
#define glDrawCommandsStatesAddressNV                    gl3wDrawCommandsStatesAddressNV
#define glDrawCommandsStatesNV                           gl3wDrawCommandsStatesNV
#define glDrawElements                                   gl3wDrawElements
#define glDrawElementsBaseVertex                         gl3wDrawElementsBaseVertex
#define glDrawElementsIndirect                           gl3wDrawElementsIndirect
#define glDrawElementsInstanced                          gl3wDrawElementsInstanced
#define glDrawElementsInstancedARB                       gl3wDrawElementsInstancedARB
#define glDrawElementsInstancedBaseInstance              gl3wDrawElementsInstancedBaseInstance
#define glDrawElementsInstancedBaseVertex                gl3wDrawElementsInstancedBaseVertex
#define glDrawElementsInstancedBaseVertexBaseInstance    gl3wDrawElementsInstancedBaseVertexBaseInstance
#define glDrawElementsInstancedEXT                       gl3wDrawElementsInstancedEXT
#define glDrawRangeElements                              gl3wDrawRangeElements
#define glDrawRangeElementsBaseVertex                    gl3wDrawRangeElementsBaseVertex
#define glDrawTransformFeedback                          gl3wDrawTransformFeedback
#define glDrawTransformFeedbackInstanced                 gl3wDrawTransformFeedbackInstanced
#define glDrawTransformFeedbackStream                    gl3wDrawTransformFeedbackStream
#define glDrawTransformFeedbackStreamInstanced           gl3wDrawTransformFeedbackStreamInstanced
#define glDrawVkImageNV                                  gl3wDrawVkImageNV
#define glEdgeFlagFormatNV                               gl3wEdgeFlagFormatNV
#define glEnable                                         gl3wEnable
#define glEnableClientStateIndexedEXT                    gl3wEnableClientStateIndexedEXT
#define glEnableClientStateiEXT                          gl3wEnableClientStateiEXT
#define glEnableIndexedEXT                               gl3wEnableIndexedEXT
#define glEnableVertexArrayAttrib                        gl3wEnableVertexArrayAttrib
#define glEnableVertexArrayAttribEXT                     gl3wEnableVertexArrayAttribEXT
#define glEnableVertexArrayEXT                           gl3wEnableVertexArrayEXT
#define glEnableVertexAttribArray                        gl3wEnableVertexAttribArray
#define glEnablei                                        gl3wEnablei
#define glEndConditionalRender                           gl3wEndConditionalRender
#define glEndConditionalRenderNV                         gl3wEndConditionalRenderNV
#define glEndPerfMonitorAMD                              gl3wEndPerfMonitorAMD
#define glEndPerfQueryINTEL                              gl3wEndPerfQueryINTEL
#define glEndQuery                                       gl3wEndQuery
#define glEndQueryIndexed                                gl3wEndQueryIndexed
#define glEndTransformFeedback                           gl3wEndTransformFeedback
#define glEvaluateDepthValuesARB                         gl3wEvaluateDepthValuesARB
#define glFenceSync                                      gl3wFenceSync
#define glFinish                                         gl3wFinish
#define glFlush                                          gl3wFlush
#define glFlushMappedBufferRange                         gl3wFlushMappedBufferRange
#define glFlushMappedNamedBufferRange                    gl3wFlushMappedNamedBufferRange
#define glFlushMappedNamedBufferRangeEXT                 gl3wFlushMappedNamedBufferRangeEXT
#define glFogCoordFormatNV                               gl3wFogCoordFormatNV
#define glFragmentCoverageColorNV                        gl3wFragmentCoverageColorNV
#define glFramebufferDrawBufferEXT                       gl3wFramebufferDrawBufferEXT
#define glFramebufferDrawBuffersEXT                      gl3wFramebufferDrawBuffersEXT
#define glFramebufferParameteri                          gl3wFramebufferParameteri
#define glFramebufferReadBufferEXT                       gl3wFramebufferReadBufferEXT
#define glFramebufferRenderbuffer                        gl3wFramebufferRenderbuffer
#define glFramebufferSampleLocationsfvARB                gl3wFramebufferSampleLocationsfvARB
#define glFramebufferSampleLocationsfvNV                 gl3wFramebufferSampleLocationsfvNV
#define glFramebufferTexture                             gl3wFramebufferTexture
#define glFramebufferTexture1D                           gl3wFramebufferTexture1D
#define glFramebufferTexture2D                           gl3wFramebufferTexture2D
#define glFramebufferTexture3D                           gl3wFramebufferTexture3D
#define glFramebufferTextureARB                          gl3wFramebufferTextureARB
#define glFramebufferTextureFaceARB                      gl3wFramebufferTextureFaceARB
#define glFramebufferTextureLayer                        gl3wFramebufferTextureLayer
#define glFramebufferTextureLayerARB                     gl3wFramebufferTextureLayerARB
#define glFramebufferTextureMultiviewOVR                 gl3wFramebufferTextureMultiviewOVR
#define glFrontFace                                      gl3wFrontFace
#define glGenBuffers                                     gl3wGenBuffers
#define glGenFramebuffers                                gl3wGenFramebuffers
#define glGenPathsNV                                     gl3wGenPathsNV
#define glGenPerfMonitorsAMD                             gl3wGenPerfMonitorsAMD
#define glGenProgramPipelines                            gl3wGenProgramPipelines
#define glGenQueries                                     gl3wGenQueries
#define glGenRenderbuffers                               gl3wGenRenderbuffers
#define glGenSamplers                                    gl3wGenSamplers
#define glGenTextures                                    gl3wGenTextures
#define glGenTransformFeedbacks                          gl3wGenTransformFeedbacks
#define glGenVertexArrays                                gl3wGenVertexArrays
#define glGenerateMipmap                                 gl3wGenerateMipmap
#define glGenerateMultiTexMipmapEXT                      gl3wGenerateMultiTexMipmapEXT
#define glGenerateTextureMipmap                          gl3wGenerateTextureMipmap
#define glGenerateTextureMipmapEXT                       gl3wGenerateTextureMipmapEXT
#define glGetActiveAtomicCounterBufferiv                 gl3wGetActiveAtomicCounterBufferiv
#define glGetActiveAttrib                                gl3wGetActiveAttrib
#define glGetActiveSubroutineName                        gl3wGetActiveSubroutineName
#define glGetActiveSubroutineUniformName                 gl3wGetActiveSubroutineUniformName
#define glGetActiveSubroutineUniformiv                   gl3wGetActiveSubroutineUniformiv
#define glGetActiveUniform                               gl3wGetActiveUniform
#define glGetActiveUniformBlockName                      gl3wGetActiveUniformBlockName
#define glGetActiveUniformBlockiv                        gl3wGetActiveUniformBlockiv
#define glGetActiveUniformName                           gl3wGetActiveUniformName
#define glGetActiveUniformsiv                            gl3wGetActiveUniformsiv
#define glGetAttachedShaders                             gl3wGetAttachedShaders
#define glGetAttribLocation                              gl3wGetAttribLocation
#define glGetBooleanIndexedvEXT                          gl3wGetBooleanIndexedvEXT
#define glGetBooleani_v                                  gl3wGetBooleani_v
#define glGetBooleanv                                    gl3wGetBooleanv
#define glGetBufferParameteri64v                         gl3wGetBufferParameteri64v
#define glGetBufferParameteriv                           gl3wGetBufferParameteriv
#define glGetBufferParameterui64vNV                      gl3wGetBufferParameterui64vNV
#define glGetBufferPointerv                              gl3wGetBufferPointerv
#define glGetBufferSubData                               gl3wGetBufferSubData
#define glGetCommandHeaderNV                             gl3wGetCommandHeaderNV
#define glGetCompressedMultiTexImageEXT                  gl3wGetCompressedMultiTexImageEXT
#define glGetCompressedTexImage                          gl3wGetCompressedTexImage
#define glGetCompressedTextureImage                      gl3wGetCompressedTextureImage
#define glGetCompressedTextureImageEXT                   gl3wGetCompressedTextureImageEXT
#define glGetCompressedTextureSubImage                   gl3wGetCompressedTextureSubImage
#define glGetCoverageModulationTableNV                   gl3wGetCoverageModulationTableNV
#define glGetDebugMessageLog                             gl3wGetDebugMessageLog
#define glGetDebugMessageLogARB                          gl3wGetDebugMessageLogARB
#define glGetDoubleIndexedvEXT                           gl3wGetDoubleIndexedvEXT
#define glGetDoublei_v                                   gl3wGetDoublei_v
#define glGetDoublei_vEXT                                gl3wGetDoublei_vEXT
#define glGetDoublev                                     gl3wGetDoublev
#define glGetError                                       gl3wGetError
#define glGetFirstPerfQueryIdINTEL                       gl3wGetFirstPerfQueryIdINTEL
#define glGetFloatIndexedvEXT                            gl3wGetFloatIndexedvEXT
#define glGetFloati_v                                    gl3wGetFloati_v
#define glGetFloati_vEXT                                 gl3wGetFloati_vEXT
#define glGetFloatv                                      gl3wGetFloatv
#define glGetFragDataIndex                               gl3wGetFragDataIndex
#define glGetFragDataLocation                            gl3wGetFragDataLocation
#define glGetFramebufferAttachmentParameteriv            gl3wGetFramebufferAttachmentParameteriv
#define glGetFramebufferParameteriv                      gl3wGetFramebufferParameteriv
#define glGetFramebufferParameterivEXT                   gl3wGetFramebufferParameterivEXT
#define glGetGraphicsResetStatus                         gl3wGetGraphicsResetStatus
#define glGetGraphicsResetStatusARB                      gl3wGetGraphicsResetStatusARB
#define glGetImageHandleARB                              gl3wGetImageHandleARB
#define glGetImageHandleNV                               gl3wGetImageHandleNV
#define glGetInteger64i_v                                gl3wGetInteger64i_v
#define glGetInteger64v                                  gl3wGetInteger64v
#define glGetIntegerIndexedvEXT                          gl3wGetIntegerIndexedvEXT
#define glGetIntegeri_v                                  gl3wGetIntegeri_v
#define glGetIntegerui64i_vNV                            gl3wGetIntegerui64i_vNV
#define glGetIntegerui64vNV                              gl3wGetIntegerui64vNV
#define glGetIntegerv                                    gl3wGetIntegerv
#define glGetInternalformatSampleivNV                    gl3wGetInternalformatSampleivNV
#define glGetInternalformati64v                          gl3wGetInternalformati64v
#define glGetInternalformativ                            gl3wGetInternalformativ
#define glGetMultiTexEnvfvEXT                            gl3wGetMultiTexEnvfvEXT
#define glGetMultiTexEnvivEXT                            gl3wGetMultiTexEnvivEXT
#define glGetMultiTexGendvEXT                            gl3wGetMultiTexGendvEXT
#define glGetMultiTexGenfvEXT                            gl3wGetMultiTexGenfvEXT
#define glGetMultiTexGenivEXT                            gl3wGetMultiTexGenivEXT
#define glGetMultiTexImageEXT                            gl3wGetMultiTexImageEXT
#define glGetMultiTexLevelParameterfvEXT                 gl3wGetMultiTexLevelParameterfvEXT
#define glGetMultiTexLevelParameterivEXT                 gl3wGetMultiTexLevelParameterivEXT
#define glGetMultiTexParameterIivEXT                     gl3wGetMultiTexParameterIivEXT
#define glGetMultiTexParameterIuivEXT                    gl3wGetMultiTexParameterIuivEXT
#define glGetMultiTexParameterfvEXT                      gl3wGetMultiTexParameterfvEXT
#define glGetMultiTexParameterivEXT                      gl3wGetMultiTexParameterivEXT
#define glGetMultisamplefv                               gl3wGetMultisamplefv
#define glGetNamedBufferParameteri64v                    gl3wGetNamedBufferParameteri64v
#define glGetNamedBufferParameteriv                      gl3wGetNamedBufferParameteriv
#define glGetNamedBufferParameterivEXT                   gl3wGetNamedBufferParameterivEXT
#define glGetNamedBufferParameterui64vNV                 gl3wGetNamedBufferParameterui64vNV
#define glGetNamedBufferPointerv                         gl3wGetNamedBufferPointerv
#define glGetNamedBufferPointervEXT                      gl3wGetNamedBufferPointervEXT
#define glGetNamedBufferSubData                          gl3wGetNamedBufferSubData
#define glGetNamedBufferSubDataEXT                       gl3wGetNamedBufferSubDataEXT
#define glGetNamedFramebufferAttachmentParameteriv       gl3wGetNamedFramebufferAttachmentParameteriv
#define glGetNamedFramebufferAttachmentParameterivEXT    gl3wGetNamedFramebufferAttachmentParameterivEXT
#define glGetNamedFramebufferParameteriv                 gl3wGetNamedFramebufferParameteriv
#define glGetNamedFramebufferParameterivEXT              gl3wGetNamedFramebufferParameterivEXT
#define glGetNamedProgramLocalParameterIivEXT            gl3wGetNamedProgramLocalParameterIivEXT
#define glGetNamedProgramLocalParameterIuivEXT           gl3wGetNamedProgramLocalParameterIuivEXT
#define glGetNamedProgramLocalParameterdvEXT             gl3wGetNamedProgramLocalParameterdvEXT
#define glGetNamedProgramLocalParameterfvEXT             gl3wGetNamedProgramLocalParameterfvEXT
#define glGetNamedProgramStringEXT                       gl3wGetNamedProgramStringEXT
#define glGetNamedProgramivEXT                           gl3wGetNamedProgramivEXT
#define glGetNamedRenderbufferParameteriv                gl3wGetNamedRenderbufferParameteriv
#define glGetNamedRenderbufferParameterivEXT             gl3wGetNamedRenderbufferParameterivEXT
#define glGetNamedStringARB                              gl3wGetNamedStringARB
#define glGetNamedStringivARB                            gl3wGetNamedStringivARB
#define glGetNextPerfQueryIdINTEL                        gl3wGetNextPerfQueryIdINTEL
#define glGetObjectLabel                                 gl3wGetObjectLabel
#define glGetObjectLabelEXT                              gl3wGetObjectLabelEXT
#define glGetObjectPtrLabel                              gl3wGetObjectPtrLabel
#define glGetPathCommandsNV                              gl3wGetPathCommandsNV
#define glGetPathCoordsNV                                gl3wGetPathCoordsNV
#define glGetPathDashArrayNV                             gl3wGetPathDashArrayNV
#define glGetPathLengthNV                                gl3wGetPathLengthNV
#define glGetPathMetricRangeNV                           gl3wGetPathMetricRangeNV
#define glGetPathMetricsNV                               gl3wGetPathMetricsNV
#define glGetPathParameterfvNV                           gl3wGetPathParameterfvNV
#define glGetPathParameterivNV                           gl3wGetPathParameterivNV
#define glGetPathSpacingNV                               gl3wGetPathSpacingNV
#define glGetPerfCounterInfoINTEL                        gl3wGetPerfCounterInfoINTEL
#define glGetPerfMonitorCounterDataAMD                   gl3wGetPerfMonitorCounterDataAMD
#define glGetPerfMonitorCounterInfoAMD                   gl3wGetPerfMonitorCounterInfoAMD
#define glGetPerfMonitorCounterStringAMD                 gl3wGetPerfMonitorCounterStringAMD
#define glGetPerfMonitorCountersAMD                      gl3wGetPerfMonitorCountersAMD
#define glGetPerfMonitorGroupStringAMD                   gl3wGetPerfMonitorGroupStringAMD
#define glGetPerfMonitorGroupsAMD                        gl3wGetPerfMonitorGroupsAMD
#define glGetPerfQueryDataINTEL                          gl3wGetPerfQueryDataINTEL
#define glGetPerfQueryIdByNameINTEL                      gl3wGetPerfQueryIdByNameINTEL
#define glGetPerfQueryInfoINTEL                          gl3wGetPerfQueryInfoINTEL
#define glGetPointerIndexedvEXT                          gl3wGetPointerIndexedvEXT
#define glGetPointeri_vEXT                               gl3wGetPointeri_vEXT
#define glGetPointerv                                    gl3wGetPointerv
#define glGetProgramBinary                               gl3wGetProgramBinary
#define glGetProgramInfoLog                              gl3wGetProgramInfoLog
#define glGetProgramInterfaceiv                          gl3wGetProgramInterfaceiv
#define glGetProgramPipelineInfoLog                      gl3wGetProgramPipelineInfoLog
#define glGetProgramPipelineiv                           gl3wGetProgramPipelineiv
#define glGetProgramResourceIndex                        gl3wGetProgramResourceIndex
#define glGetProgramResourceLocation                     gl3wGetProgramResourceLocation
#define glGetProgramResourceLocationIndex                gl3wGetProgramResourceLocationIndex
#define glGetProgramResourceName                         gl3wGetProgramResourceName
#define glGetProgramResourcefvNV                         gl3wGetProgramResourcefvNV
#define glGetProgramResourceiv                           gl3wGetProgramResourceiv
#define glGetProgramStageiv                              gl3wGetProgramStageiv
#define glGetProgramiv                                   gl3wGetProgramiv
#define glGetQueryBufferObjecti64v                       gl3wGetQueryBufferObjecti64v
#define glGetQueryBufferObjectiv                         gl3wGetQueryBufferObjectiv
#define glGetQueryBufferObjectui64v                      gl3wGetQueryBufferObjectui64v
#define glGetQueryBufferObjectuiv                        gl3wGetQueryBufferObjectuiv
#define glGetQueryIndexediv                              gl3wGetQueryIndexediv
#define glGetQueryObjecti64v                             gl3wGetQueryObjecti64v
#define glGetQueryObjectiv                               gl3wGetQueryObjectiv
#define glGetQueryObjectui64v                            gl3wGetQueryObjectui64v
#define glGetQueryObjectuiv                              gl3wGetQueryObjectuiv
#define glGetQueryiv                                     gl3wGetQueryiv
#define glGetRenderbufferParameteriv                     gl3wGetRenderbufferParameteriv
#define glGetSamplerParameterIiv                         gl3wGetSamplerParameterIiv
#define glGetSamplerParameterIuiv                        gl3wGetSamplerParameterIuiv
#define glGetSamplerParameterfv                          gl3wGetSamplerParameterfv
#define glGetSamplerParameteriv                          gl3wGetSamplerParameteriv
#define glGetShaderInfoLog                               gl3wGetShaderInfoLog
#define glGetShaderPrecisionFormat                       gl3wGetShaderPrecisionFormat
#define glGetShaderSource                                gl3wGetShaderSource
#define glGetShaderiv                                    gl3wGetShaderiv
#define glGetStageIndexNV                                gl3wGetStageIndexNV
#define glGetString                                      gl3wGetString
#define glGetStringi                                     gl3wGetStringi
#define glGetSubroutineIndex                             gl3wGetSubroutineIndex
#define glGetSubroutineUniformLocation                   gl3wGetSubroutineUniformLocation
#define glGetSynciv                                      gl3wGetSynciv
#define glGetTexImage                                    gl3wGetTexImage
#define glGetTexLevelParameterfv                         gl3wGetTexLevelParameterfv
#define glGetTexLevelParameteriv                         gl3wGetTexLevelParameteriv
#define glGetTexParameterIiv                             gl3wGetTexParameterIiv
#define glGetTexParameterIuiv                            gl3wGetTexParameterIuiv
#define glGetTexParameterfv                              gl3wGetTexParameterfv
#define glGetTexParameteriv                              gl3wGetTexParameteriv
#define glGetTextureHandleARB                            gl3wGetTextureHandleARB
#define glGetTextureHandleNV                             gl3wGetTextureHandleNV
#define glGetTextureImage                                gl3wGetTextureImage
#define glGetTextureImageEXT                             gl3wGetTextureImageEXT
#define glGetTextureLevelParameterfv                     gl3wGetTextureLevelParameterfv
#define glGetTextureLevelParameterfvEXT                  gl3wGetTextureLevelParameterfvEXT
#define glGetTextureLevelParameteriv                     gl3wGetTextureLevelParameteriv
#define glGetTextureLevelParameterivEXT                  gl3wGetTextureLevelParameterivEXT
#define glGetTextureParameterIiv                         gl3wGetTextureParameterIiv
#define glGetTextureParameterIivEXT                      gl3wGetTextureParameterIivEXT
#define glGetTextureParameterIuiv                        gl3wGetTextureParameterIuiv
#define glGetTextureParameterIuivEXT                     gl3wGetTextureParameterIuivEXT
#define glGetTextureParameterfv                          gl3wGetTextureParameterfv
#define glGetTextureParameterfvEXT                       gl3wGetTextureParameterfvEXT
#define glGetTextureParameteriv                          gl3wGetTextureParameteriv
#define glGetTextureParameterivEXT                       gl3wGetTextureParameterivEXT
#define glGetTextureSamplerHandleARB                     gl3wGetTextureSamplerHandleARB
#define glGetTextureSamplerHandleNV                      gl3wGetTextureSamplerHandleNV
#define glGetTextureSubImage                             gl3wGetTextureSubImage
#define glGetTransformFeedbackVarying                    gl3wGetTransformFeedbackVarying
#define glGetTransformFeedbacki64_v                      gl3wGetTransformFeedbacki64_v
#define glGetTransformFeedbacki_v                        gl3wGetTransformFeedbacki_v
#define glGetTransformFeedbackiv                         gl3wGetTransformFeedbackiv
#define glGetUniformBlockIndex                           gl3wGetUniformBlockIndex
#define glGetUniformIndices                              gl3wGetUniformIndices
#define glGetUniformLocation                             gl3wGetUniformLocation
#define glGetUniformSubroutineuiv                        gl3wGetUniformSubroutineuiv
#define glGetUniformdv                                   gl3wGetUniformdv
#define glGetUniformfv                                   gl3wGetUniformfv
#define glGetUniformi64vARB                              gl3wGetUniformi64vARB
#define glGetUniformi64vNV                               gl3wGetUniformi64vNV
#define glGetUniformiv                                   gl3wGetUniformiv
#define glGetUniformui64vARB                             gl3wGetUniformui64vARB
#define glGetUniformui64vNV                              gl3wGetUniformui64vNV
#define glGetUniformuiv                                  gl3wGetUniformuiv
#define glGetVertexArrayIndexed64iv                      gl3wGetVertexArrayIndexed64iv
#define glGetVertexArrayIndexediv                        gl3wGetVertexArrayIndexediv
#define glGetVertexArrayIntegeri_vEXT                    gl3wGetVertexArrayIntegeri_vEXT
#define glGetVertexArrayIntegervEXT                      gl3wGetVertexArrayIntegervEXT
#define glGetVertexArrayPointeri_vEXT                    gl3wGetVertexArrayPointeri_vEXT
#define glGetVertexArrayPointervEXT                      gl3wGetVertexArrayPointervEXT
#define glGetVertexArrayiv                               gl3wGetVertexArrayiv
#define glGetVertexAttribIiv                             gl3wGetVertexAttribIiv
#define glGetVertexAttribIuiv                            gl3wGetVertexAttribIuiv
#define glGetVertexAttribLdv                             gl3wGetVertexAttribLdv
#define glGetVertexAttribLi64vNV                         gl3wGetVertexAttribLi64vNV
#define glGetVertexAttribLui64vARB                       gl3wGetVertexAttribLui64vARB
#define glGetVertexAttribLui64vNV                        gl3wGetVertexAttribLui64vNV
#define glGetVertexAttribPointerv                        gl3wGetVertexAttribPointerv
#define glGetVertexAttribdv                              gl3wGetVertexAttribdv
#define glGetVertexAttribfv                              gl3wGetVertexAttribfv
#define glGetVertexAttribiv                              gl3wGetVertexAttribiv
#define glGetVkProcAddrNV                                gl3wGetVkProcAddrNV
#define glGetnCompressedTexImage                         gl3wGetnCompressedTexImage
#define glGetnCompressedTexImageARB                      gl3wGetnCompressedTexImageARB
#define glGetnTexImage                                   gl3wGetnTexImage
#define glGetnTexImageARB                                gl3wGetnTexImageARB
#define glGetnUniformdv                                  gl3wGetnUniformdv
#define glGetnUniformdvARB                               gl3wGetnUniformdvARB
#define glGetnUniformfv                                  gl3wGetnUniformfv
#define glGetnUniformfvARB                               gl3wGetnUniformfvARB
#define glGetnUniformi64vARB                             gl3wGetnUniformi64vARB
#define glGetnUniformiv                                  gl3wGetnUniformiv
#define glGetnUniformivARB                               gl3wGetnUniformivARB
#define glGetnUniformui64vARB                            gl3wGetnUniformui64vARB
#define glGetnUniformuiv                                 gl3wGetnUniformuiv
#define glGetnUniformuivARB                              gl3wGetnUniformuivARB
#define glHint                                           gl3wHint
#define glIndexFormatNV                                  gl3wIndexFormatNV
#define glInsertEventMarkerEXT                           gl3wInsertEventMarkerEXT
#define glInterpolatePathsNV                             gl3wInterpolatePathsNV
#define glInvalidateBufferData                           gl3wInvalidateBufferData
#define glInvalidateBufferSubData                        gl3wInvalidateBufferSubData
#define glInvalidateFramebuffer                          gl3wInvalidateFramebuffer
#define glInvalidateNamedFramebufferData                 gl3wInvalidateNamedFramebufferData
#define glInvalidateNamedFramebufferSubData              gl3wInvalidateNamedFramebufferSubData
#define glInvalidateSubFramebuffer                       gl3wInvalidateSubFramebuffer
#define glInvalidateTexImage                             gl3wInvalidateTexImage
#define glInvalidateTexSubImage                          gl3wInvalidateTexSubImage
#define glIsBuffer                                       gl3wIsBuffer
#define glIsBufferResidentNV                             gl3wIsBufferResidentNV
#define glIsCommandListNV                                gl3wIsCommandListNV
#define glIsEnabled                                      gl3wIsEnabled
#define glIsEnabledIndexedEXT                            gl3wIsEnabledIndexedEXT
#define glIsEnabledi                                     gl3wIsEnabledi
#define glIsFramebuffer                                  gl3wIsFramebuffer
#define glIsImageHandleResidentARB                       gl3wIsImageHandleResidentARB
#define glIsImageHandleResidentNV                        gl3wIsImageHandleResidentNV
#define glIsNamedBufferResidentNV                        gl3wIsNamedBufferResidentNV
#define glIsNamedStringARB                               gl3wIsNamedStringARB
#define glIsPathNV                                       gl3wIsPathNV
#define glIsPointInFillPathNV                            gl3wIsPointInFillPathNV
#define glIsPointInStrokePathNV                          gl3wIsPointInStrokePathNV
#define glIsProgram                                      gl3wIsProgram
#define glIsProgramPipeline                              gl3wIsProgramPipeline
#define glIsQuery                                        gl3wIsQuery
#define glIsRenderbuffer                                 gl3wIsRenderbuffer
#define glIsSampler                                      gl3wIsSampler
#define glIsShader                                       gl3wIsShader
#define glIsStateNV                                      gl3wIsStateNV
#define glIsSync                                         gl3wIsSync
#define glIsTexture                                      gl3wIsTexture
#define glIsTextureHandleResidentARB                     gl3wIsTextureHandleResidentARB
#define glIsTextureHandleResidentNV                      gl3wIsTextureHandleResidentNV
#define glIsTransformFeedback                            gl3wIsTransformFeedback
#define glIsVertexArray                                  gl3wIsVertexArray
#define glLabelObjectEXT                                 gl3wLabelObjectEXT
#define glLineWidth                                      gl3wLineWidth
#define glLinkProgram                                    gl3wLinkProgram
#define glListDrawCommandsStatesClientNV                 gl3wListDrawCommandsStatesClientNV
#define glLogicOp                                        gl3wLogicOp
#define glMakeBufferNonResidentNV                        gl3wMakeBufferNonResidentNV
#define glMakeBufferResidentNV                           gl3wMakeBufferResidentNV
#define glMakeImageHandleNonResidentARB                  gl3wMakeImageHandleNonResidentARB
#define glMakeImageHandleNonResidentNV                   gl3wMakeImageHandleNonResidentNV
#define glMakeImageHandleResidentARB                     gl3wMakeImageHandleResidentARB
#define glMakeImageHandleResidentNV                      gl3wMakeImageHandleResidentNV
#define glMakeNamedBufferNonResidentNV                   gl3wMakeNamedBufferNonResidentNV
#define glMakeNamedBufferResidentNV                      gl3wMakeNamedBufferResidentNV
#define glMakeTextureHandleNonResidentARB                gl3wMakeTextureHandleNonResidentARB
#define glMakeTextureHandleNonResidentNV                 gl3wMakeTextureHandleNonResidentNV
#define glMakeTextureHandleResidentARB                   gl3wMakeTextureHandleResidentARB
#define glMakeTextureHandleResidentNV                    gl3wMakeTextureHandleResidentNV
#define glMapBuffer                                      gl3wMapBuffer
#define glMapBufferRange                                 gl3wMapBufferRange
#define glMapNamedBuffer                                 gl3wMapNamedBuffer
#define glMapNamedBufferEXT                              gl3wMapNamedBufferEXT
#define glMapNamedBufferRange                            gl3wMapNamedBufferRange
#define glMapNamedBufferRangeEXT                         gl3wMapNamedBufferRangeEXT
#define glMatrixFrustumEXT                               gl3wMatrixFrustumEXT
#define glMatrixLoad3x2fNV                               gl3wMatrixLoad3x2fNV
#define glMatrixLoad3x3fNV                               gl3wMatrixLoad3x3fNV
#define glMatrixLoadIdentityEXT                          gl3wMatrixLoadIdentityEXT
#define glMatrixLoadTranspose3x3fNV                      gl3wMatrixLoadTranspose3x3fNV
#define glMatrixLoadTransposedEXT                        gl3wMatrixLoadTransposedEXT
#define glMatrixLoadTransposefEXT                        gl3wMatrixLoadTransposefEXT
#define glMatrixLoaddEXT                                 gl3wMatrixLoaddEXT
#define glMatrixLoadfEXT                                 gl3wMatrixLoadfEXT
#define glMatrixMult3x2fNV                               gl3wMatrixMult3x2fNV
#define glMatrixMult3x3fNV                               gl3wMatrixMult3x3fNV
#define glMatrixMultTranspose3x3fNV                      gl3wMatrixMultTranspose3x3fNV
#define glMatrixMultTransposedEXT                        gl3wMatrixMultTransposedEXT
#define glMatrixMultTransposefEXT                        gl3wMatrixMultTransposefEXT
#define glMatrixMultdEXT                                 gl3wMatrixMultdEXT
#define glMatrixMultfEXT                                 gl3wMatrixMultfEXT
#define glMatrixOrthoEXT                                 gl3wMatrixOrthoEXT
#define glMatrixPopEXT                                   gl3wMatrixPopEXT
#define glMatrixPushEXT                                  gl3wMatrixPushEXT
#define glMatrixRotatedEXT                               gl3wMatrixRotatedEXT
#define glMatrixRotatefEXT                               gl3wMatrixRotatefEXT
#define glMatrixScaledEXT                                gl3wMatrixScaledEXT
#define glMatrixScalefEXT                                gl3wMatrixScalefEXT
#define glMatrixTranslatedEXT                            gl3wMatrixTranslatedEXT
#define glMatrixTranslatefEXT                            gl3wMatrixTranslatefEXT
#define glMaxShaderCompilerThreadsARB                    gl3wMaxShaderCompilerThreadsARB
#define glMemoryBarrier                                  gl3wMemoryBarrier
#define glMemoryBarrierByRegion                          gl3wMemoryBarrierByRegion
#define glMinSampleShading                               gl3wMinSampleShading
#define glMinSampleShadingARB                            gl3wMinSampleShadingARB
#define glMultiDrawArrays                                gl3wMultiDrawArrays
#define glMultiDrawArraysIndirect                        gl3wMultiDrawArraysIndirect
#define glMultiDrawArraysIndirectBindlessCountNV         gl3wMultiDrawArraysIndirectBindlessCountNV
#define glMultiDrawArraysIndirectBindlessNV              gl3wMultiDrawArraysIndirectBindlessNV
#define glMultiDrawArraysIndirectCount                   gl3wMultiDrawArraysIndirectCount
#define glMultiDrawArraysIndirectCountARB                gl3wMultiDrawArraysIndirectCountARB
#define glMultiDrawElements                              gl3wMultiDrawElements
#define glMultiDrawElementsBaseVertex                    gl3wMultiDrawElementsBaseVertex
#define glMultiDrawElementsIndirect                      gl3wMultiDrawElementsIndirect
#define glMultiDrawElementsIndirectBindlessCountNV       gl3wMultiDrawElementsIndirectBindlessCountNV
#define glMultiDrawElementsIndirectBindlessNV            gl3wMultiDrawElementsIndirectBindlessNV
#define glMultiDrawElementsIndirectCount                 gl3wMultiDrawElementsIndirectCount
#define glMultiDrawElementsIndirectCountARB              gl3wMultiDrawElementsIndirectCountARB
#define glMultiTexBufferEXT                              gl3wMultiTexBufferEXT
#define glMultiTexCoordPointerEXT                        gl3wMultiTexCoordPointerEXT
#define glMultiTexEnvfEXT                                gl3wMultiTexEnvfEXT
#define glMultiTexEnvfvEXT                               gl3wMultiTexEnvfvEXT
#define glMultiTexEnviEXT                                gl3wMultiTexEnviEXT
#define glMultiTexEnvivEXT                               gl3wMultiTexEnvivEXT
#define glMultiTexGendEXT                                gl3wMultiTexGendEXT
#define glMultiTexGendvEXT                               gl3wMultiTexGendvEXT
#define glMultiTexGenfEXT                                gl3wMultiTexGenfEXT
#define glMultiTexGenfvEXT                               gl3wMultiTexGenfvEXT
#define glMultiTexGeniEXT                                gl3wMultiTexGeniEXT
#define glMultiTexGenivEXT                               gl3wMultiTexGenivEXT
#define glMultiTexImage1DEXT                             gl3wMultiTexImage1DEXT
#define glMultiTexImage2DEXT                             gl3wMultiTexImage2DEXT
#define glMultiTexImage3DEXT                             gl3wMultiTexImage3DEXT
#define glMultiTexParameterIivEXT                        gl3wMultiTexParameterIivEXT
#define glMultiTexParameterIuivEXT                       gl3wMultiTexParameterIuivEXT
#define glMultiTexParameterfEXT                          gl3wMultiTexParameterfEXT
#define glMultiTexParameterfvEXT                         gl3wMultiTexParameterfvEXT
#define glMultiTexParameteriEXT                          gl3wMultiTexParameteriEXT
#define glMultiTexParameterivEXT                         gl3wMultiTexParameterivEXT
#define glMultiTexRenderbufferEXT                        gl3wMultiTexRenderbufferEXT
#define glMultiTexSubImage1DEXT                          gl3wMultiTexSubImage1DEXT
#define glMultiTexSubImage2DEXT                          gl3wMultiTexSubImage2DEXT
#define glMultiTexSubImage3DEXT                          gl3wMultiTexSubImage3DEXT
#define glNamedBufferData                                gl3wNamedBufferData
#define glNamedBufferDataEXT                             gl3wNamedBufferDataEXT
#define glNamedBufferPageCommitmentARB                   gl3wNamedBufferPageCommitmentARB
#define glNamedBufferPageCommitmentEXT                   gl3wNamedBufferPageCommitmentEXT
#define glNamedBufferStorage                             gl3wNamedBufferStorage
#define glNamedBufferStorageEXT                          gl3wNamedBufferStorageEXT
#define glNamedBufferSubData                             gl3wNamedBufferSubData
#define glNamedBufferSubDataEXT                          gl3wNamedBufferSubDataEXT
#define glNamedCopyBufferSubDataEXT                      gl3wNamedCopyBufferSubDataEXT
#define glNamedFramebufferDrawBuffer                     gl3wNamedFramebufferDrawBuffer
#define glNamedFramebufferDrawBuffers                    gl3wNamedFramebufferDrawBuffers
#define glNamedFramebufferParameteri                     gl3wNamedFramebufferParameteri
#define glNamedFramebufferParameteriEXT                  gl3wNamedFramebufferParameteriEXT
#define glNamedFramebufferReadBuffer                     gl3wNamedFramebufferReadBuffer
#define glNamedFramebufferRenderbuffer                   gl3wNamedFramebufferRenderbuffer
#define glNamedFramebufferRenderbufferEXT                gl3wNamedFramebufferRenderbufferEXT
#define glNamedFramebufferSampleLocationsfvARB           gl3wNamedFramebufferSampleLocationsfvARB
#define glNamedFramebufferSampleLocationsfvNV            gl3wNamedFramebufferSampleLocationsfvNV
#define glNamedFramebufferTexture                        gl3wNamedFramebufferTexture
#define glNamedFramebufferTexture1DEXT                   gl3wNamedFramebufferTexture1DEXT
#define glNamedFramebufferTexture2DEXT                   gl3wNamedFramebufferTexture2DEXT
#define glNamedFramebufferTexture3DEXT                   gl3wNamedFramebufferTexture3DEXT
#define glNamedFramebufferTextureEXT                     gl3wNamedFramebufferTextureEXT
#define glNamedFramebufferTextureFaceEXT                 gl3wNamedFramebufferTextureFaceEXT
#define glNamedFramebufferTextureLayer                   gl3wNamedFramebufferTextureLayer
#define glNamedFramebufferTextureLayerEXT                gl3wNamedFramebufferTextureLayerEXT
#define glNamedProgramLocalParameter4dEXT                gl3wNamedProgramLocalParameter4dEXT
#define glNamedProgramLocalParameter4dvEXT               gl3wNamedProgramLocalParameter4dvEXT
#define glNamedProgramLocalParameter4fEXT                gl3wNamedProgramLocalParameter4fEXT
#define glNamedProgramLocalParameter4fvEXT               gl3wNamedProgramLocalParameter4fvEXT
#define glNamedProgramLocalParameterI4iEXT               gl3wNamedProgramLocalParameterI4iEXT
#define glNamedProgramLocalParameterI4ivEXT              gl3wNamedProgramLocalParameterI4ivEXT
#define glNamedProgramLocalParameterI4uiEXT              gl3wNamedProgramLocalParameterI4uiEXT
#define glNamedProgramLocalParameterI4uivEXT             gl3wNamedProgramLocalParameterI4uivEXT
#define glNamedProgramLocalParameters4fvEXT              gl3wNamedProgramLocalParameters4fvEXT
#define glNamedProgramLocalParametersI4ivEXT             gl3wNamedProgramLocalParametersI4ivEXT
#define glNamedProgramLocalParametersI4uivEXT            gl3wNamedProgramLocalParametersI4uivEXT
#define glNamedProgramStringEXT                          gl3wNamedProgramStringEXT
#define glNamedRenderbufferStorage                       gl3wNamedRenderbufferStorage
#define glNamedRenderbufferStorageEXT                    gl3wNamedRenderbufferStorageEXT
#define glNamedRenderbufferStorageMultisample            gl3wNamedRenderbufferStorageMultisample
#define glNamedRenderbufferStorageMultisampleCoverageEXT gl3wNamedRenderbufferStorageMultisampleCoverageEXT
#define glNamedRenderbufferStorageMultisampleEXT         gl3wNamedRenderbufferStorageMultisampleEXT
#define glNamedStringARB                                 gl3wNamedStringARB
#define glNormalFormatNV                                 gl3wNormalFormatNV
#define glObjectLabel                                    gl3wObjectLabel
#define glObjectPtrLabel                                 gl3wObjectPtrLabel
#define glPatchParameterfv                               gl3wPatchParameterfv
#define glPatchParameteri                                gl3wPatchParameteri
#define glPathCommandsNV                                 gl3wPathCommandsNV
#define glPathCoordsNV                                   gl3wPathCoordsNV
#define glPathCoverDepthFuncNV                           gl3wPathCoverDepthFuncNV
#define glPathDashArrayNV                                gl3wPathDashArrayNV
#define glPathGlyphIndexArrayNV                          gl3wPathGlyphIndexArrayNV
#define glPathGlyphIndexRangeNV                          gl3wPathGlyphIndexRangeNV
#define glPathGlyphRangeNV                               gl3wPathGlyphRangeNV
#define glPathGlyphsNV                                   gl3wPathGlyphsNV
#define glPathMemoryGlyphIndexArrayNV                    gl3wPathMemoryGlyphIndexArrayNV
#define glPathParameterfNV                               gl3wPathParameterfNV
#define glPathParameterfvNV                              gl3wPathParameterfvNV
#define glPathParameteriNV                               gl3wPathParameteriNV
#define glPathParameterivNV                              gl3wPathParameterivNV
#define glPathStencilDepthOffsetNV                       gl3wPathStencilDepthOffsetNV
#define glPathStencilFuncNV                              gl3wPathStencilFuncNV
#define glPathStringNV                                   gl3wPathStringNV
#define glPathSubCommandsNV                              gl3wPathSubCommandsNV
#define glPathSubCoordsNV                                gl3wPathSubCoordsNV
#define glPauseTransformFeedback                         gl3wPauseTransformFeedback
#define glPixelStoref                                    gl3wPixelStoref
#define glPixelStorei                                    gl3wPixelStorei
#define glPointAlongPathNV                               gl3wPointAlongPathNV
#define glPointParameterf                                gl3wPointParameterf
#define glPointParameterfv                               gl3wPointParameterfv
#define glPointParameteri                                gl3wPointParameteri
#define glPointParameteriv                               gl3wPointParameteriv
#define glPointSize                                      gl3wPointSize
#define glPolygonMode                                    gl3wPolygonMode
#define glPolygonOffset                                  gl3wPolygonOffset
#define glPolygonOffsetClamp                             gl3wPolygonOffsetClamp
#define glPolygonOffsetClampEXT                          gl3wPolygonOffsetClampEXT
#define glPopDebugGroup                                  gl3wPopDebugGroup
#define glPopGroupMarkerEXT                              gl3wPopGroupMarkerEXT
#define glPrimitiveBoundingBoxARB                        gl3wPrimitiveBoundingBoxARB
#define glPrimitiveRestartIndex                          gl3wPrimitiveRestartIndex
#define glProgramBinary                                  gl3wProgramBinary
#define glProgramParameteri                              gl3wProgramParameteri
#define glProgramParameteriARB                           gl3wProgramParameteriARB
#define glProgramPathFragmentInputGenNV                  gl3wProgramPathFragmentInputGenNV
#define glProgramUniform1d                               gl3wProgramUniform1d
#define glProgramUniform1dEXT                            gl3wProgramUniform1dEXT
#define glProgramUniform1dv                              gl3wProgramUniform1dv
#define glProgramUniform1dvEXT                           gl3wProgramUniform1dvEXT
#define glProgramUniform1f                               gl3wProgramUniform1f
#define glProgramUniform1fEXT                            gl3wProgramUniform1fEXT
#define glProgramUniform1fv                              gl3wProgramUniform1fv
#define glProgramUniform1fvEXT                           gl3wProgramUniform1fvEXT
#define glProgramUniform1i                               gl3wProgramUniform1i
#define glProgramUniform1i64ARB                          gl3wProgramUniform1i64ARB
#define glProgramUniform1i64NV                           gl3wProgramUniform1i64NV
#define glProgramUniform1i64vARB                         gl3wProgramUniform1i64vARB
#define glProgramUniform1i64vNV                          gl3wProgramUniform1i64vNV
#define glProgramUniform1iEXT                            gl3wProgramUniform1iEXT
#define glProgramUniform1iv                              gl3wProgramUniform1iv
#define glProgramUniform1ivEXT                           gl3wProgramUniform1ivEXT
#define glProgramUniform1ui                              gl3wProgramUniform1ui
#define glProgramUniform1ui64ARB                         gl3wProgramUniform1ui64ARB
#define glProgramUniform1ui64NV                          gl3wProgramUniform1ui64NV
#define glProgramUniform1ui64vARB                        gl3wProgramUniform1ui64vARB
#define glProgramUniform1ui64vNV                         gl3wProgramUniform1ui64vNV
#define glProgramUniform1uiEXT                           gl3wProgramUniform1uiEXT
#define glProgramUniform1uiv                             gl3wProgramUniform1uiv
#define glProgramUniform1uivEXT                          gl3wProgramUniform1uivEXT
#define glProgramUniform2d                               gl3wProgramUniform2d
#define glProgramUniform2dEXT                            gl3wProgramUniform2dEXT
#define glProgramUniform2dv                              gl3wProgramUniform2dv
#define glProgramUniform2dvEXT                           gl3wProgramUniform2dvEXT
#define glProgramUniform2f                               gl3wProgramUniform2f
#define glProgramUniform2fEXT                            gl3wProgramUniform2fEXT
#define glProgramUniform2fv                              gl3wProgramUniform2fv
#define glProgramUniform2fvEXT                           gl3wProgramUniform2fvEXT
#define glProgramUniform2i                               gl3wProgramUniform2i
#define glProgramUniform2i64ARB                          gl3wProgramUniform2i64ARB
#define glProgramUniform2i64NV                           gl3wProgramUniform2i64NV
#define glProgramUniform2i64vARB                         gl3wProgramUniform2i64vARB
#define glProgramUniform2i64vNV                          gl3wProgramUniform2i64vNV
#define glProgramUniform2iEXT                            gl3wProgramUniform2iEXT
#define glProgramUniform2iv                              gl3wProgramUniform2iv
#define glProgramUniform2ivEXT                           gl3wProgramUniform2ivEXT
#define glProgramUniform2ui                              gl3wProgramUniform2ui
#define glProgramUniform2ui64ARB                         gl3wProgramUniform2ui64ARB
#define glProgramUniform2ui64NV                          gl3wProgramUniform2ui64NV
#define glProgramUniform2ui64vARB                        gl3wProgramUniform2ui64vARB
#define glProgramUniform2ui64vNV                         gl3wProgramUniform2ui64vNV
#define glProgramUniform2uiEXT                           gl3wProgramUniform2uiEXT
#define glProgramUniform2uiv                             gl3wProgramUniform2uiv
#define glProgramUniform2uivEXT                          gl3wProgramUniform2uivEXT
#define glProgramUniform3d                               gl3wProgramUniform3d
#define glProgramUniform3dEXT                            gl3wProgramUniform3dEXT
#define glProgramUniform3dv                              gl3wProgramUniform3dv
#define glProgramUniform3dvEXT                           gl3wProgramUniform3dvEXT
#define glProgramUniform3f                               gl3wProgramUniform3f
#define glProgramUniform3fEXT                            gl3wProgramUniform3fEXT
#define glProgramUniform3fv                              gl3wProgramUniform3fv
#define glProgramUniform3fvEXT                           gl3wProgramUniform3fvEXT
#define glProgramUniform3i                               gl3wProgramUniform3i
#define glProgramUniform3i64ARB                          gl3wProgramUniform3i64ARB
#define glProgramUniform3i64NV                           gl3wProgramUniform3i64NV
#define glProgramUniform3i64vARB                         gl3wProgramUniform3i64vARB
#define glProgramUniform3i64vNV                          gl3wProgramUniform3i64vNV
#define glProgramUniform3iEXT                            gl3wProgramUniform3iEXT
#define glProgramUniform3iv                              gl3wProgramUniform3iv
#define glProgramUniform3ivEXT                           gl3wProgramUniform3ivEXT
#define glProgramUniform3ui                              gl3wProgramUniform3ui
#define glProgramUniform3ui64ARB                         gl3wProgramUniform3ui64ARB
#define glProgramUniform3ui64NV                          gl3wProgramUniform3ui64NV
#define glProgramUniform3ui64vARB                        gl3wProgramUniform3ui64vARB
#define glProgramUniform3ui64vNV                         gl3wProgramUniform3ui64vNV
#define glProgramUniform3uiEXT                           gl3wProgramUniform3uiEXT
#define glProgramUniform3uiv                             gl3wProgramUniform3uiv
#define glProgramUniform3uivEXT                          gl3wProgramUniform3uivEXT
#define glProgramUniform4d                               gl3wProgramUniform4d
#define glProgramUniform4dEXT                            gl3wProgramUniform4dEXT
#define glProgramUniform4dv                              gl3wProgramUniform4dv
#define glProgramUniform4dvEXT                           gl3wProgramUniform4dvEXT
#define glProgramUniform4f                               gl3wProgramUniform4f
#define glProgramUniform4fEXT                            gl3wProgramUniform4fEXT
#define glProgramUniform4fv                              gl3wProgramUniform4fv
#define glProgramUniform4fvEXT                           gl3wProgramUniform4fvEXT
#define glProgramUniform4i                               gl3wProgramUniform4i
#define glProgramUniform4i64ARB                          gl3wProgramUniform4i64ARB
#define glProgramUniform4i64NV                           gl3wProgramUniform4i64NV
#define glProgramUniform4i64vARB                         gl3wProgramUniform4i64vARB
#define glProgramUniform4i64vNV                          gl3wProgramUniform4i64vNV
#define glProgramUniform4iEXT                            gl3wProgramUniform4iEXT
#define glProgramUniform4iv                              gl3wProgramUniform4iv
#define glProgramUniform4ivEXT                           gl3wProgramUniform4ivEXT
#define glProgramUniform4ui                              gl3wProgramUniform4ui
#define glProgramUniform4ui64ARB                         gl3wProgramUniform4ui64ARB
#define glProgramUniform4ui64NV                          gl3wProgramUniform4ui64NV
#define glProgramUniform4ui64vARB                        gl3wProgramUniform4ui64vARB
#define glProgramUniform4ui64vNV                         gl3wProgramUniform4ui64vNV
#define glProgramUniform4uiEXT                           gl3wProgramUniform4uiEXT
#define glProgramUniform4uiv                             gl3wProgramUniform4uiv
#define glProgramUniform4uivEXT                          gl3wProgramUniform4uivEXT
#define glProgramUniformHandleui64ARB                    gl3wProgramUniformHandleui64ARB
#define glProgramUniformHandleui64NV                     gl3wProgramUniformHandleui64NV
#define glProgramUniformHandleui64vARB                   gl3wProgramUniformHandleui64vARB
#define glProgramUniformHandleui64vNV                    gl3wProgramUniformHandleui64vNV
#define glProgramUniformMatrix2dv                        gl3wProgramUniformMatrix2dv
#define glProgramUniformMatrix2dvEXT                     gl3wProgramUniformMatrix2dvEXT
#define glProgramUniformMatrix2fv                        gl3wProgramUniformMatrix2fv
#define glProgramUniformMatrix2fvEXT                     gl3wProgramUniformMatrix2fvEXT
#define glProgramUniformMatrix2x3dv                      gl3wProgramUniformMatrix2x3dv
#define glProgramUniformMatrix2x3dvEXT                   gl3wProgramUniformMatrix2x3dvEXT
#define glProgramUniformMatrix2x3fv                      gl3wProgramUniformMatrix2x3fv
#define glProgramUniformMatrix2x3fvEXT                   gl3wProgramUniformMatrix2x3fvEXT
#define glProgramUniformMatrix2x4dv                      gl3wProgramUniformMatrix2x4dv
#define glProgramUniformMatrix2x4dvEXT                   gl3wProgramUniformMatrix2x4dvEXT
#define glProgramUniformMatrix2x4fv                      gl3wProgramUniformMatrix2x4fv
#define glProgramUniformMatrix2x4fvEXT                   gl3wProgramUniformMatrix2x4fvEXT
#define glProgramUniformMatrix3dv                        gl3wProgramUniformMatrix3dv
#define glProgramUniformMatrix3dvEXT                     gl3wProgramUniformMatrix3dvEXT
#define glProgramUniformMatrix3fv                        gl3wProgramUniformMatrix3fv
#define glProgramUniformMatrix3fvEXT                     gl3wProgramUniformMatrix3fvEXT
#define glProgramUniformMatrix3x2dv                      gl3wProgramUniformMatrix3x2dv
#define glProgramUniformMatrix3x2dvEXT                   gl3wProgramUniformMatrix3x2dvEXT
#define glProgramUniformMatrix3x2fv                      gl3wProgramUniformMatrix3x2fv
#define glProgramUniformMatrix3x2fvEXT                   gl3wProgramUniformMatrix3x2fvEXT
#define glProgramUniformMatrix3x4dv                      gl3wProgramUniformMatrix3x4dv
#define glProgramUniformMatrix3x4dvEXT                   gl3wProgramUniformMatrix3x4dvEXT
#define glProgramUniformMatrix3x4fv                      gl3wProgramUniformMatrix3x4fv
#define glProgramUniformMatrix3x4fvEXT                   gl3wProgramUniformMatrix3x4fvEXT
#define glProgramUniformMatrix4dv                        gl3wProgramUniformMatrix4dv
#define glProgramUniformMatrix4dvEXT                     gl3wProgramUniformMatrix4dvEXT
#define glProgramUniformMatrix4fv                        gl3wProgramUniformMatrix4fv
#define glProgramUniformMatrix4fvEXT                     gl3wProgramUniformMatrix4fvEXT
#define glProgramUniformMatrix4x2dv                      gl3wProgramUniformMatrix4x2dv
#define glProgramUniformMatrix4x2dvEXT                   gl3wProgramUniformMatrix4x2dvEXT
#define glProgramUniformMatrix4x2fv                      gl3wProgramUniformMatrix4x2fv
#define glProgramUniformMatrix4x2fvEXT                   gl3wProgramUniformMatrix4x2fvEXT
#define glProgramUniformMatrix4x3dv                      gl3wProgramUniformMatrix4x3dv
#define glProgramUniformMatrix4x3dvEXT                   gl3wProgramUniformMatrix4x3dvEXT
#define glProgramUniformMatrix4x3fv                      gl3wProgramUniformMatrix4x3fv
#define glProgramUniformMatrix4x3fvEXT                   gl3wProgramUniformMatrix4x3fvEXT
#define glProgramUniformui64NV                           gl3wProgramUniformui64NV
#define glProgramUniformui64vNV                          gl3wProgramUniformui64vNV
#define glProvokingVertex                                gl3wProvokingVertex
#define glPushClientAttribDefaultEXT                     gl3wPushClientAttribDefaultEXT
#define glPushDebugGroup                                 gl3wPushDebugGroup
#define glPushGroupMarkerEXT                             gl3wPushGroupMarkerEXT
#define glQueryCounter                                   gl3wQueryCounter
#define glRasterSamplesEXT                               gl3wRasterSamplesEXT
#define glReadBuffer                                     gl3wReadBuffer
#define glReadPixels                                     gl3wReadPixels
#define glReadnPixels                                    gl3wReadnPixels
#define glReadnPixelsARB                                 gl3wReadnPixelsARB
#define glReleaseShaderCompiler                          gl3wReleaseShaderCompiler
#define glRenderbufferStorage                            gl3wRenderbufferStorage
#define glRenderbufferStorageMultisample                 gl3wRenderbufferStorageMultisample
#define glRenderbufferStorageMultisampleCoverageNV       gl3wRenderbufferStorageMultisampleCoverageNV
#define glResolveDepthValuesNV                           gl3wResolveDepthValuesNV
#define glResumeTransformFeedback                        gl3wResumeTransformFeedback
#define glSampleCoverage                                 gl3wSampleCoverage
#define glSampleMaski                                    gl3wSampleMaski
#define glSamplerParameterIiv                            gl3wSamplerParameterIiv
#define glSamplerParameterIuiv                           gl3wSamplerParameterIuiv
#define glSamplerParameterf                              gl3wSamplerParameterf
#define glSamplerParameterfv                             gl3wSamplerParameterfv
#define glSamplerParameteri                              gl3wSamplerParameteri
#define glSamplerParameteriv                             gl3wSamplerParameteriv
#define glScissor                                        gl3wScissor
#define glScissorArrayv                                  gl3wScissorArrayv
#define glScissorIndexed                                 gl3wScissorIndexed
#define glScissorIndexedv                                gl3wScissorIndexedv
#define glSecondaryColorFormatNV                         gl3wSecondaryColorFormatNV
#define glSelectPerfMonitorCountersAMD                   gl3wSelectPerfMonitorCountersAMD
#define glShaderBinary                                   gl3wShaderBinary
#define glShaderSource                                   gl3wShaderSource
#define glShaderStorageBlockBinding                      gl3wShaderStorageBlockBinding
#define glSignalVkFenceNV                                gl3wSignalVkFenceNV
#define glSignalVkSemaphoreNV                            gl3wSignalVkSemaphoreNV
#define glSpecializeShader                               gl3wSpecializeShader
#define glSpecializeShaderARB                            gl3wSpecializeShaderARB
#define glStateCaptureNV                                 gl3wStateCaptureNV
#define glStencilFillPathInstancedNV                     gl3wStencilFillPathInstancedNV
#define glStencilFillPathNV                              gl3wStencilFillPathNV
#define glStencilFunc                                    gl3wStencilFunc
#define glStencilFuncSeparate                            gl3wStencilFuncSeparate
#define glStencilMask                                    gl3wStencilMask
#define glStencilMaskSeparate                            gl3wStencilMaskSeparate
#define glStencilOp                                      gl3wStencilOp
#define glStencilOpSeparate                              gl3wStencilOpSeparate
#define glStencilStrokePathInstancedNV                   gl3wStencilStrokePathInstancedNV
#define glStencilStrokePathNV                            gl3wStencilStrokePathNV
#define glStencilThenCoverFillPathInstancedNV            gl3wStencilThenCoverFillPathInstancedNV
#define glStencilThenCoverFillPathNV                     gl3wStencilThenCoverFillPathNV
#define glStencilThenCoverStrokePathInstancedNV          gl3wStencilThenCoverStrokePathInstancedNV
#define glStencilThenCoverStrokePathNV                   gl3wStencilThenCoverStrokePathNV
#define glSubpixelPrecisionBiasNV                        gl3wSubpixelPrecisionBiasNV
#define glTexBuffer                                      gl3wTexBuffer
#define glTexBufferARB                                   gl3wTexBufferARB
#define glTexBufferRange                                 gl3wTexBufferRange
#define glTexCoordFormatNV                               gl3wTexCoordFormatNV
#define glTexImage1D                                     gl3wTexImage1D
#define glTexImage2D                                     gl3wTexImage2D
#define glTexImage2DMultisample                          gl3wTexImage2DMultisample
#define glTexImage3D                                     gl3wTexImage3D
#define glTexImage3DMultisample                          gl3wTexImage3DMultisample
#define glTexPageCommitmentARB                           gl3wTexPageCommitmentARB
#define glTexParameterIiv                                gl3wTexParameterIiv
#define glTexParameterIuiv                               gl3wTexParameterIuiv
#define glTexParameterf                                  gl3wTexParameterf
#define glTexParameterfv                                 gl3wTexParameterfv
#define glTexParameteri                                  gl3wTexParameteri
#define glTexParameteriv                                 gl3wTexParameteriv
#define glTexStorage1D                                   gl3wTexStorage1D
#define glTexStorage2D                                   gl3wTexStorage2D
#define glTexStorage2DMultisample                        gl3wTexStorage2DMultisample
#define glTexStorage3D                                   gl3wTexStorage3D
#define glTexStorage3DMultisample                        gl3wTexStorage3DMultisample
#define glTexSubImage1D                                  gl3wTexSubImage1D
#define glTexSubImage2D                                  gl3wTexSubImage2D
#define glTexSubImage3D                                  gl3wTexSubImage3D
#define glTextureBarrier                                 gl3wTextureBarrier
#define glTextureBarrierNV                               gl3wTextureBarrierNV
#define glTextureBuffer                                  gl3wTextureBuffer
#define glTextureBufferEXT                               gl3wTextureBufferEXT
#define glTextureBufferRange                             gl3wTextureBufferRange
#define glTextureBufferRangeEXT                          gl3wTextureBufferRangeEXT
#define glTextureImage1DEXT                              gl3wTextureImage1DEXT
#define glTextureImage2DEXT                              gl3wTextureImage2DEXT
#define glTextureImage3DEXT                              gl3wTextureImage3DEXT
#define glTexturePageCommitmentEXT                       gl3wTexturePageCommitmentEXT
#define glTextureParameterIiv                            gl3wTextureParameterIiv
#define glTextureParameterIivEXT                         gl3wTextureParameterIivEXT
#define glTextureParameterIuiv                           gl3wTextureParameterIuiv
#define glTextureParameterIuivEXT                        gl3wTextureParameterIuivEXT
#define glTextureParameterf                              gl3wTextureParameterf
#define glTextureParameterfEXT                           gl3wTextureParameterfEXT
#define glTextureParameterfv                             gl3wTextureParameterfv
#define glTextureParameterfvEXT                          gl3wTextureParameterfvEXT
#define glTextureParameteri                              gl3wTextureParameteri
#define glTextureParameteriEXT                           gl3wTextureParameteriEXT
#define glTextureParameteriv                             gl3wTextureParameteriv
#define glTextureParameterivEXT                          gl3wTextureParameterivEXT
#define glTextureRenderbufferEXT                         gl3wTextureRenderbufferEXT
#define glTextureStorage1D                               gl3wTextureStorage1D
#define glTextureStorage1DEXT                            gl3wTextureStorage1DEXT
#define glTextureStorage2D                               gl3wTextureStorage2D
#define glTextureStorage2DEXT                            gl3wTextureStorage2DEXT
#define glTextureStorage2DMultisample                    gl3wTextureStorage2DMultisample
#define glTextureStorage2DMultisampleEXT                 gl3wTextureStorage2DMultisampleEXT
#define glTextureStorage3D                               gl3wTextureStorage3D
#define glTextureStorage3DEXT                            gl3wTextureStorage3DEXT
#define glTextureStorage3DMultisample                    gl3wTextureStorage3DMultisample
#define glTextureStorage3DMultisampleEXT                 gl3wTextureStorage3DMultisampleEXT
#define glTextureSubImage1D                              gl3wTextureSubImage1D
#define glTextureSubImage1DEXT                           gl3wTextureSubImage1DEXT
#define glTextureSubImage2D                              gl3wTextureSubImage2D
#define glTextureSubImage2DEXT                           gl3wTextureSubImage2DEXT
#define glTextureSubImage3D                              gl3wTextureSubImage3D
#define glTextureSubImage3DEXT                           gl3wTextureSubImage3DEXT
#define glTextureView                                    gl3wTextureView
#define glTransformFeedbackBufferBase                    gl3wTransformFeedbackBufferBase
#define glTransformFeedbackBufferRange                   gl3wTransformFeedbackBufferRange
#define glTransformFeedbackVaryings                      gl3wTransformFeedbackVaryings
#define glTransformPathNV                                gl3wTransformPathNV
#define glUniform1d                                      gl3wUniform1d
#define glUniform1dv                                     gl3wUniform1dv
#define glUniform1f                                      gl3wUniform1f
#define glUniform1fv                                     gl3wUniform1fv
#define glUniform1i                                      gl3wUniform1i
#define glUniform1i64ARB                                 gl3wUniform1i64ARB
#define glUniform1i64NV                                  gl3wUniform1i64NV
#define glUniform1i64vARB                                gl3wUniform1i64vARB
#define glUniform1i64vNV                                 gl3wUniform1i64vNV
#define glUniform1iv                                     gl3wUniform1iv
#define glUniform1ui                                     gl3wUniform1ui
#define glUniform1ui64ARB                                gl3wUniform1ui64ARB
#define glUniform1ui64NV                                 gl3wUniform1ui64NV
#define glUniform1ui64vARB                               gl3wUniform1ui64vARB
#define glUniform1ui64vNV                                gl3wUniform1ui64vNV
#define glUniform1uiv                                    gl3wUniform1uiv
#define glUniform2d                                      gl3wUniform2d
#define glUniform2dv                                     gl3wUniform2dv
#define glUniform2f                                      gl3wUniform2f
#define glUniform2fv                                     gl3wUniform2fv
#define glUniform2i                                      gl3wUniform2i
#define glUniform2i64ARB                                 gl3wUniform2i64ARB
#define glUniform2i64NV                                  gl3wUniform2i64NV
#define glUniform2i64vARB                                gl3wUniform2i64vARB
#define glUniform2i64vNV                                 gl3wUniform2i64vNV
#define glUniform2iv                                     gl3wUniform2iv
#define glUniform2ui                                     gl3wUniform2ui
#define glUniform2ui64ARB                                gl3wUniform2ui64ARB
#define glUniform2ui64NV                                 gl3wUniform2ui64NV
#define glUniform2ui64vARB                               gl3wUniform2ui64vARB
#define glUniform2ui64vNV                                gl3wUniform2ui64vNV
#define glUniform2uiv                                    gl3wUniform2uiv
#define glUniform3d                                      gl3wUniform3d
#define glUniform3dv                                     gl3wUniform3dv
#define glUniform3f                                      gl3wUniform3f
#define glUniform3fv                                     gl3wUniform3fv
#define glUniform3i                                      gl3wUniform3i
#define glUniform3i64ARB                                 gl3wUniform3i64ARB
#define glUniform3i64NV                                  gl3wUniform3i64NV
#define glUniform3i64vARB                                gl3wUniform3i64vARB
#define glUniform3i64vNV                                 gl3wUniform3i64vNV
#define glUniform3iv                                     gl3wUniform3iv
#define glUniform3ui                                     gl3wUniform3ui
#define glUniform3ui64ARB                                gl3wUniform3ui64ARB
#define glUniform3ui64NV                                 gl3wUniform3ui64NV
#define glUniform3ui64vARB                               gl3wUniform3ui64vARB
#define glUniform3ui64vNV                                gl3wUniform3ui64vNV
#define glUniform3uiv                                    gl3wUniform3uiv
#define glUniform4d                                      gl3wUniform4d
#define glUniform4dv                                     gl3wUniform4dv
#define glUniform4f                                      gl3wUniform4f
#define glUniform4fv                                     gl3wUniform4fv
#define glUniform4i                                      gl3wUniform4i
#define glUniform4i64ARB                                 gl3wUniform4i64ARB
#define glUniform4i64NV                                  gl3wUniform4i64NV
#define glUniform4i64vARB                                gl3wUniform4i64vARB
#define glUniform4i64vNV                                 gl3wUniform4i64vNV
#define glUniform4iv                                     gl3wUniform4iv
#define glUniform4ui                                     gl3wUniform4ui
#define glUniform4ui64ARB                                gl3wUniform4ui64ARB
#define glUniform4ui64NV                                 gl3wUniform4ui64NV
#define glUniform4ui64vARB                               gl3wUniform4ui64vARB
#define glUniform4ui64vNV                                gl3wUniform4ui64vNV
#define glUniform4uiv                                    gl3wUniform4uiv
#define glUniformBlockBinding                            gl3wUniformBlockBinding
#define glUniformHandleui64ARB                           gl3wUniformHandleui64ARB
#define glUniformHandleui64NV                            gl3wUniformHandleui64NV
#define glUniformHandleui64vARB                          gl3wUniformHandleui64vARB
#define glUniformHandleui64vNV                           gl3wUniformHandleui64vNV
#define glUniformMatrix2dv                               gl3wUniformMatrix2dv
#define glUniformMatrix2fv                               gl3wUniformMatrix2fv
#define glUniformMatrix2x3dv                             gl3wUniformMatrix2x3dv
#define glUniformMatrix2x3fv                             gl3wUniformMatrix2x3fv
#define glUniformMatrix2x4dv                             gl3wUniformMatrix2x4dv
#define glUniformMatrix2x4fv                             gl3wUniformMatrix2x4fv
#define glUniformMatrix3dv                               gl3wUniformMatrix3dv
#define glUniformMatrix3fv                               gl3wUniformMatrix3fv
#define glUniformMatrix3x2dv                             gl3wUniformMatrix3x2dv
#define glUniformMatrix3x2fv                             gl3wUniformMatrix3x2fv
#define glUniformMatrix3x4dv                             gl3wUniformMatrix3x4dv
#define glUniformMatrix3x4fv                             gl3wUniformMatrix3x4fv
#define glUniformMatrix4dv                               gl3wUniformMatrix4dv
#define glUniformMatrix4fv                               gl3wUniformMatrix4fv
#define glUniformMatrix4x2dv                             gl3wUniformMatrix4x2dv
#define glUniformMatrix4x2fv                             gl3wUniformMatrix4x2fv
#define glUniformMatrix4x3dv                             gl3wUniformMatrix4x3dv
#define glUniformMatrix4x3fv                             gl3wUniformMatrix4x3fv
#define glUniformSubroutinesuiv                          gl3wUniformSubroutinesuiv
#define glUniformui64NV                                  gl3wUniformui64NV
#define glUniformui64vNV                                 gl3wUniformui64vNV
#define glUnmapBuffer                                    gl3wUnmapBuffer
#define glUnmapNamedBuffer                               gl3wUnmapNamedBuffer
#define glUnmapNamedBufferEXT                            gl3wUnmapNamedBufferEXT
#define glUseProgram                                     gl3wUseProgram
#define glUseProgramStages                               gl3wUseProgramStages
#define glUseShaderProgramEXT                            gl3wUseShaderProgramEXT
#define glValidateProgram                                gl3wValidateProgram
#define glValidateProgramPipeline                        gl3wValidateProgramPipeline
#define glVertexArrayAttribBinding                       gl3wVertexArrayAttribBinding
#define glVertexArrayAttribFormat                        gl3wVertexArrayAttribFormat
#define glVertexArrayAttribIFormat                       gl3wVertexArrayAttribIFormat
#define glVertexArrayAttribLFormat                       gl3wVertexArrayAttribLFormat
#define glVertexArrayBindVertexBufferEXT                 gl3wVertexArrayBindVertexBufferEXT
#define glVertexArrayBindingDivisor                      gl3wVertexArrayBindingDivisor
#define glVertexArrayColorOffsetEXT                      gl3wVertexArrayColorOffsetEXT
#define glVertexArrayEdgeFlagOffsetEXT                   gl3wVertexArrayEdgeFlagOffsetEXT
#define glVertexArrayElementBuffer                       gl3wVertexArrayElementBuffer
#define glVertexArrayFogCoordOffsetEXT                   gl3wVertexArrayFogCoordOffsetEXT
#define glVertexArrayIndexOffsetEXT                      gl3wVertexArrayIndexOffsetEXT
#define glVertexArrayMultiTexCoordOffsetEXT              gl3wVertexArrayMultiTexCoordOffsetEXT
#define glVertexArrayNormalOffsetEXT                     gl3wVertexArrayNormalOffsetEXT
#define glVertexArraySecondaryColorOffsetEXT             gl3wVertexArraySecondaryColorOffsetEXT
#define glVertexArrayTexCoordOffsetEXT                   gl3wVertexArrayTexCoordOffsetEXT
#define glVertexArrayVertexAttribBindingEXT              gl3wVertexArrayVertexAttribBindingEXT
#define glVertexArrayVertexAttribDivisorEXT              gl3wVertexArrayVertexAttribDivisorEXT
#define glVertexArrayVertexAttribFormatEXT               gl3wVertexArrayVertexAttribFormatEXT
#define glVertexArrayVertexAttribIFormatEXT              gl3wVertexArrayVertexAttribIFormatEXT
#define glVertexArrayVertexAttribIOffsetEXT              gl3wVertexArrayVertexAttribIOffsetEXT
#define glVertexArrayVertexAttribLFormatEXT              gl3wVertexArrayVertexAttribLFormatEXT
#define glVertexArrayVertexAttribLOffsetEXT              gl3wVertexArrayVertexAttribLOffsetEXT
#define glVertexArrayVertexAttribOffsetEXT               gl3wVertexArrayVertexAttribOffsetEXT
#define glVertexArrayVertexBindingDivisorEXT             gl3wVertexArrayVertexBindingDivisorEXT
#define glVertexArrayVertexBuffer                        gl3wVertexArrayVertexBuffer
#define glVertexArrayVertexBuffers                       gl3wVertexArrayVertexBuffers
#define glVertexArrayVertexOffsetEXT                     gl3wVertexArrayVertexOffsetEXT
#define glVertexAttrib1d                                 gl3wVertexAttrib1d
#define glVertexAttrib1dv                                gl3wVertexAttrib1dv
#define glVertexAttrib1f                                 gl3wVertexAttrib1f
#define glVertexAttrib1fv                                gl3wVertexAttrib1fv
#define glVertexAttrib1s                                 gl3wVertexAttrib1s
#define glVertexAttrib1sv                                gl3wVertexAttrib1sv
#define glVertexAttrib2d                                 gl3wVertexAttrib2d
#define glVertexAttrib2dv                                gl3wVertexAttrib2dv
#define glVertexAttrib2f                                 gl3wVertexAttrib2f
#define glVertexAttrib2fv                                gl3wVertexAttrib2fv
#define glVertexAttrib2s                                 gl3wVertexAttrib2s
#define glVertexAttrib2sv                                gl3wVertexAttrib2sv
#define glVertexAttrib3d                                 gl3wVertexAttrib3d
#define glVertexAttrib3dv                                gl3wVertexAttrib3dv
#define glVertexAttrib3f                                 gl3wVertexAttrib3f
#define glVertexAttrib3fv                                gl3wVertexAttrib3fv
#define glVertexAttrib3s                                 gl3wVertexAttrib3s
#define glVertexAttrib3sv                                gl3wVertexAttrib3sv
#define glVertexAttrib4Nbv                               gl3wVertexAttrib4Nbv
#define glVertexAttrib4Niv                               gl3wVertexAttrib4Niv
#define glVertexAttrib4Nsv                               gl3wVertexAttrib4Nsv
#define glVertexAttrib4Nub                               gl3wVertexAttrib4Nub
#define glVertexAttrib4Nubv                              gl3wVertexAttrib4Nubv
#define glVertexAttrib4Nuiv                              gl3wVertexAttrib4Nuiv
#define glVertexAttrib4Nusv                              gl3wVertexAttrib4Nusv
#define glVertexAttrib4bv                                gl3wVertexAttrib4bv
#define glVertexAttrib4d                                 gl3wVertexAttrib4d
#define glVertexAttrib4dv                                gl3wVertexAttrib4dv
#define glVertexAttrib4f                                 gl3wVertexAttrib4f
#define glVertexAttrib4fv                                gl3wVertexAttrib4fv
#define glVertexAttrib4iv                                gl3wVertexAttrib4iv
#define glVertexAttrib4s                                 gl3wVertexAttrib4s
#define glVertexAttrib4sv                                gl3wVertexAttrib4sv
#define glVertexAttrib4ubv                               gl3wVertexAttrib4ubv
#define glVertexAttrib4uiv                               gl3wVertexAttrib4uiv
#define glVertexAttrib4usv                               gl3wVertexAttrib4usv
#define glVertexAttribBinding                            gl3wVertexAttribBinding
#define glVertexAttribDivisor                            gl3wVertexAttribDivisor
#define glVertexAttribDivisorARB                         gl3wVertexAttribDivisorARB
#define glVertexAttribFormat                             gl3wVertexAttribFormat
#define glVertexAttribFormatNV                           gl3wVertexAttribFormatNV
#define glVertexAttribI1i                                gl3wVertexAttribI1i
#define glVertexAttribI1iv                               gl3wVertexAttribI1iv
#define glVertexAttribI1ui                               gl3wVertexAttribI1ui
#define glVertexAttribI1uiv                              gl3wVertexAttribI1uiv
#define glVertexAttribI2i                                gl3wVertexAttribI2i
#define glVertexAttribI2iv                               gl3wVertexAttribI2iv
#define glVertexAttribI2ui                               gl3wVertexAttribI2ui
#define glVertexAttribI2uiv                              gl3wVertexAttribI2uiv
#define glVertexAttribI3i                                gl3wVertexAttribI3i
#define glVertexAttribI3iv                               gl3wVertexAttribI3iv
#define glVertexAttribI3ui                               gl3wVertexAttribI3ui
#define glVertexAttribI3uiv                              gl3wVertexAttribI3uiv
#define glVertexAttribI4bv                               gl3wVertexAttribI4bv
#define glVertexAttribI4i                                gl3wVertexAttribI4i
#define glVertexAttribI4iv                               gl3wVertexAttribI4iv
#define glVertexAttribI4sv                               gl3wVertexAttribI4sv
#define glVertexAttribI4ubv                              gl3wVertexAttribI4ubv
#define glVertexAttribI4ui                               gl3wVertexAttribI4ui
#define glVertexAttribI4uiv                              gl3wVertexAttribI4uiv
#define glVertexAttribI4usv                              gl3wVertexAttribI4usv
#define glVertexAttribIFormat                            gl3wVertexAttribIFormat
#define glVertexAttribIFormatNV                          gl3wVertexAttribIFormatNV
#define glVertexAttribIPointer                           gl3wVertexAttribIPointer
#define glVertexAttribL1d                                gl3wVertexAttribL1d
#define glVertexAttribL1dv                               gl3wVertexAttribL1dv
#define glVertexAttribL1i64NV                            gl3wVertexAttribL1i64NV
#define glVertexAttribL1i64vNV                           gl3wVertexAttribL1i64vNV
#define glVertexAttribL1ui64ARB                          gl3wVertexAttribL1ui64ARB
#define glVertexAttribL1ui64NV                           gl3wVertexAttribL1ui64NV
#define glVertexAttribL1ui64vARB                         gl3wVertexAttribL1ui64vARB
#define glVertexAttribL1ui64vNV                          gl3wVertexAttribL1ui64vNV
#define glVertexAttribL2d                                gl3wVertexAttribL2d
#define glVertexAttribL2dv                               gl3wVertexAttribL2dv
#define glVertexAttribL2i64NV                            gl3wVertexAttribL2i64NV
#define glVertexAttribL2i64vNV                           gl3wVertexAttribL2i64vNV
#define glVertexAttribL2ui64NV                           gl3wVertexAttribL2ui64NV
#define glVertexAttribL2ui64vNV                          gl3wVertexAttribL2ui64vNV
#define glVertexAttribL3d                                gl3wVertexAttribL3d
#define glVertexAttribL3dv                               gl3wVertexAttribL3dv
#define glVertexAttribL3i64NV                            gl3wVertexAttribL3i64NV
#define glVertexAttribL3i64vNV                           gl3wVertexAttribL3i64vNV
#define glVertexAttribL3ui64NV                           gl3wVertexAttribL3ui64NV
#define glVertexAttribL3ui64vNV                          gl3wVertexAttribL3ui64vNV
#define glVertexAttribL4d                                gl3wVertexAttribL4d
#define glVertexAttribL4dv                               gl3wVertexAttribL4dv
#define glVertexAttribL4i64NV                            gl3wVertexAttribL4i64NV
#define glVertexAttribL4i64vNV                           gl3wVertexAttribL4i64vNV
#define glVertexAttribL4ui64NV                           gl3wVertexAttribL4ui64NV
#define glVertexAttribL4ui64vNV                          gl3wVertexAttribL4ui64vNV
#define glVertexAttribLFormat                            gl3wVertexAttribLFormat
#define glVertexAttribLFormatNV                          gl3wVertexAttribLFormatNV
#define glVertexAttribLPointer                           gl3wVertexAttribLPointer
#define glVertexAttribP1ui                               gl3wVertexAttribP1ui
#define glVertexAttribP1uiv                              gl3wVertexAttribP1uiv
#define glVertexAttribP2ui                               gl3wVertexAttribP2ui
#define glVertexAttribP2uiv                              gl3wVertexAttribP2uiv
#define glVertexAttribP3ui                               gl3wVertexAttribP3ui
#define glVertexAttribP3uiv                              gl3wVertexAttribP3uiv
#define glVertexAttribP4ui                               gl3wVertexAttribP4ui
#define glVertexAttribP4uiv                              gl3wVertexAttribP4uiv
#define glVertexAttribPointer                            gl3wVertexAttribPointer
#define glVertexBindingDivisor                           gl3wVertexBindingDivisor
#define glVertexFormatNV                                 gl3wVertexFormatNV
#define glViewport                                       gl3wViewport
#define glViewportArrayv                                 gl3wViewportArrayv
#define glViewportIndexedf                               gl3wViewportIndexedf
#define glViewportIndexedfv                              gl3wViewportIndexedfv
#define glViewportPositionWScaleNV                       gl3wViewportPositionWScaleNV
#define glViewportSwizzleNV                              gl3wViewportSwizzleNV
#define glWaitSync                                       gl3wWaitSync
#define glWaitVkSemaphoreNV                              gl3wWaitVkSemaphoreNV
#define glWeightPathsNV                                  gl3wWeightPathsNV
#define glWindowRectanglesEXT                            gl3wWindowRectanglesEXT

#ifdef __cplusplus
}
#endif

#endif
