/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;

public class MultiPolygon
extends GeometryCollection
implements Polygonal {
    private static final long serialVersionUID = -551033529766975875L;

    public MultiPolygon(Polygon[] polygons, PrecisionModel precisionModel, int SRID) {
        this(polygons, new GeometryFactory(precisionModel, SRID));
    }

    public MultiPolygon(Polygon[] polygons, GeometryFactory factory) {
        super(polygons, factory);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public String getGeometryType() {
        return "MultiPolygon";
    }

    @Override
    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString();
        }
        ArrayList<Geometry> allRings = new ArrayList<Geometry>();
        for (int i = 0; i < this.geometries.length; ++i) {
            Polygon polygon = (Polygon)this.geometries[i];
            Geometry rings = polygon.getBoundary();
            for (int j = 0; j < rings.getNumGeometries(); ++j) {
                allRings.add(rings.getGeometryN(j));
            }
        }
        LineString[] allRingsArray = new LineString[allRings.size()];
        return this.getFactory().createMultiLineString(allRings.toArray(allRingsArray));
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        return super.equalsExact(other, tolerance);
    }

    @Override
    public MultiPolygon reverse() {
        return (MultiPolygon)super.reverse();
    }

    @Override
    protected MultiPolygon reverseInternal() {
        Polygon[] polygons = new Polygon[this.geometries.length];
        for (int i = 0; i < polygons.length; ++i) {
            polygons[i] = (Polygon)this.geometries[i].reverse();
        }
        return new MultiPolygon(polygons, this.factory);
    }

    @Override
    protected MultiPolygon copyInternal() {
        Polygon[] polygons = new Polygon[this.geometries.length];
        for (int i = 0; i < polygons.length; ++i) {
            polygons[i] = (Polygon)this.geometries[i].copy();
        }
        return new MultiPolygon(polygons, this.factory);
    }

    @Override
    protected int getTypeCode() {
        return 6;
    }
}

