/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.parser;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.aesh.command.operator.OperatorType;
import org.aesh.parser.ParsedLine;
import org.aesh.parser.ParsedWord;
import org.aesh.parser.ParserStatus;

public class LineParser {
    private static final char NULL_CHAR = '\u0000';
    private static final char SPACE_CHAR = ' ';
    private static final char BACK_SLASH = '\\';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char CURLY_START = '{';
    private static final char CURLY_END = '}';
    private static final char PARENTHESIS_START = '(';
    private static final char PARENTHESIS_END = ')';
    private List<ParsedWord> textList = new ArrayList<ParsedWord>();
    private boolean haveEscape = false;
    private boolean haveSingleQuote = false;
    private boolean haveDoubleQuote = false;
    private boolean ternaryQuote = false;
    private boolean haveCurlyBracket = false;
    private boolean haveSquareBracket = false;
    private StringBuilder builder = new StringBuilder();
    private char prev = '\u0000';
    private int index = 0;
    private int cursorWord = -1;
    private int wordCursor = -1;
    private String text;
    private int cursor = -1;
    private boolean parseBrackets;
    private EnumSet<OperatorType> operators;
    private OperatorType currentOperator;
    private int startIndex;

    public LineParser input(String text) {
        this.text = text;
        return this;
    }

    public LineParser cursor(int cursor) {
        this.cursor = cursor;
        return this;
    }

    public LineParser parseBrackets(boolean doParse) {
        this.parseBrackets = doParse;
        return this;
    }

    public LineParser operators(EnumSet<OperatorType> operators) {
        this.operators = operators;
        return this;
    }

    public ParsedLine parse() {
        if (this.text != null) {
            return this.parseLine(this.text, this.cursor, this.parseBrackets);
        }
        return null;
    }

    public List<ParsedLine> parseWithOperators() {
        if (this.text != null && this.operators != null) {
            return this.parseLine(this.text, this.cursor, this.parseBrackets, this.operators);
        }
        return null;
    }

    public ParsedLine parseLine(String text) {
        return this.parseLine(text, -1);
    }

    public ParsedLine parseLine(String text, int cursor) {
        return this.parseLine(text, cursor, false);
    }

    public ParsedLine parseLine(String text, int cursor, boolean parseCurlyAndSquareBrackets) {
        this.reset();
        if (cursor > text.length()) {
            cursor = text.length();
        }
        return this.doParseLine(text, cursor, parseCurlyAndSquareBrackets);
    }

    private ParsedLine doParseLine(String text, int cursor, boolean parseCurlyAndSquareBrackets) {
        this.index = 0;
        while (this.index < text.length()) {
            char c = text.charAt(this.index);
            if (cursor == this.index && (this.prev != ' ' || this.haveEscape)) {
                this.cursorWord = this.textList.size();
                this.wordCursor = this.haveEscape ? this.builder.length() + 1 : this.builder.length();
            }
            if (c == ' ') {
                c = this.handleSpace(c);
            } else if (c == '\\') {
                if (this.haveEscape || this.ternaryQuote || this.haveDoubleQuote || this.haveSingleQuote) {
                    this.builder.append(c);
                    this.haveEscape = false;
                } else {
                    this.haveEscape = true;
                }
            } else if (c == '\'') {
                this.handleSingleQuote(c);
            } else if (c == '\"') {
                this.handleDoubleQuote(c);
            } else if (parseCurlyAndSquareBrackets && (c == '{' || c == '(')) {
                this.handleCurlyStart(c);
            } else if (parseCurlyAndSquareBrackets && (c == '}' || c == ')') && this.haveCurlyBracket) {
                this.handleCurlyEnd(c);
            } else if (this.haveEscape) {
                this.handleEscape(c);
            } else {
                this.builder.append(c);
            }
            this.prev = c;
            ++this.index;
        }
        return this.endOfLineProcessing(text, cursor, 0, text.length());
    }

    public List<ParsedLine> parseLine(String text, int cursor, boolean parseCurlyAndSquareBrackets, Set<OperatorType> operators) {
        if (operators == null || operators.size() == 0) {
            ArrayList<ParsedLine> lines = new ArrayList<ParsedLine>();
            lines.add(this.parseLine(text, cursor, parseCurlyAndSquareBrackets));
            return lines;
        }
        this.reset();
        this.currentOperator = null;
        this.startIndex = 0;
        return this.doParseLine(text, cursor, parseCurlyAndSquareBrackets, operators);
    }

    private List<ParsedLine> doParseLine(String text, int cursor, boolean parseCurlyAndSquareBrackets, Set<OperatorType> operators) {
        ArrayList<ParsedLine> lines = new ArrayList<ParsedLine>();
        this.index = 0;
        while (this.index < text.length()) {
            char c = text.charAt(this.index);
            if (cursor == this.index && (this.prev != ' ' || this.haveEscape)) {
                this.cursorWord = this.textList.size();
                this.wordCursor = this.builder.length();
            }
            if (c == ' ') {
                c = this.handleSpace(c);
            } else if (c == '\\') {
                if (this.haveEscape || this.ternaryQuote || this.haveDoubleQuote || this.haveSingleQuote) {
                    this.builder.append(c);
                    this.haveEscape = false;
                } else {
                    this.haveEscape = true;
                }
            } else if (c == '\'') {
                this.handleSingleQuote(c);
            } else if (c == '\"') {
                this.handleDoubleQuote(c);
            } else if (parseCurlyAndSquareBrackets && (c == '{' || c == '(')) {
                this.handleCurlyStart(c);
            } else if (parseCurlyAndSquareBrackets && (c == '}' || c == ')') && this.haveCurlyBracket) {
                this.handleCurlyEnd(c);
            } else if (this.haveEscape) {
                if (this.isQuoted() || (this.currentOperator = this.matchesOperators(operators, text, this.index)) == OperatorType.NONE) {
                    this.builder.append('\\');
                }
                this.builder.append(c);
                this.haveEscape = false;
            } else if (!this.haveEscape && !this.isQuoted() && (this.currentOperator = this.matchesOperators(operators, text, this.index)) != OperatorType.NONE) {
                this.handleFoundOperator(lines, text, cursor);
                if (this.index + this.currentOperator.value().length() == text.length() && cursor == text.length()) {
                    this.textList.add(new ParsedWord("", this.index));
                    lines.add(new ParsedLine(text, this.textList, 0, 0, 0, ParserStatus.OK, "", OperatorType.NONE));
                    return lines;
                }
            } else {
                this.builder.append(c);
            }
            if (this.currentOperator != null && this.currentOperator != OperatorType.NONE) {
                this.index += this.currentOperator.value().length();
                this.prev = text.charAt(this.index - 1);
                this.currentOperator = OperatorType.NONE;
                continue;
            }
            this.prev = c;
            ++this.index;
        }
        if (this.builder.length() > 0 || !this.textList.isEmpty() || this.startIndex < this.index) {
            lines.add(this.endOfLineProcessing(text.substring(this.startIndex, this.index), cursor, this.startIndex, text.length()));
        }
        return lines;
    }

    private char nextChar(String text, int index) {
        if (text.length() > index + 1) {
            return text.charAt(index + 1);
        }
        return '\u0000';
    }

    private boolean isQuoted() {
        return this.haveDoubleQuote || this.haveSingleQuote || this.haveCurlyBracket || this.haveSquareBracket;
    }

    private OperatorType matchesOperators(Set<OperatorType> operators, String text, int index) {
        return OperatorType.matches(operators, text, index);
    }

    private ParsedLine endOfLineProcessing(String text, int cursor, int startIndex, int totalTextLength) {
        if (this.haveEscape) {
            this.builder.append('\\');
        }
        if (this.builder.length() > 0) {
            if (this.haveDoubleQuote || this.haveSingleQuote) {
                this.textList.add(new ParsedWord(this.builder.toString(), this.index - this.builder.length(), ParsedWord.Status.OPEN_QUOTE));
            } else if (this.haveSquareBracket || this.haveCurlyBracket) {
                this.textList.add(new ParsedWord(this.builder.toString(), this.index - this.builder.length(), ParsedWord.Status.OPEN_BRACKET));
            } else {
                this.textList.add(new ParsedWord(this.builder.toString(), this.index - this.builder.length()));
            }
        }
        if (cursor == totalTextLength && (this.prev != ' ' || this.haveEscape || this.isQuoted())) {
            this.cursorWord = this.textList.size() - 1;
            if (this.textList.size() > 0) {
                this.wordCursor = this.textList.get(this.textList.size() - 1).word().length();
            }
        }
        ParserStatus status = ParserStatus.OK;
        if (this.haveSingleQuote && this.haveDoubleQuote) {
            status = ParserStatus.DOUBLE_UNCLOSED_QUOTE;
        } else if (this.haveSingleQuote || this.haveDoubleQuote || this.haveCurlyBracket) {
            status = ParserStatus.UNCLOSED_QUOTE;
        }
        return new ParsedLine(text, this.textList, startIndex <= cursor && cursor <= this.index ? cursor - startIndex : -1, this.cursorWord, this.wordCursor, status, "", OperatorType.NONE);
    }

    private void handleCurlyEnd(char c) {
        if (this.haveEscape) {
            this.haveEscape = false;
        } else {
            this.haveCurlyBracket = false;
        }
        this.builder.append(c);
    }

    private void handleCurlyStart(char c) {
        if (this.haveEscape) {
            this.haveEscape = false;
        } else if (!this.haveSingleQuote && !this.haveDoubleQuote) {
            this.haveCurlyBracket = true;
        }
        this.builder.append(c);
    }

    private void handleDoubleQuote(char c) {
        if ((this.ternaryQuote || this.haveDoubleQuote || this.haveSingleQuote) && this.prev == '\\') {
            this.builder.append(c);
            return;
        }
        if (this.haveEscape || this.ternaryQuote && this.prev != '\"') {
            this.builder.append(c);
            this.haveEscape = false;
        } else if (this.haveDoubleQuote) {
            this.handleHaveDoubleQuote();
        } else if (this.haveSingleQuote || this.haveCurlyBracket) {
            this.builder.append(c);
        } else {
            this.haveDoubleQuote = true;
        }
    }

    private void handleHaveDoubleQuote() {
        if (!this.ternaryQuote && this.prev == '\"') {
            this.ternaryQuote = true;
        } else if (this.ternaryQuote && this.prev == '\"') {
            if (this.builder.length() > 0) {
                this.builder.deleteCharAt(this.builder.length() - 1);
                this.textList.add(new ParsedWord(this.builder.toString(), this.index - this.builder.length()));
                this.builder = new StringBuilder();
            }
            this.haveDoubleQuote = false;
            this.ternaryQuote = false;
        } else {
            if (this.builder.length() > 0) {
                this.textList.add(new ParsedWord(this.builder.toString(), this.index - this.builder.length()));
                this.builder = new StringBuilder();
            }
            this.haveDoubleQuote = false;
        }
    }

    private void handleSingleQuote(char c) {
        if ((this.ternaryQuote || this.haveDoubleQuote || this.haveSingleQuote) && this.prev == '\\') {
            this.builder.append(c);
            return;
        }
        if (this.haveEscape || this.ternaryQuote) {
            this.builder.append(c);
            this.haveEscape = false;
        } else if (this.haveSingleQuote) {
            if (this.builder.length() > 0) {
                this.textList.add(new ParsedWord(this.builder.toString(), this.index - this.builder.length()));
                this.builder = new StringBuilder();
            }
            this.haveSingleQuote = false;
        } else if (this.haveDoubleQuote) {
            this.builder.append(c);
        } else if (this.haveCurlyBracket) {
            this.builder.append(c);
        } else {
            this.haveSingleQuote = true;
        }
    }

    private char handleSpace(char c) {
        if (this.haveEscape) {
            this.builder.append(c);
            this.haveEscape = false;
            c = '\u0000';
        } else if (this.haveSingleQuote || this.haveDoubleQuote || this.haveCurlyBracket) {
            this.builder.append(c);
        } else if (this.builder.length() > 0) {
            this.textList.add(new ParsedWord(this.builder.toString(), this.index - this.builder.length()));
            this.builder = new StringBuilder();
        }
        return c;
    }

    private void handleFoundOperator(List<ParsedLine> lines, String text, int cursor) {
        ParserStatus parserStatus = ParserStatus.OK;
        String errorMessage = "";
        if (this.builder.length() > 0) {
            this.textList.add(new ParsedWord(this.builder.toString(), this.index - this.builder.length()));
            this.builder = new StringBuilder();
        } else if (this.textList.size() == 0) {
            if (!this.currentOperator.equals((Object)OperatorType.NONE)) {
                parserStatus = ParserStatus.EMPTY_BEFORE_OPERATOR;
            }
            errorMessage = "aesh: syntax error near unexpected token '" + this.currentOperator.value() + '\'';
        }
        if (cursor == text.length() - 1) {
            this.cursorWord = this.textList.size() - 1;
            if (this.textList.size() > 0) {
                this.wordCursor = this.textList.get(this.textList.size() - 1).word().length();
            }
        }
        lines.add(new ParsedLine(text.substring(this.startIndex, this.index), this.textList, this.startIndex <= cursor && cursor <= this.index ? cursor - this.startIndex : -1, this.cursorWord, this.wordCursor, parserStatus, errorMessage, this.currentOperator));
        this.cursorWord = -1;
        this.wordCursor = -1;
        this.startIndex = this.index + this.currentOperator.value().length();
        this.textList = new ArrayList<ParsedWord>();
    }

    private void handleEscape(char c) {
        this.builder.append('\\');
        this.builder.append(c);
        this.haveEscape = false;
    }

    private void reset() {
        this.textList = new ArrayList<ParsedWord>();
        this.haveEscape = false;
        this.haveSingleQuote = false;
        this.haveDoubleQuote = false;
        this.ternaryQuote = false;
        this.haveCurlyBracket = false;
        this.haveSquareBracket = false;
        this.builder = new StringBuilder();
        this.prev = '\u0000';
        this.index = 0;
        this.cursorWord = -1;
        this.wordCursor = -1;
    }
}

