/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal.commands;

import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.internal.DeviceMonitor;
import shadow.bundletool.com.android.ddmlib.internal.commands.CommandResult;
import shadow.bundletool.com.android.ddmlib.internal.commands.ICommand;

public class DisconnectCommand
implements ICommand {
    public static final String COMMAND = "disconnect";
    private DeviceMonitor myMonitor;

    public DisconnectCommand(DeviceMonitor monitor) {
        this.myMonitor = monitor;
    }

    @Override
    public CommandResult run(String argsString) {
        try {
            if (argsString == null) {
                throw new IllegalArgumentException("Expected arguments got null.");
            }
            String[] params = argsString.split(":");
            if (params.length != 2) {
                throw new IllegalArgumentException("Expected 2 parameters got " + params.length);
            }
            String deviceId = params[0];
            int pid = Integer.parseInt(params[1]);
            for (IDevice device : this.myMonitor.getDevices()) {
                if (!device.getSerialNumber().equals(deviceId)) continue;
                this.myMonitor.disconnectClient(device, pid);
                return new CommandResult();
            }
            Log.w("DisconnectCommand", "No client found for given args (" + argsString + ")");
            return new CommandResult("No client found for " + argsString);
        }
        catch (Exception ex4) {
            Log.e("DisconnectCommand", ex4);
            return new CommandResult("Unknown error: " + ex4.getMessage());
        }
    }
}

