/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.ActiveLineRangeEvent;
import org.fife.ui.rsyntaxtextarea.ActiveLineRangeListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.ExpandedFoldRenderStrategy;
import org.fife.ui.rtextarea.FoldIndicator;
import org.fife.ui.rtextarea.FoldIndicatorIcon;
import org.fife.ui.rtextarea.FoldIndicatorStyle;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.IconRowListener;
import org.fife.ui.rtextarea.LineNumberFormatter;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RDocument;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class Gutter
extends JPanel {
    public static final Color DEFAULT_ACTIVE_LINE_RANGE_COLOR = new Color(51, 153, 255);
    private RTextArea textArea;
    private LineNumberList lineNumberList;
    private Color lineNumberColor;
    private Color currentLineNumberColor;
    private int lineNumberingStartIndex = 1;
    private LineNumberFormatter lineNumberFormatter;
    private Font lineNumberFont;
    private IconRowHeader iconArea;
    private boolean iconRowHeaderInheritsGutterBackground = false;
    private int spacingBetweenLineNumbersAndFoldIndicator;
    private FoldIndicator foldIndicator;
    private boolean armed;
    private transient TextAreaListener listener = new TextAreaListener();

    public Gutter(RTextArea textArea) {
        this.lineNumberColor = LineNumberList.DEFAULT_LINE_NUMBER_COLOR;
        this.lineNumberFont = RTextArea.getDefaultFont();
        this.lineNumberFormatter = LineNumberList.DEFAULT_LINE_NUMBER_FORMATTER;
        this.setTextArea(textArea);
        this.setLayout(new BorderLayout());
        if (this.textArea != null) {
            this.setLineNumbersEnabled(true);
            if (this.textArea instanceof RSyntaxTextArea) {
                RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
                this.setFoldIndicatorEnabled(rsta.isCodeFoldingEnabled());
            }
        }
        this.setBorder(new GutterBorder(0, 0, 0, 1));
        Color bg5 = null;
        if (textArea != null) {
            bg5 = textArea.getBackground();
        }
        this.setBackground(bg5 != null ? bg5 : Color.WHITE);
    }

    public GutterIconInfo addLineTrackingIcon(int line, Icon icon) throws BadLocationException {
        return this.addLineTrackingIcon(line, icon, null);
    }

    public GutterIconInfo addLineTrackingIcon(int line, Icon icon, String tip) throws BadLocationException {
        int offs = this.textArea.getLineStartOffset(line);
        return this.addOffsetTrackingIcon(offs, icon, tip);
    }

    public GutterIconInfo addOffsetTrackingIcon(int offs, Icon icon) throws BadLocationException {
        return this.addOffsetTrackingIcon(offs, icon, null);
    }

    public GutterIconInfo addOffsetTrackingIcon(int offs, Icon icon, String tip) throws BadLocationException {
        return this.iconArea.addOffsetTrackingIcon(offs, icon, tip);
    }

    private void clearActiveLineRange() {
        this.iconArea.clearActiveLineRange();
    }

    public Color getActiveLineRangeColor() {
        return this.iconArea.getActiveLineRangeColor();
    }

    public Color getArmedFoldBackground() {
        return this.foldIndicator.getFoldIconArmedBackground();
    }

    public Icon getBookmarkIcon() {
        return this.iconArea.getBookmarkIcon();
    }

    public GutterIconInfo[] getBookmarks() {
        return this.iconArea.getBookmarks();
    }

    public Color getBorderColor() {
        return ((GutterBorder)this.getBorder()).getColor();
    }

    public Color getCurrentLineNumberColor() {
        return this.currentLineNumberColor;
    }

    public ExpandedFoldRenderStrategy getExpandedFoldRenderStrategy() {
        return this.foldIndicator.getExpandedFoldRenderStrategy();
    }

    public Color getFoldBackground() {
        return this.foldIndicator.getFoldIconBackground();
    }

    public Color getFoldIndicatorArmedForeground() {
        return this.foldIndicator.getArmedForeground();
    }

    public Color getFoldIndicatorForeground() {
        return this.foldIndicator.getForeground();
    }

    public boolean getIconRowHeaderInheritsGutterBackground() {
        return this.iconRowHeaderInheritsGutterBackground;
    }

    public Color getLineNumberColor() {
        return this.lineNumberColor;
    }

    public Font getLineNumberFont() {
        return this.lineNumberFont;
    }

    public int getLineNumberingStartIndex() {
        return this.lineNumberingStartIndex;
    }

    public LineNumberFormatter getLineNumberFormatter() {
        return this.lineNumberFormatter;
    }

    public boolean getLineNumbersEnabled() {
        for (int i15 = 0; i15 < this.getComponentCount(); ++i15) {
            if (this.getComponent(i15) != this.lineNumberList) continue;
            return true;
        }
        return false;
    }

    public boolean getShowCollapsedRegionToolTips() {
        return this.foldIndicator.getShowCollapsedRegionToolTips();
    }

    public int getSpacingBetweenLineNumbersAndFoldIndicator() {
        return this.spacingBetweenLineNumbersAndFoldIndicator;
    }

    public GutterIconInfo[] getTrackingIcons(Point p15) throws BadLocationException {
        int offs = this.textArea.viewToModel(new Point(0, p15.y));
        int line = this.textArea.getLineOfOffset(offs);
        return this.iconArea.getTrackingIcons(line);
    }

    public boolean isArmed() {
        return this.armed;
    }

    public boolean isFoldIndicatorEnabled() {
        for (int i15 = 0; i15 < this.getComponentCount(); ++i15) {
            if (this.getComponent(i15) != this.foldIndicator) continue;
            return true;
        }
        return false;
    }

    public boolean isBookmarkingEnabled() {
        return this.iconArea.isBookmarkingEnabled();
    }

    public boolean isIconRowHeaderEnabled() {
        for (int i15 = 0; i15 < this.getComponentCount(); ++i15) {
            if (this.getComponent(i15) != this.iconArea) continue;
            return true;
        }
        return false;
    }

    public void removeAllTrackingIcons() {
        this.iconArea.removeAllTrackingIcons();
    }

    public void removeTrackingIcon(GutterIconInfo tag) {
        this.iconArea.removeTrackingIcon(tag);
    }

    public void setActiveLineRangeColor(Color color) {
        this.iconArea.setActiveLineRangeColor(color);
    }

    private void setActiveLineRange(int startLine, int endLine) {
        this.iconArea.setActiveLineRange(startLine, endLine);
    }

    void setArmed(boolean armed) {
        if (armed != this.armed) {
            this.armed = armed;
            if (this.foldIndicator != null) {
                this.foldIndicator.gutterArmedUpdate(armed);
            }
        }
    }

    public void setArmedFoldBackground(Color bg5) {
        this.foldIndicator.setFoldIconArmedBackground(bg5);
    }

    public void setBookmarkIcon(Icon icon) {
        this.iconArea.setBookmarkIcon(icon);
    }

    public void setBookmarkingEnabled(boolean enabled) {
        this.iconArea.setBookmarkingEnabled(enabled);
        if (enabled && !this.isIconRowHeaderEnabled()) {
            this.setIconRowHeaderEnabled(true);
        }
    }

    public void setBorderColor(Color color) {
        ((GutterBorder)this.getBorder()).setColor(color);
        this.repaint();
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o15) {
        if (this.getBorder() instanceof GutterBorder) {
            if (o15.isLeftToRight()) {
                ((GutterBorder)this.getBorder()).setEdges(0, 0, 0, 1);
            } else {
                ((GutterBorder)this.getBorder()).setEdges(0, 1, 0, 0);
            }
        }
        super.setComponentOrientation(o15);
    }

    public void setCurrentLineNumberColor(Color color) {
        if (!Objects.equals(color, this.currentLineNumberColor)) {
            this.currentLineNumberColor = color;
            if (this.lineNumberList != null) {
                this.lineNumberList.setCurrentLineNumberColor(color);
            }
        }
    }

    public void setExpandedFoldRenderStrategy(ExpandedFoldRenderStrategy strategy) {
        this.foldIndicator.setExpandedFoldRenderStrategy(strategy);
    }

    public void setFoldIcons(FoldIndicatorIcon collapsedIcon, FoldIndicatorIcon expandedIcon) {
        if (this.foldIndicator != null) {
            this.foldIndicator.setFoldIcons(collapsedIcon, expandedIcon);
        }
    }

    public void setFoldIndicatorEnabled(boolean enabled) {
        if (this.foldIndicator != null) {
            if (enabled) {
                this.add((Component)this.foldIndicator, "After");
            } else {
                this.remove(this.foldIndicator);
            }
            this.revalidate();
        }
    }

    public void setFoldIndicatorStyle(FoldIndicatorStyle style) {
        if (this.foldIndicator != null) {
            this.foldIndicator.setStyle(style);
            this.revalidate();
            this.repaint();
        }
    }

    public void setFoldBackground(Color bg5) {
        if (bg5 == null) {
            bg5 = FoldIndicator.DEFAULT_FOLD_BACKGROUND;
        }
        this.foldIndicator.setFoldIconBackground(bg5);
    }

    public void setFoldIndicatorArmedForeground(Color fg5) {
        if (fg5 == null) {
            fg5 = FoldIndicator.DEFAULT_FOREGROUND;
        }
        this.foldIndicator.setArmedForeground(fg5);
    }

    public void setFoldIndicatorForeground(Color fg5) {
        if (fg5 == null) {
            fg5 = FoldIndicator.DEFAULT_FOREGROUND;
        }
        this.foldIndicator.setForeground(fg5);
    }

    public void setIconRowHeaderEnabled(boolean enabled) {
        if (this.iconArea != null) {
            if (enabled) {
                this.add((Component)this.iconArea, "Before");
            } else {
                this.remove(this.iconArea);
            }
            this.revalidate();
        }
    }

    public void setIconRowHeaderInheritsGutterBackground(boolean inherits) {
        if (inherits != this.iconRowHeaderInheritsGutterBackground) {
            this.iconRowHeaderInheritsGutterBackground = inherits;
            if (this.iconArea != null) {
                this.iconArea.setInheritsGutterBackground(inherits);
            }
        }
    }

    public void setLineNumberColor(Color color) {
        if (color != null && !color.equals(this.lineNumberColor)) {
            this.lineNumberColor = color;
            if (this.lineNumberList != null) {
                this.lineNumberList.setForeground(color);
            }
        }
    }

    public void setLineNumberFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font cannot be null");
        }
        if (!font.equals(this.lineNumberFont)) {
            this.lineNumberFont = font;
            if (this.lineNumberList != null) {
                this.lineNumberList.setFont(font);
            }
        }
    }

    public void setLineNumberingStartIndex(int index) {
        if (index != this.lineNumberingStartIndex) {
            this.lineNumberingStartIndex = index;
            this.lineNumberList.setLineNumberingStartIndex(index);
        }
    }

    public void setLineNumberFormatter(LineNumberFormatter formatter) {
        if (formatter != this.lineNumberFormatter) {
            this.lineNumberFormatter = formatter;
            this.lineNumberList.setLineNumberFormatter(formatter);
        }
    }

    public void setLineNumbersEnabled(boolean enabled) {
        if (this.lineNumberList != null) {
            if (enabled) {
                this.add(this.lineNumberList);
            } else {
                this.remove(this.lineNumberList);
            }
            this.revalidate();
        }
    }

    public void setShowCollapsedRegionToolTips(boolean show) {
        if (this.foldIndicator != null) {
            this.foldIndicator.setShowCollapsedRegionToolTips(show);
        }
    }

    public void setSpacingBetweenLineNumbersAndFoldIndicator(int spacing) {
        if (spacing != this.spacingBetweenLineNumbersAndFoldIndicator) {
            this.spacingBetweenLineNumbersAndFoldIndicator = spacing;
            this.foldIndicator.setAdditionalLeftMargin(spacing);
            this.revalidate();
            this.repaint();
        }
    }

    public void setTextArea(RTextArea textArea) {
        if (this.textArea != null) {
            this.listener.uninstall();
        }
        if (textArea != null) {
            RTextAreaEditorKit kit = (RTextAreaEditorKit)textArea.getUI().getEditorKit(textArea);
            if (this.lineNumberList == null) {
                this.lineNumberList = kit.createLineNumberList(textArea);
                this.lineNumberList.setFont(this.getLineNumberFont());
                this.lineNumberList.setForeground(this.getLineNumberColor());
                this.lineNumberList.setCurrentLineNumberColor(this.getCurrentLineNumberColor());
                this.lineNumberList.setLineNumberingStartIndex(this.getLineNumberingStartIndex());
                this.lineNumberList.setLineNumberFormatter(this.getLineNumberFormatter());
            } else {
                this.lineNumberList.setTextArea(textArea);
            }
            if (this.iconArea == null) {
                this.iconArea = kit.createIconRowHeader(textArea);
                this.iconArea.setInheritsGutterBackground(this.getIconRowHeaderInheritsGutterBackground());
            } else {
                this.iconArea.setTextArea(textArea);
            }
            if (this.foldIndicator == null) {
                this.foldIndicator = new FoldIndicator(textArea);
            } else {
                this.foldIndicator.setTextArea(textArea);
            }
            this.listener.install(textArea);
        }
        this.textArea = textArea;
    }

    public boolean toggleBookmark(int line) throws BadLocationException {
        return this.iconArea.toggleBookmark(line);
    }

    @Override
    public void setBorder(Border border) {
        if (border instanceof GutterBorder) {
            super.setBorder(border);
        }
    }

    public void addIconRowListener(IconRowListener l15) {
        this.iconArea.addIconRowListener(l15);
    }

    public void removeIconRowListener(IconRowListener l15) {
        this.iconArea.removeIconRowListener(l15);
    }

    private final class TextAreaListener
    extends ComponentAdapter
    implements DocumentListener,
    PropertyChangeListener,
    ActiveLineRangeListener {
        private boolean installed;

        private TextAreaListener() {
        }

        @Override
        public void activeLineRangeChanged(ActiveLineRangeEvent e15) {
            if (e15.getMin() == -1) {
                Gutter.this.clearActiveLineRange();
            } else {
                Gutter.this.setActiveLineRange(e15.getMin(), e15.getMax());
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e15) {
        }

        @Override
        public void componentResized(ComponentEvent e15) {
            Gutter.this.revalidate();
        }

        protected void handleDocumentEvent(DocumentEvent e15) {
            for (int i15 = 0; i15 < Gutter.this.getComponentCount(); ++i15) {
                AbstractGutterComponent agc = (AbstractGutterComponent)Gutter.this.getComponent(i15);
                agc.handleDocumentEvent(e15);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e15) {
            this.handleDocumentEvent(e15);
        }

        protected void install(RTextArea textArea) {
            if (this.installed) {
                this.uninstall();
            }
            textArea.addComponentListener(this);
            textArea.getDocument().addDocumentListener(this);
            textArea.addPropertyChangeListener(this);
            if (textArea instanceof RSyntaxTextArea) {
                RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
                rsta.addActiveLineRangeListener(this);
                rsta.getFoldManager().addPropertyChangeListener(this);
            }
            this.installed = true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e15) {
            block6: {
                RDocument newDoc;
                String name;
                block8: {
                    block7: {
                        block5: {
                            name = e15.getPropertyName();
                            if (!"font".equals(name) && !"RSTA.syntaxScheme".equals(name)) break block5;
                            for (int i15 = 0; i15 < Gutter.this.getComponentCount(); ++i15) {
                                AbstractGutterComponent agc = (AbstractGutterComponent)Gutter.this.getComponent(i15);
                                agc.lineHeightsChanged();
                            }
                            break block6;
                        }
                        if (!"RSTA.codeFolding".equals(name)) break block7;
                        boolean foldingEnabled = (Boolean)e15.getNewValue();
                        if (Gutter.this.lineNumberList != null) {
                            Gutter.this.lineNumberList.updateCellWidths();
                        }
                        Gutter.this.setFoldIndicatorEnabled(foldingEnabled);
                        break block6;
                    }
                    if (!"FoldsUpdated".equals(name)) break block8;
                    Gutter.this.repaint();
                    break block6;
                }
                if (!"document".equals(name)) break block6;
                RDocument old = (RDocument)e15.getOldValue();
                if (old != null) {
                    old.removeDocumentListener(this);
                }
                if ((newDoc = (RDocument)e15.getNewValue()) != null) {
                    newDoc.addDocumentListener(this);
                }
                for (int i16 = 0; i16 < Gutter.this.getComponentCount(); ++i16) {
                    AbstractGutterComponent agc = (AbstractGutterComponent)Gutter.this.getComponent(i16);
                    agc.handleDocumentUpdated(old, newDoc);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e15) {
            this.handleDocumentEvent(e15);
        }

        protected void uninstall() {
            if (this.installed) {
                Gutter.this.textArea.removeComponentListener(this);
                Gutter.this.textArea.getDocument().removeDocumentListener(this);
                Gutter.this.textArea.removePropertyChangeListener(this);
                if (Gutter.this.textArea instanceof RSyntaxTextArea) {
                    RSyntaxTextArea rsta = (RSyntaxTextArea)Gutter.this.textArea;
                    rsta.removeActiveLineRangeListener(this);
                    rsta.getFoldManager().removePropertyChangeListener(this);
                }
                this.installed = false;
            }
        }
    }

    public static class GutterBorder
    extends EmptyBorder {
        private Color color = new Color(221, 221, 221);
        private Rectangle visibleRect = new Rectangle();

        public GutterBorder(int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
            this.visibleRect = g15.getClipBounds(this.visibleRect);
            if (this.visibleRect == null) {
                this.visibleRect = ((JComponent)c15).getVisibleRect();
            }
            g15.setColor(this.color);
            if (this.left == 1) {
                g15.drawLine(0, this.visibleRect.y, 0, this.visibleRect.y + this.visibleRect.height);
            } else {
                g15.drawLine(width - 1, this.visibleRect.y, width - 1, this.visibleRect.y + this.visibleRect.height);
            }
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setEdges(int top, int left, int bottom, int right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }
    }
}

