/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import org.fife.ui.rtextarea.FoldIndicator;
import org.fife.ui.rtextarea.FoldIndicatorIcon;

class ChevronFoldIcon
extends FoldIndicatorIcon {
    ChevronFoldIcon(boolean collapsed) {
        super(collapsed);
    }

    private Path2D createPath(double ... points) {
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(points[0], points[1]);
        for (int i15 = 2; i15 < points.length; i15 += 2) {
            ((Path2D)path).lineTo(points[i15], points[i15 + 1]);
        }
        path.closePath();
        return path;
    }

    @Override
    public int getIconHeight() {
        return 11;
    }

    @Override
    public int getIconWidth() {
        return 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c15, Graphics g15, int x15, int y15) {
        FoldIndicator fi4 = (FoldIndicator)c15;
        Color fg5 = c15.getForeground();
        if (this.isArmed() && fi4.getArmedForeground() != null) {
            fg5 = fi4.getArmedForeground();
        }
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        Graphics2D g2d = (Graphics2D)g15.create();
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(fg5);
            g2d.translate(x15, y15);
            if (!this.isCollapsed()) {
                g2d.rotate(Math.toRadians(90.0), (float)width / 2.0f, (float)height / 2.0f);
            }
            g2d.fill(this.createPath(3.0, 1.0, 3.0, 2.5, 6.0, 5.5, 3.0, 8.5, 3.0, 10.0, 4.5, 10.0, 9.0, 5.5, 4.5, 1.0));
        }
        finally {
            g2d.dispose();
        }
    }
}

