/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.function.IOIntConsumer;
import org.apache.commons.io.input.Input;

public abstract class ProxyInputStream
extends FilterInputStream {
    private volatile boolean closed;
    private final IOIntConsumer afterRead;

    protected ProxyInputStream(AbstractBuilder<?, ?> builder) throws IOException {
        this(builder.getInputStream(), builder);
    }

    public ProxyInputStream(InputStream proxy) {
        super(proxy);
        this.afterRead = IOIntConsumer.NOOP;
    }

    protected ProxyInputStream(InputStream proxy, AbstractBuilder<?, ?> builder) {
        super(proxy);
        this.afterRead = builder.getAfterRead() != null ? builder.getAfterRead() : IOIntConsumer.NOOP;
    }

    protected void afterRead(int n15) throws IOException {
        this.afterRead.accept(n15);
    }

    @Override
    public int available() throws IOException {
        if (this.in != null && !this.isClosed()) {
            try {
                return this.in.available();
            }
            catch (IOException e15) {
                this.handleIOException(e15);
            }
        }
        return 0;
    }

    protected void beforeRead(int n15) throws IOException {
    }

    void checkOpen() throws IOException {
        Input.checkOpen(!this.isClosed());
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.in, this::handleIOException);
        this.closed = true;
    }

    protected void handleIOException(IOException e15) throws IOException {
        throw e15;
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (this.in != null) {
            this.in.mark(readLimit);
        }
    }

    @Override
    public boolean markSupported() {
        return this.in != null && this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            this.beforeRead(1);
            int b15 = this.in.read();
            this.afterRead(b15 != -1 ? 1 : -1);
            return b15;
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return -1;
        }
    }

    @Override
    public int read(byte[] b15) throws IOException {
        try {
            this.beforeRead(IOUtils.length(b15));
            int n15 = this.in.read(b15);
            this.afterRead(n15);
            return n15;
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return -1;
        }
    }

    @Override
    public int read(byte[] b15, int off, int len) throws IOException {
        try {
            this.beforeRead(len);
            int n15 = this.in.read(b15, off, len);
            this.afterRead(n15);
            return n15;
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return -1;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.in.reset();
        }
        catch (IOException e15) {
            this.handleIOException(e15);
        }
    }

    public ProxyInputStream setReference(InputStream in4) {
        this.in = in4;
        return this;
    }

    @Override
    public long skip(long n15) throws IOException {
        try {
            return this.in.skip(n15);
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return 0L;
        }
    }

    public InputStream unwrap() {
        return this.in;
    }

    protected static abstract class AbstractBuilder<T, B extends AbstractStreamBuilder<T, B>>
    extends AbstractStreamBuilder<T, B> {
        private IOIntConsumer afterRead;

        protected AbstractBuilder() {
        }

        public IOIntConsumer getAfterRead() {
            return this.afterRead;
        }

        public B setAfterRead(IOIntConsumer afterRead) {
            this.afterRead = afterRead;
            return (B)((AbstractStreamBuilder)this.asThis());
        }
    }
}

