/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.intellij;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingVisitor;

public final class MigrationMapFileReader {
    private MigrationMapFileReader() {
    }

    public static void read(Reader reader, MappingVisitor visitor2) throws IOException {
        MigrationMapFileReader.read(reader, "source", "target", visitor2);
    }

    public static void read(Reader reader, String sourceNs, String targetNs, MappingVisitor visitor2) throws IOException {
        BufferedReader br4 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        MigrationMapFileReader.read(br4, sourceNs, targetNs, visitor2);
    }

    private static void read(BufferedReader reader, String sourceNs, String targetNs, MappingVisitor visitor2) throws IOException {
        try {
            MigrationMapFileReader.read0(reader, sourceNs, targetNs, visitor2);
        }
        catch (XMLStreamException e15) {
            throw new IOException(e15);
        }
    }

    private static void read0(BufferedReader reader, String sourceNs, String targetNs, MappingVisitor visitor2) throws IOException, XMLStreamException {
        CharArrayReader parentReader = null;
        if (visitor2.getFlags().contains((Object)MappingFlag.NEEDS_MULTIPLE_PASSES)) {
            int len;
            char[] buffer = new char[100000];
            int pos = 0;
            while ((len = reader.read(buffer, pos, buffer.length - pos)) >= 0) {
                if ((pos += len) != buffer.length) continue;
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            parentReader = new CharArrayReader(buffer, 0, pos);
            reader = new CustomBufferedReader((Reader)parentReader);
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        while (true) {
            block29: {
                XMLStreamReader xmlReader = factory.createXMLStreamReader(reader);
                boolean visitHeader = visitor2.visitHeader();
                if (visitHeader) {
                    visitor2.visitNamespaces(sourceNs, Collections.singletonList(targetNs));
                }
                if (!visitor2.visitContent()) break block29;
                int depth = 0;
                while (xmlReader.hasNext()) {
                    block30: {
                        int event = xmlReader.next();
                        switch (event) {
                            case 1: {
                                String name = xmlReader.getLocalName();
                                if (depth != (name.equals("migrationMap") ? 0 : 1)) {
                                    throw new IOException("unexpected depth at line " + xmlReader.getLocation().getLineNumber());
                                }
                                ++depth;
                                switch (name) {
                                    case "name": 
                                    case "order": 
                                    case "description": {
                                        if (visitHeader) {
                                            String value = xmlReader.getAttributeValue(null, "value");
                                            if (name.equals("order")) {
                                                name = "migrationmap:order";
                                            }
                                            if (name.equals("name") && value.equals("Unnamed migration map")) break;
                                            visitor2.visitMetadata(name, value);
                                            break;
                                        }
                                        break block30;
                                    }
                                    case "entry": {
                                        String type = xmlReader.getAttributeValue(null, "type");
                                        if (type == null || type.isEmpty()) {
                                            throw new IOException("missing/empty type attribute at line " + xmlReader.getLocation().getLineNumber());
                                        }
                                        if (type.equals("package")) break;
                                        if (!type.equals("class")) {
                                            throw new IOException("unexpected entry type " + type + " at line " + xmlReader.getLocation().getLineNumber());
                                        }
                                        String srcName = xmlReader.getAttributeValue(null, "oldName");
                                        String dstName = xmlReader.getAttributeValue(null, "newName");
                                        if (srcName == null || srcName.isEmpty()) {
                                            throw new IOException("missing/empty oldName attribute at line " + xmlReader.getLocation().getLineNumber());
                                        }
                                        if (dstName == null || dstName.isEmpty()) {
                                            throw new IOException("missing/empty newName attribute at line " + xmlReader.getLocation().getLineNumber());
                                        }
                                        srcName = srcName.replace('.', '/');
                                        dstName = dstName.replace('.', '/');
                                        if (visitor2.visitClass(srcName)) {
                                            visitor2.visitDstName(MappedElementKind.CLASS, 0, dstName);
                                            visitor2.visitElementContent(MappedElementKind.CLASS);
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break;
                            }
                            case 2: {
                                --depth;
                            }
                        }
                    }
                }
            }
            if (visitor2.visitEnd()) {
                if (parentReader == null) break;
                ((CustomBufferedReader)reader).forceClose();
                break;
            }
            if (parentReader == null) {
                throw new IllegalStateException("repeated visitation requested without NEEDS_MULTIPLE_PASSES");
            }
            parentReader.reset();
            reader = new CustomBufferedReader((Reader)parentReader);
        }
    }

    private static class CustomBufferedReader
    extends BufferedReader {
        private CustomBufferedReader(Reader in4) {
            super(in4);
        }

        public void forceClose() throws IOException {
            super.close();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

