/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.javaconvert;

import com.android.dx.command.dexer.DxContext;
import com.android.dx.command.dexer.Main;
import java.io.ByteArrayOutputStream;
import java.nio.file.Path;

public class DxConverter {
    private static final String CHARSET_NAME = "UTF-8";

    public static void run(Path path, Path tempDirectory) {
        String dxErrors;
        int result;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             ByteArrayOutputStream errOut = new ByteArrayOutputStream();){
            DxContext context = new DxContext(out, errOut);
            DxArgs args = new DxArgs(context, tempDirectory.toAbsolutePath().toString(), new String[]{path.toAbsolutePath().toString()});
            result = new Main(context).runDx(args);
            dxErrors = errOut.toString(CHARSET_NAME);
        }
        catch (Exception e15) {
            throw new RuntimeException("dx exception: " + e15.getMessage(), e15);
        }
        if (result != 0) {
            throw new RuntimeException("Java to dex conversion error, code: " + result + ", errors: " + dxErrors);
        }
    }

    private static class DxArgs
    extends Main.Arguments {
        public DxArgs(DxContext context, String dexDir, String[] input) {
            super(context);
            this.outName = dexDir;
            this.fileNames = input;
            this.jarOutput = false;
            this.multiDex = true;
            this.optimize = true;
            this.localInfo = true;
            this.coreLibrary = true;
            this.debug = true;
            this.warnings = true;
            this.minSdkVersion = 28;
        }
    }
}

