/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.panel;

import jadx.gui.device.debugger.LogcatController;
import jadx.gui.device.protocol.ADB;
import jadx.gui.device.protocol.ADBDevice;
import jadx.gui.ui.panel.JDebuggerPanel;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.NodeLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogcatPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(LogcatPanel.class);
    StyleContext sc = StyleContext.getDefaultStyleContext();
    private final AttributeSet defaultAset = this.sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.decode("#6c71c4"));
    private final AttributeSet verboseAset = this.sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.decode("#2aa198"));
    private final AttributeSet debugAset = this.sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.decode("#859900"));
    private final AttributeSet infoAset = this.sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.decode("#586e75"));
    private final AttributeSet warningAset = this.sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.decode("#b58900"));
    private final AttributeSet errorAset = this.sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.decode("#dc322f"));
    private final AttributeSet fatalAset = this.sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.decode("#d33682"));
    private final AttributeSet silentAset = this.sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.decode("#002b36"));
    private static final ImageIcon ICON_PAUSE = UiUtils.openSvgIcon("debugger/threadFrozen");
    private static final ImageIcon ICON_RUN = UiUtils.openSvgIcon("debugger/execute");
    private static final ImageIcon CLEAR_LOGCAT = UiUtils.openSvgIcon("debugger/trash");
    private transient JTextPane logcatPane;
    private final transient JDebuggerPanel debugPanel;
    private LogcatController logcatController;
    private boolean ready = false;
    private List<ADB.Process> procs;
    private List<Integer> pids;
    private JScrollPane logcatScroll;
    private int pid;
    private final AbstractAction pauseButton = new AbstractAction(NLS.str("logcat.pause"), ICON_PAUSE){

        @Override
        public void actionPerformed(ActionEvent e15) {
            LogcatPanel.this.toggleLogcat();
        }
    };
    private final AbstractAction clearButton = new AbstractAction(NLS.str("logcat.clear"), CLEAR_LOGCAT){

        @Override
        public void actionPerformed(ActionEvent e15) {
            LogcatPanel.this.clearLogcat();
        }
    };

    public LogcatPanel(JDebuggerPanel debugPanel) {
        this.debugPanel = debugPanel;
    }

    public boolean showLogcat() {
        this.removeAll();
        ArrayList<String> pkgs = new ArrayList<String>();
        this.pids = new ArrayList<Integer>();
        for (ADB.Process proc : this.procs.subList(1, this.procs.size())) {
            pkgs.add(String.format("[pid: %-6s] %s", proc.pid, proc.name));
            this.pids.add(Integer.valueOf(proc.pid));
        }
        String[] msgTypes = new String[]{NLS.str("logcat.default"), NLS.str("logcat.verbose"), NLS.str("logcat.debug"), NLS.str("logcat.info"), NLS.str("logcat.warn"), NLS.str("logcat.error"), NLS.str("logcat.fatal"), NLS.str("logcat.silent")};
        Integer[] msgIndex = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.setLayout(new BorderLayout());
        this.logcatPane = new JTextPane();
        this.logcatPane.setEditable(false);
        this.logcatScroll = new JScrollPane(this.logcatPane);
        JToolBar menuPanel = new JToolBar();
        CheckCombo procObj = new CheckCombo(NLS.str("logcat.process"), 1, this.pids.toArray(new Integer[0]), pkgs.toArray(new String[0]));
        JPanel procBox = procObj.getContent();
        procObj.selectAllBut(this.pids.indexOf(this.pid));
        JPanel msgTypeBox = new CheckCombo(NLS.str("logcat.level"), 2, msgIndex, msgTypes).getContent();
        menuPanel.add(procBox);
        menuPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        menuPanel.add(msgTypeBox);
        menuPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        menuPanel.add(this.pauseButton);
        menuPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        menuPanel.add(this.clearButton);
        this.add((Component)menuPanel, "North");
        this.add((Component)this.logcatScroll, "Center");
        return true;
    }

    public boolean clearLogcatArea() {
        this.logcatPane.setText("");
        return true;
    }

    public boolean init(ADBDevice device, String pid) {
        this.pid = Integer.parseInt(pid);
        try {
            this.logcatController = new LogcatController(this, device);
            this.procs = device.getProcessList();
            if (!this.showLogcat()) {
                this.debugPanel.log(NLS.str("logcat.error_fail_start"));
            }
        }
        catch (Exception e15) {
            this.ready = false;
            LOG.error("Failed to start logcat", e15);
            return false;
        }
        this.ready = true;
        return true;
    }

    private void toggleLogcat() {
        if (Objects.equals(this.logcatController.getStatus(), "running")) {
            this.logcatController.stopLogcat();
            this.pauseButton.putValue("SmallIcon", ICON_RUN);
            this.pauseButton.putValue("Name", NLS.str("logcat.start"));
        } else if (Objects.equals(this.logcatController.getStatus(), "stopped")) {
            this.logcatController.startLogcat();
            this.pauseButton.putValue("SmallIcon", ICON_PAUSE);
            this.pauseButton.putValue("Name", NLS.str("logcat.pause"));
        }
    }

    private void clearLogcat() {
        boolean running = false;
        if (Objects.equals(this.logcatController.getStatus(), "running")) {
            this.logcatController.stopLogcat();
            running = true;
        }
        this.logcatController.clearLogcat();
        this.clearLogcatArea();
        this.debugPanel.log(this.logcatController.getStatus());
        if (running) {
            this.logcatController.startLogcat();
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    private boolean isAtBottom(JScrollBar scrollbar) {
        BoundedRangeModel model = scrollbar.getModel();
        return model.getExtent() + model.getValue() == model.getMaximum();
    }

    public void log(LogcatController.LogcatInfo logcatInfo) {
        boolean atBottom = false;
        int len = this.logcatPane.getDocument().getLength();
        JScrollBar scrollbar = this.logcatScroll.getVerticalScrollBar();
        if (this.isAtBottom(scrollbar)) {
            atBottom = true;
        }
        StringBuilder sb5 = new StringBuilder();
        sb5.append(" > ").append(logcatInfo.getTimestamp()).append(" [pid: ").append(logcatInfo.getPid()).append("] ").append(logcatInfo.getMsgTypeString()).append(": ").append(logcatInfo.getMsg()).append("\n");
        try {
            switch (logcatInfo.getMsgType()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.logcatPane.getDocument().insertString(len, sb5.toString(), this.defaultAset);
                    break;
                }
                case 2: {
                    this.logcatPane.getDocument().insertString(len, sb5.toString(), this.verboseAset);
                    break;
                }
                case 3: {
                    this.logcatPane.getDocument().insertString(len, sb5.toString(), this.debugAset);
                    break;
                }
                case 4: {
                    this.logcatPane.getDocument().insertString(len, sb5.toString(), this.infoAset);
                    break;
                }
                case 5: {
                    this.logcatPane.getDocument().insertString(len, sb5.toString(), this.warningAset);
                    break;
                }
                case 6: {
                    this.logcatPane.getDocument().insertString(len, sb5.toString(), this.errorAset);
                    break;
                }
                case 7: {
                    this.logcatPane.getDocument().insertString(len, sb5.toString(), this.fatalAset);
                    break;
                }
                case 8: {
                    this.logcatPane.getDocument().insertString(len, sb5.toString(), this.silentAset);
                    break;
                }
                default: {
                    this.logcatPane.getDocument().insertString(len, sb5.toString(), null);
                    break;
                }
            }
        }
        catch (Exception e15) {
            LOG.error("Failed to write logcat message", e15);
        }
        if (atBottom) {
            EventQueue.invokeLater(() -> scrollbar.setValue(scrollbar.getMaximum()));
        }
    }

    public void exit() {
        this.logcatController.exit();
        this.clearLogcatArea();
        this.logcatController.clearEvents();
    }

    class CheckCombo
    implements ActionListener {
        private final String[] ids;
        private final int type;
        private final String label;
        private final Integer[] index;
        private JComboBox<CheckComboStore> combo;

        public CheckCombo(String label, int type, Integer[] index, String[] ids) {
            this.ids = ids;
            this.type = type;
            this.label = label;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            JComboBox cb5 = (JComboBox)e15.getSource();
            CheckComboStore store = (CheckComboStore)cb5.getSelectedItem();
            CheckComboRenderer ccr = (CheckComboRenderer)cb5.getRenderer();
            store.state = store.state == false;
            ccr.checkBox.setSelected(store.state);
            switch (this.type) {
                case 1: {
                    LogcatPanel.this.logcatController.getFilter().togglePid(store.index, store.state);
                    LogcatPanel.this.logcatController.reload();
                    break;
                }
                case 2: {
                    LogcatPanel.this.logcatController.getFilter().toggleMsgType((byte)store.index, store.state);
                    LogcatPanel.this.logcatController.reload();
                    break;
                }
                default: {
                    LOG.error("Invalid Logcat Filter Type");
                }
            }
        }

        public JPanel getContent() {
            NodeLabel label = NodeLabel.noHtml(this.label + ": ");
            CheckComboStore[] stores = new CheckComboStore[this.ids.length];
            for (int j15 = 0; j15 < this.ids.length; ++j15) {
                stores[j15] = new CheckComboStore(this.index[j15], this.ids[j15], Boolean.TRUE);
            }
            this.combo = new JComboBox<CheckComboStore>(stores);
            this.combo.setRenderer(new CheckComboRenderer());
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c15 = new GridBagConstraints();
            c15.weightx = 0.0;
            c15.gridwidth = 1;
            c15.insets = new Insets(0, 1, 0, 1);
            panel.add((Component)label, c15);
            c15.weightx = 1.0;
            c15.gridwidth = 0;
            c15.anchor = 17;
            c15.insets = new Insets(0, 1, 0, 1);
            panel.add(this.combo, c15);
            this.combo.addActionListener(this);
            this.combo.addMouseListener(new FilterClickListener(this));
            return panel;
        }

        public void toggleAll(boolean checked) {
            block4: for (int i15 = 0; i15 < this.combo.getItemCount(); ++i15) {
                CheckComboStore ccs = this.combo.getItemAt(i15);
                ccs.state = checked;
                switch (this.type) {
                    case 1: {
                        LogcatPanel.this.logcatController.getFilter().togglePid(ccs.index, checked);
                        continue block4;
                    }
                    case 2: {
                        LogcatPanel.this.logcatController.getFilter().toggleMsgType((byte)ccs.index, checked);
                        continue block4;
                    }
                    default: {
                        LOG.error("Invalid Logcat Toggle Filter Encountered");
                    }
                }
            }
            LogcatPanel.this.logcatController.reload();
        }

        public void selectAllBut(int ind) {
            block4: for (int i15 = 0; i15 < this.combo.getItemCount(); ++i15) {
                CheckComboStore ccs = this.combo.getItemAt(i15);
                ccs.state = i15 != ind ? Boolean.valueOf(false) : Boolean.valueOf(true);
                switch (this.type) {
                    case 1: {
                        LogcatPanel.this.logcatController.getFilter().togglePid(ccs.index, ccs.state);
                        continue block4;
                    }
                    case 2: {
                        LogcatPanel.this.logcatController.getFilter().toggleMsgType((byte)ccs.index, ccs.state);
                        continue block4;
                    }
                    default: {
                        LOG.error("Invalid Logcat selectAllBut filter encountered");
                    }
                }
            }
            LogcatPanel.this.logcatController.reload();
        }
    }

    class FilterPopup
    extends JPopupMenu {
        CheckCombo combo;
        JMenuItem selectAll;
        JMenuItem unselectAll;
        JMenuItem selectAttached;

        public FilterPopup(CheckCombo combo) {
            this.combo = combo;
            this.selectAll = new JMenuItem(NLS.str("logcat.select_all"));
            this.selectAll.addActionListener(actionEvent -> combo.toggleAll(true));
            this.unselectAll = new JMenuItem(NLS.str("logcat.unselect_all"));
            this.unselectAll.addActionListener(actionEvent -> combo.toggleAll(false));
            if (combo.type == 1) {
                this.selectAttached = new JMenuItem(NLS.str("logcat.select_attached"));
                this.selectAttached.addActionListener(actionEvent -> combo.selectAllBut(LogcatPanel.this.pids.indexOf(LogcatPanel.this.pid)));
                this.add(this.selectAttached);
            }
            this.add(this.selectAll);
            this.add(this.unselectAll);
        }
    }

    class FilterClickListener
    extends MouseAdapter {
        CheckCombo combo;

        public FilterClickListener(CheckCombo combo) {
            this.combo = combo;
        }

        @Override
        public void mousePressed(MouseEvent e15) {
            if (e15.isPopupTrigger()) {
                this.doPop(e15);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e15) {
            if (e15.isPopupTrigger()) {
                this.doPop(e15);
            }
        }

        private void doPop(MouseEvent e15) {
            FilterPopup menu = new FilterPopup(this.combo);
            menu.show(e15.getComponent(), e15.getX(), e15.getY());
        }
    }

    static class CheckComboStore {
        String id;
        Boolean state;
        int index;

        public CheckComboStore(int index, String id5, Boolean state) {
            this.id = id5;
            this.state = state;
            this.index = index;
        }
    }

    private static class CheckComboRenderer
    implements ListCellRenderer {
        private final JCheckBox checkBox = new JCheckBox();

        private CheckComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CheckComboStore store = (CheckComboStore)value;
            this.checkBox.setText(store.id);
            this.checkBox.setSelected(store.state);
            return this.checkBox;
        }
    }
}

