/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.utils.GsonUtils;
import jadx.gui.device.debugger.DbgUtils;
import jadx.gui.device.debugger.DebugController;
import jadx.gui.device.debugger.smali.Smali;
import jadx.gui.treemodel.JClass;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreakpointManager {
    private static final Logger LOG = LoggerFactory.getLogger(BreakpointManager.class);
    private static final Gson GSON = GsonUtils.buildGson();
    private static final Type TYPE_TOKEN = new TypeToken<Map<String, List<FileBreakpoint>>>(){}.getType();
    @NotNull
    private static Map<String, List<FileBreakpoint>> bpm = Collections.emptyMap();
    @Nullable
    private static Path savePath;
    private static DebugController debugController;
    private static Map<String, Map.Entry<ClassNode, Listener>> listeners;

    public static void saveAndExit() {
        BreakpointManager.sync();
        bpm = Collections.emptyMap();
        savePath = null;
        listeners = Collections.emptyMap();
    }

    public static void init(@Nullable Path baseDir) {
        Path saveDir = baseDir != null ? baseDir : Paths.get(".", new String[0]);
        savePath = saveDir.resolve("breakpoints.json");
        if (Files.exists(savePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(savePath, StandardCharsets.UTF_8);){
                bpm = (Map)GSON.fromJson((Reader)reader, TYPE_TOKEN);
            }
            catch (Exception e15) {
                LOG.error("Failed to read breakpoints config: {}", (Object)savePath, (Object)e15);
            }
        }
    }

    public static void addListener(JClass topCls, Listener listener) {
        if (listeners.isEmpty()) {
            listeners = new HashMap<String, Map.Entry<ClassNode, Listener>>();
        }
        listeners.put(DbgUtils.getRawFullName(topCls), new AbstractMap.SimpleEntry<ClassNode, Listener>(topCls.getCls().getClassNode(), listener));
    }

    public static void removeListener(JClass topCls) {
        listeners.remove(DbgUtils.getRawFullName(topCls));
    }

    public static List<Integer> getPositions(JClass topCls) {
        Smali smali;
        List<FileBreakpoint> bps = bpm.get(DbgUtils.getRawFullName(topCls));
        if (bps != null && bps.size() > 0 && (smali = DbgUtils.getSmali(topCls.getCls().getClassNode())) != null) {
            ArrayList<Integer> posList = new ArrayList<Integer>(bps.size());
            for (FileBreakpoint bp4 : bps) {
                int pos = smali.getInsnPosByCodeOffset(bp4.getFullMthRawID(), bp4.codeOffset);
                if (pos <= -1) continue;
                posList.add(pos);
            }
            return posList;
        }
        return Collections.emptyList();
    }

    public static boolean set(JClass topCls, int line) {
        Map.Entry<String, Integer> lineInfo = DbgUtils.getCodeOffsetInfoByLine(topCls, line);
        if (lineInfo != null) {
            String[] sigs;
            if (bpm.isEmpty()) {
                bpm = new HashMap<String, List<FileBreakpoint>>();
            }
            String name = DbgUtils.getRawFullName(topCls);
            List list2 = bpm.computeIfAbsent(name, k15 -> new ArrayList());
            FileBreakpoint bkp = list2.stream().filter(bp4 -> bp4.codeOffset == (long)((Integer)lineInfo.getValue()).intValue() && bp4.getFullMthRawID().equals(lineInfo.getKey())).findFirst().orElse(null);
            boolean ok4 = true;
            if (bkp == null && (sigs = DbgUtils.sepClassAndMthSig(lineInfo.getKey())) != null && sigs.length == 2) {
                FileBreakpoint bp5 = new FileBreakpoint(sigs[0], sigs[1], lineInfo.getValue().intValue());
                list2.add(bp5);
                if (debugController != null) {
                    ok4 = debugController.setBreakpoint(bp5);
                }
            }
            return ok4;
        }
        return false;
    }

    public static boolean remove(JClass topCls, int line) {
        Map.Entry<String, Integer> lineInfo = DbgUtils.getCodeOffsetInfoByLine(topCls, line);
        if (lineInfo != null) {
            List<FileBreakpoint> bps = bpm.get(DbgUtils.getRawFullName(topCls));
            Iterator<FileBreakpoint> it = bps.iterator();
            while (it.hasNext()) {
                FileBreakpoint bp4 = it.next();
                if (bp4.codeOffset != (long)lineInfo.getValue().intValue() || !bp4.getFullMthRawID().equals(lineInfo.getKey())) continue;
                it.remove();
                if (debugController == null) break;
                return debugController.removeBreakpoint(bp4);
            }
        }
        return true;
    }

    private static void sync() {
        if (savePath == null) {
            return;
        }
        if (bpm.isEmpty() && !Files.exists(savePath, new LinkOption[0])) {
            return;
        }
        try {
            Files.write(savePath, GSON.toJson(bpm).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e15) {
            LOG.error("Failed to write breakpoints config: {}", (Object)savePath, (Object)e15);
        }
    }

    protected static List<FileBreakpoint> getAllBreakpoints() {
        ArrayList<FileBreakpoint> bpList = new ArrayList<FileBreakpoint>();
        for (Map.Entry<String, List<FileBreakpoint>> entry : bpm.entrySet()) {
            bpList.addAll((Collection<FileBreakpoint>)entry.getValue());
        }
        return bpList;
    }

    protected static void failBreakpoint(FileBreakpoint bp4) {
        Map.Entry<ClassNode, Listener> entry = listeners.get(bp4.cls);
        if (entry != null) {
            int pos = DbgUtils.getSmali(entry.getKey()).getInsnPosByCodeOffset(bp4.getFullMthRawID(), bp4.codeOffset);
            pos = Math.max(0, pos);
            entry.getValue().breakpointDisabled(pos);
        }
    }

    protected static void setDebugController(DebugController controller) {
        debugController = controller;
    }

    static {
        listeners = Collections.emptyMap();
    }

    protected static class FileBreakpoint {
        public String cls;
        public String mth;
        public long codeOffset;

        public FileBreakpoint() {
        }

        private FileBreakpoint(String cls, String mth, long codeOffset) {
            this.cls = cls;
            this.mth = mth;
            this.codeOffset = codeOffset;
        }

        protected String getFullMthRawID() {
            return this.cls + "." + this.mth;
        }

        public int hashCode() {
            return Objects.hash(this.codeOffset, this.cls, this.mth);
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileBreakpoint) {
                if (obj == this) {
                    return true;
                }
                FileBreakpoint fbp = (FileBreakpoint)obj;
                return fbp.codeOffset == this.codeOffset && fbp.cls.equals(this.cls) && fbp.mth.equals(this.mth);
            }
            return false;
        }
    }

    public static interface Listener {
        public void breakpointDisabled(int var1);
    }
}

