/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.deobf.NameMapper;

class ResNameUtils {
    private ResNameUtils() {
    }

    static String sanitizeAsResourceName(String name, String postfix, boolean allowNonPrintable) {
        if (name.isEmpty()) {
            return postfix;
        }
        StringBuilder sb5 = new StringBuilder(name.length() + 1);
        boolean nameChanged = false;
        int cp4 = name.codePointAt(0);
        if (ResNameUtils.isValidResourceNameStart(cp4, allowNonPrintable)) {
            sb5.appendCodePoint(cp4);
        } else {
            sb5.append('_');
            nameChanged = true;
            if (ResNameUtils.isValidResourceNamePart(cp4, allowNonPrintable)) {
                sb5.appendCodePoint(cp4);
            }
        }
        for (int i15 = Character.charCount(cp4); i15 < name.length(); i15 += Character.charCount(cp4)) {
            cp4 = name.codePointAt(i15);
            if (ResNameUtils.isValidResourceNamePart(cp4, allowNonPrintable)) {
                sb5.appendCodePoint(cp4);
                continue;
            }
            sb5.append('_');
            nameChanged = true;
        }
        String sanitizedName = sb5.toString();
        if (NameMapper.isReserved(sanitizedName)) {
            nameChanged = true;
        }
        return nameChanged ? sanitizedName + postfix : sanitizedName;
    }

    static String convertToRFieldName(String resourceName) {
        return resourceName.replace('.', '_');
    }

    private static boolean isValidResourceNameStart(int codePoint, boolean allowNonPrintable) {
        return (allowNonPrintable || NameMapper.isPrintableAsciiCodePoint(codePoint)) && ResNameUtils.isValidAapt2ResourceNameStart(codePoint) && NameMapper.isValidIdentifierStart(codePoint);
    }

    private static boolean isValidResourceNamePart(int codePoint, boolean allowNonPrintable) {
        return (allowNonPrintable || NameMapper.isPrintableAsciiCodePoint(codePoint)) && (ResNameUtils.isValidAapt2ResourceNamePart(codePoint) && NameMapper.isValidIdentifierPart(codePoint) || codePoint == 46);
    }

    private static boolean isValidAapt2ResourceNameStart(int codePoint) {
        return ResNameUtils.isXidStart(codePoint) || codePoint == 95;
    }

    private static boolean isValidAapt2ResourceNamePart(int codePoint) {
        return ResNameUtils.isXidContinue(codePoint) || codePoint == 46 || codePoint == 45;
    }

    private static boolean isXidStart(int codePoint) {
        return codePoint < 880 && Character.isUnicodeIdentifierStart(codePoint);
    }

    private static boolean isXidContinue(int codePoint) {
        return codePoint < 880 && Character.isUnicodeIdentifierPart(codePoint) && !Character.isIdentifierIgnorable(codePoint);
    }
}

