/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.ICodeWriter;
import jadx.api.JadxDecompiler;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.utils.ImmutableList;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final String JADX_API_PACKAGE = JadxDecompiler.class.getPackage().getName();
    private static final String STACKTRACE_STOP_CLS_NAME = DepthTraversal.class.getName();

    private Utils() {
    }

    public static String cleanObjectName(String obj) {
        int last;
        if (obj.charAt(0) == 'L' && obj.charAt(last = obj.length() - 1) == ';') {
            return obj.substring(1, last).replace('/', '.');
        }
        return obj;
    }

    public static String cutObject(String obj) {
        if (obj.charAt(0) == 'L') {
            return obj.substring(1, obj.length() - 1);
        }
        return obj;
    }

    public static String makeQualifiedObjectName(String obj) {
        return "L" + obj.replace('.', '/') + ";";
    }

    public static String strRepeat(String str, int count) {
        if (count < 1) {
            return "";
        }
        if (count == 1) {
            return str;
        }
        StringBuilder sb5 = new StringBuilder(str.length() * count);
        for (int i15 = 0; i15 < count; ++i15) {
            sb5.append(str);
        }
        return sb5.toString();
    }

    public static String listToString(Iterable<?> objects) {
        return Utils.listToString(objects, ", ");
    }

    public static String listToString(Iterable<?> objects, String joiner) {
        if (objects == null) {
            return "";
        }
        return Utils.listToString(objects, joiner, Objects::toString);
    }

    public static <T> String listToString(Iterable<T> objects, Function<T, String> toStr) {
        return Utils.listToString(objects, ", ", toStr);
    }

    public static <T> String listToString(Iterable<T> objects, String joiner, Function<T, String> toStr) {
        StringBuilder sb5 = new StringBuilder();
        Utils.listToString(sb5, objects, joiner, toStr);
        return sb5.toString();
    }

    public static <T> void listToString(StringBuilder sb5, Iterable<T> objects, String joiner) {
        Utils.listToString(sb5, objects, joiner, Objects::toString);
    }

    public static <T> void listToString(StringBuilder sb5, Iterable<T> objects, String joiner, Function<T, String> toStr) {
        if (objects == null) {
            return;
        }
        Iterator<T> it = objects.iterator();
        if (it.hasNext()) {
            sb5.append(toStr.apply(it.next()));
        }
        while (it.hasNext()) {
            sb5.append(joiner).append(toStr.apply(it.next()));
        }
    }

    public static <T> String arrayToStr(T[] arr) {
        int len;
        int n15 = len = arr == null ? 0 : arr.length;
        if (len == 0) {
            return "";
        }
        StringBuilder sb5 = new StringBuilder();
        sb5.append(arr[0]);
        for (int i15 = 1; i15 < len; ++i15) {
            sb5.append(", ").append(arr[i15]);
        }
        return sb5.toString();
    }

    public static String concatStrings(List<String> list2) {
        if (Utils.isEmpty(list2)) {
            return "";
        }
        if (list2.size() == 1) {
            return list2.get(0);
        }
        StringBuilder sb5 = new StringBuilder();
        list2.forEach(sb5::append);
        return sb5.toString();
    }

    public static String currentStackTrace() {
        return Utils.getStackTrace(new Exception());
    }

    public static String currentStackTrace(int skipFrames) {
        Exception e15 = new Exception();
        StackTraceElement[] stackTrace = e15.getStackTrace();
        int len = stackTrace.length;
        if (skipFrames < len) {
            e15.setStackTrace(Arrays.copyOfRange(stackTrace, skipFrames, len));
        }
        return Utils.getStackTrace(e15);
    }

    public static String getFullStackTrace(Throwable throwable) {
        return Utils.getStackTrace(throwable, false);
    }

    public static String getStackTrace(Throwable throwable) {
        return Utils.getStackTrace(throwable, true);
    }

    private static String getStackTrace(Throwable throwable, boolean filter) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw4 = new StringWriter();
        PrintWriter pw4 = new PrintWriter((Writer)sw4, true);
        if (filter) {
            Utils.filterRecursive(throwable);
        }
        throwable.printStackTrace(pw4);
        return sw4.getBuffer().toString();
    }

    public static void appendStackTrace(final ICodeWriter code, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        code.startLine();
        OutputStream w15 = new OutputStream(){

            @Override
            public void write(int b15) {
                char c15 = (char)b15;
                switch (c15) {
                    case '\n': {
                        code.startLine();
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    default: {
                        code.add(c15);
                    }
                }
            }
        };
        try (PrintWriter pw4 = new PrintWriter(w15, true);){
            Utils.filterRecursive(throwable);
            throwable.printStackTrace(pw4);
            pw4.flush();
        }
    }

    private static void filterRecursive(Throwable th4) {
        try {
            Utils.filter(th4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Throwable cause = th4.getCause();
        if (cause != null) {
            Utils.filterRecursive(cause);
        }
    }

    private static void filter(Throwable th4) {
        int i15;
        StackTraceElement[] stackTrace = th4.getStackTrace();
        int length = stackTrace.length;
        StackTraceElement prevElement = null;
        for (i15 = 0; i15 < length; ++i15) {
            StackTraceElement stackTraceElement = stackTrace[i15];
            String clsName = stackTraceElement.getClassName();
            if (clsName.equals(STACKTRACE_STOP_CLS_NAME) || clsName.startsWith(JADX_API_PACKAGE) || Objects.equals(prevElement, stackTraceElement)) {
                th4.setStackTrace(Arrays.copyOfRange(stackTrace, 0, i15));
                return;
            }
            prevElement = stackTraceElement;
        }
        for (i15 = length - 1; i15 >= 0; --i15) {
            String clsName = stackTrace[i15].getClassName();
            if (!clsName.startsWith("jadx.") || clsName.startsWith("jadx.tests.")) continue;
            th4.setStackTrace(Arrays.copyOfRange(stackTrace, 0, i15));
            return;
        }
    }

    public static <T, R> List<R> collectionMap(Collection<T> list2, Function<T, R> mapFunc) {
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<R> result = new ArrayList<R>(list2.size());
        for (T t15 : list2) {
            result.add(mapFunc.apply(t15));
        }
        return result;
    }

    public static <T, R> List<R> collectionMapNoNull(Collection<T> list2, Function<T, R> mapFunc) {
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<R> result = new ArrayList<R>(list2.size());
        for (T t15 : list2) {
            R r15 = mapFunc.apply(t15);
            if (r15 == null) continue;
            result.add(r15);
        }
        return result;
    }

    public static <T> boolean containsInListByRef(List<T> list2, T element) {
        if (Utils.isEmpty(list2)) {
            return false;
        }
        for (T t15 : list2) {
            if (t15 != element) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexInListByRef(List<T> list2, T element) {
        if (list2 == null || list2.isEmpty()) {
            return -1;
        }
        int size = list2.size();
        for (int i15 = 0; i15 < size; ++i15) {
            T t15 = list2.get(i15);
            if (t15 != element) continue;
            return i15;
        }
        return -1;
    }

    public static <T> List<T> lockList(List<T> list2) {
        if (list2.isEmpty()) {
            return Collections.emptyList();
        }
        if (list2.size() == 1) {
            return Collections.singletonList(list2.get(0));
        }
        return new ImmutableList<T>(list2);
    }

    public static <T> List<T> listTail(List<T> list2, int startIndex) {
        if (startIndex == 0) {
            return list2;
        }
        int size = list2.size();
        if (startIndex >= size) {
            return Collections.emptyList();
        }
        return list2.subList(startIndex, size);
    }

    public static <T> List<T> mergeLists(List<T> first, List<T> second) {
        if (Utils.isEmpty(first)) {
            return second;
        }
        if (Utils.isEmpty(second)) {
            return first;
        }
        ArrayList<T> result = new ArrayList<T>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static <T> Set<T> mergeSets(Set<T> first, Set<T> second) {
        if (Utils.isEmpty(first)) {
            return second;
        }
        if (Utils.isEmpty(second)) {
            return first;
        }
        HashSet<T> result = new HashSet<T>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static Map<String, String> newConstStringMap(String ... parameters) {
        int len = parameters.length;
        if (len == 0) {
            return Collections.emptyMap();
        }
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Incorrect arguments count: " + len);
        }
        HashMap<String, String> result = new HashMap<String, String>(len / 2);
        for (int i15 = 0; i15 < len - 1; i15 += 2) {
            result.put(parameters[i15], parameters[i15 + 1]);
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> first, Map<K, V> second) {
        if (Utils.isEmpty(first)) {
            return second;
        }
        if (Utils.isEmpty(second)) {
            return first;
        }
        HashMap<K, V> result = new HashMap<K, V>(first.size() + second.size());
        result.putAll(first);
        result.putAll(second);
        return result;
    }

    public static <K, V> Map<K, V> groupBy(List<V> list2, Function<V, K> mapKey) {
        HashMap<K, V> map = new HashMap<K, V>(list2.size());
        for (V v15 : list2) {
            map.put(mapKey.apply(v15), v15);
        }
        return map;
    }

    public static <T> void treeDfsVisit(T root, Function<T, List<T>> childrenProvider, Consumer<T> visitor2) {
        Utils.multiRootTreeDfsVisit(Collections.singletonList(root), childrenProvider, visitor2);
    }

    public static <T> void multiRootTreeDfsVisit(List<T> roots, Function<T, List<T>> childrenProvider, Consumer<T> visitor2) {
        ArrayDeque<T> queue = new ArrayDeque<T>(roots);
        Object current;
        block0: while ((current = queue.pollLast()) != null) {
            visitor2.accept(current);
            Iterator<T> iterator2 = childrenProvider.apply(current).iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block0;
                T child = iterator2.next();
                queue.addLast(child);
            }
            break;
        }
        return;
    }

    @Nullable
    public static <T> T getOne(@Nullable List<T> list2) {
        if (list2 == null || list2.size() != 1) {
            return null;
        }
        return list2.get(0);
    }

    @Nullable
    public static <T> T getOne(@Nullable Collection<T> collection) {
        if (collection == null || collection.size() != 1) {
            return null;
        }
        return collection.iterator().next();
    }

    public static <T> boolean isSetContainsAny(Set<T> inputSet, Set<T> searchKeys) {
        for (T t15 : inputSet) {
            if (!searchKeys.contains(t15)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> T first(List<T> list2) {
        if (list2.isEmpty()) {
            return null;
        }
        return list2.get(0);
    }

    @Nullable
    public static <T> T first(Iterable<T> list2) {
        Iterator<T> it = list2.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    @Nullable
    public static <T> T last(List<T> list2) {
        if (list2.isEmpty()) {
            return null;
        }
        return list2.get(list2.size() - 1);
    }

    @Nullable
    public static <T> T last(Iterable<T> list2) {
        T next;
        Iterator<T> it = list2.iterator();
        if (!it.hasNext()) {
            return null;
        }
        do {
            next = it.next();
        } while (it.hasNext());
        return next;
    }

    public static <T> T getOrElse(@Nullable T obj, T defaultObj) {
        if (obj == null) {
            return defaultObj;
        }
        return obj;
    }

    public static <T> boolean isEmpty(Collection<T> col) {
        return col == null || col.isEmpty();
    }

    public static <T> boolean notEmpty(Collection<T> col) {
        return col != null && !col.isEmpty();
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <T> boolean isEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }

    public static <T> boolean notEmpty(T[] arr) {
        return arr != null && arr.length != 0;
    }

    public static void checkThreadInterrupt() {
        if (Thread.currentThread().isInterrupted()) {
            throw new JadxRuntimeException("Thread interrupted");
        }
    }

    public static ThreadFactory simpleThreadFactory(String name) {
        return new SimpleThreadFactory(name);
    }

    @Deprecated
    public static boolean getEnvVarBool(String varName, boolean defValue) {
        String strValue = System.getenv(varName);
        if (strValue == null) {
            return defValue;
        }
        return strValue.equalsIgnoreCase("true");
    }

    @Deprecated
    public static int getEnvVarInt(String varName, int defValue) {
        String strValue = System.getenv(varName);
        if (strValue == null) {
            return defValue;
        }
        return Integer.parseInt(strValue);
    }

    private static final class SimpleThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL = new AtomicInteger(0);
        private static final Thread.UncaughtExceptionHandler EXC_HANDLER = new SimpleUncaughtExceptionHandler();
        private final AtomicInteger number = new AtomicInteger(0);
        private final String name;

        public SimpleThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(@NotNull Runnable r15) {
            Thread thread2 = new Thread(r15, "jadx-" + this.name + "-" + POOL.incrementAndGet() + "-" + this.number.incrementAndGet());
            thread2.setUncaughtExceptionHandler(EXC_HANDLER);
            return thread2;
        }

        private static class SimpleUncaughtExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            private static final Logger LOG = LoggerFactory.getLogger(SimpleUncaughtExceptionHandler.class);

            private SimpleUncaughtExceptionHandler() {
            }

            @Override
            public void uncaughtException(Thread thread2, Throwable e15) {
                if (e15 instanceof OutOfMemoryError) {
                    thread2.interrupt();
                    LOG.error("OutOfMemoryError in thread: {}, forcing interrupt", (Object)thread2.getName());
                } else {
                    LOG.error("Uncaught thread exception, thread: {}", (Object)thread2.getName(), (Object)e15);
                }
            }
        }
    }
}

