/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.export;

import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TemplateFile {
    private final String templateName;
    private final InputStream template;
    private final Map<String, String> values = new HashMap<String, String>();

    public static TemplateFile fromResources(String path) throws FileNotFoundException {
        InputStream res = TemplateFile.class.getResourceAsStream(path);
        if (res == null) {
            throw new FileNotFoundException("Resource not found: " + path);
        }
        return new TemplateFile(path, res);
    }

    private TemplateFile(String name, InputStream in4) {
        this.templateName = name;
        this.template = in4;
    }

    public void add(String name, @Nullable Object value) {
        this.values.put(name, String.valueOf(value));
    }

    public String build() throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.process(out);
            String string = out.toString();
            return string;
        }
    }

    public void save(File outFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(outFile);){
            this.process(out);
        }
    }

    private void process(OutputStream out) throws IOException {
        if (this.template.available() == 0) {
            throw new IOException("Template already processed");
        }
        try (BufferedInputStream in4 = new BufferedInputStream(this.template);){
            int ch4;
            ParserState state = new ParserState();
            while ((ch4 = ((InputStream)in4).read()) != -1) {
                String str = this.process(state, (char)ch4);
                if (str != null) {
                    out.write(str.getBytes());
                    continue;
                }
                if (state.skip) continue;
                out.write(ch4);
            }
        }
    }

    @Nullable
    private String process(ParserState parser, char ch4) {
        State state = parser.state;
        switch (ch4) {
            case '{': {
                switch (state.ordinal()) {
                    case 1: {
                        parser.state = State.VARIABLE;
                        parser.curVariable = new StringBuilder();
                        break;
                    }
                    default: {
                        parser.state = State.START;
                    }
                }
                parser.skip = true;
                return null;
            }
            case '}': {
                switch (state.ordinal()) {
                    case 2: {
                        parser.state = State.END;
                        parser.skip = true;
                        return null;
                    }
                    case 3: {
                        parser.state = State.NONE;
                        String varName = parser.curVariable.toString();
                        parser.curVariable = new StringBuilder();
                        return this.processVar(varName);
                    }
                }
                break;
            }
            default: {
                switch (state.ordinal()) {
                    case 2: {
                        parser.curVariable.append(ch4);
                        parser.skip = true;
                        return null;
                    }
                    case 1: {
                        parser.state = State.NONE;
                        return "{" + ch4;
                    }
                    case 3: {
                        throw new JadxRuntimeException("Expected variable end: '" + String.valueOf(parser.curVariable) + "' (missing second '}')");
                    }
                }
            }
        }
        parser.skip = false;
        return null;
    }

    private String processVar(String varName) {
        String str = this.values.get(varName);
        if (str == null) {
            throw new JadxRuntimeException("Unknown variable: '" + varName + "' in template: " + this.templateName);
        }
        return str;
    }

    private static class ParserState {
        private State state = State.NONE;
        private StringBuilder curVariable;
        private boolean skip;

        private ParserState() {
        }
    }

    private static enum State {
        NONE,
        START,
        VARIABLE,
        END;

    }
}

