/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.visitors.typeinference.ITypeConstraint;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTypeConstraint
implements ITypeConstraint {
    protected final InsnNode insn;
    protected final List<SSAVar> relatedVars;

    public AbstractTypeConstraint(InsnNode insn, InsnArg arg) {
        this.insn = insn;
        this.relatedVars = this.collectRelatedVars(insn, arg);
    }

    private List<SSAVar> collectRelatedVars(InsnNode insn, InsnArg arg) {
        ArrayList<SSAVar> list2 = new ArrayList<SSAVar>(insn.getArgsCount());
        if (insn.getResult() == arg) {
            for (InsnArg insnArg : insn.getArguments()) {
                if (!insnArg.isRegister()) continue;
                list2.add(((RegisterArg)insnArg).getSVar());
            }
        } else {
            list2.add(insn.getResult().getSVar());
            for (InsnArg insnArg : insn.getArguments()) {
                if (insnArg == arg || !insnArg.isRegister()) continue;
                list2.add(((RegisterArg)insnArg).getSVar());
            }
        }
        return list2;
    }

    @Override
    public List<SSAVar> getRelatedVars() {
        return this.relatedVars;
    }

    public String toString() {
        return "(" + String.valueOf((Object)this.insn.getType()) + ":" + Utils.listToString(this.relatedVars, SSAVar::toShortString) + ")";
    }
}

