/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.Callable;

public final class SingleFromCallable<T>
extends Single<T> {
    final Callable<? extends T> callable;

    public SingleFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        T value;
        Disposable d15 = Disposable.empty();
        observer.onSubscribe(d15);
        if (d15.isDisposed()) {
            return;
        }
        try {
            value = Objects.requireNonNull(this.callable.call(), "The callable returned a null value");
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            if (!d15.isDisposed()) {
                observer.onError(ex4);
            } else {
                RxJavaPlugins.onError(ex4);
            }
            return;
        }
        if (!d15.isDisposed()) {
            observer.onSuccess(value);
        }
    }
}

