/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;

public final class ObservableZipIterable<T, U, V>
extends Observable<V> {
    final Observable<? extends T> source;
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public ObservableZipIterable(Observable<? extends T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        this.source = source;
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Observer<? super V> t15) {
        boolean b15;
        Iterator<U> it;
        try {
            it = Objects.requireNonNull(this.other.iterator(), "The iterator returned by other is null");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptyDisposable.error(e15, t15);
            return;
        }
        try {
            b15 = it.hasNext();
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            EmptyDisposable.error(e16, t15);
            return;
        }
        if (!b15) {
            EmptyDisposable.complete(t15);
            return;
        }
        this.source.subscribe(new ZipIterableObserver<T, U, V>(t15, it, this.zipper));
    }

    static final class ZipIterableObserver<T, U, V>
    implements Observer<T>,
    Disposable {
        final Observer<? super V> downstream;
        final Iterator<U> iterator;
        final BiFunction<? super T, ? super U, ? extends V> zipper;
        Disposable upstream;
        boolean done;

        ZipIterableObserver(Observer<? super V> actual, Iterator<U> iterator2, BiFunction<? super T, ? super U, ? extends V> zipper) {
            this.downstream = actual;
            this.iterator = iterator2;
            this.zipper = zipper;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t15) {
            boolean b15;
            V v15;
            U u15;
            if (this.done) {
                return;
            }
            try {
                u15 = Objects.requireNonNull(this.iterator.next(), "The iterator returned a null value");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.fail(e15);
                return;
            }
            try {
                v15 = Objects.requireNonNull(this.zipper.apply(t15, u15), "The zipper function returned a null value");
            }
            catch (Throwable e16) {
                Exceptions.throwIfFatal(e16);
                this.fail(e16);
                return;
            }
            this.downstream.onNext(v15);
            try {
                b15 = this.iterator.hasNext();
            }
            catch (Throwable e17) {
                Exceptions.throwIfFatal(e17);
                this.fail(e17);
                return;
            }
            if (!b15) {
                this.done = true;
                this.upstream.dispose();
                this.downstream.onComplete();
            }
        }

        void fail(Throwable e15) {
            this.done = true;
            this.upstream.dispose();
            this.downstream.onError(e15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

