/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.observers.SerializedObserver;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWithLatestFrom<T, U, R>
extends AbstractObservableWithUpstream<T, R> {
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final ObservableSource<? extends U> other;

    public ObservableWithLatestFrom(ObservableSource<T> source, BiFunction<? super T, ? super U, ? extends R> combiner, ObservableSource<? extends U> other) {
        super(source);
        this.combiner = combiner;
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super R> t15) {
        SerializedObserver<R> serial = new SerializedObserver<R>(t15);
        WithLatestFromObserver<? super T, ? super U, ? extends R> wlf = new WithLatestFromObserver<T, U, R>(serial, this.combiner);
        serial.onSubscribe(wlf);
        this.other.subscribe(new WithLatestFromOtherObserver(wlf));
        this.source.subscribe(wlf);
    }

    final class WithLatestFromOtherObserver
    implements Observer<U> {
        private final WithLatestFromObserver<T, U, R> parent;

        WithLatestFromOtherObserver(WithLatestFromObserver<T, U, R> parent) {
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.parent.setOther(d15);
        }

        @Override
        public void onNext(U t15) {
            this.parent.lazySet(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.otherError(t15);
        }

        @Override
        public void onComplete() {
        }
    }

    static final class WithLatestFromObserver<T, U, R>
    extends AtomicReference<U>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -312246233408980075L;
        final Observer<? super R> downstream;
        final BiFunction<? super T, ? super U, ? extends R> combiner;
        final AtomicReference<Disposable> upstream = new AtomicReference();
        final AtomicReference<Disposable> other = new AtomicReference();

        WithLatestFromObserver(Observer<? super R> actual, BiFunction<? super T, ? super U, ? extends R> combiner) {
            this.downstream = actual;
            this.combiner = combiner;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this.upstream, d15);
        }

        @Override
        public void onNext(T t15) {
            Object u15 = this.get();
            if (u15 != null) {
                R r15;
                try {
                    r15 = Objects.requireNonNull(this.combiner.apply(t15, u15), "The combiner returned a null value");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.dispose();
                    this.downstream.onError(e15);
                    return;
                }
                this.downstream.onNext(r15);
            }
        }

        @Override
        public void onError(Throwable t15) {
            DisposableHelper.dispose(this.other);
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.other);
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose(this.other);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        public boolean setOther(Disposable o15) {
            return DisposableHelper.setOnce(this.other, o15);
        }

        public void otherError(Throwable e15) {
            DisposableHelper.dispose(this.upstream);
            this.downstream.onError(e15);
        }
    }
}

