/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.fuseable.FuseToObservable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableIgnoreElements;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableIgnoreElementsCompletable<T>
extends Completable
implements FuseToObservable<T> {
    final ObservableSource<T> source;

    public ObservableIgnoreElementsCompletable(ObservableSource<T> source) {
        this.source = source;
    }

    @Override
    public void subscribeActual(CompletableObserver t15) {
        this.source.subscribe(new IgnoreObservable(t15));
    }

    @Override
    public Observable<T> fuseToObservable() {
        return RxJavaPlugins.onAssembly(new ObservableIgnoreElements<T>(this.source));
    }

    static final class IgnoreObservable<T>
    implements Observer<T>,
    Disposable {
        final CompletableObserver downstream;
        Disposable upstream;

        IgnoreObservable(CompletableObserver t15) {
            this.downstream = t15;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.upstream = d15;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T v15) {
        }

        @Override
        public void onError(Throwable e15) {
            this.downstream.onError(e15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

