/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWindowSubscribeIntercept;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import io.reactivex.rxjava3.subscribers.DisposableSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindowBoundary<T, B>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final Publisher<B> other;
    final int capacityHint;

    public FlowableWindowBoundary(Flowable<T> source, Publisher<B> other, int capacityHint) {
        super(source);
        this.other = other;
        this.capacityHint = capacityHint;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Flowable<T>> subscriber) {
        WindowBoundaryMainSubscriber parent = new WindowBoundaryMainSubscriber(subscriber, this.capacityHint);
        subscriber.onSubscribe(parent);
        parent.innerNext();
        this.other.subscribe(parent.boundarySubscriber);
        this.source.subscribe(parent);
    }

    static final class WindowBoundaryInnerSubscriber<T, B>
    extends DisposableSubscriber<B> {
        final WindowBoundaryMainSubscriber<T, B> parent;
        boolean done;

        WindowBoundaryInnerSubscriber(WindowBoundaryMainSubscriber<T, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t15) {
            if (this.done) {
                return;
            }
            this.parent.innerNext();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.parent.innerError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.innerComplete();
        }
    }

    static final class WindowBoundaryMainSubscriber<T, B>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 2233020065421370272L;
        final Subscriber<? super Flowable<T>> downstream;
        final int capacityHint;
        final WindowBoundaryInnerSubscriber<T, B> boundarySubscriber;
        final AtomicReference<Subscription> upstream;
        final AtomicInteger windows;
        final MpscLinkedQueue<Object> queue;
        final AtomicThrowable errors;
        final AtomicBoolean stopWindows;
        final AtomicLong requested;
        static final Object NEXT_WINDOW = new Object();
        volatile boolean done;
        UnicastProcessor<T> window;
        long emitted;

        WindowBoundaryMainSubscriber(Subscriber<? super Flowable<T>> downstream, int capacityHint) {
            this.downstream = downstream;
            this.capacityHint = capacityHint;
            this.boundarySubscriber = new WindowBoundaryInnerSubscriber(this);
            this.upstream = new AtomicReference();
            this.windows = new AtomicInteger(1);
            this.queue = new MpscLinkedQueue();
            this.errors = new AtomicThrowable();
            this.stopWindows = new AtomicBoolean();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.setOnce(this.upstream, s15, Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t15) {
            this.queue.offer(t15);
            this.drain();
        }

        @Override
        public void onError(Throwable e15) {
            this.boundarySubscriber.dispose();
            if (this.errors.tryAddThrowableOrReport(e15)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.boundarySubscriber.dispose();
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            if (this.stopWindows.compareAndSet(false, true)) {
                this.boundarySubscriber.dispose();
                if (this.windows.decrementAndGet() == 0) {
                    SubscriptionHelper.cancel(this.upstream);
                }
            }
        }

        @Override
        public void request(long n15) {
            BackpressureHelper.add(this.requested, n15);
        }

        @Override
        public void run() {
            if (this.windows.decrementAndGet() == 0) {
                SubscriptionHelper.cancel(this.upstream);
            }
        }

        void innerNext() {
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        void innerError(Throwable e15) {
            SubscriptionHelper.cancel(this.upstream);
            if (this.errors.tryAddThrowableOrReport(e15)) {
                this.done = true;
                this.drain();
            }
        }

        void innerComplete() {
            SubscriptionHelper.cancel(this.upstream);
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<Flowable<FlowableWindowSubscribeIntercept<T>>> downstream = this.downstream;
            MpscLinkedQueue<Object> queue = this.queue;
            AtomicThrowable errors = this.errors;
            long emitted = this.emitted;
            while (true) {
                boolean empty;
                if (this.windows.get() == 0) {
                    queue.clear();
                    this.window = null;
                    return;
                }
                UnicastProcessor<Object> w15 = this.window;
                boolean d15 = this.done;
                if (d15 && errors.get() != null) {
                    queue.clear();
                    Throwable ex4 = errors.terminate();
                    if (w15 != null) {
                        this.window = null;
                        w15.onError(ex4);
                    }
                    downstream.onError(ex4);
                    return;
                }
                Object v15 = queue.poll();
                boolean bl4 = empty = v15 == null;
                if (d15 && empty) {
                    Throwable ex5 = errors.terminate();
                    if (ex5 == null) {
                        if (w15 != null) {
                            this.window = null;
                            w15.onComplete();
                        }
                        downstream.onComplete();
                    } else {
                        if (w15 != null) {
                            this.window = null;
                            w15.onError(ex5);
                        }
                        downstream.onError(ex5);
                    }
                    return;
                }
                if (!empty) {
                    if (v15 != NEXT_WINDOW) {
                        w15.onNext(v15);
                        continue;
                    }
                    if (w15 != null) {
                        this.window = null;
                        w15.onComplete();
                    }
                    if (this.stopWindows.get()) continue;
                    w15 = UnicastProcessor.create(this.capacityHint, this);
                    this.window = w15;
                    this.windows.getAndIncrement();
                    if (emitted != this.requested.get()) {
                        ++emitted;
                        FlowableWindowSubscribeIntercept<T> intercept = new FlowableWindowSubscribeIntercept<T>(w15);
                        downstream.onNext(intercept);
                        if (!intercept.tryAbandon()) continue;
                        w15.onComplete();
                        continue;
                    }
                    SubscriptionHelper.cancel(this.upstream);
                    this.boundarySubscriber.dispose();
                    errors.tryAddThrowableOrReport(MissingBackpressureException.createDefault());
                    this.done = true;
                    continue;
                }
                this.emitted = emitted;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

