/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableGroupJoin;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends AbstractFlowableWithUpstream<TLeft, R> {
    final Publisher<? extends TRight> other;
    final Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector;

    public FlowableJoin(Flowable<TLeft> source, Publisher<? extends TRight> other, Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector) {
        super(source);
        this.other = other;
        this.leftEnd = leftEnd;
        this.rightEnd = rightEnd;
        this.resultSelector = resultSelector;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        JoinSubscription parent = new JoinSubscription(s15, this.leftEnd, this.rightEnd, this.resultSelector);
        s15.onSubscribe(parent);
        FlowableGroupJoin.LeftRightSubscriber left = new FlowableGroupJoin.LeftRightSubscriber(parent, true);
        parent.disposables.add(left);
        FlowableGroupJoin.LeftRightSubscriber right = new FlowableGroupJoin.LeftRightSubscriber(parent, false);
        parent.disposables.add(right);
        this.source.subscribe(left);
        this.other.subscribe(right);
    }

    static final class JoinSubscription<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements Subscription,
    FlowableGroupJoin.JoinSupport {
        private static final long serialVersionUID = -6071216598687999801L;
        final Subscriber<? super R> downstream;
        final AtomicLong requested;
        final SpscLinkedArrayQueue<Object> queue;
        final CompositeDisposable disposables;
        final Map<Integer, TLeft> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd;
        final Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd;
        final BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        JoinSubscription(Subscriber<? super R> actual, Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector) {
            this.downstream = actual;
            this.requested = new AtomicLong();
            this.disposables = new CompositeDisposable();
            this.queue = new SpscLinkedArrayQueue(Flowable.bufferSize());
            this.lefts = new LinkedHashMap<Integer, TLeft>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(Subscriber<?> a15) {
            Throwable ex4 = ExceptionHelper.terminate(this.error);
            this.lefts.clear();
            this.rights.clear();
            a15.onError(ex4);
        }

        void fail(Throwable exc, Subscriber<?> a15, SimpleQueue<?> q15) {
            Exceptions.throwIfFatal(exc);
            ExceptionHelper.addThrowable(this.error, exc);
            q15.clear();
            this.cancelAll();
            this.errorAll(a15);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            Subscriber<R> a15 = this.downstream;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    q15.clear();
                    return;
                }
                Throwable ex4 = this.error.get();
                if (ex4 != null) {
                    q15.clear();
                    this.cancelAll();
                    this.errorAll(a15);
                    return;
                }
                boolean d15 = this.active.get() == 0;
                Integer mode = (Integer)q15.poll();
                boolean bl4 = empty = mode == null;
                if (d15 && empty) {
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a15.onComplete();
                    return;
                }
                if (!empty) {
                    FlowableGroupJoin.LeftRightEndSubscriber end;
                    R w15;
                    long e15;
                    long r15;
                    FlowableGroupJoin.LeftRightEndSubscriber end2;
                    Publisher<Object> p15;
                    int idx;
                    Object val = q15.poll();
                    if (mode == LEFT_VALUE) {
                        Object left = val;
                        ++this.leftIndex;
                        this.lefts.put(idx, left);
                        try {
                            p15 = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a15, q15);
                            return;
                        }
                        end2 = new FlowableGroupJoin.LeftRightEndSubscriber(this, true, idx);
                        this.disposables.add(end2);
                        p15.subscribe(end2);
                        ex4 = this.error.get();
                        if (ex4 != null) {
                            q15.clear();
                            this.cancelAll();
                            this.errorAll(a15);
                            return;
                        }
                        r15 = this.requested.get();
                        e15 = 0L;
                        for (Object right : this.rights.values()) {
                            try {
                                w15 = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a15, q15);
                                return;
                            }
                            if (e15 != r15) {
                                a15.onNext(w15);
                                ++e15;
                                continue;
                            }
                            ExceptionHelper.addThrowable(this.error, MissingBackpressureException.createDefault());
                            q15.clear();
                            this.cancelAll();
                            this.errorAll(a15);
                            return;
                        }
                        if (e15 == 0L) continue;
                        BackpressureHelper.produced(this.requested, e15);
                        continue;
                    }
                    if (mode == RIGHT_VALUE) {
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p15 = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a15, q15);
                            return;
                        }
                        end2 = new FlowableGroupJoin.LeftRightEndSubscriber(this, false, idx);
                        this.disposables.add(end2);
                        p15.subscribe(end2);
                        ex4 = this.error.get();
                        if (ex4 != null) {
                            q15.clear();
                            this.cancelAll();
                            this.errorAll(a15);
                            return;
                        }
                        r15 = this.requested.get();
                        e15 = 0L;
                        for (Object left : this.lefts.values()) {
                            try {
                                w15 = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a15, q15);
                                return;
                            }
                            if (e15 != r15) {
                                a15.onNext(w15);
                                ++e15;
                                continue;
                            }
                            ExceptionHelper.addThrowable(this.error, MissingBackpressureException.createDefault());
                            q15.clear();
                            this.cancelAll();
                            this.errorAll(a15);
                            return;
                        }
                        if (e15 == 0L) continue;
                        BackpressureHelper.produced(this.requested, e15);
                        continue;
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (FlowableGroupJoin.LeftRightEndSubscriber)val;
                        this.lefts.remove(end.index);
                        this.disposables.remove(end);
                        continue;
                    }
                    end = (FlowableGroupJoin.LeftRightEndSubscriber)val;
                    this.rights.remove(end.index);
                    this.disposables.remove(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex4) {
            if (ExceptionHelper.addThrowable(this.error, ex4)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }

        @Override
        public void innerComplete(FlowableGroupJoin.LeftRightSubscriber sender) {
            this.disposables.delete(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o15) {
            JoinSubscription joinSubscription = this;
            synchronized (joinSubscription) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o15);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, FlowableGroupJoin.LeftRightEndSubscriber index) {
            JoinSubscription joinSubscription = this;
            synchronized (joinSubscription) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex4) {
            if (ExceptionHelper.addThrowable(this.error, ex4)) {
                this.drain();
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }
    }
}

