/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;

public final class FlowableFromFuture<T>
extends Flowable<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public FlowableFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        T v15;
        DeferredScalarSubscription<T> deferred = new DeferredScalarSubscription<T>(s15);
        s15.onSubscribe(deferred);
        try {
            v15 = this.unit != null ? this.future.get(this.timeout, this.unit) : this.future.get();
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            if (!deferred.isCancelled()) {
                s15.onError(ex4);
            }
            return;
        }
        if (v15 == null) {
            s15.onError(ExceptionHelper.createNullPointerException("The future returned a null value."));
        } else {
            deferred.complete(v15);
        }
    }
}

