/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;

public final class CompletableToSingle<T>
extends Single<T> {
    final CompletableSource source;
    final Supplier<? extends T> completionValueSupplier;
    final T completionValue;

    public CompletableToSingle(CompletableSource source, Supplier<? extends T> completionValueSupplier, T completionValue) {
        this.source = source;
        this.completionValue = completionValue;
        this.completionValueSupplier = completionValueSupplier;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new ToSingle(observer));
    }

    final class ToSingle
    implements CompletableObserver {
        private final SingleObserver<? super T> observer;

        ToSingle(SingleObserver<? super T> observer) {
            this.observer = observer;
        }

        @Override
        public void onComplete() {
            Object v15;
            if (CompletableToSingle.this.completionValueSupplier != null) {
                try {
                    v15 = CompletableToSingle.this.completionValueSupplier.get();
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.observer.onError(e15);
                    return;
                }
            } else {
                v15 = CompletableToSingle.this.completionValue;
            }
            if (v15 == null) {
                this.observer.onError(new NullPointerException("The value supplied is null"));
            } else {
                this.observer.onSuccess(v15);
            }
        }

        @Override
        public void onError(Throwable e15) {
            this.observer.onError(e15);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.observer.onSubscribe(d15);
        }
    }
}

