/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.Overlay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;

public final class PixelMarkerOverlay
extends Overlay {
    private Set<Point> points = new HashSet<Point>();
    private Color color = Color.RED;
    private int size = 5;

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("Negative size");
        }
        this.size = newSize;
        this.repaint();
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.color = color;
        this.repaint();
    }

    public void addPoint(Point p15) {
        if (p15 == null) {
            throw new NullPointerException();
        }
        this.points.add(new Point(p15));
        this.repaint();
    }

    public void setPoint(Point p15) {
        this.points.clear();
        if (p15 != null) {
            this.points.add(new Point(p15));
        }
        this.repaint();
    }

    public void setPoints(Iterable<Point> points) {
        if (points == null) {
            throw new NullPointerException();
        }
        this.points.clear();
        for (Point p15 : points) {
            this.points.add(new Point(p15));
        }
        this.repaint();
    }

    public void clear() {
        if (!this.points.isEmpty()) {
            this.points.clear();
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics2D g15, BufferedImage image, AffineTransform transform) {
        g15.setColor(this.color);
        Point2D.Double p2d = new Point2D.Double();
        int currentSize = Math.max(this.size, (int)Math.ceil(transform.getScaleX() / Math.sqrt(2.0)));
        for (Point p15 : this.points) {
            ((Point2D)p2d).setLocation((double)p15.x + 0.5, (double)p15.y + 0.5);
            transform.transform(p2d, p2d);
            g15.drawOval((int)((Point2D)p2d).getX() - currentSize, (int)((Point2D)p2d).getY() - currentSize, 2 * currentSize + 1, 2 * currentSize + 1);
        }
    }
}

