/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.common.hash.ParametricNullness;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@Immutable
abstract class AbstractCompositeHashFunction
extends AbstractHashFunction {
    final HashFunction[] functions;
    private static final long serialVersionUID = 0L;

    AbstractCompositeHashFunction(HashFunction ... functions) {
        for (HashFunction function : functions) {
            Preconditions.checkNotNull(function);
        }
        this.functions = functions;
    }

    abstract HashCode makeHash(Hasher[] var1);

    @Override
    public Hasher newHasher() {
        Hasher[] hashers = new Hasher[this.functions.length];
        for (int i15 = 0; i15 < hashers.length; ++i15) {
            hashers[i15] = this.functions[i15].newHasher();
        }
        return this.fromHashers(hashers);
    }

    @Override
    public Hasher newHasher(int expectedInputSize) {
        Preconditions.checkArgument(expectedInputSize >= 0);
        Hasher[] hashers = new Hasher[this.functions.length];
        for (int i15 = 0; i15 < hashers.length; ++i15) {
            hashers[i15] = this.functions[i15].newHasher(expectedInputSize);
        }
        return this.fromHashers(hashers);
    }

    private Hasher fromHashers(final Hasher[] hashers) {
        return new Hasher(){
            final /* synthetic */ AbstractCompositeHashFunction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Hasher putByte(byte b15) {
                for (Hasher hasher : hashers) {
                    hasher.putByte(b15);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes) {
                for (Hasher hasher : hashers) {
                    hasher.putBytes(bytes);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes, int off, int len) {
                for (Hasher hasher : hashers) {
                    hasher.putBytes(bytes, off, len);
                }
                return this;
            }

            @Override
            public Hasher putBytes(ByteBuffer bytes) {
                int pos = bytes.position();
                for (Hasher hasher : hashers) {
                    Java8Compatibility.position(bytes, pos);
                    hasher.putBytes(bytes);
                }
                return this;
            }

            @Override
            public Hasher putShort(short s15) {
                for (Hasher hasher : hashers) {
                    hasher.putShort(s15);
                }
                return this;
            }

            @Override
            public Hasher putInt(int i15) {
                for (Hasher hasher : hashers) {
                    hasher.putInt(i15);
                }
                return this;
            }

            @Override
            public Hasher putLong(long l15) {
                for (Hasher hasher : hashers) {
                    hasher.putLong(l15);
                }
                return this;
            }

            @Override
            public Hasher putFloat(float f15) {
                for (Hasher hasher : hashers) {
                    hasher.putFloat(f15);
                }
                return this;
            }

            @Override
            public Hasher putDouble(double d15) {
                for (Hasher hasher : hashers) {
                    hasher.putDouble(d15);
                }
                return this;
            }

            @Override
            public Hasher putBoolean(boolean b15) {
                for (Hasher hasher : hashers) {
                    hasher.putBoolean(b15);
                }
                return this;
            }

            @Override
            public Hasher putChar(char c15) {
                for (Hasher hasher : hashers) {
                    hasher.putChar(c15);
                }
                return this;
            }

            @Override
            public Hasher putUnencodedChars(CharSequence chars) {
                for (Hasher hasher : hashers) {
                    hasher.putUnencodedChars(chars);
                }
                return this;
            }

            @Override
            public Hasher putString(CharSequence chars, Charset charset) {
                for (Hasher hasher : hashers) {
                    hasher.putString(chars, charset);
                }
                return this;
            }

            @Override
            public <T> Hasher putObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
                for (Hasher hasher : hashers) {
                    hasher.putObject(instance, funnel);
                }
                return this;
            }

            @Override
            public HashCode hash() {
                return this.this$0.makeHash(hashers);
            }
        };
    }
}

