/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes.font;

import com.github.weisj.jsvg.attributes.font.FontStyle;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Percentage;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontSpec {
    @NotNull
    protected final String[] families;
    @Nullable
    protected final FontStyle style;
    @Nullable
    protected final Length sizeAdjust;
    @NotNull
    protected final Percentage stretch;

    FontSpec(@NotNull String[] families, @Nullable FontStyle style, @Nullable Length sizeAdjust, @NotNull Percentage stretch) {
        this.families = families;
        this.style = style;
        this.sizeAdjust = sizeAdjust;
        this.stretch = stretch;
    }

    public String toString() {
        return "FontSpec{families=" + Arrays.toString(this.families) + ", style=" + this.style + ", sizeAdjust=" + this.sizeAdjust + ", stretch=" + this.stretch + '}';
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof FontSpec)) {
            return false;
        }
        FontSpec fontSpec = (FontSpec)o15;
        return Objects.equals(this.stretch, fontSpec.stretch) && Arrays.equals(this.families, fontSpec.families) && Objects.equals(this.style, fontSpec.style) && Objects.equals(this.sizeAdjust, fontSpec.sizeAdjust);
    }

    public int hashCode() {
        int result = Objects.hash(this.style, this.sizeAdjust, this.stretch);
        result = 31 * result + Arrays.hashCode(this.families);
        return result;
    }
}

