/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.FuzzyMap;
import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.IMainParameter;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IParameterizedParser;
import com.beust.jcommander.IParametersValidator;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.IStringConverterInstanceFactory;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.IVariableArity;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.StringKey;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.converters.DefaultListConverter;
import com.beust.jcommander.converters.EnumConverter;
import com.beust.jcommander.converters.IParameterSplitter;
import com.beust.jcommander.converters.NoConverter;
import com.beust.jcommander.converters.StringConverter;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.beust.jcommander.internal.DefaultConverterFactory;
import com.beust.jcommander.internal.JDK6Console;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.beust.jcommander.internal.Nullable;
import com.beust.jcommander.internal.Sets;
import com.beust.jcommander.parser.DefaultParameterizedParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class JCommander {
    public static final String DEBUG_PROPERTY = "jcommander.debug";
    protected IParameterizedParser parameterizedParser = new DefaultParameterizedParser();
    private Map<FuzzyMap.IKey, ParameterDescription> descriptions;
    private List<Object> objects = Lists.newArrayList();
    private IUsageFormatter usageFormatter = new DefaultUsageFormatter(this);
    private MainParameter mainParameter = null;
    private Map<Parameterized, ParameterDescription> requiredFields = Maps.newHashMap();
    private Set<IParametersValidator> parametersValidators = Sets.newHashSet();
    private Map<Parameterized, ParameterDescription> fields = Maps.newHashMap();
    private Map<ProgramName, JCommander> commands = Maps.newLinkedHashMap();
    private Map<FuzzyMap.IKey, ProgramName> aliasMap = Maps.newLinkedHashMap();
    private String parsedCommand;
    private String parsedAlias;
    private ProgramName programName;
    private boolean helpWasSpecified;
    private List<String> unknownArgs = Lists.newArrayList();
    private Console console;
    private final Options options;
    private final IVariableArity DEFAULT_VARIABLE_ARITY = new DefaultVariableArity();

    private JCommander(Options options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        if (options.converterInstanceFactories.isEmpty()) {
            this.addConverterFactory(new DefaultConverterFactory());
        }
    }

    public JCommander() {
        this(new Options());
    }

    public JCommander(Object object) {
        this(object, (ResourceBundle)null);
    }

    public JCommander(Object object, @Nullable ResourceBundle bundle) {
        this(object, bundle, (String[])null);
    }

    public JCommander(Object object, @Nullable ResourceBundle bundle, String ... args) {
        this();
        this.addObject(object);
        if (bundle != null) {
            this.setDescriptionsBundle(bundle);
        }
        this.createDescriptions();
        if (args != null) {
            this.parse(args);
        }
    }

    @Deprecated
    public JCommander(Object object, String ... args) {
        this(object);
        this.parse(args);
    }

    public void setParameterizedParser(IParameterizedParser parameterizedParser) {
        this.parameterizedParser = parameterizedParser;
    }

    public void setExpandAtSign(boolean expandAtSign) {
        this.options.expandAtSign = expandAtSign;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public synchronized Console getConsole() {
        if (this.console == null) {
            try {
                Method consoleMethod = System.class.getDeclaredMethod("console", new Class[0]);
                Object console = consoleMethod.invoke(null, new Object[0]);
                this.console = new JDK6Console(console);
            }
            catch (Throwable t15) {
                this.console = new DefaultConsole();
            }
        }
        return this.console;
    }

    public final void addObject(Object object) {
        if (object instanceof Iterable) {
            for (Object o15 : (Iterable)object) {
                this.objects.add(o15);
            }
        } else if (object.getClass().isArray()) {
            for (Object o16 : (Object[])object) {
                this.objects.add(o16);
            }
        } else {
            this.objects.add(object);
        }
    }

    public final void setDescriptionsBundle(ResourceBundle bundle) {
        this.options.bundle = bundle;
    }

    public void parse(String ... args) {
        try {
            this.parse(true, args);
        }
        catch (ParameterException ex4) {
            ex4.setJCommander(this);
            throw ex4;
        }
    }

    public void parseWithoutValidation(String ... args) {
        this.parse(false, args);
    }

    private void parse(boolean validate, String ... args) {
        StringBuilder sb5 = new StringBuilder("Parsing \"");
        sb5.append(Strings.join(" ", args)).append("\"\n  with:").append(Strings.join(" ", this.objects.toArray()));
        this.p(sb5.toString());
        if (this.descriptions == null) {
            this.createDescriptions();
        }
        this.initializeDefaultValues();
        this.parseValues(this.expandArgs(args), validate);
        if (validate) {
            this.validateOptions();
        }
    }

    private void initializeDefaultValues() {
        if (this.options.defaultProvider != null) {
            for (ParameterDescription parameterDescription : this.descriptions.values()) {
                this.initializeDefaultValue(parameterDescription);
            }
            for (Map.Entry entry : this.commands.entrySet()) {
                ((JCommander)entry.getValue()).initializeDefaultValues();
            }
        }
    }

    private void validateOptions() {
        if (this.helpWasSpecified) {
            return;
        }
        if (!this.requiredFields.isEmpty()) {
            ArrayList<String> missingFields = new ArrayList<String>();
            for (ParameterDescription pd5 : this.requiredFields.values()) {
                missingFields.add("[" + Strings.join(" | ", pd5.getParameter().names()) + "]");
            }
            String message2 = Strings.join(", ", missingFields);
            throw new ParameterException("The following " + JCommander.pluralize(this.requiredFields.size(), "option is required: ", "options are required: ") + message2);
        }
        if (this.mainParameter != null && this.mainParameter.description != null) {
            int size;
            Object value;
            ParameterDescription mainParameterDescription = this.mainParameter.description;
            if (mainParameterDescription.getParameter().required() && !mainParameterDescription.isAssigned()) {
                throw new ParameterException("Main parameters are required (\"" + mainParameterDescription.getDescription() + "\")");
            }
            int arity = mainParameterDescription.getParameter().arity();
            if (arity != -1 && List.class.isAssignableFrom((value = mainParameterDescription.getParameterized().get(this.mainParameter.object)).getClass()) && (size = ((List)value).size()) != arity) {
                throw new ParameterException("There should be exactly " + arity + " main parameters but " + size + " were found");
            }
        }
        Map<String, Object> nameValuePairs = Maps.newHashMap();
        for (ParameterDescription pd6 : this.fields.values()) {
            nameValuePairs.put(pd6.getLongestName(), pd6.getValue());
        }
        for (IParametersValidator parametersValidator : this.parametersValidators) {
            parametersValidator.validate(nameValuePairs);
        }
    }

    private static String pluralize(int quantity, String singular, String plural) {
        return quantity == 1 ? singular : plural;
    }

    private String[] expandArgs(String[] originalArgv) {
        List<String> vResult1 = Lists.newArrayList();
        for (String arg : originalArgv) {
            List<String> expanded = this.expandDynamicArg(arg);
            vResult1.addAll(expanded);
        }
        List vResult2 = Lists.newArrayList();
        for (String arg : vResult1) {
            if (this.isOption(arg)) {
                String sep = this.getSeparatorFor(arg);
                if (!" ".equals(sep)) {
                    String[] sp4;
                    for (String ssp : sp4 = arg.split("[" + sep + "]", 2)) {
                        vResult2.add(ssp);
                    }
                    continue;
                }
                vResult2.add(arg);
                continue;
            }
            vResult2.add(arg);
        }
        return vResult2.toArray(new String[vResult2.size()]);
    }

    private List<String> expandDynamicArg(String arg) {
        for (ParameterDescription pd5 : this.descriptions.values()) {
            if (!pd5.isDynamicParameter()) continue;
            for (String name : pd5.getParameter().names()) {
                if (!arg.startsWith(name) || arg.equals(name) || !arg.contains(pd5.getParameter().getAssignment())) continue;
                return Arrays.asList(name, arg.substring(name.length()));
            }
        }
        return Arrays.asList(arg);
    }

    private boolean matchArg(String arg, FuzzyMap.IKey key) {
        String separator;
        ParameterDescription pd5;
        String kn4;
        String string = kn4 = this.options.caseSensitiveOptions ? key.getName() : key.getName().toLowerCase();
        return this.options.allowAbbreviatedOptions ? kn4.startsWith(arg) : ((pd5 = this.descriptions.get(key)) != null ? (!" ".equals(separator = this.getSeparatorFor(arg)) ? arg.startsWith(kn4) : kn4.equals(arg)) : kn4.equals(arg));
    }

    private boolean isOption(String passedArg) {
        return this.options.acceptUnknownOptions || this.isNamedOption(passedArg);
    }

    private boolean isNamedOption(String passedArg) {
        String arg = this.options.caseSensitiveOptions ? passedArg : passedArg.toLowerCase();
        for (FuzzyMap.IKey iKey : this.descriptions.keySet()) {
            if (!this.matchArg(arg, iKey)) continue;
            return true;
        }
        for (FuzzyMap.IKey iKey : this.commands.keySet()) {
            if (!this.matchArg(arg, iKey)) continue;
            return true;
        }
        for (FuzzyMap.IKey iKey : this.aliasMap.keySet()) {
            if (!this.matchArg(arg, iKey)) continue;
            return true;
        }
        return false;
    }

    private ParameterDescription getPrefixDescriptionFor(String arg) {
        for (Map.Entry<FuzzyMap.IKey, ParameterDescription> es4 : this.descriptions.entrySet()) {
            if (!Strings.startsWith(arg, es4.getKey().getName(), this.options.caseSensitiveOptions)) continue;
            return es4.getValue();
        }
        return null;
    }

    private ParameterDescription getDescriptionFor(String arg) {
        return this.getPrefixDescriptionFor(arg);
    }

    private String getSeparatorFor(String arg) {
        Parameters p15;
        ParameterDescription pd5 = this.getDescriptionFor(arg);
        if (pd5 != null && (p15 = pd5.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return p15.separators();
        }
        return " ";
    }

    private List<String> readFile(String fileName) {
        List<String> result = Lists.newArrayList();
        try (BufferedReader bufRead = Files.newBufferedReader(Paths.get(fileName, new String[0]), this.options.atFileCharset);){
            String line;
            while ((line = bufRead.readLine()) != null) {
                if (line.isEmpty() || line.trim().startsWith("#")) continue;
                result.addAll(Arrays.asList(line.split("\\s")));
            }
        }
        catch (IOException e15) {
            throw new ParameterException("Could not read file " + fileName + ": " + e15);
        }
        return result;
    }

    private static String trim(String string) {
        String result = string.trim();
        if (result.startsWith("\"") && result.endsWith("\"") && result.length() > 1) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    public void createDescriptions() {
        this.descriptions = Maps.newHashMap();
        for (Object object : this.objects) {
            this.addDescription(object);
        }
    }

    private void addDescription(Object object) {
        Class<?> cls = object.getClass();
        Parameters parameters = cls.getAnnotation(Parameters.class);
        if (parameters != null) {
            Class<? extends IParametersValidator>[] parametersValidatorClasses = parameters.parametersValidators();
            for (Class<? extends IParametersValidator> parametersValidatorClass : parametersValidatorClasses) {
                try {
                    IParametersValidator parametersValidator = (IParametersValidator)parametersValidatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.parametersValidators.add(parametersValidator);
                }
                catch (ReflectiveOperationException e15) {
                    throw new ParameterException("Cannot instantiate rule: " + (Class)parametersValidatorClass, e15);
                }
            }
        }
        List<Parameterized> parameterizeds = this.parameterizedParser.parseArg(object);
        for (Parameterized parameterized : parameterizeds) {
            WrappedParameter wp4 = parameterized.getWrappedParameter();
            if (wp4 != null && wp4.getParameter() != null) {
                Parameter annotation = wp4.getParameter();
                Parameter p15 = annotation;
                if (p15.names().length == 0) {
                    this.p("Found main parameter:" + parameterized);
                    if (this.mainParameter != null) {
                        throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.mainParameter + " and " + parameterized);
                    }
                    this.mainParameter = new MainParameter();
                    this.mainParameter.parameterized = parameterized;
                    this.mainParameter.object = object;
                    this.mainParameter.annotation = p15;
                    this.mainParameter.description = new ParameterDescription(object, p15, parameterized, this.options.bundle, this);
                    continue;
                }
                ParameterDescription pd5 = new ParameterDescription(object, p15, parameterized, this.options.bundle, this);
                for (String name : p15.names()) {
                    if (this.descriptions.containsKey(new StringKey(name))) {
                        throw new ParameterException("Found the option " + name + " multiple times");
                    }
                    this.p("Adding description for " + name);
                    this.fields.put(parameterized, pd5);
                    this.descriptions.put(new StringKey(name), pd5);
                    if (!p15.required()) continue;
                    this.requiredFields.put(parameterized, pd5);
                }
                continue;
            }
            if (parameterized.getDelegateAnnotation() != null) {
                Object delegateObject = parameterized.get(object);
                if (delegateObject == null) {
                    throw new ParameterException("Delegate field '" + parameterized.getName() + "' cannot be null.");
                }
                this.addDescription(delegateObject);
                continue;
            }
            if (wp4 == null || wp4.getDynamicParameter() == null) continue;
            DynamicParameter dp4 = wp4.getDynamicParameter();
            for (String name : dp4.names()) {
                if (this.descriptions.containsKey(name)) {
                    throw new ParameterException("Found the option " + name + " multiple times");
                }
                this.p("Adding description for " + name);
                ParameterDescription pd6 = new ParameterDescription(object, dp4, parameterized, this.options.bundle, this);
                this.fields.put(parameterized, pd6);
                this.descriptions.put(new StringKey(name), pd6);
                if (!dp4.required()) continue;
                this.requiredFields.put(parameterized, pd6);
            }
        }
    }

    private void initializeDefaultValue(ParameterDescription pd5) {
        for (String optionName : pd5.getParameter().names()) {
            String def = this.options.defaultProvider.getDefaultValueFor(optionName);
            if (def == null) continue;
            this.p("Initializing " + optionName + " with default value:" + def);
            pd5.addValue(def, true);
            this.requiredFields.remove(pd5.getParameterized());
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseValues(String[] args, boolean validate) {
        boolean commandParsed = false;
        int i15 = 0;
        boolean isDashDash = false;
        while (i15 < args.length && !commandParsed) {
            String a15;
            String arg = args[i15];
            if (arg.startsWith("@") && this.options.expandAtSign) {
                String fileName = arg.substring(1);
                List<String> fileArgs = this.readFile(fileName);
                String[] newArgs = new String[args.length + fileArgs.size() - 1];
                System.arraycopy(args, 0, newArgs, 0, i15);
                System.arraycopy(fileArgs.toArray(), 0, newArgs, i15, fileArgs.size());
                System.arraycopy(args, i15 + 1, newArgs, i15 + fileArgs.size(), args.length - i15 - 1);
                args = newArgs;
                continue;
            }
            args[i15] = a15 = JCommander.trim(arg);
            this.p("Parsing arg: " + a15);
            JCommander jc5 = this.findCommandByAlias(arg);
            int increment = 1;
            if (!isDashDash && !"--".equals(a15) && this.isOption(a15) && jc5 == null) {
                ParameterDescription pd5 = this.findParameterDescription(a15);
                if (pd5 != null) {
                    if (pd5.getParameter().password()) {
                        increment = this.processPassword(args, i15, pd5, validate);
                    } else if (pd5.getParameter().variableArity()) {
                        increment = this.processVariableArity(args, i15, pd5, validate);
                    } else {
                        Class<?> clazz = pd5.getParameterized().getType();
                        if (pd5.getParameter().arity() == -1 && this.isBooleanType(clazz)) {
                            this.handleBooleanOption(pd5, clazz);
                        } else {
                            increment = this.processFixedArity(args, i15, pd5, validate, clazz);
                        }
                        if (pd5.isHelp()) {
                            this.helpWasSpecified = true;
                        }
                    }
                } else {
                    if (!this.options.acceptUnknownOptions) throw new ParameterException("Unknown option: " + arg);
                    this.unknownArgs.add(arg);
                    ++i15;
                    while (i15 < args.length && !this.isOption(args[i15])) {
                        this.unknownArgs.add(args[i15++]);
                    }
                    increment = 0;
                }
            } else if ("--".equals(arg) && !isDashDash) {
                isDashDash = true;
            } else if (this.commands.isEmpty()) {
                void var11_19;
                ParameterizedType p15;
                Type cls;
                Type genericType;
                this.initMainParameterValue(arg);
                String value = a15;
                for (Class<? extends IParameterValidator> validator : this.mainParameter.annotation.validateWith()) {
                    this.mainParameter.description.validateParameter(validator, "Default", value);
                }
                String string = value;
                if (this.mainParameter.annotation.converter() != null && this.mainParameter.annotation.converter() != NoConverter.class) {
                    Object object = this.convertValue(this.mainParameter.parameterized, this.mainParameter.parameterized.getType(), null, value);
                }
                if ((genericType = this.mainParameter.parameterized.getGenericType()) instanceof ParameterizedType && (cls = (p15 = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
                    Object object = this.convertValue(this.mainParameter.parameterized, (Class)cls, null, value);
                }
                this.mainParameter.description.setAssigned(true);
                this.mainParameter.addValue(var11_19);
            } else {
                if (jc5 == null && validate) {
                    throw new MissingCommandException("Expected a command, got " + arg, arg);
                }
                if (jc5 != null) {
                    this.parsedCommand = jc5.programName.name;
                    this.parsedAlias = arg;
                    jc5.parse(validate, this.subArray(args, i15 + 1));
                    commandParsed = true;
                }
            }
            i15 += increment;
        }
        for (ParameterDescription parameterDescription : this.descriptions.values()) {
            if (parameterDescription.isAssigned()) {
                this.fields.get(parameterDescription.getParameterized()).setAssigned(true);
            }
            if (parameterDescription.getDefault() == null || parameterDescription.getParameterized().getType().isPrimitive()) continue;
            this.requiredFields.remove(parameterDescription.getParameterized());
        }
    }

    private boolean isBooleanType(Class<?> fieldType) {
        return Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType);
    }

    private void handleBooleanOption(ParameterDescription pd5, Class<?> fieldType) {
        Boolean value = (Boolean)pd5.getParameterized().get(pd5.getObject());
        if (value != null) {
            pd5.addValue(value != false ? "false" : "true");
        } else if (!fieldType.isPrimitive()) {
            pd5.addValue("true");
        }
        this.requiredFields.remove(pd5.getParameterized());
    }

    private final int determineArity(String[] args, int index, ParameterDescription pd5, IVariableArity va5) {
        List currentArgs = Lists.newArrayList();
        for (int j15 = index + 1; j15 < args.length; ++j15) {
            currentArgs.add(args[j15]);
        }
        return va5.processVariableArity(pd5.getParameter().names()[0], currentArgs.toArray(new String[0]));
    }

    private int processPassword(String[] args, int index, ParameterDescription pd5, boolean validate) {
        int passwordArity = this.determineArity(args, index, pd5, this.DEFAULT_VARIABLE_ARITY);
        if (passwordArity == 0) {
            char[] password = this.readPassword(pd5.getDescription(), pd5.getParameter().echoInput());
            pd5.addValue(new String(password));
            this.requiredFields.remove(pd5.getParameterized());
            return 1;
        }
        if (passwordArity == 1) {
            return this.processFixedArity(args, index, pd5, validate, List.class, 1);
        }
        throw new ParameterException("Password parameter must have at most 1 argument.");
    }

    private int processVariableArity(String[] args, int index, ParameterDescription pd5, boolean validate) {
        Object arg = pd5.getObject();
        IVariableArity va5 = !(arg instanceof IVariableArity) ? this.DEFAULT_VARIABLE_ARITY : (IVariableArity)arg;
        int arity = this.determineArity(args, index, pd5, va5);
        int result = this.processFixedArity(args, index, pd5, validate, List.class, arity);
        return result;
    }

    private int processFixedArity(String[] args, int index, ParameterDescription pd5, boolean validate, Class<?> fieldType) {
        int arity = pd5.getParameter().arity();
        int n15 = arity != -1 ? arity : 1;
        return this.processFixedArity(args, index, pd5, validate, fieldType, n15);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processFixedArity(String[] args, int originalIndex, ParameterDescription pd5, boolean validate, Class<?> fieldType, int arity) {
        int index = originalIndex;
        String arg = args[index];
        if (arity == 0 && this.isBooleanType(fieldType)) {
            this.handleBooleanOption(pd5, fieldType);
            return arity + 1;
        } else {
            if (arity == 0) {
                throw new ParameterException("Expected a value after parameter " + arg);
            }
            if (index >= args.length - 1) throw new ParameterException("Expected a value after parameter " + arg);
            int offset = "--".equals(args[index + 1]) ? 1 : 0;
            Object finalValue = null;
            if (index + arity >= args.length) throw new ParameterException("Expected " + arity + " values after " + arg);
            for (int j15 = 1; j15 <= arity; ++j15) {
                String value = args[index + j15 + offset];
                finalValue = pd5.addValue(arg, value, false, validate, j15 - 1);
                this.requiredFields.remove(pd5.getParameterized());
            }
            if (finalValue != null && validate) {
                pd5.validateValueParameter(arg, finalValue);
            }
            index += arity + offset;
        }
        return arity + 1;
    }

    private char[] readPassword(String description, boolean echoInput) {
        this.getConsole().print(description + ": ");
        return this.getConsole().readPassword(echoInput);
    }

    private String[] subArray(String[] args, int index) {
        int l15 = args.length - index;
        String[] result = new String[l15];
        System.arraycopy(args, index, result, 0, l15);
        return result;
    }

    private void initMainParameterValue(String arg) {
        if (this.mainParameter == null) {
            throw new ParameterException("Was passed main parameter '" + arg + "' but no main parameter was defined in your arg class");
        }
        Object object = this.mainParameter.parameterized.get(this.mainParameter.object);
        Class<?> type = this.mainParameter.parameterized.getType();
        if (List.class.isAssignableFrom(type)) {
            List result = object == null ? Lists.newArrayList() : (List)object;
            if (this.mainParameter.firstTimeMainParameter) {
                result.clear();
                this.mainParameter.firstTimeMainParameter = false;
            }
            this.mainParameter.multipleValue = result;
            this.mainParameter.parameterized.set(this.mainParameter.object, result);
        }
    }

    public String getMainParameterDescription() {
        if (this.descriptions == null) {
            this.createDescriptions();
        }
        return this.mainParameter == null ? null : (this.mainParameter.annotation != null ? this.mainParameter.annotation.description() : null);
    }

    public void setProgramName(String name) {
        this.setProgramName(name, new String[0]);
    }

    public String getProgramName() {
        return this.programName == null ? null : this.programName.getName();
    }

    public String getProgramDisplayName() {
        return this.programName == null ? null : this.programName.getDisplayName();
    }

    public void setProgramName(String name, String ... aliases) {
        this.programName = new ProgramName(name, Arrays.asList(aliases));
    }

    public void usage() {
        StringBuilder sb5 = new StringBuilder();
        this.usageFormatter.usage(sb5);
        this.getConsole().println(sb5.toString());
    }

    public void usage(String commandName) {
        StringBuilder sb5 = new StringBuilder();
        this.usageFormatter.usage(commandName, sb5);
        this.getConsole().println(sb5.toString());
    }

    public void usage(String commandName, StringBuilder out) {
        this.usageFormatter.usage(commandName, out, "");
    }

    public void usage(String commandName, StringBuilder out, String indent) {
        this.usageFormatter.usage(commandName, out, indent);
    }

    public void usage(StringBuilder out) {
        this.usageFormatter.usage(out, "");
    }

    public void usage(StringBuilder out, String indent) {
        this.usageFormatter.usage(out, indent);
    }

    public void setUsageFormatter(IUsageFormatter usageFormatter) {
        if (usageFormatter == null) {
            throw new IllegalArgumentException("Argument UsageFormatter must not be null");
        }
        this.usageFormatter = usageFormatter;
    }

    public IUsageFormatter getUsageFormatter() {
        return this.usageFormatter;
    }

    public Options getOptions() {
        return this.options;
    }

    public Map<FuzzyMap.IKey, ParameterDescription> getDescriptions() {
        return this.descriptions;
    }

    public IMainParameter getMainParameter() {
        return this.mainParameter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<Parameterized, ParameterDescription> getFields() {
        return this.fields;
    }

    public Comparator<? super ParameterDescription> getParameterDescriptionComparator() {
        return this.options.parameterDescriptionComparator;
    }

    public void setParameterDescriptionComparator(Comparator<? super ParameterDescription> c15) {
        this.options.parameterDescriptionComparator = c15;
    }

    public void setColumnSize(int columnSize) {
        this.options.columnSize = columnSize;
    }

    public int getColumnSize() {
        return this.options.columnSize;
    }

    public ResourceBundle getBundle() {
        return this.options.bundle;
    }

    public List<ParameterDescription> getParameters() {
        return new ArrayList<ParameterDescription>(this.fields.values());
    }

    public ParameterDescription getMainParameterValue() {
        return this.mainParameter == null ? null : this.mainParameter.description;
    }

    private void p(String string) {
        if (this.options.verbose > 0 || System.getProperty(DEBUG_PROPERTY) != null) {
            this.getConsole().println("[JCommander] " + string);
        }
    }

    public void setDefaultProvider(IDefaultProvider defaultProvider) {
        this.options.defaultProvider = defaultProvider;
    }

    public void addConverterFactory(final IStringConverterFactory converterFactory) {
        this.addConverterInstanceFactory(new IStringConverterInstanceFactory(){

            @Override
            public IStringConverter<?> getConverterInstance(Parameter parameter, Class<?> forType, String optionName) {
                Class<? extends IStringConverter<?>> converterClass = converterFactory.getConverter(forType);
                try {
                    if (optionName == null) {
                        optionName = parameter.names().length > 0 ? parameter.names()[0] : "[Main class]";
                    }
                    return converterClass != null ? JCommander.instantiateConverter(optionName, converterClass) : null;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e15) {
                    throw new ParameterException(e15);
                }
            }
        });
    }

    public void addConverterInstanceFactory(IStringConverterInstanceFactory converterInstanceFactory) {
        this.options.converterInstanceFactories.add(0, converterInstanceFactory);
    }

    private IStringConverter<?> findConverterInstance(Parameter parameter, Class<?> forType, String optionName) {
        for (IStringConverterInstanceFactory f15 : this.options.converterInstanceFactories) {
            IStringConverter<?> result = f15.getConverterInstance(parameter, forType, optionName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object convertValue(final Parameterized parameterized, Class type, String optionName, String value) {
        Parameter annotation = parameterized.getParameter();
        if (annotation == null) {
            return value;
        }
        if (optionName == null) {
            optionName = annotation.names().length > 0 ? annotation.names()[0] : "[Main class]";
        }
        IStringConverter<String> converter = null;
        if (type.isAssignableFrom(List.class) || type.isAssignableFrom(Set.class)) {
            converter = JCommander.tryInstantiateConverter(optionName, annotation.listConverter());
        }
        if ((type.isAssignableFrom(List.class) || type.isAssignableFrom(Set.class)) && converter == null) {
            IParameterSplitter splitter = JCommander.tryInstantiateConverter(null, annotation.splitter());
            converter = new DefaultListConverter(splitter, new IStringConverter(){

                public Object convert(String value) {
                    Type genericType = parameterized.findFieldGenericType();
                    return JCommander.this.convertValue(parameterized, genericType instanceof Class ? (Class)genericType : String.class, null, value);
                }
            });
        }
        if (converter == null) {
            converter = JCommander.tryInstantiateConverter(optionName, annotation.converter());
        }
        if (converter == null) {
            converter = this.findConverterInstance(annotation, type, optionName);
        }
        if (converter == null && type.isEnum()) {
            converter = new EnumConverter(optionName, type);
        }
        if (converter == null) {
            converter = new StringConverter();
        }
        return converter.convert(value);
    }

    private static <T> T tryInstantiateConverter(String optionName, Class<T> converterClass) {
        if (converterClass == NoConverter.class || converterClass == null) {
            return null;
        }
        try {
            return JCommander.instantiateConverter(optionName, converterClass);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ignore) {
            return null;
        }
    }

    private static <T> T instantiateConverter(String optionName, Class<? extends T> converterClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> ctor = null;
        Constructor<?> stringCtor = null;
        for (Constructor<?> c15 : converterClass.getDeclaredConstructors()) {
            c15.setAccessible(true);
            Class<?>[] types = c15.getParameterTypes();
            if (types.length == 1 && types[0].equals(String.class)) {
                stringCtor = c15;
                continue;
            }
            if (types.length != 0) continue;
            ctor = c15;
        }
        return stringCtor != null ? (T)stringCtor.newInstance(optionName) : (ctor != null ? (T)ctor.newInstance(new Object[0]) : null);
    }

    public void addCommand(String name, Object object) {
        this.addCommand(name, object, new String[0]);
    }

    public void addCommand(Object object) {
        Parameters p15 = object.getClass().getAnnotation(Parameters.class);
        if (p15 != null && p15.commandNames().length > 0) {
            for (String commandName : p15.commandNames()) {
                this.addCommand(commandName, object);
            }
        } else {
            throw new ParameterException("Trying to add command " + object.getClass().getName() + " without specifying its names in @Parameters");
        }
    }

    public void addCommand(String name, Object object, String ... aliases) {
        JCommander jc5 = new JCommander(this.options);
        jc5.addObject(object);
        jc5.createDescriptions();
        jc5.setProgramName(name, aliases);
        ProgramName progName = jc5.programName;
        this.commands.put(progName, jc5);
        this.aliasMap.put(new StringKey(name), progName);
        for (String a15 : aliases) {
            StringKey alias = new StringKey(a15);
            if (((Object)alias).equals(name)) continue;
            ProgramName mappedName = this.aliasMap.get(alias);
            if (mappedName != null && !mappedName.equals(progName)) {
                throw new ParameterException("Cannot set alias " + alias + " for " + name + " command because it has already been defined for " + mappedName.name + " command");
            }
            this.aliasMap.put(alias, progName);
        }
    }

    public Map<String, JCommander> getCommands() {
        Map<String, JCommander> res = Maps.newLinkedHashMap();
        for (Map.Entry<ProgramName, JCommander> entry : this.commands.entrySet()) {
            res.put(entry.getKey().name, entry.getValue());
        }
        return res;
    }

    public Map<ProgramName, JCommander> getRawCommands() {
        Map<ProgramName, JCommander> res = Maps.newLinkedHashMap();
        for (Map.Entry<ProgramName, JCommander> entry : this.commands.entrySet()) {
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }

    public String getParsedCommand() {
        return this.parsedCommand;
    }

    public String getParsedAlias() {
        return this.parsedAlias;
    }

    private String s(int count) {
        StringBuilder result = new StringBuilder();
        for (int i15 = 0; i15 < count; ++i15) {
            result.append(" ");
        }
        return result.toString();
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    private ParameterDescription findParameterDescription(String arg) {
        return FuzzyMap.findInMap(this.descriptions, new StringKey(arg), this.options.caseSensitiveOptions, this.options.allowAbbreviatedOptions);
    }

    private JCommander findCommand(ProgramName name) {
        return FuzzyMap.findInMap(this.commands, name, this.options.caseSensitiveOptions, this.options.allowAbbreviatedOptions);
    }

    private ProgramName findProgramName(String name) {
        return FuzzyMap.findInMap(this.aliasMap, new StringKey(name), this.options.caseSensitiveOptions, this.options.allowAbbreviatedOptions);
    }

    public JCommander findCommandByAlias(String commandOrAlias) {
        ProgramName progName = this.findProgramName(commandOrAlias);
        if (progName == null) {
            return null;
        }
        JCommander jc5 = this.findCommand(progName);
        if (jc5 == null) {
            throw new IllegalStateException("There appears to be inconsistency in the internal command database.  This is likely a bug. Please report.");
        }
        return jc5;
    }

    public void setVerbose(int verbose) {
        this.options.verbose = verbose;
    }

    public void setCaseSensitiveOptions(boolean b15) {
        this.options.caseSensitiveOptions = b15;
    }

    public void setAllowAbbreviatedOptions(boolean b15) {
        this.options.allowAbbreviatedOptions = b15;
    }

    public void setAcceptUnknownOptions(boolean b15) {
        this.options.acceptUnknownOptions = b15;
    }

    public List<String> getUnknownOptions() {
        return this.unknownArgs;
    }

    public void setAllowParameterOverwriting(boolean b15) {
        this.options.allowParameterOverwriting = b15;
    }

    public boolean isParameterOverwritingAllowed() {
        return this.options.allowParameterOverwriting;
    }

    public void setAtFileCharset(Charset charset) {
        this.options.atFileCharset = charset;
    }

    public static final class ProgramName
    implements FuzzyMap.IKey {
        private final String name;
        private final List<String> aliases;

        ProgramName(String name, List<String> aliases) {
            this.name = name;
            this.aliases = aliases;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            StringBuilder sb5 = new StringBuilder();
            sb5.append(this.name);
            if (!this.aliases.isEmpty()) {
                sb5.append("(");
                Iterator<String> aliasesIt = this.aliases.iterator();
                while (aliasesIt.hasNext()) {
                    sb5.append(aliasesIt.next());
                    if (!aliasesIt.hasNext()) continue;
                    sb5.append(",");
                }
                sb5.append(")");
            }
            return sb5.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProgramName other = (ProgramName)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public static class Builder {
        private JCommander jCommander = new JCommander();
        private String[] args = null;

        public Builder addObject(Object o15) {
            this.jCommander.addObject(o15);
            return this;
        }

        public Builder resourceBundle(ResourceBundle bundle) {
            this.jCommander.setDescriptionsBundle(bundle);
            return this;
        }

        public Builder args(String[] args) {
            this.args = args;
            return this;
        }

        public Builder console(Console console) {
            this.jCommander.setConsole(console);
            return this;
        }

        public Builder expandAtSign(Boolean expand2) {
            this.jCommander.setExpandAtSign(expand2);
            return this;
        }

        public Builder programName(String name) {
            this.jCommander.setProgramName(name);
            return this;
        }

        public Builder columnSize(int columnSize) {
            this.jCommander.setColumnSize(columnSize);
            return this;
        }

        public Builder defaultProvider(IDefaultProvider provider) {
            this.jCommander.setDefaultProvider(provider);
            return this;
        }

        public Builder addConverterFactory(IStringConverterFactory factory) {
            this.jCommander.addConverterFactory(factory);
            return this;
        }

        public Builder verbose(int verbose) {
            this.jCommander.setVerbose(verbose);
            return this;
        }

        public Builder allowAbbreviatedOptions(boolean b15) {
            this.jCommander.setAllowAbbreviatedOptions(b15);
            return this;
        }

        public Builder acceptUnknownOptions(boolean b15) {
            this.jCommander.setAcceptUnknownOptions(b15);
            return this;
        }

        public Builder allowParameterOverwriting(boolean b15) {
            this.jCommander.setAllowParameterOverwriting(b15);
            return this;
        }

        public Builder atFileCharset(Charset charset) {
            this.jCommander.setAtFileCharset(charset);
            return this;
        }

        public Builder addConverterInstanceFactory(IStringConverterInstanceFactory factory) {
            this.jCommander.addConverterInstanceFactory(factory);
            return this;
        }

        public Builder addCommand(Object command) {
            this.jCommander.addCommand(command);
            return this;
        }

        public Builder addCommand(String name, Object command, String ... aliases) {
            this.jCommander.addCommand(name, command, aliases);
            return this;
        }

        public Builder usageFormatter(IUsageFormatter usageFormatter) {
            this.jCommander.setUsageFormatter(usageFormatter);
            return this;
        }

        public JCommander build() {
            if (this.args != null) {
                this.jCommander.parse(this.args);
            }
            return this.jCommander;
        }
    }

    private class DefaultVariableArity
    implements IVariableArity {
        private DefaultVariableArity() {
        }

        @Override
        public int processVariableArity(String optionName, String[] options) {
            int i15;
            for (i15 = 0; i15 < options.length && !JCommander.this.isNamedOption(options[i15]); ++i15) {
            }
            return i15;
        }
    }

    private static class Options {
        private ResourceBundle bundle;
        private IDefaultProvider defaultProvider;
        private Comparator<? super ParameterDescription> parameterDescriptionComparator = new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription p05, ParameterDescription p15) {
                WrappedParameter a05 = p05.getParameter();
                WrappedParameter a15 = p15.getParameter();
                if (a05 != null && a15 != null && !a05.category().equals(a15.category())) {
                    return a05.category().compareTo(a15.category());
                }
                if (a05 != null && a05.order() != -1 && a15 != null && a15.order() != -1) {
                    int comp = Integer.compare(a05.order(), a15.order());
                    return comp != 0 ? comp : p05.getLongestName().compareTo(p15.getLongestName());
                }
                if (a05 != null && a05.order() != -1) {
                    return -1;
                }
                if (a15 != null && a15.order() != -1) {
                    return 1;
                }
                return p05.getLongestName().compareTo(p15.getLongestName());
            }
        };
        private int columnSize = 79;
        private boolean acceptUnknownOptions = false;
        private boolean allowParameterOverwriting = false;
        private boolean expandAtSign = true;
        private int verbose = 0;
        private boolean caseSensitiveOptions = true;
        private boolean allowAbbreviatedOptions = false;
        private final List<IStringConverterInstanceFactory> converterInstanceFactories = new CopyOnWriteArrayList<IStringConverterInstanceFactory>();
        private Charset atFileCharset = Charset.defaultCharset();

        private Options() {
        }
    }

    static class MainParameter
    implements IMainParameter {
        Parameterized parameterized;
        Object object;
        private Parameter annotation;
        private ParameterDescription description;
        private List<Object> multipleValue = null;
        private Object singleValue = null;
        private boolean firstTimeMainParameter = true;

        MainParameter() {
        }

        @Override
        public ParameterDescription getDescription() {
            return this.description;
        }

        public void addValue(Object convertedValue) {
            if (this.multipleValue != null) {
                this.multipleValue.add(convertedValue);
            } else {
                if (this.singleValue != null) {
                    throw new ParameterException("Only one main parameter allowed but found several: \"" + this.singleValue + "\" and \"" + convertedValue + "\"");
                }
                this.singleValue = convertedValue;
                this.parameterized.set(this.object, convertedValue);
            }
        }
    }
}

