/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.pool;

import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.writer.pool.PoolMethod;
import com.android.tools.smali.dexlib2.writer.pool.TypeListPool;
import com.android.tools.smali.util.ArraySortedSet;
import com.android.tools.smali.util.CollectionUtils;
import com.android.tools.smali.util.IteratorUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class PoolClassDef
extends BaseTypeReference
implements ClassDef {
    @Nonnull
    final ClassDef classDef;
    @Nonnull
    final TypeListPool.Key<List<String>> interfaces;
    @Nonnull
    final SortedSet<Field> staticFields;
    @Nonnull
    final SortedSet<Field> instanceFields;
    @Nonnull
    final SortedSet<PoolMethod> directMethods;
    @Nonnull
    final SortedSet<PoolMethod> virtualMethods;
    int classDefIndex = -1;
    int annotationDirectoryOffset = 0;

    PoolClassDef(@Nonnull ClassDef classDef) {
        this.classDef = classDef;
        this.interfaces = new TypeListPool.Key<List<String>>(Collections.unmodifiableList(new ArrayList<String>(classDef.getInterfaces())));
        this.staticFields = ArraySortedSet.copyOf(CollectionUtils.naturalOrdering(), IteratorUtils.toList(classDef.getStaticFields()));
        this.instanceFields = ArraySortedSet.copyOf(CollectionUtils.naturalOrdering(), IteratorUtils.toList(classDef.getInstanceFields()));
        this.directMethods = ArraySortedSet.copyOf(CollectionUtils.naturalOrdering(), IteratorUtils.toList(classDef.getDirectMethods()).stream().map(PoolMethod.TRANSFORM).collect(Collectors.toList()));
        this.virtualMethods = ArraySortedSet.copyOf(CollectionUtils.naturalOrdering(), IteratorUtils.toList(classDef.getVirtualMethods()).stream().map(PoolMethod.TRANSFORM).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public String getType() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.classDef.getAccessFlags();
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.classDef.getSuperclass();
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        return (List)this.interfaces.types;
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.classDef.getSourceFile();
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        return this.classDef.getAnnotations();
    }

    @Nonnull
    public SortedSet<Field> getStaticFields() {
        return this.staticFields;
    }

    @Nonnull
    public SortedSet<Field> getInstanceFields() {
        return this.instanceFields;
    }

    @Nonnull
    public Collection<Field> getFields() {
        return new AbstractCollection<Field>(){

            @Override
            @Nonnull
            public Iterator<Field> iterator() {
                ArrayList<Field> fields2 = new ArrayList<Field>(PoolClassDef.this.staticFields);
                fields2.addAll(PoolClassDef.this.instanceFields);
                fields2.sort(CollectionUtils.naturalOrdering());
                return fields2.iterator();
            }

            @Override
            public int size() {
                return PoolClassDef.this.staticFields.size() + PoolClassDef.this.instanceFields.size();
            }
        };
    }

    @Nonnull
    public SortedSet<PoolMethod> getDirectMethods() {
        return this.directMethods;
    }

    @Nonnull
    public SortedSet<PoolMethod> getVirtualMethods() {
        return this.virtualMethods;
    }

    @Nonnull
    public Collection<PoolMethod> getMethods() {
        return new AbstractCollection<PoolMethod>(){

            @Override
            @Nonnull
            public Iterator<PoolMethod> iterator() {
                ArrayList<PoolMethod> methods2 = new ArrayList<PoolMethod>(PoolClassDef.this.directMethods);
                methods2.addAll(PoolClassDef.this.virtualMethods);
                methods2.sort(CollectionUtils.naturalOrdering());
                return methods2.iterator();
            }

            @Override
            public int size() {
                return PoolClassDef.this.directMethods.size() + PoolClassDef.this.virtualMethods.size();
            }
        };
    }
}

