/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.raw.EncodedValue;
import com.android.tools.smali.dexlib2.dexbacked.raw.MapItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.SectionAnnotator;
import com.android.tools.smali.dexlib2.dexbacked.raw.util.DexAnnotator;
import com.android.tools.smali.dexlib2.util.AnnotatedBytes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnnotationItem {
    public static final int VISIBILITY_OFFSET = 0;
    public static final int ANNOTATION_OFFSET = 1;

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "annotation_item";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                int visibility2 = this.dexFile.getBuffer().readUbyte(out.getCursor());
                out.annotate(1, "visibility = %d: %s", visibility2, AnnotationItem.getAnnotationVisibility(visibility2));
                DexReader<? extends DexBuffer> reader = this.dexFile.getBuffer().readerAt(out.getCursor());
                EncodedValue.annotateEncodedAnnotation(this.dexFile, out, reader);
            }
        };
    }

    private static String getAnnotationVisibility(int visibility2) {
        switch (visibility2) {
            case 0: {
                return "build";
            }
            case 1: {
                return "runtime";
            }
            case 2: {
                return "system";
            }
        }
        return "invalid visibility";
    }

    public static String getReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int annotationItemOffset) {
        try {
            DexReader<? extends DexBuffer> reader = dexFile.getDataBuffer().readerAt(annotationItemOffset);
            reader.readUbyte();
            int typeIndex = reader.readSmallUleb128();
            String annotationType = (String)dexFile.getTypeSection().get(typeIndex);
            return String.format("annotation_item[0x%x]: %s", annotationItemOffset, annotationType);
        }
        catch (Exception ex4) {
            ex4.printStackTrace(System.err);
            return String.format("annotation_item[0x%x]", annotationItemOffset);
        }
    }
}

