/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.function.Supplier;

public final class Password {
    private final Supplier<KeyStore.PasswordProtection> passwordSupplier;

    public Password(Supplier<KeyStore.PasswordProtection> passwordSupplier) {
        this.passwordSupplier = passwordSupplier;
    }

    @VisibleForTesting
    public static Password createForTest(String password) {
        return new Password(() -> new KeyStore.PasswordProtection(password.toCharArray()));
    }

    public final KeyStore.PasswordProtection getValue() {
        return this.passwordSupplier.get();
    }

    public static Password createFromStringValue(String value) {
        if (value.startsWith("pass:")) {
            return new Password(() -> new KeyStore.PasswordProtection(value.substring("pass:".length()).toCharArray()));
        }
        if (value.startsWith("file:")) {
            Path passwordFile = Paths.get(value.substring("file:".length()), new String[0]);
            FilePreconditions.checkFileExistsAndReadable(passwordFile);
            return new Password(() -> new KeyStore.PasswordProtection(Password.readPasswordFromFile(passwordFile).toCharArray()));
        }
        throw new IllegalArgumentException("Passwords must be prefixed with \"pass:\" or \"file:\".");
    }

    private static String readPasswordFromFile(Path passwordFile) {
        try {
            return MoreFiles.asCharSource(passwordFile, StandardCharsets.UTF_8, new OpenOption[0]).readFirstLine();
        }
        catch (IOException e15) {
            throw new UncheckedIOException(String.format("Unable to read password from file '%s'.", passwordFile), e15);
        }
    }
}

