/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.model.exceptions.BundleToolException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class ConcurrencyUtils {
    public static <T> ImmutableList<T> waitForAll(Iterable<ListenableFuture<T>> futures) {
        try {
            return ImmutableList.copyOf((Collection)ConcurrencyUtils.waitFor(Futures.allAsList(futures)));
        }
        catch (RuntimeException e15) {
            try {
                ConcurrencyUtils.waitFor(Futures.whenAllComplete(futures).call(() -> null, MoreExecutors.directExecutor()));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e15;
        }
    }

    public static <K, V> ImmutableMap<K, V> waitForAll(Map<K, ListenableFuture<V>> futures) {
        ImmutableMap.Builder finishedMap = ImmutableMap.builder();
        for (Map.Entry<K, ListenableFuture<V>> entry : futures.entrySet()) {
            finishedMap.put(entry.getKey(), ConcurrencyUtils.waitFor((Future)entry.getValue()));
        }
        return finishedMap.build();
    }

    private static <T> T waitFor(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e15) {
            if (e15.getCause() instanceof IOException) {
                throw new UncheckedIOException(e15.getCause().getMessage(), (IOException)e15.getCause());
            }
            if (e15.getCause() instanceof UncheckedIOException) {
                throw (UncheckedIOException)e15.getCause();
            }
            if (e15.getCause() instanceof BundleToolException) {
                throw (BundleToolException)e15.getCause();
            }
            throw new RuntimeException(e15.getMessage(), e15);
        }
        catch (InterruptedException e16) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("One operation was interrupted.", e16);
        }
    }

    private ConcurrencyUtils() {
    }
}

