/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class HttpUtil {
    URL url;
    HttpURLConnection conn;
    RequestMethod requestMethod;
    Map<String, String> headerMap = new HashMap<String, String>(2);

    public HttpUtil(RequestMethod requestMethod, URL url) {
        this.requestMethod = requestMethod;
        this.url = url;
    }

    public HttpUtil(RequestMethod requestMethod, String urlStr) throws MalformedURLException {
        this(requestMethod, new URL(urlStr));
    }

    Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public HttpURLConnection connectTextTxt() {
        return this.connectType("text/txt;charset=utf-8");
    }

    public HttpURLConnection connectTextPlain() {
        return this.connectType("text/plain; charset=utf-8");
    }

    public HttpURLConnection connectType(String acceptType) {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
            conn.setRequestMethod(this.requestMethod.name());
            this.headerMap.forEach((h15, v15) -> conn.setRequestProperty((String)h15, (String)v15));
            conn.setRequestProperty("Accept", acceptType);
            if (this.requestMethod == RequestMethod.POST) {
                conn.setDoOutput(true);
            }
            conn.connect();
            return conn;
        }
        catch (IOException e15) {
            e15.printStackTrace();
            return null;
        }
    }

    public String readResponse(HttpURLConnection conn) {
        if (conn == null) {
            return null;
        }
        try {
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                return this.innerReadResponse(conn);
            }
            System.out.println("status=" + responseCode + " Failed response");
            return null;
        }
        catch (IOException e15) {
            System.out.println("url=" + this.url.toString() + " failed to read status");
            e15.printStackTrace();
            return null;
        }
    }

    private String innerReadResponse(HttpURLConnection conn) {
        String string;
        block9: {
            InputStream is4 = conn.getInputStream();
            try {
                String inputLine;
                BufferedReader in4 = new BufferedReader(new InputStreamReader(is4, StandardCharsets.UTF_8));
                StringBuffer buffer = new StringBuffer();
                while ((inputLine = in4.readLine()) != null) {
                    buffer.append(inputLine);
                }
                string = buffer.toString();
                if (is4 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is4 != null) {
                        try {
                            is4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e15) {
                    e15.printStackTrace();
                    return null;
                }
            }
            is4.close();
        }
        return string;
    }

    public boolean post(HttpURLConnection conn, String str) {
        boolean bl4;
        block10: {
            if (conn == null) {
                System.out.println("null HttpURLConnection object");
                return false;
            }
            if (this.requestMethod != RequestMethod.POST) {
                System.out.println("Incorrect request method " + this.requestMethod.name());
                return false;
            }
            OutputStream os4 = conn.getOutputStream();
            try {
                OutputStreamWriter wr4 = new OutputStreamWriter(os4);
                wr4.write(str);
                wr4.flush();
                bl4 = true;
                if (os4 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (os4 != null) {
                        try {
                            os4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e15) {
                    e15.printStackTrace();
                    return false;
                }
            }
            os4.close();
        }
        return bl4;
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

