/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectMultiMaplet;

final class IntObjectTransientMultiMaplet<V>
extends IntObjectMultiMaplet<V> {
    private final Int2ObjectOpenHashMap<Collection<V>> myMap = new Int2ObjectOpenHashMap();
    private final Supplier<? extends Collection<V>> myCollectionFactory;

    IntObjectTransientMultiMaplet(Supplier<? extends Collection<V>> collectionFactory) {
        this.myCollectionFactory = collectionFactory;
    }

    @Override
    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public Collection<V> get(int key) {
        return (Collection)this.myMap.get(key);
    }

    @Override
    public void putAll(IntObjectMultiMaplet<V> m) {
        m.forEachEntry((vs, value) -> this.put(value, (V)vs));
    }

    @Override
    public void put(int key, Collection<V> value) {
        Collection x = (Collection)this.myMap.get(key);
        if (x == null) {
            this.myMap.put(key, value);
        } else {
            x.addAll(value);
        }
    }

    @Override
    public void replace(int key, Collection<V> value) {
        if (value == null || value.isEmpty()) {
            this.myMap.remove(key);
        } else {
            this.myMap.put(key, value);
        }
    }

    @Override
    public void put(int key, V value) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection == null) {
            Collection<V> x = this.myCollectionFactory.get();
            x.add(value);
            this.myMap.put(key, x);
        } else {
            collection.add(value);
        }
    }

    @Override
    public void removeFrom(int key, V value) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection != null && collection.remove(value) && collection.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    @Override
    public void removeAll(int key, Collection<V> values) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection != null && collection.removeAll(values) && collection.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    @Override
    public void remove(int key) {
        this.myMap.remove(key);
    }

    @Override
    public void replaceAll(IntObjectMultiMaplet<V> m) {
        m.forEachEntry((vs, value) -> this.replace(value, (Collection<V>)vs));
    }

    @Override
    void forEachEntry(ObjIntConsumer<? super Collection<V>> procedure) {
        this.myMap.int2ObjectEntrySet().fastForEach(entry -> procedure.accept((Object)entry.getValue(), entry.getIntKey()));
    }

    @Override
    public void close() {
        this.myMap.clear();
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
    }
}

