/*******************************************************************************
* Copyright 2001-2023 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!    vmlSetErrorCallBack/vmlGetErrorCallBack/vmlClearErrorCallBack  Example
!    Program Text
!******************************************************************************/

#include <stdio.h>
#include <string.h>

#include "mkl.h"

/**
 * @brief Callback function for VM
 *
 * Defines callback function for VM
 *
 * @param[in,out]  pdefVmlErrorContext] Callback context
 *
 */
int UserCallBack(DefVmlErrorContext* pdefVmlErrorContext)
{
    /* Check if function name contains Ln and argument is 0.0 */
    if ((strstr(pdefVmlErrorContext->cFuncName, "Ln")) && 
               (pdefVmlErrorContext->dbA1 == 0.0))
    {
        double dbNewR = -7.0e77; /* Some negative big value */
        fprintf(stdout, "\t\tInside callback: Function %s, argument a[%d]=%lg, computed result %lg to be replaced by %lg\n",
            pdefVmlErrorContext->cFuncName,
            pdefVmlErrorContext->iIndex,
            pdefVmlErrorContext->dbA1,
            pdefVmlErrorContext->dbR1,
            dbNewR);

        /* Replace Inf result by some negative big value */
        pdefVmlErrorContext->dbR1 = dbNewR;
    }

    return 0;
}

/**
 * @brief Main function for callback test
 *
 * Main performs simple test of callback feature
 *
 * @param[in] argc         Number of arguments
 * @param[in] argv         Pointer to argument strings
 * @return                 -1 for FAIL or 0 for PASS
 *
 */
int main (int argc, char **argv)
{
  int ret = VML_STATUS_OK;
  VMLErrorCallBack errcb;
  double dbA = 0.0;
  double dbR = 0.0;

  fprintf (stdout, "classic c vm_callback: started...\n"); fflush (stdout);

  errcb=vmlGetErrorCallBack();
  fprintf(stdout, "\tInitial adress of CallBack function: 0x%p\n",errcb);

  errcb=UserCallBack;

  vmlSetErrorCallBack(errcb);
  errcb=vmlGetErrorCallBack();

  fprintf(stdout, "\tAddress of CallBack function after using Set CallBack: 0x%p\n",errcb);
  fprintf(stdout, "\tTest user callback on vdLn function called on argument %lg\n", dbA);

  vdLn(1, &dbA, &dbR);

  fprintf(stdout, "\tFunction %s argument: %lg, result: %lg\n", "vdLn", dbA, dbR);

  vmlClearErrorCallBack();
  errcb=vmlGetErrorCallBack();

  fprintf(stdout, "\tAddress of CallBack function after using Clear CallBack: 0x%p\n",errcb);

  ret = (vmlGetErrStatus() < VML_STATUS_OK)?-1:0;
  fprintf (stdout, "classic c vm_callback: %s\n\n", (ret)?"FAIL":"PASS");
  return ret;
}

