/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.INTERNAL, since="5.1")
public class DynamicDescendantFilter
implements BiPredicate<UniqueId, Integer> {
    private final Set<UniqueId> allowedUniqueIds = new HashSet<UniqueId>();
    private final Set<Integer> allowedIndices = new HashSet<Integer>();
    private Mode mode = Mode.EXPLICIT;

    public void allowUniqueIdPrefix(UniqueId uniqueId) {
        if (this.mode == Mode.EXPLICIT) {
            this.allowedUniqueIds.add(uniqueId);
        }
    }

    public void allowIndex(int index) {
        if (this.mode == Mode.EXPLICIT) {
            this.allowedIndices.add(index);
        }
    }

    public void allowIndex(Set<Integer> indices) {
        if (this.mode == Mode.EXPLICIT) {
            this.allowedIndices.addAll(indices);
        }
    }

    public void allowAll() {
        this.mode = Mode.ALLOW_ALL;
        this.allowedUniqueIds.clear();
        this.allowedIndices.clear();
    }

    @Override
    public boolean test(UniqueId uniqueId, Integer index) {
        return this.isEverythingAllowed() || this.isUniqueIdAllowed(uniqueId) || this.allowedIndices.contains(index);
    }

    private boolean isEverythingAllowed() {
        return this.allowedUniqueIds.isEmpty() && this.allowedIndices.isEmpty();
    }

    private boolean isUniqueIdAllowed(UniqueId uniqueId) {
        return this.allowedUniqueIds.stream().anyMatch(allowedUniqueId -> this.isPrefixOrViceVersa(uniqueId, (UniqueId)allowedUniqueId));
    }

    private boolean isPrefixOrViceVersa(UniqueId currentUniqueId, UniqueId allowedUniqueId) {
        return allowedUniqueId.hasPrefix(currentUniqueId) || currentUniqueId.hasPrefix(allowedUniqueId);
    }

    public DynamicDescendantFilter withoutIndexFiltering() {
        return new WithoutIndexFiltering();
    }

    public DynamicDescendantFilter copy(UnaryOperator<UniqueId> uniqueIdTransformer) {
        return this.configure(uniqueIdTransformer, new DynamicDescendantFilter());
    }

    protected DynamicDescendantFilter configure(UnaryOperator<UniqueId> uniqueIdTransformer, DynamicDescendantFilter copy) {
        this.allowedUniqueIds.stream().map(uniqueIdTransformer).forEach(copy.allowedUniqueIds::add);
        copy.allowedIndices.addAll(this.allowedIndices);
        copy.mode = this.mode;
        return copy;
    }

    private static enum Mode {
        EXPLICIT,
        ALLOW_ALL;

    }

    private class WithoutIndexFiltering
    extends DynamicDescendantFilter {
        private WithoutIndexFiltering() {
        }

        @Override
        public boolean test(UniqueId uniqueId, Integer index) {
            return DynamicDescendantFilter.this.isEverythingAllowed() || DynamicDescendantFilter.this.isUniqueIdAllowed(uniqueId);
        }

        @Override
        public DynamicDescendantFilter withoutIndexFiltering() {
            return this;
        }

        @Override
        public DynamicDescendantFilter copy(UnaryOperator<UniqueId> uniqueIdTransformer) {
            return this.configure(uniqueIdTransformer, new WithoutIndexFiltering());
        }
    }
}

