import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useMemo } from 'react';
import '@grafana/data';
import { reportInteraction } from '@grafana/runtime';
import { useStyles2, Tooltip, Button } from '@grafana/ui';

const QueryBuilderHints = ({
  datasource,
  query: visualQuery,
  onChange,
  data,
  queryModeller,
  buildVisualQueryFromString,
  buildDataQueryFromQueryString,
  buildQueryStringFromDataQuery
}) => {
  const styles = useStyles2(getStyles);
  const hints = useMemo(() => {
    var _a;
    const dataQuery = buildDataQueryFromQueryString(queryModeller.renderQuery(visualQuery));
    const hints2 = (_a = datasource.getQueryHints) == null ? undefined : _a.call(datasource, dataQuery, (data == null ? undefined : data.series) || []).filter((hint) => {
      var _a2;
      return (_a2 = hint.fix) == null ? undefined : _a2.action;
    });
    return hints2 != null ? hints2 : [];
  }, [datasource, visualQuery, data, queryModeller, buildDataQueryFromQueryString]);
  return /* @__PURE__ */ jsx(Fragment, { children: hints.length > 0 && /* @__PURE__ */ jsx("div", { className: styles.container, children: hints.map((hint) => {
    var _a, _b, _c, _d;
    return /* @__PURE__ */ jsx(Tooltip, { content: `${hint.label} ${(_a = hint.fix) == null ? undefined : _a.label}`, children: /* @__PURE__ */ jsxs(
      Button,
      {
        onClick: () => {
          var _a2, _b2, _c2;
          reportInteraction("grafana_query_builder_hints_clicked", {
            hint: hint.type,
            datasourceType: datasource.type
          });
          if ((_a2 = hint == null ? undefined : hint.fix) == null ? undefined : _a2.action) {
            const dataQuery = buildDataQueryFromQueryString(queryModeller.renderQuery(visualQuery));
            const newQuery = (_b2 = datasource.modifyQuery) == null ? undefined : _b2.call(datasource, dataQuery, hint.fix.action);
            if (newQuery) {
              const newVisualQuery = buildVisualQueryFromString(
                (_c2 = buildQueryStringFromDataQuery(newQuery)) != null ? _c2 : ""
              );
              return onChange(newVisualQuery.query);
            }
          }
        },
        fill: "outline",
        size: "sm",
        className: styles.hint,
        children: [
          "hint: ",
          ((_b = hint.fix) == null ? undefined : _b.title) || ((_d = (_c = hint.fix) == null ? undefined : _c.action) == null ? undefined : _d.type.toLowerCase().replace("_", " "))
        ]
      }
    ) }, hint.type);
  }) }) });
};
QueryBuilderHints.displayName = "QueryBuilderHints";
const getStyles = (theme) => {
  return {
    container: css`
      display: flex;
      align-items: start;
    `,
    hint: css`
      margin-right: ${theme.spacing(1)};
    `
  };
};

export { QueryBuilderHints };
//# sourceMappingURL=QueryBuilderHints.js.map
