import { jsx, Fragment } from 'react/jsx-runtime';
import 'prismjs';
import { OperationExplainedBox } from './OperationExplainedBox.js';
import { RawQuery } from './RawQuery.js';
import 'react';
import '@grafana/data';

function OperationListExplained({
  query,
  queryModeller,
  stepNumber,
  language,
  onMouseEnter,
  onMouseLeave
}) {
  return /* @__PURE__ */ jsx(Fragment, { children: query.operations.map((op, index) => {
    var _a;
    const def = queryModeller.getOperationDefinition(op.id);
    if (!def) {
      return `Operation ${op.id} not found`;
    }
    const title = def.renderer(op, def, queryModeller.innerQueryPlaceholder);
    const body = def.explainHandler ? def.explainHandler(op, def) : (_a = def.documentation) != null ? _a : "no docs";
    return /* @__PURE__ */ jsx(
      "div",
      {
        onMouseEnter: () => onMouseEnter == null ? undefined : onMouseEnter(op, index),
        onMouseLeave: () => onMouseLeave == null ? undefined : onMouseLeave(op, index),
        children: /* @__PURE__ */ jsx(
          OperationExplainedBox,
          {
            stepNumber: index + stepNumber,
            title: /* @__PURE__ */ jsx(RawQuery, { query: title, language }),
            markdown: body
          }
        )
      },
      index
    );
  }) });
}

export { OperationListExplained };
//# sourceMappingURL=OperationListExplained.js.map
