import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { Input } from '@grafana/ui';
import { useState } from 'react';
import { DatePicker } from '../DatePicker/DatePicker.js';
import { getStyles } from './styles.js';
import { cx } from '@emotion/css';

const formatDate = (date) => date.toISOString().split("T")[0];
const DatePickerWithInput = (props) => {
  const { value, onChange, className, ...rest } = props;
  const [open, setOpen] = useState(false);
  const styles = getStyles();
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      Input,
      {
        type: "date",
        placeholder: "Date",
        value: formatDate(value || /* @__PURE__ */ new Date()),
        onClick: () => setOpen(true),
        onChange: () => {
        },
        className: cx(styles.input, className),
        ...rest
      }
    ),
    /* @__PURE__ */ jsx(DatePicker, { isOpen: open, value, onChange: (ev) => onChange(ev), onClose: () => setOpen(false) })
  ] });
};

export { DatePickerWithInput, formatDate };
//# sourceMappingURL=DatePickerWithInput.js.map
