#############################################################################
##
#W  good-ideals.gd          Manuel Delgado <mdelgado@fc.up.pt>
#W                          Pedro A. Garcia-Sanchez <pedro@ugr.es>
##
#Y  Copyright 2016-- Centro de Matemática da Universidade do Porto, Portugal and IEMath-GR, Universidad de Granada, Spain
#############################################################################

#############################################################################
##
#R  IsGoodIdealRep
##
##  The representation of an ideal of a good semigroup.
##
#############################################################################
DeclareRepresentation( "IsGoodIdealRep", IsAttributeStoringRep,
        [] );


#############################################################################
##
#C  IsGoodIdeal
##
##  The category of good ideals of good semigroups.
##
#############################################################################
DeclareCategory( "IsGoodIdeal", IsAdditiveMagma and IsGoodIdealRep);


# Elements of ideals of good semigroups are pairs of integers, so ideals of
# good semigroups are collections pairs of integers.
BindGlobal( "GoodIdealType",
        NewType( CollectionsFamily(CollectionsFamily(CyclotomicsFamily)),
                 IsGoodIdeal));


#############################################################################
##
#F Ideal(l,S)
##
## l is a list of integers and S a good semigroup
##
## returns the ideal of S generated by l.
##
#############################################################################
DeclareGlobalFunction("GoodIdeal");
#A
DeclareAttribute( "AmbientGS", IsGoodIdeal);


#############################################################################
##
#F  GoodGeneratingSystemOfGoodIdeal(I)
##
##  Returns a set of generators of the ideal I.
##  If a minimal generating system has already been computed, this
##  is the set returned.
############################################################################
DeclareGlobalFunction("GoodGeneratingSystemOfGoodIdeal");
#A
DeclareAttribute( "GoodGeneratorsIdealGS", IsGoodIdeal);


#############################################################################
##
#F AmbientGoodSemigroupOfIdeal(I)
##
##  Returns the ambient semigroup of the ideal I.
############################################################################
DeclareGlobalFunction("AmbientGoodSemigroupOfGoodIdeal");

#############################################################################
##
#F  IsIntegralIdeal(i)
##
##  Detects if the ideal i is contained in its ambient semigroup
##
#############################################################################
#DeclareGlobalFunction("IsIntegralIdeal");


#############################################################################
##
#F  BelongsToGoodIdeal(n,I)
##
##  Tests if the integer n belongs to the ideal I.
##
#############################################################################
DeclareOperation("BelongsToGoodIdeal",[IsHomogeneousList,IsGoodIdeal]);

#############################################################################
##
#F DifferenceOfdeals(I,J)
##
## returns the set difference I\J (J must be contained in I)
#############################################################################
#DeclareGlobalFunction("DifferenceOfGoodIdeals");


#############################################################################
##
#F MinimalGoodGeneratingSystemOfGoodIdeal(I)
##
## The argument I is an ideal of a good semigroup
## returns the minimal generating system of I.
##
#############################################################################
DeclareGlobalFunction("MinimalGoodGeneratingSystemOfGoodIdeal");
DeclareAttribute("MinimalGoodGeneratorsIdealGS", IsGoodIdeal);


#############################################################################
##
#A SmallElementsOfGoodIdeal
##
##  Returns the list of elements in the ideal I
##
#############################################################################
DeclareAttribute( "SmallElements", IsGoodIdeal);
DeclareSynonymAttr( "SmallElementsOfGoodIdeal", SmallElements);
#############################################################################
##
#A  ConductorOfGoodIdeal(I)
##
##  Returns the conductor of I, the largest element in SmallElements(I)
##
#############################################################################
DeclareAttribute("Conductor", IsGoodIdeal);
DeclareSynonymAttr("ConductorOfGoodIdeal", Conductor);

#############################################################################
##
#A  MinIGS(I)
##
##  Every good ideal has a minimum
##
#############################################################################
DeclareAttribute("MinIGS", IsGoodIdeal);

#############################################################################
##
#F  CanonicalIdealOfGoodSemigroup(s)
##
##  Computes a canonical ideal of <s>
##
#############################################################################
DeclareGlobalFunction("CanonicalIdealOfGoodSemigroup");
